/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;

public class EditComponentAction
extends CompositeEditorTableAction {
    private static final String ACTION_NAME = "Edit Component";
    private static final String GROUP_NAME = "1_BASIC_EDITOR_ACTION";
    private static final String DESCRIPTION = "Edit the selected component";
    private static String[] popupPath = new String[]{"Edit Component"};
    private static String[] menuPath = new String[]{"Edit Component"};
    private DataTypeManagerService dtmService;

    public EditComponentAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Edit Component", GROUP_NAME, popupPath, menuPath, null);
        this.dtmService = provider.dtmService;
        this.setDescription(DESCRIPTION);
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        int row = this.model.getRow();
        if (row < this.model.getNumComponents()) {
            DataTypeComponent comp = this.model.getComponent(row);
            DataType dt = DataTypeHelper.getBaseType(comp.getDataType());
            if (dt instanceof Structure || dt instanceof Union || dt instanceof Enum) {
                DataTypeManager dtm = this.model.getOriginalDataTypeManager();
                if (dtm != null && (dt = dtm.getDataType(dt.getDataTypePath())) != null) {
                    this.dtmService.edit(dt);
                    return;
                }
                String name = dt != null ? dt.getDisplayName() : comp.getDataType().getDisplayName();
                this.model.setStatus("Can't edit \"" + name + "\".");
            } else {
                this.model.setStatus("Can only edit a structure, union or enum.");
            }
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isEditComponentAllowed());
    }
}

