/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import java.awt.Color;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.OvalColorIcon;
import resources.icons.TranslateIcon;

public class NavigatableIconFactory {
    private static final ImageIcon SNAPSHOT_ICON = ResourceManager.loadImage((String)"images/camera-photo.png");

    public static ImageIcon createSnapshotOverlayIcon(Icon primaryIcon) {
        MultiIcon newOuterIcon = new MultiIcon(primaryIcon);
        ImageIcon scaledIcon = ResourceManager.getScaledIcon((Icon)SNAPSHOT_ICON, (int)8, (int)8, (int)0);
        ImageIcon highlightIcon = NavigatableIconFactory.getHighlightIcon(scaledIcon);
        MultiIcon highlightMultiIcon = new MultiIcon((Icon)highlightIcon);
        Point centerPoint = NavigatableIconFactory.getCenteredIconOffset(highlightIcon, scaledIcon);
        highlightMultiIcon.addIcon((Icon)new TranslateIcon((Icon)scaledIcon, centerPoint.x, centerPoint.y));
        Point lowerRightPoint = NavigatableIconFactory.getLowerRightIconOffset(primaryIcon, (Icon)highlightMultiIcon);
        newOuterIcon.addIcon((Icon)new TranslateIcon((Icon)highlightMultiIcon, lowerRightPoint.x + 2, lowerRightPoint.y + 2));
        return ResourceManager.getImageIcon((Icon)newOuterIcon);
    }

    private static ImageIcon getHighlightIcon(Icon primaryIcon) {
        int primaryWidth = primaryIcon.getIconWidth();
        int primaryHeight = primaryIcon.getIconHeight();
        Color color = new Color(255, 255, 0, 255);
        return ResourceManager.getImageIcon((Icon)new OvalColorIcon(color, primaryWidth + 4, primaryHeight + 4));
    }

    private static Point getCenteredIconOffset(Icon primaryIcon, Icon overlayIcon) {
        int primaryWidth = primaryIcon.getIconWidth();
        int primaryHeight = primaryIcon.getIconHeight();
        int overlayWidth = overlayIcon.getIconWidth();
        int overlayHeight = overlayIcon.getIconHeight();
        int offsetX = primaryWidth - overlayWidth >> 1;
        int offsetY = primaryHeight - overlayHeight >> 1;
        return new Point(offsetX, offsetY);
    }

    private static Point getLowerRightIconOffset(Icon primaryIcon, Icon overlayIcon) {
        int primaryWidth = primaryIcon.getIconWidth();
        int primaryHeight = primaryIcon.getIconHeight();
        int overlayWidth = overlayIcon.getIconWidth();
        int overlayHeight = overlayIcon.getIconHeight();
        return new Point(primaryWidth - overlayWidth, primaryHeight - overlayHeight);
    }
}

