/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;

public class CreateDataInStructureCmd
implements Command {
    private Address addr;
    private int[] componentPath;
    private DataType newDataType;
    private String msg;
    private boolean stackPointers;

    public CreateDataInStructureCmd(Address addr, int[] componentPath, DataType dt) {
        this(addr, componentPath, dt, false);
    }

    public CreateDataInStructureCmd(Address addr, int[] componentPath, DataType dt, boolean stackPointers) {
        this.addr = addr;
        this.componentPath = componentPath;
        this.newDataType = dt;
        this.stackPointers = stackPointers;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        Data data = program.getListing().getDefinedDataContaining(this.addr);
        Data dataComp = data.getComponent(this.componentPath);
        if (dataComp == null) {
            this.msg = "Component data not found";
            return false;
        }
        DataType parentDataType = dataComp.getParent().getBaseDataType();
        if (!(parentDataType instanceof Composite)) {
            this.msg = "Invalid command usage";
            return false;
        }
        if (this.newDataType instanceof FactoryDataType) {
            this.msg = "Factory data-type not allowed in structure or union: " + this.newDataType.getName();
            return false;
        }
        DataType existingDT = dataComp.getDataType();
        int index = dataComp.getComponentIndex();
        this.newDataType = DataUtilities.reconcileAppliedDataType((DataType)existingDT, (DataType)this.newDataType, (boolean)this.stackPointers);
        if (this.newDataType instanceof Dynamic) {
            this.msg = "Dynamically sized data-type not allowed: " + this.newDataType.getName();
            return false;
        }
        this.newDataType = program.getDataTypeManager().resolve(this.newDataType, null);
        try {
            if (parentDataType instanceof Structure) {
                Structure struct = (Structure)parentDataType;
                if (this.newDataType == DataType.DEFAULT) {
                    struct.clearComponent(index);
                } else {
                    DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)this.newDataType, (int)-1);
                    struct.replace(index, dti.getDataType(), dti.getLength());
                }
            } else if (parentDataType instanceof Union) {
                Union union = (Union)parentDataType;
                DataTypeComponent comp = union.getComponent(index);
                String comment = comp.getComment();
                String fieldName = comp.getFieldName();
                union.insert(index, this.newDataType);
                union.delete(index + 1);
                comp = union.getComponent(index);
                comp.setComment(comment);
                comp.setFieldName(fieldName);
            }
        }
        catch (Exception e) {
            this.msg = e.getMessage();
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Create " + this.newDataType.getDisplayName() + " component";
    }
}

