/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;

public class CreateArrayCmd
implements Command {
    private String msg;
    private Address addr;
    private int numElements;
    private int elementLength;
    private DataType dataType;

    public CreateArrayCmd(Address addr, int numElements, DataType dt, int elementLength) {
        this.addr = addr;
        this.numElements = numElements;
        this.dataType = dt;
        this.elementLength = elementLength;
    }

    public boolean applyTo(DomainObject obj) {
        Address endAddr;
        Program program = (Program)obj;
        Listing listing = program.getListing();
        if (this.dataType instanceof FactoryDataType) {
            this.msg = "Array not allowed on a Factory data-type: " + this.dataType.getName();
            return false;
        }
        if (this.dataType instanceof Dynamic && !((Dynamic)this.dataType).canSpecifyLength()) {
            this.msg = "Array not allowed on a non-sizable Dynamic data-type: " + this.dataType.getName();
            return false;
        }
        if (this.elementLength <= 0) {
            this.msg = "DataType must have fixed size > 0, not " + this.dataType.getLength();
            return false;
        }
        if (this.numElements <= 0) {
            this.msg = "Number of elements must be positive, not " + this.numElements;
            return false;
        }
        int length = this.numElements * this.elementLength;
        try {
            endAddr = this.addr.addNoWrap((long)(length - 1));
        }
        catch (AddressOverflowException e1) {
            this.msg = "Can't create data because length exceeds address space";
            return false;
        }
        AddressSet set = new AddressSet(this.addr, endAddr);
        InstructionIterator iter = listing.getInstructions((AddressSetView)set, true);
        if (iter.hasNext()) {
            this.msg = "Can't create data because the current selection contains instructions";
            return false;
        }
        listing.clearCodeUnits(this.addr, endAddr, false);
        ArrayDataType adt = new ArrayDataType(this.dataType, this.numElements, this.elementLength);
        try {
            listing.createData(this.addr, (DataType)adt, adt.getLength());
        }
        catch (CodeUnitInsertionException e) {
            this.msg = e.getMessage();
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Create Array";
    }
}

