/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;

public class FunctionNameFieldLocation
extends FunctionSignatureFieldLocation {
    private String functionName;

    public FunctionNameFieldLocation(Program program, Address locationAddr, Address functionAddr, int charOffset, String signature, String functionName) {
        super(program, locationAddr, functionAddr, charOffset, signature);
        this.functionName = functionName;
    }

    public FunctionNameFieldLocation(Program program, Address functionAddr, int col, String signature, String functionName) {
        super(program, functionAddr, col, signature);
        this.functionName = functionName;
    }

    public FunctionNameFieldLocation(Program program, Address addr, String functionName) {
        super(program, addr);
        this.functionName = functionName;
    }

    public FunctionNameFieldLocation() {
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String toString() {
        return super.toString() + ", Function Name: " + this.functionName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionNameFieldLocation other = (FunctionNameFieldLocation)obj;
        return !(this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName));
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_FUNCTION_NAME", this.functionName);
    }

    @Override
    public void restoreState(Program restoreProgram, SaveState obj) {
        super.restoreState(restoreProgram, obj);
        this.functionName = obj.getString("_FUNCTION_NAME", null);
    }
}

