/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class BlockIfGoto
extends BlockGraph {
    private PcodeBlock gototarget;
    private int gototype;

    public BlockIfGoto() {
        this.blocktype = 10;
        this.gototarget = null;
        this.gototype = 1;
    }

    public void setGotoTarget(PcodeBlock bl) {
        this.gototarget = bl;
    }

    public PcodeBlock getGotoTarget() {
        return this.gototarget;
    }

    public int getGotoType() {
        return this.gototype;
    }

    @Override
    public void saveXmlBody(Writer writer) throws IOException {
        super.saveXmlBody(writer);
        PcodeBlock leaf = this.gototarget.getFrontLeaf();
        int depth = this.gototarget.calcDepth(leaf);
        StringBuilder buf = new StringBuilder();
        buf.append("<target");
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"index", (long)leaf.getIndex());
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"depth", (long)depth);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"type", (long)this.gototype);
        buf.append("/>\n");
        writer.write(buf.toString());
    }

    @Override
    public void restoreXmlBody(XmlPullParser parser, BlockMap resolver) throws PcodeXMLException {
        super.restoreXmlBody(parser, resolver);
        XmlElement el = parser.start(new String[]{"target"});
        int target = SpecXmlUtils.decodeInt((String)el.getAttribute("index"));
        int depth = SpecXmlUtils.decodeInt((String)el.getAttribute("depth"));
        this.gototype = SpecXmlUtils.decodeInt((String)el.getAttribute("type"));
        parser.end(el);
        this.gototarget = null;
        resolver.addGotoRef(this, target, depth);
    }
}

