/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.math.BigInteger;

public class WrappedMemBuffer
implements MemBuffer {
    private final MemBuffer memBuffer;
    private int baseOffset;
    private Address address;

    public WrappedMemBuffer(MemBuffer buf, int offset) throws AddressOutOfBoundsException {
        this.memBuffer = buf;
        this.setBaseOffset(offset);
    }

    public void setBaseOffset(int offset) throws AddressOutOfBoundsException {
        this.baseOffset = offset;
        this.address = this.memBuffer.getAddress().add(this.baseOffset);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    private int computeOffset(int offset) throws MemoryAccessException {
        int bufOffset = this.baseOffset + offset;
        if (offset > 0 && bufOffset < this.baseOffset) {
            throw new MemoryAccessException();
        }
        if (offset < 0 && bufOffset > this.baseOffset) {
            throw new MemoryAccessException();
        }
        return bufOffset;
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        return this.memBuffer.getByte(this.computeOffset(offset));
    }

    @Override
    public int getBytes(byte[] b, int offset) {
        try {
            return this.memBuffer.getBytes(b, this.computeOffset(offset));
        }
        catch (MemoryAccessException e) {
            return 0;
        }
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        return this.memBuffer.getInt(this.computeOffset(offset));
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        return this.memBuffer.getLong(this.computeOffset(offset));
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        return this.memBuffer.getBigInteger(this.computeOffset(offset), size, signed);
    }

    @Override
    public Memory getMemory() {
        return this.memBuffer.getMemory();
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        return this.memBuffer.getShort(this.computeOffset(offset));
    }

    @Override
    public boolean isBigEndian() {
        return this.memBuffer.isBigEndian();
    }
}

