/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AlignmentDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassTranslator;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DialogResourceDataType
extends DynamicDataType {
    private static byte DS_SETFONT = (byte)64;
    private static Map<Integer, String> itemTypeMap = new HashMap<Integer, String>();

    public DialogResourceDataType() {
        super(null, "DialogResource", null);
    }

    public DialogResourceDataType(DataTypeManager dtm) {
        super(null, "DialogResource", dtm);
    }

    @Override
    public String getDescription() {
        return "Dialog stored as a Resource";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "DialogRes";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int len) {
        return "Dialog";
    }

    @Override
    protected DataTypeComponent[] getAllComponents(MemBuffer mbIn) {
        ArrayList<DataTypeComponent> comps = new ArrayList<DataTypeComponent>();
        int tempOffset = 0;
        MemBuffer memBuffer = mbIn;
        try {
            boolean ex = memBuffer.getShort(0) == 1 && memBuffer.getShort(2) == -1;
            tempOffset = this.addDlgTemplateStructure(memBuffer, comps, tempOffset, ex);
            tempOffset = this.addDialogMenuArray(memBuffer, comps, tempOffset);
            tempOffset = this.addDialogClassArray(memBuffer, comps, tempOffset);
            tempOffset = this.addDialogTitleArray(memBuffer, comps, tempOffset);
            byte getStyle = memBuffer.getByte(0);
            if ((getStyle & DS_SETFONT) > 0) {
                tempOffset = this.addDialogFontSizeAndArray(memBuffer, comps, tempOffset);
            }
            int numComponents = memBuffer.getShort(ex ? 16 : 8);
            for (int i = 0; i < numComponents; ++i) {
                tempOffset = this.addDlgItemStructure(memBuffer, comps, tempOffset, ex);
                tempOffset = this.addItemClassArray(memBuffer, comps, tempOffset);
                tempOffset = this.addItemTitleArray(memBuffer, comps, tempOffset);
                tempOffset = this.addItemCreationData(memBuffer, comps, tempOffset);
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("buffer error: " + e.getMessage()), (Throwable)((Object)e));
        }
        DataTypeComponent[] result = comps.toArray(new DataTypeComponent[comps.size()]);
        return result;
    }

    private int addDlgTemplateStructure(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset, boolean ex) {
        tempOffset = this.addComp(ex ? this.dlgTemplateExStructure() : this.dlgTemplateStructure(), ex ? 26 : 18, "Dialog Template Structure", memBuffer.getAddress(), comps, tempOffset);
        return tempOffset;
    }

    private int addDialogMenuArray(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) throws MemoryAccessException {
        short dialogMenuInfo = memBuffer.getShort(tempOffset);
        tempOffset = dialogMenuInfo == 0 ? this.addComp(this.createArrayOfShorts(1), 2, "Dialog Menu", memBuffer.getAddress().add(tempOffset), comps, tempOffset) : (dialogMenuInfo == 65535 ? this.addComp(this.createArrayOfShorts(2), 4, "Dialog Menu", memBuffer.getAddress().add(tempOffset), comps, tempOffset) : this.addUnicodeString(memBuffer, comps, tempOffset, "Dialog Menu"));
        return tempOffset;
    }

    private int addDialogClassArray(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) throws MemoryAccessException {
        short dialogClassInfo = memBuffer.getShort(tempOffset);
        tempOffset = dialogClassInfo == 0 ? this.addComp(this.createArrayOfShorts(1), 2, "Dialog Class", memBuffer.getAddress().add(tempOffset), comps, tempOffset) : (dialogClassInfo == 65535 ? this.addComp(this.createArrayOfShorts(2), 4, "Dialog Class", memBuffer.getAddress().add(tempOffset), comps, tempOffset) : this.addUnicodeString(memBuffer, comps, tempOffset, "Dialog Class"));
        return tempOffset;
    }

    private int addDialogTitleArray(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) throws MemoryAccessException {
        short dialogTitleInfo = memBuffer.getShort(tempOffset);
        tempOffset = dialogTitleInfo == 0 ? this.addComp(this.createArrayOfShorts(1), 2, "Dialog Title", memBuffer.getAddress().add(tempOffset), comps, tempOffset) : this.addUnicodeString(memBuffer, comps, tempOffset, "Dialog Title");
        return tempOffset;
    }

    private int addDialogFontSizeAndArray(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) {
        tempOffset = this.addComp(new ShortDataType(), 2, "Dialog Font Size", memBuffer.getAddress().add(tempOffset), comps, tempOffset);
        tempOffset = this.addUnicodeString(memBuffer, comps, tempOffset, "Dialog Font Typeface");
        return tempOffset;
    }

    private int addDlgItemStructure(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset, boolean ex) {
        if (memBuffer.getAddress().add(tempOffset).getOffset() % 4L != 0L) {
            tempOffset = this.addComp(new AlignmentDataType(), 2, "Alignment", memBuffer.getAddress().add(tempOffset), comps, tempOffset);
        }
        tempOffset = this.addComp(ex ? this.dlgItemTemplateExStructure() : this.dlgItemTemplateStructure(), ex ? 24 : 18, "Dialog Item Structure", memBuffer.getAddress().add(tempOffset), comps, tempOffset);
        return tempOffset;
    }

    private int addItemClassArray(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) throws MemoryAccessException {
        short itemClassInfo = memBuffer.getShort(tempOffset);
        if ((itemClassInfo & 0xFFFF) == 65535) {
            short classType = memBuffer.getShort(tempOffset + 2);
            tempOffset = this.addComp(this.createArrayOfShorts(2), 4, "Item Class Type or Name(" + this.getItemType(Integer.valueOf(classType)) + ")", memBuffer.getAddress().add(tempOffset), comps, tempOffset);
        } else {
            tempOffset = this.addUnicodeString(memBuffer, comps, tempOffset, "Item Class Type or Name");
        }
        return tempOffset;
    }

    private int addItemTitleArray(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) throws MemoryAccessException {
        short itemTitleInfo = memBuffer.getShort(tempOffset);
        tempOffset = (itemTitleInfo & 0xFFFF) == 65535 ? this.addComp(this.createArrayOfShorts(2), 4, "Item Title or Resource ID", memBuffer.getAddress().add(tempOffset), comps, tempOffset) : this.addUnicodeString(memBuffer, comps, tempOffset, "Item Title or Resource ID");
        return tempOffset;
    }

    private int addItemCreationData(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset) throws MemoryAccessException {
        short itemDataLength = memBuffer.getShort(tempOffset);
        tempOffset = itemDataLength == 0 ? this.addComp(this.createArrayOfShorts(1), 2, "Item Data", memBuffer.getAddress().add(tempOffset), comps, tempOffset) : this.addComp(new ArrayDataType(ByteDataType.dataType, itemDataLength, 1), itemDataLength, "Item Data", memBuffer.getAddress().add(tempOffset), comps, tempOffset);
        return tempOffset;
    }

    private StructureDataType dlgTemplateExStructure() {
        StructureDataType struct = new StructureDataType("DLGTEMPLATEEX", 0);
        struct.add(WordDataType.dataType);
        struct.add(WordDataType.dataType);
        struct.add(DWordDataType.dataType);
        struct.add(DWordDataType.dataType);
        struct.add(DWordDataType.dataType);
        struct.add(WordDataType.dataType);
        struct.add(ShortDataType.dataType);
        struct.add(ShortDataType.dataType);
        struct.add(ShortDataType.dataType);
        struct.add(ShortDataType.dataType);
        try {
            struct.getComponent(0).setFieldName("dlgVer");
            struct.getComponent(1).setFieldName("signature");
            struct.getComponent(2).setFieldName("helpId");
            struct.getComponent(3).setFieldName("exStyle");
            struct.getComponent(4).setFieldName("style");
            struct.getComponent(5).setFieldName("cDlgItems");
            struct.getComponent(6).setFieldName("x");
            struct.getComponent(7).setFieldName("y");
            struct.getComponent(8).setFieldName("cx");
            struct.getComponent(9).setFieldName("cy");
        }
        catch (DuplicateNameException e) {
            Msg.debug((Object)this, (Object)"Unexpected exception building DLGTEMPLATEEX", (Throwable)e);
        }
        struct.getComponent(0).setComment("version (must be 1)");
        struct.getComponent(1).setComment("signature (must be 0xffff)");
        struct.getComponent(2).setComment("help context identifier");
        struct.getComponent(3).setComment("extended styles for a window");
        struct.getComponent(4).setComment("style of dialog box");
        struct.getComponent(5).setComment("number of items in dialog box");
        struct.getComponent(6).setComment("x-coordinate of upper-left corner of dialog");
        struct.getComponent(7).setComment("y-coordinate of upper-left corner of dialog");
        struct.getComponent(8).setComment("width of dialog box");
        struct.getComponent(9).setComment("height of dialog box");
        return struct;
    }

    private StructureDataType dlgTemplateStructure() {
        StructureDataType struct = new StructureDataType("DLGTEMPLATE", 0);
        struct.add(DWordDataType.dataType);
        struct.add(DWordDataType.dataType);
        struct.add(WordDataType.dataType);
        struct.add(ShortDataType.dataType);
        struct.add(ShortDataType.dataType);
        struct.add(ShortDataType.dataType);
        struct.add(ShortDataType.dataType);
        try {
            struct.getComponent(0).setFieldName("style");
            struct.getComponent(1).setFieldName("dwExtendedStyle");
            struct.getComponent(2).setFieldName("cdit");
            struct.getComponent(3).setFieldName("x");
            struct.getComponent(4).setFieldName("y");
            struct.getComponent(5).setFieldName("cx");
            struct.getComponent(6).setFieldName("cy");
        }
        catch (DuplicateNameException e) {
            Msg.debug((Object)this, (Object)"Unexpected exception building DLGTEMPLATE", (Throwable)e);
        }
        struct.getComponent(0).setComment("style of dialog box");
        struct.getComponent(1).setComment("extended styles for a window");
        struct.getComponent(2).setComment("number of items in dialog box");
        struct.getComponent(3).setComment("x-coordinate of upper-left corner of dialog");
        struct.getComponent(4).setComment("y-coordinate of upper-left corner of dialog");
        struct.getComponent(5).setComment("width of dialog box");
        struct.getComponent(6).setComment("height of dialog box");
        return struct;
    }

    private StructureDataType dlgItemTemplateExStructure() {
        StructureDataType struct = new StructureDataType("DLGITEMTEMPLATEEX", 0);
        try {
            struct.add(DWordDataType.dataType);
            struct.add(DWordDataType.dataType);
            struct.add(DWordDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(DWordDataType.dataType);
            struct.getComponent(0).setFieldName("helpID");
            struct.getComponent(1).setFieldName("exStyle");
            struct.getComponent(2).setFieldName("style");
            struct.getComponent(3).setFieldName("x");
            struct.getComponent(4).setFieldName("y");
            struct.getComponent(5).setFieldName("cx");
            struct.getComponent(6).setFieldName("cy");
            struct.getComponent(7).setFieldName("id");
        }
        catch (DuplicateNameException e) {
            Msg.debug((Object)this, (Object)"Unexpected exception building DLGITEMTEMPLATEEX", (Throwable)e);
        }
        struct.getComponent(0).setComment("help context identifier");
        struct.getComponent(1).setComment("extended styles for a window");
        struct.getComponent(2).setComment("style of control");
        struct.getComponent(3).setComment("x-coordinate of upper-left corner of control");
        struct.getComponent(4).setComment("y-coordinate of upper-left corner of control");
        struct.getComponent(5).setComment("width of control");
        struct.getComponent(6).setComment("height of control");
        struct.getComponent(7).setComment("control identifier");
        return struct;
    }

    private StructureDataType dlgItemTemplateStructure() {
        StructureDataType struct = new StructureDataType("DLGITEMTEMPLATE", 0);
        try {
            struct.add(DWordDataType.dataType);
            struct.add(DWordDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(ShortDataType.dataType);
            struct.add(WordDataType.dataType);
            struct.getComponent(0).setFieldName("style");
            struct.getComponent(1).setFieldName("dwExtendedStyle");
            struct.getComponent(2).setFieldName("x");
            struct.getComponent(3).setFieldName("y");
            struct.getComponent(4).setFieldName("cx");
            struct.getComponent(5).setFieldName("cy");
            struct.getComponent(6).setFieldName("id");
        }
        catch (DuplicateNameException e) {
            Msg.debug((Object)this, (Object)"Unexpected exception building DLGITEMTEMPLATE", (Throwable)e);
        }
        struct.getComponent(0).setComment("style of control");
        struct.getComponent(1).setComment("extended styles for a window");
        struct.getComponent(2).setComment("x-coordinate of upper-left corner of control");
        struct.getComponent(3).setComment("y-coordinate of upper-left corner of control");
        struct.getComponent(4).setComment("width of control");
        struct.getComponent(5).setComment("height of control");
        struct.getComponent(6).setComment("control identifier");
        return struct;
    }

    public String getItemType(Integer value) {
        return itemTypeMap.get(value);
    }

    private int addUnicodeString(MemBuffer memBuffer, List<DataTypeComponent> comps, int tempOffset, String title) {
        byte[] tempBytes = new byte[1024];
        memBuffer.getBytes(tempBytes, tempOffset);
        int strLength = DialogResourceDataType.findUnicodeLength(tempBytes);
        if (strLength >= 2) {
            tempOffset = this.addComp(UnicodeDataType.dataType, strLength, title, memBuffer.getAddress().add(tempOffset), comps, tempOffset);
        }
        return tempOffset;
    }

    static int findUnicodeLength(byte[] byteArray) {
        for (int i = 0; i <= byteArray.length; i += 2) {
            if (byteArray[i] != 0 || byteArray[i + 1] != 0) continue;
            return i + 2;
        }
        return -1;
    }

    private ArrayDataType createArrayOfShorts(int len) {
        ArrayDataType array = new ArrayDataType(ShortDataType.dataType, len, 2);
        return array;
    }

    private int addComp(DataType dataType, int len, String fieldName, Address address, List<DataTypeComponent> comps, int currentOffset) {
        if (len > 0) {
            ReadOnlyDataTypeComponent readOnlyDataTypeComponent = new ReadOnlyDataTypeComponent(dataType, this, len, comps.size(), currentOffset, fieldName, null);
            comps.add(readOnlyDataTypeComponent);
            currentOffset += len;
        }
        return currentOffset;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int len) {
        return "<Dialog-Resource>";
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "Dialog";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new DialogResourceDataType(dtm);
    }

    static {
        itemTypeMap.put(128, "Button");
        itemTypeMap.put(129, "Edit");
        itemTypeMap.put(130, "Static");
        itemTypeMap.put(131, "List Box");
        itemTypeMap.put(132, "Scoll Bar");
        itemTypeMap.put(133, "Combo Box");
        ClassTranslator.put((String)"ghidra.app.plugin.prototype.data.DialogResourceDataType", (String)DialogResourceDataType.class.getName());
    }
}

