/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.SwingUtilities;

public class DataTypeManagerChangeListenerHandler
implements DataTypeManagerChangeListener {
    private transient WeakSet<DataTypeManagerChangeListener> listenerList = WeakDataStructureFactory.createCopyOnReadWeakSet();

    public void addDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.listenerList.add((Object)l);
    }

    public void removeDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.listenerList.remove((Object)l);
    }

    @Override
    public void categoryAdded(final DataTypeManager dtm, final CategoryPath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.categoryAdded(dtm, path);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void categoryMoved(final DataTypeManager dtm, final CategoryPath oldPath, final CategoryPath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.categoryMoved(dtm, oldPath, newPath);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void categoryRemoved(final DataTypeManager dtm, final CategoryPath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.categoryRemoved(dtm, path);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void categoryRenamed(final DataTypeManager dtm, final CategoryPath oldPath, final CategoryPath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.categoryRenamed(dtm, oldPath, newPath);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void dataTypeAdded(final DataTypeManager dtm, final DataTypePath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.dataTypeAdded(dtm, path);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void dataTypeChanged(final DataTypeManager dtm, final DataTypePath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.dataTypeChanged(dtm, path);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void dataTypeMoved(final DataTypeManager dtm, final DataTypePath oldPath, final DataTypePath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.dataTypeMoved(dtm, oldPath, newPath);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void dataTypeRemoved(final DataTypeManager dtm, final DataTypePath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.dataTypeRemoved(dtm, path);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void dataTypeRenamed(final DataTypeManager dtm, final DataTypePath oldPath, final DataTypePath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.dataTypeRenamed(dtm, oldPath, newPath);
                    listener.favoritesChanged(dtm, oldPath, false);
                }
            }
        };
        this.invokeRunnable(r);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.listenerList = WeakDataStructureFactory.createCopyOnReadWeakSet();
    }

    private void invokeRunnable(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void dataTypeReplaced(final DataTypeManager dtm, final DataTypePath oldPath, final DataTypePath newPath, final DataType newDataType) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.dataTypeReplaced(dtm, oldPath, newPath, newDataType);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void favoritesChanged(final DataTypeManager dtm, final DataTypePath path, final boolean isFavorite) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.favoritesChanged(dtm, path, isFavorite);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void sourceArchiveChanged(final DataTypeManager dataTypeManager, final SourceArchive dataTypeSource) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.sourceArchiveChanged(dataTypeManager, dataTypeSource);
                }
            }
        };
        this.invokeRunnable(r);
    }

    @Override
    public void sourceArchiveAdded(final DataTypeManager dataTypeManager, final SourceArchive dataTypeSource) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (DataTypeManagerChangeListener listener : DataTypeManagerChangeListenerHandler.this.listenerList) {
                    listener.sourceArchiveAdded(dataTypeManager, dataTypeSource);
                }
            }
        };
        this.invokeRunnable(r);
    }
}

