/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ByteField;
import db.DBHandle;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV0;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV1;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV2;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

abstract class SymbolDatabaseAdapter {
    static final String SYMBOL_TABLE_NAME = "Symbols";
    static final Schema SYMBOL_SCHEMA = new Schema(2, "Key", new Class[]{StringField.class, LongField.class, LongField.class, ByteField.class, LongField.class, IntField.class, StringField.class, ByteField.class}, new String[]{"Name", "Address", "Parent", "Symbol Type", "SymbolData1", "SymbolData2", "SymbolData3", "Flags"});
    static final int SYMBOL_NAME_COL = 0;
    static final int SYMBOL_ADDR_COL = 1;
    static final int SYMBOL_PARENT_COL = 2;
    static final int SYMBOL_TYPE_COL = 3;
    static final int SYMBOL_DATA1_COL = 4;
    static final int SYMBOL_DATA2_COL = 5;
    static final int SYMBOL_DATA3_COL = 6;
    static final int SYMBOL_FLAGS_COL = 7;
    static final byte SYMBOL_SOURCE_BITS = 3;
    static final byte SYMBOL_PINNED_FLAG = 4;

    SymbolDatabaseAdapter() {
    }

    static SymbolDatabaseAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            return new SymbolDatabaseAdapterV2(dbHandle, addrMap, true);
        }
        try {
            SymbolDatabaseAdapterV2 adapter = new SymbolDatabaseAdapterV2(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            SymbolDatabaseAdapter adapter = SymbolDatabaseAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == 3) {
                adapter = SymbolDatabaseAdapterV2.upgrade(dbHandle, addrMap, adapter, monitor);
            } else if (adapter instanceof SymbolDatabaseAdapterV0) {
                throw e;
            }
            return adapter;
        }
    }

    private static SymbolDatabaseAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException, IOException {
        try {
            return new SymbolDatabaseAdapterV2(handle, addrMap.getOldAddressMap(), false);
        }
        catch (VersionException versionException) {
            try {
                return new SymbolDatabaseAdapterV1(handle, addrMap.getOldAddressMap());
            }
            catch (VersionException versionException2) {
                return new SymbolDatabaseAdapterV0(handle, addrMap);
            }
        }
    }

    abstract Record createSymbol(String var1, Address var2, long var3, SymbolType var5, long var6, int var8, String var9, SourceType var10) throws IOException;

    abstract Record getSymbolRecord(long var1) throws IOException;

    abstract void removeSymbol(long var1) throws IOException;

    abstract boolean hasSymbol(Address var1) throws IOException;

    abstract long[] getSymbolIDs(Address var1) throws IOException;

    abstract int getSymbolCount();

    abstract RecordIterator getSymbolsByAddress(boolean var1) throws IOException;

    abstract RecordIterator getSymbolsByAddress(Address var1, boolean var2) throws IOException;

    abstract void updateSymbolRecord(Record var1) throws IOException;

    abstract RecordIterator getSymbols() throws IOException;

    abstract RecordIterator getSymbols(Address var1, Address var2, boolean var3) throws IOException;

    abstract void moveAddress(Address var1, Address var2) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException, IOException;

    abstract Set<Address> deleteAddressRange(Address var1, Address var2, TaskMonitor var3) throws CancelledException, IOException;

    abstract RecordIterator getSymbolsByNamespace(long var1) throws IOException;

    abstract RecordIterator getSymbolsByName(String var1) throws IOException;

    abstract Address getMaxSymbolAddress(AddressSpace var1) throws IOException;

    abstract Table getTable();
}

