/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.function.FunctionAdapter;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionAdapterV3
extends FunctionAdapter {
    static final int SCHEMA_VERSION = 3;
    private Table table;

    FunctionAdapterV3(DBHandle dbHandle, AddressMap addrMap, boolean create) throws VersionException, IOException {
        super(addrMap);
        if (create) {
            this.table = dbHandle.createTable("Function Data", FUNCTION_SCHEMA);
        } else {
            this.table = dbHandle.getTable("Function Data");
            if (this.table == null) {
                throw new VersionException("Missing Table: Function Data");
            }
            int version = this.table.getSchema().getVersion();
            if (version != 3) {
                if (version < 3) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    void removeFunctionRecord(long functionKey) throws IOException {
        this.table.deleteRecord(functionKey);
    }

    @Override
    Record getFunctionRecord(long functionKey) throws IOException {
        return this.table.getRecord(functionKey);
    }

    @Override
    void updateFunctionRecord(Record functionRecord) throws IOException {
        this.table.putRecord(functionRecord);
    }

    @Override
    Record createFunctionRecord(long symbolID, long returnDataTypeId) throws IOException {
        Record rec = FUNCTION_SCHEMA.createRecord(symbolID);
        rec.setByteValue(4, FunctionAdapterV3.getSignatureSourceFlagBits(SourceType.DEFAULT));
        rec.setLongValue(0, returnDataTypeId);
        rec.setByteValue(5, (byte)0);
        rec.setIntValue(1, Integer.MAX_VALUE);
        this.table.putRecord(rec);
        return rec;
    }

    @Override
    RecordIterator iterateFunctionRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    Record translateRecord(Record record) {
        throw new UnsupportedOperationException();
    }

    @Override
    int getVersion() {
        return 3;
    }
}

