/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;

public class OpBehaviorIntRight
extends BinaryOpBehavior {
    public OpBehaviorIntRight() {
        super(30);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        if (in2 < 0L || in2 >= (long)(8 * sizein)) {
            return 0L;
        }
        return in1 >>> (int)in2 & Utils.calc_mask(sizeout);
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (in1.signum() < 0 || in2.signum() < 0) {
            throw new AssertException("Expected unsigned in values");
        }
        BigInteger maxShift = BigInteger.valueOf(sizein * 8);
        if (in2.compareTo(maxShift) >= 0) {
            return BigInteger.ZERO;
        }
        return in1.shiftRight(in2.intValue());
    }
}

