/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Stack;

public class DbgTimer
extends PrintStream {
    Stack<Long> timeStack = new Stack();
    public static final DbgTimer ACTIVE = new DbgTimer();
    public static final DbgTimer INACTIVE = new DbgTimer(new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            throw new AssertionError((Object)"INTERNAL: Should not be here.");
        }
    }){

        @Override
        public void print(String msg) {
        }

        @Override
        public void println(String msg) {
        }

        @Override
        public void println() {
        }

        @Override
        public void print(Object msg) {
        }

        @Override
        public void println(Object msg) {
        }

        @Override
        public DbgCtx start(Object message) {
            return null;
        }

        @Override
        public void stop() {
        }
    };

    public DbgTimer(OutputStream out) {
        super(new TabbingOutputStream(out));
        TabbingOutputStream tos = (TabbingOutputStream)this.out;
        tos.setTimeStack(this.timeStack);
    }

    public DbgTimer() {
        this(System.out);
    }

    public DbgCtx start(Object message) {
        this.println(message);
        this.flush();
        this.timeStack.push(System.currentTimeMillis());
        return new DbgCtx(this);
    }

    public void stop() {
        long time = System.currentTimeMillis() - this.timeStack.pop();
        this.flush();
        this.println("Done after " + time + "ms");
    }

    public TabbingOutputStream setOutputStream(OutputStream s) {
        this.flush();
        TabbingOutputStream old = (TabbingOutputStream)this.out;
        TabbingOutputStream tos = new TabbingOutputStream(s);
        tos.setTimeStack(this.timeStack);
        this.out = tos;
        return old;
    }

    public TabbingOutputStream resetOutputStream(TabbingOutputStream s) {
        this.flush();
        TabbingOutputStream old = (TabbingOutputStream)this.out;
        this.out = s;
        return old;
    }

    public static class DbgCtx
    implements AutoCloseable {
        private DbgTimer dbg;

        private DbgCtx(DbgTimer dbg) {
            this.dbg = dbg;
        }

        @Override
        public void close() {
            this.dbg.stop();
        }
    }

    public static class TabbingOutputStream
    extends OutputStream {
        protected static final int STATE_NOLINE = 0;
        protected static final int STATE_LINE = 1;
        protected OutputStream out;
        protected int state = 0;
        protected Stack<Long> timeStack;

        private TabbingOutputStream(OutputStream out) {
            this.out = out;
        }

        protected void startln() throws IOException {
            for (Long l : this.timeStack) {
                this.out.write(32);
                this.out.write(32);
            }
        }

        protected void setTimeStack(Stack<Long> timeStack) {
            this.timeStack = timeStack;
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 10 || b == 13) {
                this.out.write(b);
                this.state = 0;
            } else if (this.state == 0) {
                this.startln();
                this.out.write(b);
                this.state = 1;
            } else {
                this.out.write(b);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.out == System.out || this.out == System.err) {
                this.out.flush();
                return;
            }
            try (OutputStream s = this.out;){
                s.flush();
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }
    }
}

