/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ir.StatementNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;

public class BlockNode
extends StatementNode {
    private final List<StatementNode> statementNodes = new ArrayList<StatementNode>();
    private boolean doAllEscape;

    public void addStatementNode(StatementNode statementNode) {
        this.statementNodes.add(statementNode);
    }

    public List<StatementNode> getStatementsNodes() {
        return this.statementNodes;
    }

    public void setAllEscape(boolean doAllEscape) {
        this.doAllEscape = doAllEscape;
    }

    public boolean doAllEscape() {
        return this.doAllEscape;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitBlock(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (StatementNode statementNode : this.statementNodes) {
            statementNode.visit(irTreeVisitor, scope);
        }
    }

    public BlockNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        for (StatementNode statementNode : this.statementNodes) {
            statementNode.continueLabel = this.continueLabel;
            statementNode.breakLabel = this.breakLabel;
            statementNode.write(classWriter, methodWriter, writeScope);
        }
    }
}

