/*	$OpenBSD: usbdevs_data.h,v 1.744 2021/04/05 20:46:06 mglocker Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	OpenBSD: usbdevs,v 1.737 2021/04/05 16:17:25 landry Exp 
 */
/* $NetBSD: usbdevs,v 1.322 2003/05/10 17:47:14 hamajima Exp $ */

/*
 * Copyright (c) 1998, 1999, 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Lennart Augustsson (lennart@augustsson.net) at
 * Carlstedt Research & Technology.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Descriptions of known vendors and devices ("products").
 */
struct usb_known_vendor {
	u_int16_t	vendor;
	char		*vendorname;
};

struct usb_known_product {
	u_int16_t	vendor;
	u_int16_t	product;
	char		*productname;
};

const struct usb_known_product usb_known_products[] = {
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_HOMECONN,
	    "HomeConnect",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3CREB96,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3C19250,
	    "3C19250 Ethernet",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3CRSHEW696,
	    "3CRSHEW696",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3C460,
	    "HomeConnect 3C460",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_USR56K,
	    "U.S.Robotics 56000",
	},
	{
	    USB_VENDOR_3COM, USB_PRODUCT_3COM_3C460B,
	    "HomeConnect 3C460B",
	},
	{
	    USB_VENDOR_3COM2, USB_PRODUCT_3COM2_3CRUSB10075,
	    "3CRUSB10075",
	},
	{
	    USB_VENDOR_3COM3, USB_PRODUCT_3COM3_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_3COM3, USB_PRODUCT_3COM3_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_3COM3, USB_PRODUCT_3COM3_AR5523_3,
	    "AR5523",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_OFFICECONN,
	    "3Com OfficeConnect Analog Modem",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_USRISDN,
	    "3Com U.S. Robotics Pro ISDN TA",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_HOMECONN,
	    "3Com HomeConnect",
	},
	{
	    USB_VENDOR_3COMUSR, USB_PRODUCT_3COMUSR_USR56K,
	    "U.S.Robotics 56000",
	},
	{
	    USB_VENDOR_ABBOTT, USB_PRODUCT_ABBOTT_STEREO_PLUG,
	    "Stereo Plug Cable",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX1,
	    "XX1",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX2,
	    "XX2",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2770,
	    "RT2770",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT3071,
	    "RT3071",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT3072,
	    "RT3072",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_URE450,
	    "URE450 Ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_UFE1000,
	    "UFE1000 Fast Ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_DSB650TX_PNA,
	    "1/10/100 Ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX4,
	    "XX4",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX5,
	    "XX5",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX6,
	    "XX6",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX7,
	    "XX7",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_LCS8138TX,
	    "LCS-8138TX",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX8,
	    "XX8",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX9,
	    "XX9",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_UF200,
	    "UF200 Ethernet",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_WL54,
	    "WL54",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RTL8188EU,
	    "RTL8188EU",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RTL8188CU_1,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RTL8188CU_2,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_XX10,
	    "XX10",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_BWU613,
	    "BWU613",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_HWU54DM,
	    "HWU54DM",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2573_3,
	    "RT2573",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_RT2573_4,
	    "RT2573",
	},
	{
	    USB_VENDOR_ABOCOM, USB_PRODUCT_ABOCOM_WUG2700,
	    "WUG2700",
	},
	{
	    USB_VENDOR_ABOCOM2, USB_PRODUCT_ABOCOM2_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_USB320_EC,
	    "USB320-EC Ethernet",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_2664W,
	    "2664W",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_111,
	    "T-Sinus 111 WLAN",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_SMCWUSBG,
	    "SMCWUSB-G",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_SMCWUSBTG2,
	    "SMCWUSBT-G2",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_SMCWUSBTG2_NF,
	    "SMCWUSBT-G2",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_PRISM_GT,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_SS1001,
	    "SpeedStream Ethernet",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT2770,
	    "RT2770",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT2870_5,
	    "RT2870",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT3070_4,
	    "RT3070",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT2870_4,
	    "RT2870",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT3070_6,
	    "RT3070",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_AR9280,
	    "AR9280+AR7010",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RTL8192SU,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_RT3070_5,
	    "RT3070",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_WN4501H_LF_IR,
	    "WN4501H-LF-IR",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_WUS201,
	    "WUS-201",
	},
	{
	    USB_VENDOR_ACCTON, USB_PRODUCT_ACCTON_WN7512,
	    "WN7512",
	},
	{
	    USB_VENDOR_ACEECA, USB_PRODUCT_ACEECA_MEZ1000,
	    "MEZ1000 RDA",
	},
	{
	    USB_VENDOR_ACERCM, USB_PRODUCT_ACERCM_EP1427X2,
	    "EP-1427X-2 Ethernet",
	},
	{
	    USB_VENDOR_ACERLABS, USB_PRODUCT_ACERLABS_M5632,
	    "USB 2.0 Data Link",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_C310U,
	    "Acerscan C310U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_320U,
	    "Acerscan 320U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_640U,
	    "Acerscan 640U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ACERSCAN_620U,
	    "Acerscan 620U",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_ATAPI,
	    "ATA/ATAPI",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_AWL300,
	    "AWL300",
	},
	{
	    USB_VENDOR_ACERP, USB_PRODUCT_ACERP_AWL400,
	    "AWL400",
	},
	{
	    USB_VENDOR_ACERW, USB_PRODUCT_ACERW_WARPLINK,
	    "Warplink",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_PRISM_25,
	    "Prism2.5 WLAN",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_PRISM_25A,
	    "Prism2.5 WLAN A",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_AR9287,
	    "AR9287+AR7010",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_FREELAN,
	    "ROPEX FreeLan 802.11b",
	},
	{
	    USB_VENDOR_ACTIONTEC, USB_PRODUCT_ACTIONTEC_802UAT1,
	    "802UAT1",
	},
	{
	    USB_VENDOR_ACTISYS, USB_PRODUCT_ACTISYS_IR2000U,
	    "ACT-IR2000U FIR",
	},
	{
	    USB_VENDOR_ACTIVEWIRE, USB_PRODUCT_ACTIVEWIRE_IOBOARD,
	    "I/O Board",
	},
	{
	    USB_VENDOR_ACTIVEWIRE, USB_PRODUCT_ACTIVEWIRE_IOBOARD_FW1,
	    "I/O Board, rev. 1",
	},
	{
	    USB_VENDOR_ADAPTEC, USB_PRODUCT_ADAPTEC_AWN8020,
	    "AWN-8020 WLAN",
	},
	{
	    USB_VENDOR_ADDONICS2, USB_PRODUCT_ADDONICS2_205,
	    "Cable 205",
	},
	{
	    USB_VENDOR_ADDTRON, USB_PRODUCT_ADDTRON_AWU120,
	    "AWU-120",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII_4,
	    "AN986A Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUS,
	    "AN986 Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII,
	    "AN8511 Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII_2,
	    "AN8513 Ethernet",
	},
	{
	    USB_VENDOR_ADMTEK, USB_PRODUCT_ADMTEK_PEGASUSII_3,
	    "AN8515 Ethernet",
	},
	{
	    USB_VENDOR_ADS, USB_PRODUCT_ADS_UBS10BT,
	    "UBS-10BT Ethernet",
	},
	{
	    USB_VENDOR_ADS, USB_PRODUCT_ADS_UBS10BTX,
	    "UBS-10BT Ethernet",
	},
	{
	    USB_VENDOR_AEI, USB_PRODUCT_AEI_FASTETHERNET,
	    "Fast Ethernet",
	},
	{
	    USB_VENDOR_AGATE, USB_PRODUCT_AGATE_QDRIVE,
	    "Q-Drive",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCAN1212U,
	    "SnapScan 1212U",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCAN1236U,
	    "SnapScan 1236U",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANTOUCH,
	    "SnapScan Touch",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCAN1212U2,
	    "SnapScan 1212U",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE40,
	    "SnapScan e40",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE50,
	    "SnapScan e50",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE20,
	    "SnapScan e20",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE25,
	    "SnapScan e25",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE26,
	    "SnapScan e26",
	},
	{
	    USB_VENDOR_AGFA, USB_PRODUCT_AGFA_SNAPSCANE52,
	    "SnapScan e52",
	},
	{
	    USB_VENDOR_AINCOMM, USB_PRODUCT_AINCOMM_AWU2000B,
	    "AWU2000B",
	},
	{
	    USB_VENDOR_AIRPRIME, USB_PRODUCT_AIRPRIME_PC5220,
	    "CDMA Wireless EVDO card",
	},
	{
	    USB_VENDOR_AIRPRIME, USB_PRODUCT_AIRPRIME_AIRCARD_313U,
	    "Aircard 313U",
	},
	{
	    USB_VENDOR_AIRTIES, USB_PRODUCT_AIRTIES_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_AIRTIES, USB_PRODUCT_AIRTIES_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_AKS, USB_PRODUCT_AKS_USBHASP,
	    "USB-HASP 0.06",
	},
	{
	    USB_VENDOR_ALCATEL, USB_PRODUCT_ALCATEL_OT535,
	    "One Touch 535/735",
	},
	{
	    USB_VENDOR_ALCATELT, USB_PRODUCT_ALCATELT_ST120G,
	    "SpeedTouch 120g",
	},
	{
	    USB_VENDOR_ALCATELT, USB_PRODUCT_ALCATELT_ST121G,
	    "SpeedTouch 121g",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_MA_KBD_HUB,
	    "MacAlly Kbd Hub",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_AU9814,
	    "AU9814 Hub",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_SM_KBD,
	    "MicroConnectors/StrongMan",
	},
	{
	    USB_VENDOR_ALCOR, USB_PRODUCT_ALCOR_NEC_KBD_HUB,
	    "NEC Kbd Hub",
	},
	{
	    USB_VENDOR_ALCOR2, USB_PRODUCT_ALCOR2_KBD_HUB,
	    "Kbd Hub",
	},
	{
	    USB_VENDOR_ALLIEDTELESYN, USB_PRODUCT_ALLIEDTELESYN_ATUSB100,
	    "AT-USB100",
	},
	{
	    USB_VENDOR_ALLWIN, USB_PRODUCT_ALLWIN_RT2070,
	    "RT2070",
	},
	{
	    USB_VENDOR_ALLWIN, USB_PRODUCT_ALLWIN_RT2770,
	    "RT2770",
	},
	{
	    USB_VENDOR_ALLWIN, USB_PRODUCT_ALLWIN_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_ALLWIN, USB_PRODUCT_ALLWIN_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_ALLWIN, USB_PRODUCT_ALLWIN_RT3071,
	    "RT3071",
	},
	{
	    USB_VENDOR_ALLWIN, USB_PRODUCT_ALLWIN_RT3072,
	    "RT3072",
	},
	{
	    USB_VENDOR_ALLWIN, USB_PRODUCT_ALLWIN_RT3572,
	    "RT3572",
	},
	{
	    USB_VENDOR_ALTEC, USB_PRODUCT_ALTEC_ADA70,
	    "ADA70 Speakers",
	},
	{
	    USB_VENDOR_ALTEC, USB_PRODUCT_ALTEC_ASC495,
	    "ASC495 Speakers",
	},
	{
	    USB_VENDOR_ALTI2, USB_PRODUCT_ALTI2_NEPTUNE3,
	    "Neptune 3",
	},
	{
	    USB_VENDOR_AMBIT, USB_PRODUCT_AMBIT_WLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_AMBIT, USB_PRODUCT_AMBIT_NTL_250,
	    "NTL 250 cable modem",
	},
	{
	    USB_VENDOR_AMD, USB_PRODUCT_AMD_HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_AMIGO, USB_PRODUCT_AMIGO_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_AMIGO, USB_PRODUCT_AMIGO_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_AMIT, USB_PRODUCT_AMIT_CGWLUSB2GO,
	    "CG-WLUSB2GO",
	},
	{
	    USB_VENDOR_AMIT, USB_PRODUCT_AMIT_CGWLUSB2GNR,
	    "CG-WLUSB2GNR",
	},
	{
	    USB_VENDOR_AMIT, USB_PRODUCT_AMIT_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_AMIT2, USB_PRODUCT_AMIT2_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEI,
	    "Eagle I",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEI_NF,
	    "Eagle I",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEII,
	    "Eagle II",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEII_NF,
	    "Eagle II",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIIC,
	    "Eagle IIC",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIIC_NF,
	    "Eagle IIC",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIII,
	    "Eagle III",
	},
	{
	    USB_VENDOR_ANALOG, USB_PRODUCT_ANALOG_EAGLEIII_NF,
	    "Eagle III",
	},
	{
	    USB_VENDOR_ANALOGDEVICES, USB_PRODUCT_ANALOGDEVICES_GNICE,
	    "gnICE",
	},
	{
	    USB_VENDOR_ANALOGDEVICES, USB_PRODUCT_ANALOGDEVICES_GNICEPLUS,
	    "gnICE+",
	},
	{
	    USB_VENDOR_ANCHOR, USB_PRODUCT_ANCHOR_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_ANCHOR, USB_PRODUCT_ANCHOR_EZUSB,
	    "EZUSB",
	},
	{
	    USB_VENDOR_ANCHOR, USB_PRODUCT_ANCHOR_EZLINK,
	    "EZLINK",
	},
	{
	    USB_VENDOR_ANYDATA, USB_PRODUCT_ANYDATA_A2502,
	    "NTT DoCoMo A2502",
	},
	{
	    USB_VENDOR_ANYDATA, USB_PRODUCT_ANYDATA_ADU_E100H,
	    "ADU-E100H",
	},
	{
	    USB_VENDOR_ANYDATA, USB_PRODUCT_ANYDATA_ADU_500A,
	    "ADU-500A",
	},
	{
	    USB_VENDOR_AOX, USB_PRODUCT_AOX_USB101,
	    "Ethernet",
	},
	{
	    USB_VENDOR_APC, USB_PRODUCT_APC_UPS,
	    "UPS",
	},
	{
	    USB_VENDOR_APC, USB_PRODUCT_APC_UPS5G,
	    "5G UPS",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_FOUNTAIN_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_FOUNTAIN_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER3_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER3_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER3_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER4_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER4_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_GEYSER4_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING2_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING2_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING2_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING3_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING3_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING3_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING4_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING4_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING4_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING4A_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING4A_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING4A_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING5_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING5_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING5_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING6A_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING6A_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING6A_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING6_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING6_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING6_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING5A_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING5A_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING5A_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING7A_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING7A_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING7A_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING7_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING7_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING7_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING9_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING9_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING9_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING8_ANSI,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING8_ISO,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_WELLSPRING8_JIS,
	    "Keyboard/Trackpad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_OPTMOUSE,
	    "Optical mouse",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_BLUETOOTH_HCI,
	    "HID-proxy",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_SPEAKERS,
	    "Speakers",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPHONE,
	    "iPhone",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPOD_TOUCH,
	    "iPod Touch",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPHONE_3G,
	    "iPhone 3G",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPOD_TOUCH_2G,
	    "iPod Touch 2G",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPHONE_3GS,
	    "iPhone 3GS",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPHONE_4_GSM,
	    "iPhone 4 GSM",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPOD_TOUCH_3G,
	    "iPod Touch 3G",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPAD,
	    "iPad",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPHONE_4_CDMA,
	    "iPhone 4 CDMA",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPOD_TOUCH_4G,
	    "iPod Touch 4G",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPAD2,
	    "iPad 2",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPHONE_4S,
	    "iPhone 4S",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_IPHONE_6,
	    "iPhone 6",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_ETHERNET,
	    "Ethernet A1277",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_BLUETOOTH2,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_ISIGHT_1,
	    "iSight",
	},
	{
	    USB_VENDOR_APPLE, USB_PRODUCT_APPLE_ISIGHT,
	    "iSight",
	},
	{
	    USB_VENDOR_ARANEUS, USB_PRODUCT_ARANEUS_ALEA,
	    "True Random Number Generator",
	},
	{
	    USB_VENDOR_ARDUINO, USB_PRODUCT_ARDUINO_LEONARDO,
	    "Leonardo",
	},
	{
	    USB_VENDOR_ARKMICRO, USB_PRODUCT_ARKMICRO_ARK3116,
	    "ARK3116 Serial",
	},
	{
	    USB_VENDOR_ARUBA, USB_PRODUCT_ARUBA_CP210X,
	    "CP210x Serial",
	},
	{
	    USB_VENDOR_ASAHIOPTICAL, USB_PRODUCT_ASAHIOPTICAL_OPTIO230,
	    "PENTAX Optio230",
	},
	{
	    USB_VENDOR_ASANTE, USB_PRODUCT_ASANTE_EA,
	    "Ethernet",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88172,
	    "USB 2.0 10/100 Ethernet controller",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88178,
	    "AX88178",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88179,
	    "AX88179",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88772,
	    "AX88772",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88772A,
	    "AX88772A",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88772B,
	    "AX88772B",
	},
	{
	    USB_VENDOR_ASIX, USB_PRODUCT_ASIX_AX88772B_1,
	    "AX88772B",
	},
	{
	    USB_VENDOR_ASKEY, USB_PRODUCT_ASKEY_WLL013I,
	    "WLL013 (Intersil)",
	},
	{
	    USB_VENDOR_ASKEY, USB_PRODUCT_ASKEY_WLL013,
	    "WLL013",
	},
	{
	    USB_VENDOR_ASKEY, USB_PRODUCT_ASKEY_VOYAGER1010,
	    "Voyager 1010",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2570_2,
	    "RT2570",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_WL159G,
	    "WL-159g",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_A9T_WIFI,
	    "A9T wireless",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_P5B_WIFI,
	    "P5B wireless",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2573_1,
	    "RT2573",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2870_4,
	    "RT2870",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT2870_5,
	    "RT2870",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_USBN13,
	    "USB-N13",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_USBN10,
	    "USB-N10",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_USBN53,
	    "USB-N53",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_USBN66,
	    "USB-N66",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RTL8192CU_2,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RTL8192CU_3,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_RTL8156,
	    "RTL8156",
	},
	{
	    USB_VENDOR_ASUS, USB_PRODUCT_ASUS_MYPAL_A730,
	    "MyPal A730",
	},
	{
	    USB_VENDOR_ASUS2, USB_PRODUCT_ASUS2_USBN11,
	    "USB-N11",
	},
	{
	    USB_VENDOR_ASUSTEK, USB_PRODUCT_ASUSTEK_WL140,
	    "WL-140",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC1284,
	    "Parallel",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC10T,
	    "10Mbps Ethernet",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC110T,
	    "UC-110T Ethernet",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC232A,
	    "UC232A Serial",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC210T,
	    "UC210T Ethernet",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_UC2324,
	    "UC2324 Serial",
	},
	{
	    USB_VENDOR_ATEN, USB_PRODUCT_ATEN_DSB650C,
	    "DSB-650C",
	},
	{
	    USB_VENDOR_ATHEROS, USB_PRODUCT_ATHEROS_AR5523,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS, USB_PRODUCT_ATHEROS_AR5523_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_3,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR5523_3_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_TG121N,
	    "TG121N",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_WN821NV2,
	    "WN821NV2",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR9271_1,
	    "AR9271",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_3CRUSBN275,
	    "3CRUSBN275",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_WN612,
	    "WN612",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR3011,
	    "AR3011",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR9280,
	    "AR9280+AR7010",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR9287,
	    "AR9287+AR7010",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR9170,
	    "AR9170",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR9271_2,
	    "AR9271",
	},
	{
	    USB_VENDOR_ATHEROS2, USB_PRODUCT_ATHEROS2_AR9271_3,
	    "AR9271",
	},
	{
	    USB_VENDOR_ATI2, USB_PRODUCT_ATI2_205,
	    "USB Cable 205",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_STK541,
	    "STK541 Zigbee",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_UHB124,
	    "UHB124 hub",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_WN210,
	    "W-Buddie WN210",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_DWL900AP,
	    "DWL-900AP Wireless access point",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT91_CDC_ACM,
	    "AT91 CDC ACM",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C503I1,
	    "AT76C503 (Intersil 3861 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C503I2,
	    "AT76C503 (Intersil 3863 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C503RFMD,
	    "AT76C503 (RFMD Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505RFMD,
	    "AT76C505 (RFMD Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505RFMD2958,
	    "AT76C505 (RFMD 2958 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505A,
	    "AT76C505A (RFMD 2958 Radio)",
	},
	{
	    USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_AT76C505AS,
	    "AT76C505AS (RFMD 2958 Radio)",
	},
	{
	    USB_VENDOR_AUDIOTECHNICA, USB_PRODUCT_AUDIOTECHNICA_ATCHA4USB,
	    "ATC-HA4USB USB headphone",
	},
	{
	    USB_VENDOR_AVAGO, USB_PRODUCT_AVAGO_MOUSE,
	    "Mouse",
	},
	{
	    USB_VENDOR_AVANCELOGIC, USB_PRODUCT_AVANCELOGIC_USBAUDIO,
	    "USB Audio Speaker",
	},
	{
	    USB_VENDOR_AVERATEC, USB_PRODUCT_AVERATEC_USBWLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_AVISION, USB_PRODUCT_AVISION_1200U,
	    "1200U",
	},
	{
	    USB_VENDOR_AVM, USB_PRODUCT_AVM_FRITZWLAN,
	    "FRITZ!WLAN N",
	},
	{
	    USB_VENDOR_AXESSTEL, USB_PRODUCT_AXESSTEL_DATAMODEM,
	    "Data Modem",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RT3070_4,
	    "RT3070",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8192SU_2,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8192SU_3,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8192SU_4,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RT3070_5,
	    "RT3070",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8192SU_5,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_AR9271_1,
	    "AR9271",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_AR9271_2,
	    "AR9271",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_AR9271_3,
	    "AR9271",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_AR9271_4,
	    "AR9271",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_AR9271_5,
	    "AR9271",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_AR9271_6,
	    "AR9271",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8188CE_1,
	    "RTL8188CE",
	},
	{
	    USB_VENDOR_AZUREWAVE, USB_PRODUCT_AZUREWAVE_RTL8188CE_2,
	    "RTL8188CE",
	},
	{
	    USB_VENDOR_BALTECH, USB_PRODUCT_BALTECH_CARDREADER,
	    "Card reader",
	},
	{
	    USB_VENDOR_BAYER, USB_PRODUCT_BAYER_CONTOUR,
	    "Ascensia Contour",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOTL4,
	    "USOTL4 RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USTL4,
	    "USTL4 RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USO9ML2,
	    "USO9ML2 RS-232",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOPTL4,
	    "USOPTL4 RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USPTL4,
	    "USPTL4 RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USO9ML2DR2,
	    "USO9ML2DR-2 RS-232",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USO9ML2DR,
	    "USO9ML2DR RS-232",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOPTL4DR2,
	    "USOPTL4DR-2 RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOPTL4DR,
	    "USOPTL4DR RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USB9F2W,
	    "485USB9F-2W RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USB9F4W,
	    "485USB9F-4W RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_232USB9M,
	    "232USB9M RS-232",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USBTB_2W,
	    "485USBTB-2W RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USBTB_4W,
	    "485USBTB-4W RS-422/485",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_TTL5USB9M,
	    "TTL5USB9M",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_TTL3USB9M,
	    "TTL3USB9M",
	},
	{
	    USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_ZZ_PROG1,
	    "ZZ Programmer",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D6050,
	    "F5D6050 802.11b Wireless adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_FBT001V,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F8T003V,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_FBT003V,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U103,
	    "F5U103 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U109,
	    "F5U109 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_SCSI,
	    "SCSI",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D5050,
	    "F5D5050 Ethernet",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U234,
	    "F5U234 USB 2.0 4-Port Hub",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U237,
	    "F5U237 USB 2.0 7-Port Hub",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U257,
	    "F5U257 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6H375,
	    "F6H375 UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U409,
	    "F5U409 Serial",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8152B,
	    "RTL8152B",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C550AVR,
	    "F6C550-AVR UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C1250EITWRK,
	    "F6C1250EITW-RK UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C1500EITWRK,
	    "F6C1500EITW-RK UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C900,
	    "F6C900 UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C100,
	    "F6C100 UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C120,
	    "F6C120 UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C800,
	    "F6C800 UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F9L1004V1,
	    "F9L1004V1",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6C1100,
	    "F6C1100/1200 UPS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F9L1103,
	    "F9L1103 Wireless Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8188CUS,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5U120,
	    "F5U120-PC Hub",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F7D2102,
	    "F7D2102",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8192CU_1,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D5055,
	    "F5D5055",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D7050,
	    "F5D7050 54g USB Network Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D7050A,
	    "F5D705A 54g USB Network Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D7050C,
	    "F5D705C 54g USB Network Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D7050E,
	    "F5D705E 54g USB Network Adapter",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D8053V3,
	    "F5D8053 v3",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D8055,
	    "F5D8055",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D8055V2,
	    "F5D8055 v2",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8192SU_2,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D9050V3,
	    "F5D9050 ver 3",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F5D9050C,
	    "F5D9050C",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6D4050V1,
	    "F6D4050 ver 1",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F6D4050V2,
	    "F6D4050 ver 2",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_RTL8192SU_3,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_BELKIN, USB_PRODUCT_BELKIN_F7D1101V2,
	    "F7D1101 v2",
	},
	{
	    USB_VENDOR_BELKIN2, USB_PRODUCT_BELKIN2_F5U002,
	    "F5U002 Parallel",
	},
	{
	    USB_VENDOR_BEWAN, USB_PRODUCT_BEWAN_BWIFI_USB54AR,
	    "BWIFI-USB54AR",
	},
	{
	    USB_VENDOR_BEWAN, USB_PRODUCT_BEWAN_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USB100,
	    "USB100N 10/100 Ethernet",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USBLP100,
	    "USB100LP",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USBEL100,
	    "USB100EL",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USBE100,
	    "USBE100",
	},
	{
	    USB_VENDOR_BILLIONTON, USB_PRODUCT_BILLIONTON_USB2AR,
	    "USB2AR Ethernet",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCMFW,
	    "BCMFW",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM2033,
	    "BCM2033",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM2033NF,
	    "BCM2033 (no fw)",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM43236,
	    "BCM43236",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM43143,
	    "BCM43143",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM43242,
	    "BCM43242",
	},
	{
	    USB_VENDOR_BROADCOM, USB_PRODUCT_BROADCOM_BCM43569,
	    "BCM43569",
	},
	{
	    USB_VENDOR_BROTHER, USB_PRODUCT_BROTHER_HL1050,
	    "HL-1050 laser printer",
	},
	{
	    USB_VENDOR_BROTHER, USB_PRODUCT_BROTHER_MFC210C,
	    "MFC 210C",
	},
	{
	    USB_VENDOR_BTC, USB_PRODUCT_BTC_BTC7932,
	    "Keyboard/Mouse",
	},
	{
	    USB_VENDOR_BWCT, USB_PRODUCT_BWCT_6CHCONSER,
	    "6ch ConSer",
	},
	{
	    USB_VENDOR_CACE, USB_PRODUCT_CACE_AIRPCAPNX,
	    "AirPcap Nx",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N656U,
	    "CANOSCAN N656U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N1220U,
	    "CANOSCAN N1220U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N670U,
	    "CANOSCAN N670U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_N1240U,
	    "CANOSCAN N1240U",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_LIDE60,
	    "CANOSCAN LiDE60",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S10,
	    "PowerShot S10",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S20,
	    "PowerShot S20",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S100_US,
	    "PowerShot S100",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_S100_EU,
	    "PowerShot S100",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_G1,
	    "PowerShot G1",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_A20,
	    "PowerShot A20",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_A540,
	    "PowerShot A540",
	},
	{
	    USB_VENDOR_CANON, USB_PRODUCT_CANON_SX100,
	    "PowerShot SX100",
	},
	{
	    USB_VENDOR_CASIO, USB_PRODUCT_CASIO_QV,
	    "QV",
	},
	{
	    USB_VENDOR_CASIO, USB_PRODUCT_CASIO_BE300,
	    "BE-300 PDA",
	},
	{
	    USB_VENDOR_CASIO, USB_PRODUCT_CASIO_NAMELAND,
	    "CASIO Nameland EZ-USB",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_NETMATE,
	    "Netmate Ethernet",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_NETMATE2,
	    "Netmate2 Ethernet",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_CHIEF,
	    "USB Chief Bus & Protocol Analyzer",
	},
	{
	    USB_VENDOR_CATC, USB_PRODUCT_CATC_ANDROMEDA,
	    "Andromeda hub",
	},
	{
	    USB_VENDOR_CCYU, USB_PRODUCT_CCYU_EASYDISK,
	    "EasyDisk Portable",
	},
	{
	    USB_VENDOR_CHENSOURCE, USB_PRODUCT_CHENSOURCE_CM12402,
	    "CM12402 Eagle IR Cam",
	},
	{
	    USB_VENDOR_CHERRY, USB_PRODUCT_CHERRY_MY3000KBD,
	    "My3000 keyboard",
	},
	{
	    USB_VENDOR_CHERRY, USB_PRODUCT_CHERRY_MY3000HUB,
	    "My3000 hub",
	},
	{
	    USB_VENDOR_CHIC, USB_PRODUCT_CHIC_MOUSE1,
	    "mouse",
	},
	{
	    USB_VENDOR_CHIC, USB_PRODUCT_CHIC_CYPRESS,
	    "Cypress",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_KB8933,
	    "KB-8933 keyboard",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_CAMERA,
	    "Integrated Camera",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_RTL8188CUS_1,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_RTL8188CUS_2,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_RTL8188CUS_3,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_RTL8188CUS_4,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_RTL8188CUS_5,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_RTL8188CUS_6,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_CHICONY, USB_PRODUCT_CHICONY_IRCAMERA,
	    "Integrated IR Camera",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_PROTHROTTLE,
	    "Pro Throttle",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_PROPEDALS,
	    "Pro Pedals",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_FIGHTERSTICK,
	    "Fighterstick",
	},
	{
	    USB_VENDOR_CHPRODUCTS, USB_PRODUCT_CHPRODUCTS_FLIGHTYOKE,
	    "Flight Sim Yoke",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54GV2,
	    "WUSB54G v2",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54AG,
	    "WUSB54AG",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54G,
	    "RT2570",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54GP,
	    "RT2570",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_USB200MV2,
	    "USB200M v2",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_HU200TS,
	    "HU200-TS",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54GC,
	    "WUSB54GC",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB54GR,
	    "WUSB54GR",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSBF54G,
	    "WUSBF54G",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_WUSB200,
	    "WUSB200",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_AE1000,
	    "AE1000",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_AM10,
	    "AM10",
	},
	{
	    USB_VENDOR_CISCOLINKSYS, USB_PRODUCT_CISCOLINKSYS_USB3GIGV1,
	    "USB3GIGV1",
	},
	{
	    USB_VENDOR_CISCOLINKSYS2, USB_PRODUCT_CISCOLINKSYS2_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_CISCOLINKSYS3, USB_PRODUCT_CISCOLINKSYS3_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_CLEVO, USB_PRODUCT_CLEVO_RTL8153B,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_CLIPSAL, USB_PRODUCT_CLIPSAL_560884,
	    "560884 C-Bus Switch",
	},
	{
	    USB_VENDOR_CLIPSAL, USB_PRODUCT_CLIPSAL_5500PACA,
	    "5500PACA C-Bus Controller",
	},
	{
	    USB_VENDOR_CLIPSAL, USB_PRODUCT_CLIPSAL_5800PC,
	    "5800PC C-Bus Wireless",
	},
	{
	    USB_VENDOR_CLIPSAL, USB_PRODUCT_CLIPSAL_5500PCU,
	    "5500PCU C-Bus",
	},
	{
	    USB_VENDOR_CLIPSAL, USB_PRODUCT_CLIPSAL_5000CT2,
	    "5000CT2 C-Bus Touch Screen",
	},
	{
	    USB_VENDOR_CLIPSAL, USB_PRODUCT_CLIPSAL_C5000CT2,
	    "C5000CT2 C-Bus Touch Screen",
	},
	{
	    USB_VENDOR_CLIPSAL, USB_PRODUCT_CLIPSAL_L51XX,
	    "L51xx C-Bus Dimmer",
	},
	{
	    USB_VENDOR_CLUB3D, USB_PRODUCT_CLUB3D_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CNU510,
	    "CDMA Technologies USB modem",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CM5100P,
	    "CM-5100P EVDO",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CCU550,
	    "CCU-550 EVDO",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CNU550PRO,
	    "CNU-550pro EVDO",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CGU628,
	    "CGU-628",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CNU680,
	    "CNU-680",
	},
	{
	    USB_VENDOR_CMOTECH, USB_PRODUCT_CMOTECH_CGU628_DISK,
	    "CGU-628 disk mode",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_IPAQPOCKETPC,
	    "iPAQ PocketPC",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_A1500,
	    "A1500",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_IPAQWLAN,
	    "iPAQ WLAN",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_W100,
	    "W100",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_W200,
	    "WLAN MultiPort W200",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_PJB100,
	    "Personal Jukebox PJB100",
	},
	{
	    USB_VENDOR_COMPAQ, USB_PRODUCT_COMPAQ_IPAQLINUX,
	    "iPAQ Linux",
	},
	{
	    USB_VENDOR_COMPARE, USB_PRODUCT_COMPARE_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_PRISM_GT,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_C11U,
	    "C11U",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_WL210,
	    "WL-210",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC, USB_PRODUCT_CONCEPTRONIC_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RTL8192SU_2,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RTL8192SU_3,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_C54RU,
	    "C54RU WLAN",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2870_7,
	    "RT2870",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2870_8,
	    "RT2870",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_C54RU2,
	    "C54RU",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2573,
	    "RT2573M",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_VIGORN61,
	    "VIGORN61",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2870_5,
	    "RT2870",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT2870_6,
	    "RT2870",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2, USB_PRODUCT_CONCEPTRONIC2_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_CONCORDCAMERA, USB_PRODUCT_CONCORDCAMERA_EYE_Q_3X,
	    "Eye Q 3x",
	},
	{
	    USB_VENDOR_CONNECTIX, USB_PRODUCT_CONNECTIX_QUICKCAM,
	    "QuickCam",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_ETHER_USB_T,
	    "Ether USB-T",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB_TX,
	    "FEther USB-TX",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLAN_USB_USB_11,
	    "WirelessLAN USB-11",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB_TXS,
	    "FEther USB-TXS",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLANUSB,
	    "Wireless LAN Stick-11",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB2_TX,
	    "FEther USB2-TX",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLUSB_11_KEY,
	    "ULUSB-11 Key",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_CGWLUSB2GL,
	    "CG-WLUSB2GL",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_CGWLUSB2GPX,
	    "CG-WLUSB2GPX",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_CGWLUSB300GNM,
	    "CG-WLUSB300GNM",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_CGWLUSB300N,
	    "CG-WLUSB300N",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_RTL8192SU,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_WLUSB_11_STICK,
	    "WLAN USB Stick 11",
	},
	{
	    USB_VENDOR_COREGA, USB_PRODUCT_COREGA_FETHER_USB_TXC,
	    "FEther USB-TXC",
	},
	{
	    USB_VENDOR_CORSAIR, USB_PRODUCT_CORSAIR_CP210X,
	    "CP210X",
	},
	{
	    USB_VENDOR_CREATIVE, USB_PRODUCT_CREATIVE_NOMAD_II,
	    "Nomad II",
	},
	{
	    USB_VENDOR_CREATIVE, USB_PRODUCT_CREATIVE_EMU0202,
	    "E-Mu 0202",
	},
	{
	    USB_VENDOR_CREATIVE, USB_PRODUCT_CREATIVE_NOMAD_IIMG,
	    "Nomad II MG",
	},
	{
	    USB_VENDOR_CREATIVE, USB_PRODUCT_CREATIVE_NOMAD,
	    "Nomad",
	},
	{
	    USB_VENDOR_CREATIVE2, USB_PRODUCT_CREATIVE2_VOIP_BLASTER,
	    "Voip Blaster",
	},
	{
	    USB_VENDOR_CSR, USB_PRODUCT_CSR_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_CSR, USB_PRODUCT_CSR_BLUECORE,
	    "BlueCore",
	},
	{
	    USB_VENDOR_CTC, USB_PRODUCT_CTC_CW6622,
	    "CW6622",
	},
	{
	    USB_VENDOR_CTX, USB_PRODUCT_CTX_EX1300,
	    "Ex1300 hub",
	},
	{
	    USB_VENDOR_CYBERPOWER, USB_PRODUCT_CYBERPOWER_UPS,
	    "UPS",
	},
	{
	    USB_VENDOR_CYBERPOWER, USB_PRODUCT_CYBERPOWER_1500,
	    "1500 UPS",
	},
	{
	    USB_VENDOR_CYBERPOWER, USB_PRODUCT_CYBERPOWER_OR2200,
	    "OR2200 UPS",
	},
	{
	    USB_VENDOR_CYBERTAN, USB_PRODUCT_CYBERTAN_GIGASET108,
	    "Siemens Gigaset 108",
	},
	{
	    USB_VENDOR_CYBERTAN, USB_PRODUCT_CYBERTAN_TG54USB,
	    "TG54USB",
	},
	{
	    USB_VENDOR_CYBERTAN, USB_PRODUCT_CYBERTAN_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_CYBERTAN, USB_PRODUCT_CYBERTAN_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_MOUSE,
	    "mouse",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_THERMO,
	    "thermometer",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_KBDHUB,
	    "Keyboard/Hub",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_FMRADIO,
	    "FM Radio",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_USBRS232,
	    "RS232",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_HUB2,
	    "USB2 Hub",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_LPRDK,
	    "CY4636 LP RDK Bridge",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_SISPM_OLD,
	    "Sispm - old version",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_SISPM,
	    "Sispm",
	},
	{
	    USB_VENDOR_CYPRESS, USB_PRODUCT_CYPRESS_SISPM_FLASH,
	    "Sispm - flash",
	},
	{
	    USB_VENDOR_DAISY, USB_PRODUCT_DAISY_DMC,
	    "PhotoClip",
	},
	{
	    USB_VENDOR_DALLAS, USB_PRODUCT_DALLAS_USB_FOB_IBUTTON,
	    "USB-FOB/iBUTTON",
	},
	{
	    USB_VENDOR_DALLAS, USB_PRODUCT_DALLAS_J6502,
	    "J-6502 speakers",
	},
	{
	    USB_VENDOR_DATAAPEX, USB_PRODUCT_DATAAPEX_MULTICOM,
	    "MultiCom",
	},
	{
	    USB_VENDOR_DAVICOM, USB_PRODUCT_DAVICOM_WK668,
	    "HenTong WK-668",
	},
	{
	    USB_VENDOR_DAVICOM, USB_PRODUCT_DAVICOM_DM9601,
	    "DM9601",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_AXIM,
	    "Axim X51v",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_BC02,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_TM1180,
	    "TrueMobile 1180 WLAN",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_PRISM_GT_1,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_BLUETOOTH350,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_PRISM_GT_2,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_W5500,
	    "W5500 HSDPA",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_U740,
	    "U740 CDMA",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_EU870D,
	    "EU870D HSDPA",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_DW5821E,
	    "DW5821e LTE",
	},
	{
	    USB_VENDOR_DELL, USB_PRODUCT_DELL_DW700,
	    "DW700 GPS",
	},
	{
	    USB_VENDOR_DELL2, USB_PRODUCT_DELL2_UPS,
	    "UPS",
	},
	{
	    USB_VENDOR_DELORME, USB_PRODUCT_DELORME_EMUSB,
	    "Earthmate GPS",
	},
	{
	    USB_VENDOR_DELORME, USB_PRODUCT_DELORME_EMLT20,
	    "Earthmate LT20",
	},
	{
	    USB_VENDOR_DIAMOND, USB_PRODUCT_DIAMOND_RIO500USB,
	    "Rio 500",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_SUPRAEXPRESS56K,
	    "Supra Express 56K",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_SUPRA2890,
	    "SupraMax 2890 56K",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_RIO600USB,
	    "Rio 600",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_RIO800USB,
	    "Rio 800",
	},
	{
	    USB_VENDOR_DIAMOND2, USB_PRODUCT_DIAMOND2_PSAPLAY120,
	    "Nike psa[play 120",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_WL200U,
	    "WL-200U",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_CHUSB611G,
	    "CHUSB 611G",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_WL240U,
	    "WL-240U",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_XH1153,
	    "XH1153 802.11b",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_CWD854F,
	    "C-Net CWD-854 rev F",
	},
	{
	    USB_VENDOR_DICKSMITH, USB_PRODUCT_DICKSMITH_RTL8187,
	    "RTL8187",
	},
	{
	    USB_VENDOR_DIGI, USB_PRODUCT_DIGI_ACCELEPORT2,
	    "AccelePort 2",
	},
	{
	    USB_VENDOR_DIGI, USB_PRODUCT_DIGI_ACCELEPORT4,
	    "AccelePort 4",
	},
	{
	    USB_VENDOR_DIGI, USB_PRODUCT_DIGI_ACCELEPORT8,
	    "AccelePort 8",
	},
	{
	    USB_VENDOR_DIGIANSWER, USB_PRODUCT_DIGIANSWER_ZIGBEE802154,
	    "ZigBee",
	},
	{
	    USB_VENDOR_DIGITALSTREAM, USB_PRODUCT_DIGITALSTREAM_PS2,
	    "PS/2 Active",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_GUC2020,
	    "IOGEAR DVI GUC2020",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_LD220,
	    "Samsung LD220",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_POLARIS2,
	    "Polaris2 USB dock",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_VCUD60,
	    "Rextron DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_CONV,
	    "StarTech CONV-USB2DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_DLDVI,
	    "DisplayLink DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_VGA10,
	    "CMP-USBVGA10",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_WSDVI,
	    "WS Tech DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_EC008,
	    "EasyCAP008 DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_LCD4300U,
	    "LCD-4300U",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_LCD8000U,
	    "LCD-8000U",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_HPDOCK,
	    "HP USB Docking",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_NL571,
	    "HP USB DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_M01061,
	    "Lenovo DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_NBDOCK,
	    "VideoHome NBdock1920",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_SWDVI,
	    "SUNWEIT DVI",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_LUM70,
	    "Lilliput UM-70",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_LT1421,
	    "Lenovo ThinkVision LT1421",
	},
	{
	    USB_VENDOR_DISPLAYLINK, USB_PRODUCT_DISPLAYLINK_UM7X0,
	    "nanovision MiMo",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DUBE100,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DUBE100C1,
	    "DUB-E100 rev C1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX4,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWL120E,
	    "DWL-120 rev E",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA130C,
	    "DWA-130 rev C",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RTL8192CU_1,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RTL8192CU_2,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RTL8192CU_3,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RTL8192CU_4,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA131B,
	    "DWA-131 rev B",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA125D1,
	    "DWA-125 rev D1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA123D1,
	    "DWA-123 rev D1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA137A1,
	    "DWA-137 rev A1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA131E1,
	    "DWA-131 rev E1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA121B1,
	    "DWA-121 rev B1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA182D1,
	    "DWA-182 rev D1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA171C1,
	    "DWA-171 rev C1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWL122,
	    "DWL-122",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLG120,
	    "DWL-G120",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWL120F,
	    "DWL-120 rev F",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLG122A2,
	    "DWL-G122 rev A2",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG132,
	    "DWL-AG132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG132_NF,
	    "DWL-AG132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLG132,
	    "DWL-G132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLG132_NF,
	    "DWL-G132",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG122,
	    "DWL-AG122",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWLAG122_NF,
	    "DWL-AG122",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DUBE100B1,
	    "DUB-E100 rev B1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RT3072,
	    "RT3072",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA140B3,
	    "DWA-140 rev B3",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA160B2,
	    "DWA-160 rev B2",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA127,
	    "DWA-127",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA125B2,
	    "DWA-125 rev B2",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA162,
	    "DWA-162 Wireless Adapter",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA140D1,
	    "DWA-140 rev D1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DWA130F1,
	    "DWA-130 rev F1",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650C,
	    "10Mbps Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX1,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX_PNA,
	    "1/10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX3,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650TX2,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DUB1312,
	    "DUB-1312",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RTL8153_1,
	    "RTL8153",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_RTL8153_2,
	    "RTL8153",
	},
	{
	    USB_VENDOR_DLINK, USB_PRODUCT_DLINK_DSB650,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RTL8192SU_2,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWA131A1,
	    "DWA-131 A1",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_WUA2340,
	    "WUA-2340",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_WUA2340_NF,
	    "WUA-2340",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWA160A2,
	    "DWA-160 A2",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWA130D1,
	    "DWA-130 rev D1",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_AR9271,
	    "AR9271",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWLG122C1,
	    "DWL-G122 rev C1",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_WUA1340,
	    "WUA-1340",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWA111,
	    "DWA-111",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWA110,
	    "DWA-110",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT3072,
	    "RT3072",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT3072_1,
	    "RT3072",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWA160A1,
	    "DWA-160 A1",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_DWA130,
	    "DWA-130",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT3070_4,
	    "RT3070",
	},
	{
	    USB_VENDOR_DLINK2, USB_PRODUCT_DLINK2_RT3070_5,
	    "RT3070",
	},
	{
	    USB_VENDOR_DLINK3, USB_PRODUCT_DLINK3_KVM221,
	    "KVM-221",
	},
	{
	    USB_VENDOR_DMI, USB_PRODUCT_DMI_SA2_0,
	    "Storage Adapter",
	},
	{
	    USB_VENDOR_DOMAIN, USB_PRODUCT_DOMAIN_ROCKCHIP,
	    "RockChip Media Player",
	},
	{
	    USB_VENDOR_DRAYTEK, USB_PRODUCT_DRAYTEK_VIGOR550,
	    "Vigor550",
	},
	{
	    USB_VENDOR_DRAYTEK, USB_PRODUCT_DRAYTEK_VIGOR600,
	    "Vigor600",
	},
	{
	    USB_VENDOR_DREAMCHEEKY, USB_PRODUCT_DREAMCHEEKY_ROCKETBABY,
	    "Missile Launcher",
	},
	{
	    USB_VENDOR_DREAMLINK, USB_PRODUCT_DREAMLINK_ULMB1,
	    "USB LED Message Board v1.0",
	},
	{
	    USB_VENDOR_DRESDENELEC, USB_PRODUCT_DRESDENELEC_STB,
	    "Sensor Terminal",
	},
	{
	    USB_VENDOR_DRESDENELEC, USB_PRODUCT_DRESDENELEC_WHT,
	    "Wireless Terminal",
	},
	{
	    USB_VENDOR_DVICO, USB_PRODUCT_DVICO_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_DYNABOOK, USB_PRODUCT_DYNABOOK_RTL8153B_1,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_DYNABOOK, USB_PRODUCT_DYNABOOK_RTL8153B_2,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_DYNASTREAM, USB_PRODUCT_DYNASTREAM_ANTDEVBOARD,
	    "ANT dev board",
	},
	{
	    USB_VENDOR_DYNASTREAM, USB_PRODUCT_DYNASTREAM_ANT2USB,
	    "ANT2USB",
	},
	{
	    USB_VENDOR_DYNASTREAM, USB_PRODUCT_DYNASTREAM_ANTDEVBOARD2,
	    "ANT dev board",
	},
	{
	    USB_VENDOR_DYNASTREAM, USB_PRODUCT_DYNASTREAM_ANTUSB2,
	    "ANTUSB-2 Stick",
	},
	{
	    USB_VENDOR_DYNASTREAM, USB_PRODUCT_DYNASTREAM_ANTUSBM,
	    "ANTUSB-m Stick",
	},
	{
	    USB_VENDOR_EASYDISK, USB_PRODUCT_EASYDISK_EASYDISK,
	    "Flash Disk",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7318,
	    "EW-7318",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_RTL8192SU_2,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7618,
	    "EW-7618",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_RTL8192SU_3,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7717,
	    "EW-7717",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7718,
	    "EW-7718",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7722UTN,
	    "EW-7722UTn",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7811UN,
	    "EW-7811Un",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7611ULB,
	    "EW-7611ULB",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7811UNV2,
	    "EW-7811Un V2",
	},
	{
	    USB_VENDOR_EDIMAX, USB_PRODUCT_EDIMAX_EW7822ULC,
	    "EW-7822ULC",
	},
	{
	    USB_VENDOR_EGALAX, USB_PRODUCT_EGALAX_TPANEL,
	    "Touch Panel",
	},
	{
	    USB_VENDOR_EGALAX, USB_PRODUCT_EGALAX_TPANEL2,
	    "Touch Panel",
	},
	{
	    USB_VENDOR_EGALAX2, USB_PRODUCT_EGALAX2_TPANEL,
	    "Touch Panel",
	},
	{
	    USB_VENDOR_EICON, USB_PRODUCT_EICON_DIVA852,
	    "Diva 852 ISDN TA",
	},
	{
	    USB_VENDOR_EIZO, USB_PRODUCT_EIZO_HUB,
	    "hub",
	},
	{
	    USB_VENDOR_EIZO, USB_PRODUCT_EIZO_MONITOR,
	    "monitor",
	},
	{
	    USB_VENDOR_ELAN, USB_PRODUCT_ELAN_BARCODE,
	    "Barcode Scanner",
	},
	{
	    USB_VENDOR_ELCON, USB_PRODUCT_ELCON_PLAN,
	    "Goldpfeil P-LAN",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MOUSE29UO,
	    "29UO",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MXT3URBK,
	    "M-XT3UR BK",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MXT3DRBK,
	    "M-XT3DR BK",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MXT4DRBK,
	    "M-XT4DR BK",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MDT1URBK,
	    "M-DT1UR BK",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MDT1DRBK,
	    "M-DT1DR BK",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MHT1URBK,
	    "M-HT1UR BK",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_MHT1DRBK,
	    "M-HT1DR BK",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX0,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX1,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBLTX,
	    "LD-USBL/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_WDC150SU2M,
	    "WDC-150SU2M",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX2,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSB20,
	    "LD-USB20",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_RTL8153B,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_RTL8156B,
	    "RTL8156B",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_UCSGT,
	    "UC-SGT Serial",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_UCSGT0,
	    "UC-SGT0 Serial",
	},
	{
	    USB_VENDOR_ELECOM, USB_PRODUCT_ELECOM_LDUSBTX3,
	    "LD-USB/TX",
	},
	{
	    USB_VENDOR_ELEKTOR, USB_PRODUCT_ELEKTOR_FT323R,
	    "FT323R",
	},
	{
	    USB_VENDOR_ELSA, USB_PRODUCT_ELSA_MODEM1,
	    "ELSA",
	},
	{
	    USB_VENDOR_ELSA, USB_PRODUCT_ELSA_USB2ETHERNET,
	    "Microlink USB2Ethernet",
	},
	{
	    USB_VENDOR_ELV, USB_PRODUCT_ELV_USBI2C,
	    "USB-I2C",
	},
	{
	    USB_VENDOR_EMPIA, USB_PRODUCT_EMPIA_EEEPC701_VIDEO,
	    "EeePC701 camera",
	},
	{
	    USB_VENDOR_ENCORE, USB_PRODUCT_ENCORE_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_ENCORE, USB_PRODUCT_ENCORE_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_ENCORE, USB_PRODUCT_ENCORE_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_1S,
	    "1S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_2S,
	    "2S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_1S25,
	    "1S25 serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_4S,
	    "4S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_E45,
	    "E45 Ethernet",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_CENTRONICS,
	    "Centronics",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_XX1,
	    "Ethernet",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_1S9,
	    "1S9 serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_EZUSB,
	    "EZ-USB",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_2U4S,
	    "2U4S serial",
	},
	{
	    USB_VENDOR_ENTREGA, USB_PRODUCT_ENTREGA_XX2,
	    "Ethernet",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER1,
	    "USB Printer",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER2,
	    "ISD Smart Cable for Mac",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER3,
	    "ISD Smart Cable",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_PRINTER5,
	    "USB Printer",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_636,
	    "Perfection 636U / 636Photo",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_610,
	    "Perfection 610",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1200,
	    "Perfection 1200U / 1200Photo",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1600,
	    "Expression 1600",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1640,
	    "Perfection 1640SU",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1240,
	    "Perfection 1240U / 1240Photo",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_640U,
	    "Perfection 640U",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1650,
	    "Perfection 1650",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_GT9700F,
	    "GT-9700F",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_2400,
	    "Perfection 2400",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1260,
	    "Perfection 1260",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1660,
	    "Perfection 1660",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_1670,
	    "Perfection 1670",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_CX5400,
	    "CX5400",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_CX3650,
	    "Stylus CX3650",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_DX3800,
	    "Stylus DX3800",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_DX5000,
	    "Stylus DX5000",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_DX6000,
	    "Stylus DX6000",
	},
	{
	    USB_VENDOR_EPSON, USB_PRODUCT_EPSON_DX4000,
	    "Stylus DX4000",
	},
	{
	    USB_VENDOR_ERICSSON, USB_PRODUCT_ERICSSON_F5521GW,
	    "Mobile Broadband Module",
	},
	{
	    USB_VENDOR_ETEK, USB_PRODUCT_ETEK_1COM,
	    "Serial",
	},
	{
	    USB_VENDOR_EVOLUTION, USB_PRODUCT_EVOLUTION_ER1,
	    "ER1 Control Module",
	},
	{
	    USB_VENDOR_EVOLUTION, USB_PRODUCT_EVOLUTION_RCM4_1,
	    "RCM4 interface",
	},
	{
	    USB_VENDOR_EVOLUTION, USB_PRODUCT_EVOLUTION_RCM4_2,
	    "RCM4 interface",
	},
	{
	    USB_VENDOR_EXAR, USB_PRODUCT_EXAR_XR21V1410,
	    "XR21V1410",
	},
	{
	    USB_VENDOR_EXTENDED, USB_PRODUCT_EXTENDED_XTNDACCESS,
	    "XTNDAccess IrDA",
	},
	{
	    USB_VENDOR_FALCOM, USB_PRODUCT_FALCOM_TWIST,
	    "Twist",
	},
	{
	    USB_VENDOR_FALCOM, USB_PRODUCT_FALCOM_SAMBA,
	    "Samba",
	},
	{
	    USB_VENDOR_FEIXUN, USB_PRODUCT_FEIXUN_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_FEIXUN, USB_PRODUCT_FEIXUN_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_FESTO, USB_PRODUCT_FESTO_CPX_USB,
	    "CPX-USB",
	},
	{
	    USB_VENDOR_FESTO, USB_PRODUCT_FESTO_CMSP,
	    "CMSP",
	},
	{
	    USB_VENDOR_FIBERLINE, USB_PRODUCT_FIBERLINE_WL430U,
	    "WL-430U",
	},
	{
	    USB_VENDOR_FOSSIL, USB_PRODUCT_FOSSIL_WRISTPDA,
	    "Wrist PDA",
	},
	{
	    USB_VENDOR_FOXCONN, USB_PRODUCT_FOXCONN_TCOM_TC_300,
	    "T-Com TC 300",
	},
	{
	    USB_VENDOR_FOXCONN, USB_PRODUCT_FOXCONN_PIRELLI_DP_L10,
	    "Pirelli DP-L10",
	},
	{
	    USB_VENDOR_FREECOM, USB_PRODUCT_FREECOM_DVD,
	    "Connector for DVD drive",
	},
	{
	    USB_VENDOR_FSC, USB_PRODUCT_FSC_E5400,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_1,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U232AM,
	    "8U232AM Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U232AM4,
	    "8U232AM Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_3,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_4,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_5,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_6,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_2232C,
	    "2232C Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT4232H,
	    "FT4232H",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FTX,
	    "FTX",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PS2KBDMS,
	    "PS/2 Keyboard/Mouse",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U100AX,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MJS_SIRIUS_PC_2,
	    "MJS Sirius To PC Interface",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENRD,
	    "OpenRD JTAGKey",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CANDAPTER,
	    "CANdapter",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_NXTCAM,
	    "Mindstorms NXTCam",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OOCDLINK,
	    "OOCDlink",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LM3S_DEVEL,
	    "LM3S Devel",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LM3S_EVAL,
	    "LM3S Eval",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TURTELIZER_JTAG,
	    "JTAG/RS-232",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC,
	    "OpenDCC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC_SNIFFER,
	    "OpenDCC Sniffer",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC_THROTTLE,
	    "OpenDCC Throttle",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC_GATEWAY,
	    "OpenDCC Gateway",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LOCOBUFFER,
	    "RR-CirKits LocoBuffer",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_DMX4ALL,
	    "DMX4ALL DMX interface",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_1,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_2,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_3,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_4,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_5,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_6,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_7,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_8,
	    "ASK RDR 4X7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MJS_SIRIUS_PC_1,
	    "MJS Sirius To PC Interface",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CHAMELEON,
	    "uChameleon",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENPORT_13M,
	    "OpenPort 1.3 Mitsubishi",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENPORT_13S,
	    "OpenPort 1.3 Subaru",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENPORT_13U,
	    "OpenPort 1.3 Universal",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_2232L,
	    "2232L Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_0,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_1,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_2,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_3,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_4,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_5,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_6,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_7,
	    "Radio Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IPLUS,
	    "iPlus",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IPLUS2,
	    "iPlus",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_1,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_2,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_3,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_4,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_5,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_6,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_7,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_8,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GAMMASCOUT,
	    "Gamma Scout Online",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_JTAGCABLEII,
	    "Propox JTAG",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_WESTREX_777,
	    "Westrex 777",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_WESTREX_8900F,
	    "Westrex 8900F",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACG_HFDUAL,
	    "HF Dual ISO Reader",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ARTEMIS,
	    "CCD camera",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16,
	    "ATK-16 Camera",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16HR,
	    "ATK-16HR Camera",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16C,
	    "ATK-16C Camera",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16HRC,
	    "ATK-16HRC Camera",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16IC,
	    "ATK-16IC Camera",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_USR,
	    "USR",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_MSM1,
	    "Mini-Sound-Modul",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_KL100,
	    "KL 100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS550,
	    "WS 550",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS888,
	    "WS 888",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_TWS550,
	    "WS 550",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FEM,
	    "Funk Energie Monitor",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_YEI_SC31,
	    "ServoCenter3.1",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FHZ1300PC,
	    "FHZ 1300 PC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS500,
	    "WS 500",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_HS485,
	    "RS-485",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UMS100,
	    "UMS 100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_TFD128,
	    "TFD 128",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FM3RX,
	    "FM3 RX",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS777,
	    "WS 777",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_EM1010PC,
	    "EM 1010 PC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_CSI8,
	    "CSI 8",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_EM1000DL,
	    "EM 1000 DL",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_PCK100,
	    "PCK 100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_RFP500,
	    "RFP 500",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FS20SIG,
	    "FS 20 SIG",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UTP8,
	    "UTP 8",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS300PC,
	    "WS 300 PC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS444PC,
	    "WS 444 PC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FISCO,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ECO_PRO,
	    "EVER Eco Pro UPS",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACTROBOTS,
	    "Active Robots comms",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PYRAMID,
	    "Pyramid Display",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_UNICOM,
	    "Unicom III",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_1,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_2,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_3,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_4,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_5,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_6,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_7,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_8,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_EISCOU,
	    "Expert ISDN",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_UOPTBR,
	    "RS232 OptoBridge",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_DCF,
	    "Expert mouseCLOCK USB II",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MSF,
	    "Expert mouseCLOCK USB II MSF",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_HBG,
	    "Expert mouseCLOCK USB II HBG",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_9,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_A,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_B,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ECLO_1WIRE,
	    "1-Wire",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TNCX,
	    "TNC-X packet-radio",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TERATRONIK_VCP,
	    "VCP",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TERATRONIK_D2XX,
	    "D2XX",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_REU_TINY,
	    "RigExpert Tiny",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_HO870,
	    "HO870",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_HO820,
	    "HO820",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_232BM,
	    "FT232BM Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_KW,
	    "KW",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_YS,
	    "YS",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y6,
	    "Y6",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y8,
	    "Y8",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_IC,
	    "IC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_DB9,
	    "DB9",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_RS232,
	    "RS232",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y9,
	    "Y9",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_DGQG,
	    "DGQG",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_DUSB,
	    "DUSB",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UAD8,
	    "UAD 8",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UAD7,
	    "UAD 7",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_USI2,
	    "USI 2",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_T1100,
	    "T 1100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_PCD200,
	    "PCD 200",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_ULA200,
	    "ULA 200",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_ALC8500,
	    "ALC 8500 Expert",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FHZ1000PC,
	    "FHZ 1000 PC",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PERLE_UP,
	    "UltraPort",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SPROG_II,
	    "Sprog II",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PIEGROUP_IR,
	    "Infrared",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACTZWAVE,
	    "HomePro ZWave",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GALAXY_1,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GALAXY_2,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_COASTAL_TNCX,
	    "Coastal ChipWorks TNC-X",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_MASTER2,
	    "Master Development 2.0",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_1,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_2,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_3,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OCEANIC,
	    "Oceanic instrument",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SUUNTO,
	    "Suunto Sports",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_USBUIRT,
	    "USB-UIRT",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_USBX_707,
	    "USBX-707",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_ICDU20,
	    "ICD-U20",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_ICDU40,
	    "ICD-U40",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_MACHX,
	    "MACH-X",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_LOAD_N_GO,
	    "LOAD N GO",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_ICDU64,
	    "ICDU64",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_PRIME8,
	    "PRIME8",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ITM_TOUCH,
	    "ITM Touchscreen",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_USBSERIAL,
	    "Matrix Orbital USB Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_MX200,
	    "Matrix Orbital MX200 Series LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_MTXO,
	    "Matrix Orbital LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_LK202_24,
	    "Matrix Orbital LK202-24 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_LK204_24,
	    "Matrix Orbital LK204-24 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MATRIX_2,
	    "Matrix Orbital LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MATRIX_3,
	    "Matrix Orbital LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_RELAIS,
	    "Relais",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TIRA1,
	    "Tira-1",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PCDJ_DAC2,
	    "DAC-2",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACCESSO,
	    "Accesso reader",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_THORLABS,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UR100,
	    "UR 100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_CLI7000,
	    "CLI 7000",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UM100,
	    "UM 100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UO100,
	    "UO 100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_PPS7330,
	    "PPS 7330",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_TFM100,
	    "TFM 100",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UDF77,
	    "UDF 77",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UIO88,
	    "UIO 88",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_R2000KU_RNG,
	    "R2000KU RNG",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_BCS_SE923,
	    "BCS SE923",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232RL,
	    "FT232RL",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_632,
	    "Crystalfontz CFA-632 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_634,
	    "Crystalfontz CFA-634 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_547,
	    "Crystalfontz CFA-547 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_633,
	    "Crystalfontz CFA-633 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_631,
	    "Crystalfontz CFA-631 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_635,
	    "Crystalfontz CFA-635 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_640,
	    "Crystalfontz CFA-640 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_642,
	    "Crystalfontz CFA-642 LCD",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IRTRANS,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_1,
	    "Protego",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_R200,
	    "R200-USB TRNG",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_3,
	    "Protego",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_4,
	    "Protego",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SEMC_DSS20,
	    "SEMC DSS-20 SyncStation",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CANVIEW,
	    "CANview",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_VNHC,
	    "Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_AMC232,
	    "AMC-232USB0",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TTUSB,
	    "TT-USB",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_US485,
	    "US485",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PICPRO,
	    "PIC-Programmer",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PCMCIA,
	    "PCMCIA SRAM-cards reader",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PK1,
	    "Particel counter PK1",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_RS232MON,
	    "RS232",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_APP70,
	    "APP 70 dust monitoring",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PEDO,
	    "IBS PEDO-Modem",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_1,
	    "Serial",
	},
	{
	    USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CANUSB,
	    "CANUSB",
	},
	{
	    USB_VENDOR_FUJIPHOTO, USB_PRODUCT_FUJIPHOTO_MASS0100,
	    "Mass Storage",
	},
	{
	    USB_VENDOR_FUJITSU, USB_PRODUCT_FUJITSU_AH_F401U,
	    "AH-F401U Air H device",
	},
	{
	    USB_VENDOR_FUJITSUCOMP, USB_PRODUCT_FUJITSUCOMP_KEYBOARD6,
	    "Type 6 Keyboard",
	},
	{
	    USB_VENDOR_FUJITSUCOMP, USB_PRODUCT_FUJITSUCOMP_KEYBOARD7,
	    "Type 7 Keyboard",
	},
	{
	    USB_VENDOR_FUJITSUCOMP, USB_PRODUCT_FUJITSUCOMP_MOUSE,
	    "Type 6 Mouse",
	},
	{
	    USB_VENDOR_FUJITSUCOMP, USB_PRODUCT_FUJITSUCOMP_FX5204PS,
	    "Smart Power Strip FX-5204PS",
	},
	{
	    USB_VENDOR_FUJITSUCOMP, USB_PRODUCT_FUJITSUCOMP_FX5251WB,
	    "Base Station FX-5251WB",
	},
	{
	    USB_VENDOR_FUJITSUCOMP, USB_PRODUCT_FUJITSUCOMP_VIRTETH,
	    "Virtual Eth Device",
	},
	{
	    USB_VENDOR_FUSHICAI, USB_PRODUCT_FUSHICAI_USBTV007,
	    "Fushicai Audio-Video Grabber",
	},
	{
	    USB_VENDOR_GARMIN, USB_PRODUCT_GARMIN_GPSMAP60CSX,
	    "GPSmap 60Csx",
	},
	{
	    USB_VENDOR_GARMIN, USB_PRODUCT_GARMIN_IQUE3600,
	    "Ique 3600",
	},
	{
	    USB_VENDOR_GARMIN, USB_PRODUCT_GARMIN_DAKOTA20,
	    "Dakota 20",
	},
	{
	    USB_VENDOR_GARMIN, USB_PRODUCT_GARMIN_GPSMAP62S,
	    "GPSmap 62s",
	},
	{
	    USB_VENDOR_GCTSEMICON, USB_PRODUCT_GCTSEMICON_INSTALL,
	    "GDM720x MASS storage mode",
	},
	{
	    USB_VENDOR_GEARHEAD, USB_PRODUCT_GEARHEAD_GHKB,
	    "Gear Head Keyboard",
	},
	{
	    USB_VENDOR_GEARHEAD, USB_PRODUCT_GEARHEAD_GHKB107,
	    "Gear Head 107-Key Keyboard",
	},
	{
	    USB_VENDOR_GEMPLUS, USB_PRODUCT_GEMPLUS_PROXPU,
	    "Prox-PU/CU",
	},
	{
	    USB_VENDOR_GENESYS, USB_PRODUCT_GENESYS_GL620USB_A,
	    "GL620USB-A GeneLink USB-USB Bridge",
	},
	{
	    USB_VENDOR_GENESYS, USB_PRODUCT_GENESYS_GENELINK,
	    "GeneLink Host-Host Bridge",
	},
	{
	    USB_VENDOR_GENESYS, USB_PRODUCT_GENESYS_GL650,
	    "GL650 Hub",
	},
	{
	    USB_VENDOR_GENESYS, USB_PRODUCT_GENESYS_GL641USB,
	    "GL641USB CompactFlash",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNBR402W,
	    "GN-BR402W",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWLBM101,
	    "GN-WLBM101",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWBKG,
	    "GN-WBKG",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWB01GS,
	    "GN-WB01GS",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWI05GS,
	    "GN-WI05GS",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWB31N,
	    "GN-WB31N",
	},
	{
	    USB_VENDOR_GIGABYTE, USB_PRODUCT_GIGABYTE_GNWB32L,
	    "GN-WB32L",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_WLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_SMCWUSBTG,
	    "SMCWUSBT-G",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_SMCWUSBTG_NF,
	    "SMCWUSBT-G",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_AR5523,
	    "AR5523",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_AR5523_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_GIGASET, USB_PRODUCT_GIGASET_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_GLOBALSUN, USB_PRODUCT_GLOBALSUN_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_GLOBESPAN, USB_PRODUCT_GLOBESPAN_PRISM_GT_1,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_GLOBESPAN, USB_PRODUCT_GLOBESPAN_PRISM_GT_2,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_GMATE, USB_PRODUCT_GMATE_YP3X00,
	    "YP3X00 PDA",
	},
	{
	    USB_VENDOR_GNOTOMETRICS, USB_PRODUCT_GNOTOMETRICS_AURICAL,
	    "Aurical",
	},
	{
	    USB_VENDOR_GOHUBS, USB_PRODUCT_GOHUBS_GOCOM232,
	    "GoCOM232 Serial converter",
	},
	{
	    USB_VENDOR_GOODWAY, USB_PRODUCT_GOODWAY_GWUSB2E,
	    "GWUSB2E",
	},
	{
	    USB_VENDOR_GOODWAY, USB_PRODUCT_GOODWAY_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_GRAVIS, USB_PRODUCT_GRAVIS_GAMEPADPRO,
	    "GamePad Pro",
	},
	{
	    USB_VENDOR_GREENHOUSE, USB_PRODUCT_GREENHOUSE_KANA21,
	    "CF-writer/MP3 Player",
	},
	{
	    USB_VENDOR_GRIFFIN, USB_PRODUCT_GRIFFIN_IMATE,
	    "iMate, ADB adapter",
	},
	{
	    USB_VENDOR_GUDE, USB_PRODUCT_GUDE_DCF,
	    "Expert mouseCLOCK USB",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_DALEADER,
	    "DA Leader",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWGUSB254,
	    "HWGUSB2-54 WLAN",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWGUSB254LB,
	    "HWGUSB2-54-LB",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWGUSB254V2AP,
	    "HWGUSB2-54V2-AP",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWNU300,
	    "HWNU-300",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWNUM300,
	    "HWNUm-300",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWGUN54,
	    "HWGUn-54",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_HWNUP150,
	    "HWNUP-150",
	},
	{
	    USB_VENDOR_GUILLEMOT, USB_PRODUCT_GUILLEMOT_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_GUNZE, USB_PRODUCT_GUNZE_TOUCHPANEL,
	    "Gunze USB Touch Panel",
	},
	{
	    USB_VENDOR_HAGIWARA, USB_PRODUCT_HAGIWARA_FGSM,
	    "FlashGate SmartMedia",
	},
	{
	    USB_VENDOR_HAGIWARA, USB_PRODUCT_HAGIWARA_FGCF,
	    "FlashGate CompactFlash",
	},
	{
	    USB_VENDOR_HAGIWARA, USB_PRODUCT_HAGIWARA_FG,
	    "FlashGate",
	},
	{
	    USB_VENDOR_HAILUCK, USB_PRODUCT_HAILUCK_KEYBOARD,
	    "Keyboard",
	},
	{
	    USB_VENDOR_HAL, USB_PRODUCT_HAL_IMR001,
	    "Crossam2+USB IR commander",
	},
	{
	    USB_VENDOR_HANDSPRING, USB_PRODUCT_HANDSPRING_VISOR,
	    "Handspring Visor",
	},
	{
	    USB_VENDOR_HANDSPRING, USB_PRODUCT_HANDSPRING_TREO,
	    "Handspring Treo",
	},
	{
	    USB_VENDOR_HANDSPRING, USB_PRODUCT_HANDSPRING_TREO600,
	    "Handspring Treo 600",
	},
	{
	    USB_VENDOR_HAUPPAUGE, USB_PRODUCT_HAUPPAUGE_WINTV_USB_FM,
	    "WinTV FM",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_HWUN2,
	    "HWUN2",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_HWDN2,
	    "HWDN2",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RTL8192SU_2,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RT2870_4,
	    "RT2870",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RT2870_5,
	    "RT2870",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_RTL8192CU_2,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_HAWKING, USB_PRODUCT_HAWKING_UF100,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_HIROSE, USB_PRODUCT_HIROSE_USB100,
	    "USB-100",
	},
	{
	    USB_VENDOR_HITACHI, USB_PRODUCT_HITACHI_DZMV100A,
	    "DVD-CAM DZ-MV100A Camcorder",
	},
	{
	    USB_VENDOR_HOLTEK, USB_PRODUCT_HOLTEK_MOUSE,
	    "Mouse",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_895C,
	    "DeskJet 895C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_4100C,
	    "Scanjet 4100C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_S20,
	    "Photosmart S20",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_880C,
	    "DeskJet 880C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_4200C,
	    "ScanJet 4200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_CDWRITERPLUS,
	    "CD-Writer Plus",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_KBDHUB,
	    "Multimedia Keyboard Hub",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_HN210W,
	    "HN210W",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_HPX9GP,
	    "HP-x9G+",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_6200C,
	    "ScanJet 6200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_S20B,
	    "PhotoSmart S20",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_815C,
	    "DeskJet 815C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_3300C,
	    "ScanJet 3300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_CDW8200,
	    "CD-Writer Plus 8200e",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1220C,
	    "DeskJet 1220C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_810C,
	    "DeskJet 810C/812C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_4300C,
	    "Scanjet 4300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_CD4E,
	    "CD-Writer+ CD-4e",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_G85XI,
	    "OfficeJet G85xi",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1200,
	    "LaserJet 1200",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_5200C,
	    "Scanjet 5200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_830C,
	    "DeskJet 830C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_3400CSE,
	    "ScanJet 3400cse",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_885C,
	    "DeskJet 885C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1000,
	    "LaserJet 1000",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_6300C,
	    "Scanjet 6300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_840C,
	    "DeskJet 840c",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_2200C,
	    "ScanJet 2200C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_5300C,
	    "Scanjet 5300C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_816C,
	    "DeskJet 816C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_970CSE,
	    "Deskjet 970Cse",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_5400C,
	    "Scanjet 5400C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_2215,
	    "iPAQ 22xx/Jornada 548",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_959C,
	    "Deskjet 959C",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_568J,
	    "Jornada 568",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_930C,
	    "DeskJet 930c",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1005,
	    "LaserJet 1005",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_P2000U,
	    "Inkjet P-2000U",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_HS2300,
	    "HS2300",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_T750,
	    "T750 UPS",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_T1000,
	    "T1000 UPS",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_T1500,
	    "T1500 UPS",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_RT2200,
	    "R/T2200 UPS",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_R1500G2,
	    "R1500 G2 UPS",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_T750G2,
	    "T750 G2 UPS",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_640C,
	    "DeskJet 640c",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1020,
	    "LaserJet 1020",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_P1100,
	    "Photosmart P1100",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_LD220,
	    "LD220",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_1018,
	    "LaserJet 1018",
	},
	{
	    USB_VENDOR_HP, USB_PRODUCT_HP_HN210E,
	    "HN210E Ethernet",
	},
	{
	    USB_VENDOR_HP2, USB_PRODUCT_HP2_C500,
	    "PhotoSmart C500",
	},
	{
	    USB_VENDOR_HP3, USB_PRODUCT_HP3_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_HTC, USB_PRODUCT_HTC_PPC6700MODEM,
	    "PPC6700 Modem",
	},
	{
	    USB_VENDOR_HTC, USB_PRODUCT_HTC_SMARTPHONE,
	    "SmartPhone",
	},
	{
	    USB_VENDOR_HTC, USB_PRODUCT_HTC_ANDROID,
	    "Android phone",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E618,
	    "E618 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E220,
	    "E220 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_MOBILE,
	    "Modem",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_EM770W,
	    "EM770W WCDMA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E1750,
	    "E1750 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E180,
	    "E180 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E510,
	    "E510 HSDPA/DVB-T",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E181,
	    "E181 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E1752,
	    "E1752 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E182,
	    "E182 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E3372,
	    "E3372 LTE",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E161,
	    "E161 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_K3765,
	    "K3765 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E1820,
	    "E1820 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_K4511,
	    "K4511 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_K4510,
	    "K4510 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_K3772,
	    "K3772 LTE",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E353_INIT,
	    "E353 Initial",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E392_INIT,
	    "E392 Initial",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_K3765_INIT,
	    "K3765 Initial",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_K3772_INIT,
	    "K3772 Initial",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_MU609,
	    "ME906 LTE",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_ME906S,
	    "ME906s LTE",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E173S,
	    "E173s HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E173S_INIT,
	    "E173s Initial",
	},
	{
	    USB_VENDOR_HUAWEI, USB_PRODUCT_HUAWEI_E303,
	    "E303 HSDPA",
	},
	{
	    USB_VENDOR_HUAWEI3COM, USB_PRODUCT_HUAWEI3COM_WUB320G,
	    "Aolynk WUB320g",
	},
	{
	    USB_VENDOR_HUMAX, USB_PRODUCT_HUMAX_PVRSMART,
	    "PVR-SMART",
	},
	{
	    USB_VENDOR_HYUNDAI, USB_PRODUCT_HYUNDAI_PC5740,
	    "PC5740 EVDO",
	},
	{
	    USB_VENDOR_HYUNDAI, USB_PRODUCT_HYUNDAI_UM175,
	    "UM175 EVDO",
	},
	{
	    USB_VENDOR_IBM, USB_PRODUCT_IBM_OPTTRAVELMOUSE,
	    "Optical",
	},
	{
	    USB_VENDOR_IBM, USB_PRODUCT_IBM_OPTWHEELMOUSE,
	    "Wheel",
	},
	{
	    USB_VENDOR_IBM, USB_PRODUCT_IBM_USBCDROMDRIVE,
	    "CD-ROM",
	},
	{
	    USB_VENDOR_IBM, USB_PRODUCT_IBM_THINKPADHUB,
	    "Hub",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_ID1,
	    "ID-1",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2C1,
	    "ID-RP2C service 1",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2C2,
	    "ID-RP2C service 2",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2D,
	    "ID-RP2D",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2VT,
	    "ID-RP2V service T",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2VR,
	    "ID-RP2V service R",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP4000VT,
	    "ID-RP4000V service T",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP4000VR,
	    "ID-RP4000V service R",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2000VT,
	    "ID-RP2000V service T",
	},
	{
	    USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2000VR,
	    "ID-RP2000V service R",
	},
	{
	    USB_VENDOR_IDOWELL, USB_PRODUCT_IDOWELL_IDOWELL,
	    "UPS",
	},
	{
	    USB_VENDOR_IDQUANTIQUE, USB_PRODUCT_IDQUANTIQUE_QUANTISUSB,
	    "Quantis USB",
	},
	{
	    USB_VENDOR_IDTECH, USB_PRODUCT_IDTECH_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_IIYAMA, USB_PRODUCT_IIYAMA_HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_IMATION, USB_PRODUCT_IMATION_FLASHGO,
	    "Flash Go!",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4,
	    "EdgePort/4 RS232",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_HUBPORT7,
	    "Hubport/7",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_RAPIDPORT4,
	    "Rapidport/4",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4T,
	    "Edgeport/4 RS232",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT2,
	    "Edgeport/2 RS232",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4I,
	    "Edgeport/4 RS422",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT2I,
	    "Edgeport/2 RS422/RS485",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_HUBPORT4,
	    "Hubport/4",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8HAND,
	    "Hand-built Edgeport/8",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_MULTIMODEM,
	    "MultiTech version of RP/4",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORTPPORT,
	    "Edgeport/(4)21 Parallel",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT421,
	    "Edgeport/421 Hub+RS232+Parallel",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT21,
	    "Edgeport/21 RS232+Parallel",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8DC,
	    "1/2 Edgeport/8",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8,
	    "Edgeport/8",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT2DIN,
	    "Edgeport/2 RS232/DIN",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT4DIN,
	    "Edgeport/4 RS232/DIN",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT16DC,
	    "1/2 Edgeport/16",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORTCOMP,
	    "Edgeport Compatible",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_EDGEPORT8I,
	    "Edgeport/8 RS422",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_WATCHPORTH,
	    "WatchPort/H",
	},
	{
	    USB_VENDOR_INSIDEOUT, USB_PRODUCT_INSIDEOUT_MT4X56USB,
	    "OEM device",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_F5U002,
	    "Parallel",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ATAPI,
	    "ATAPI",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_IDEUSB2,
	    "USB2 Storage",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ISD110,
	    "IDE ISD110",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ISD105,
	    "IDE ISD105",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_DRIVEV2,
	    "Portable USB Harddrive V2",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_DRIVEV2_5,
	    "Portable USB Harddrive V2",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_USBCABLE,
	    "USB cable",
	},
	{
	    USB_VENDOR_INSYSTEM, USB_PRODUCT_INSYSTEM_ADAPTERV2,
	    "USB Storage Adapter V2",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_EASYPC_CAMERA,
	    "EasyPC",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_AP310,
	    "AP310 AnyPoint II",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_I2011B,
	    "Wireless 2011B",
	},
	{
	    USB_VENDOR_INTEL, USB_PRODUCT_INTEL_TESTBOARD,
	    "82930 test board",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_1,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_2,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_BLUETOOTH3,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_BLUETOOTH5,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_BLUETOOTH4,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_BLUETOOTH2,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_3,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_5,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_7,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_4,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_6,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTEL2, USB_PRODUCT_INTEL2_RMH_8,
	    "Rate Matching Hub",
	},
	{
	    USB_VENDOR_INTERBIO, USB_PRODUCT_INTERBIO_IOBOARD,
	    "IO Board",
	},
	{
	    USB_VENDOR_INTERBIO, USB_PRODUCT_INTERBIO_MINIIOBOARD,
	    "Mini IO Board",
	},
	{
	    USB_VENDOR_INTERBIO, USB_PRODUCT_INTERBIO_MINIIOBOARD2,
	    "Mini IO Board",
	},
	{
	    USB_VENDOR_INTERSIL, USB_PRODUCT_INTERSIL_PRISM_GT,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_INTERSIL, USB_PRODUCT_INTERSIL_PRISM_2X,
	    "Prism2.x WLAN",
	},
	{
	    USB_VENDOR_INTREPIDCS, USB_PRODUCT_INTREPIDCS_VALUECAN,
	    "ValueCAN",
	},
	{
	    USB_VENDOR_INTREPIDCS, USB_PRODUCT_INTREPIDCS_NEOVI,
	    "NeoVI Blue",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBSSMRW,
	    "USB-SSMRW SD-card",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBSDRW,
	    "USB-SDRW SD-card",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBETT,
	    "USB ET/T",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBETTX,
	    "USB ET/TX",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBETTXS,
	    "USB ET/TX-S",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBWNB11A,
	    "USB WN-B11",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBWNB11,
	    "USB Airport WN-B11",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBWNG54US,
	    "USB WN-G54/US",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBWNG54US_NF,
	    "USB WN-G54/US",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_ETXUS2,
	    "ETX-US2",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_ETGUS2,
	    "ETG-US2",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_FT232R,
	    "FT232R",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_WNGDNUS2,
	    "WN-GDN/US2",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_RT3072_1,
	    "RT3072",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_RT3072_2,
	    "RT3072",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_RT3072_3,
	    "RT3072",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_RT3072_4,
	    "RT3072",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_WNG150UM,
	    "WN-G150UM",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBRSAQ,
	    "RSAQ1 Serial",
	},
	{
	    USB_VENDOR_IODATA, USB_PRODUCT_IODATA_USBRSAQ5,
	    "RSAQ5 Serial",
	},
	{
	    USB_VENDOR_IODATA2, USB_PRODUCT_IODATA2_USB2SC,
	    "USB2.0-SCSI Bridge USB2-SC",
	},
	{
	    USB_VENDOR_IOI, USB_PRODUCT_IOI_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_ZIP100,
	    "Zip 100",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_ZIP250,
	    "Zip 250",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_ZIP250_2,
	    "Zip 250",
	},
	{
	    USB_VENDOR_IOMEGA, USB_PRODUCT_IOMEGA_CDRW,
	    "CDRW 9602",
	},
	{
	    USB_VENDOR_IRIVER, USB_PRODUCT_IRIVER_IFP_1XX,
	    "iFP-1xx",
	},
	{
	    USB_VENDOR_IRIVER, USB_PRODUCT_IRIVER_IFP_3XX,
	    "iFP-3xx",
	},
	{
	    USB_VENDOR_IRIVER, USB_PRODUCT_IRIVER_IFP_5XX,
	    "iFP-5xx",
	},
	{
	    USB_VENDOR_ISSC, USB_PRODUCT_ISSC_KYBT100,
	    "KY-BT100 Bluetooth",
	},
	{
	    USB_VENDOR_ITEGNO, USB_PRODUCT_ITEGNO_WM1080A,
	    "WM1080A",
	},
	{
	    USB_VENDOR_JABLOTRON, USB_PRODUCT_JABLOTRON_PC60B,
	    "PC-60B",
	},
	{
	    USB_VENDOR_JATON, USB_PRODUCT_JATON_EDA,
	    "Ethernet",
	},
	{
	    USB_VENDOR_JENOPTIK, USB_PRODUCT_JENOPTIK_JD350,
	    "JD 350",
	},
	{
	    USB_VENDOR_JETI, USB_PRODUCT_JETI_SPC1201,
	    "SPECBOS 1201",
	},
	{
	    USB_VENDOR_JRC, USB_PRODUCT_JRC_AH_J3001V_J3002V,
	    "AirH\"PHONE AH-J3001V/J3002V",
	},
	{
	    USB_VENDOR_JVC, USB_PRODUCT_JVC_MP_PRX1,
	    "MP-PRX1",
	},
	{
	    USB_VENDOR_JVC, USB_PRODUCT_JVC_MP_XP7250_WL,
	    "MP-XP7250 Builtin WLAN",
	},
	{
	    USB_VENDOR_KAMSTRUP, USB_PRODUCT_KAMSTRUP_OPTICALEYE,
	    "Optical Eye/3-wire",
	},
	{
	    USB_VENDOR_KAMSTRUP, USB_PRODUCT_KAMSTRUP_MBUS_250D,
	    "M-Bus Master MultiPort 250D",
	},
	{
	    USB_VENDOR_KAWATSU, USB_PRODUCT_KAWATSU_MH4000P,
	    "MiniHub 4000P",
	},
	{
	    USB_VENDOR_KAWATSU, USB_PRODUCT_KAWATSU_KC180,
	    "KC-180 IrDA",
	},
	{
	    USB_VENDOR_KEISOKUGIKEN, USB_PRODUCT_KEISOKUGIKEN_USBDAQ,
	    "HKS-0200 USBDAQ",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_ORBIT,
	    "Orbit trackball",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_TURBOBALL,
	    "TurboBall",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_ORBIT_MAC,
	    "Orbit trackball for Mac",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_BT_EDR,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_SLIMBLADE,
	    "Slimblade Trackball",
	},
	{
	    USB_VENDOR_KENSINGTON, USB_PRODUCT_KENSINGTON_VIDEOCAM_VGA,
	    "VideoCAM VGA",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28_NF,
	    "USA-28 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28X_NF,
	    "USA-28X serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19_NF,
	    "USA-19 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18_NF,
	    "USA-18 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18X_NF,
	    "USA-18X serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19W_NF,
	    "USA-19W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19,
	    "USA-19 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19W,
	    "USA-19W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA49W_NF,
	    "USA-49W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA49W,
	    "USA-49W serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QI_NF,
	    "USA-19QI serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QI,
	    "USA-19QI serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19Q_NF,
	    "USA-19Q serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19Q,
	    "USA-19Q serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28,
	    "USA-28 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XXB,
	    "USA-28X/XB serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18,
	    "USA-18 serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18X,
	    "USA-18X serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XB_NF,
	    "USA-28XB serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XA_NF,
	    "USA-28XB serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA28XA,
	    "USA-28XA serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18XA_NF,
	    "USA-18XA serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA18XA,
	    "USA-18XA serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QW_NF,
	    "USA-19WQ serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19QW,
	    "USA-19WQ serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_USA19HS,
	    "USA-19HS serial",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_UIA10,
	    "UIA-10 remote control",
	},
	{
	    USB_VENDOR_KEYSPAN, USB_PRODUCT_KEYSPAN_UIA11,
	    "UIA-11 remote control",
	},
	{
	    USB_VENDOR_KINGSTON, USB_PRODUCT_KINGSTON_XX1,
	    "Ethernet",
	},
	{
	    USB_VENDOR_KINGSTON, USB_PRODUCT_KINGSTON_KNU101TX,
	    "KNU101TX Ethernet",
	},
	{
	    USB_VENDOR_KLSI, USB_PRODUCT_KLSI_DUH3E10BT,
	    "10BT Ethernet",
	},
	{
	    USB_VENDOR_KLSI, USB_PRODUCT_KLSI_DUH3E10BTN,
	    "10BT Ethernet",
	},
	{
	    USB_VENDOR_KOBIL, USB_PRODUCT_KOBIL_B1,
	    "Konverter for B1",
	},
	{
	    USB_VENDOR_KOBIL, USB_PRODUCT_KOBIL_KAAN,
	    "Konverter for KAAN",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC220,
	    "Digital Science DC220",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC260,
	    "Digital Science DC260",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC265,
	    "Digital Science DC265",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC290,
	    "Digital Science DC290",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC240,
	    "Digital Science DC240",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DC280,
	    "Digital Science DC280",
	},
	{
	    USB_VENDOR_KODAK, USB_PRODUCT_KODAK_DX4900,
	    "EasyShare DX4900",
	},
	{
	    USB_VENDOR_KONICA, USB_PRODUCT_KONICA_CAMERA,
	    "Camera",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_NICHE,
	    "Niche mouse",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_NETSCROLL,
	    "Genius NetScroll mouse",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_FLIGHT2000,
	    "Flight 2000 joystick",
	},
	{
	    USB_VENDOR_KYE, USB_PRODUCT_KYE_VIVIDPRO,
	    "ColorPage Vivid-Pro",
	},
	{
	    USB_VENDOR_KYOCERA, USB_PRODUCT_KYOCERA_AHK3001V,
	    "AH-K3001V",
	},
	{
	    USB_VENDOR_KYOCERA2, USB_PRODUCT_KYOCERA2_KPC650,
	    "KPC650 EVDO",
	},
	{
	    USB_VENDOR_LACIE, USB_PRODUCT_LACIE_HD,
	    "Hard Disk",
	},
	{
	    USB_VENDOR_LACIE, USB_PRODUCT_LACIE_CDRW,
	    "CD R/W",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M121,
	    "Model 121",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M218A,
	    "Model 218A",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M219,
	    "Model 219",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M233,
	    "Model 233",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M235,
	    "Model 235",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M335,
	    "Model 335",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M336,
	    "Model 336",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M350,
	    "Model 350",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M371,
	    "Model 371",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M411,
	    "Model 411",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M425,
	    "Model 425",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M455A,
	    "Model 455A",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M475A,
	    "Model 475A",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M465,
	    "Model 465",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M625A,
	    "Model 625A",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M642A,
	    "Model 642A",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M648,
	    "Model 648",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M737,
	    "Model 737",
	},
	{
	    USB_VENDOR_LAKESHORE, USB_PRODUCT_LAKESHORE_M776,
	    "Model 776",
	},
	{
	    USB_VENDOR_LARSENBRUSGAARD, USB_PRODUCT_LARSENBRUSGAARD_ALTITRACK,
	    "AltiTrack",
	},
	{
	    USB_VENDOR_LEADTEK, USB_PRODUCT_LEADTEK_9531,
	    "9531 GPS",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_AX88179,
	    "AX88179",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_ONELINKPRO,
	    "OneLink Pro",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_TABLETDOCK,
	    "Tablet Dock",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_ONELINKPLUS,
	    "OneLink+ Dock",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_WIGIGDOCK,
	    "WiGig Dock",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_DOCK_ETHERNET,
	    "USB-C Dock Ethernet",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_TB3GFXDOCK,
	    "Thunderbolt 3 Graphics Dock",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_1,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_TB3DOCKGEN2,
	    "Thunderbolt 3 Dock Gen 2",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_2,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_3,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_4,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_5,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_ETHERNET,
	    "USB 2.0 Ethernet",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153_1,
	    "RTL8153",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_ONELINK,
	    "OneLink",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153_2,
	    "RTL8153",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153_3,
	    "RTL8153",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_6,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_7,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_8,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_RTL8153B_9,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_USBCDOCKGEN2,
	    "USB-C Dock Gen 2",
	},
	{
	    USB_VENDOR_LENOVO, USB_PRODUCT_LENOVO_TB3DOCK,
	    "Thunderbolt 3 Dock",
	},
	{
	    USB_VENDOR_LEXAR, USB_PRODUCT_LEXAR_JUMPSHOT,
	    "jumpSHOT CompactFlash",
	},
	{
	    USB_VENDOR_LEXAR, USB_PRODUCT_LEXAR_2662WAR,
	    "2662W-AR",
	},
	{
	    USB_VENDOR_LEXMARK, USB_PRODUCT_LEXMARK_S2450,
	    "Optra S 2450",
	},
	{
	    USB_VENDOR_LG, USB_PRODUCT_LG_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_LG, USB_PRODUCT_LG_RTL8153B,
	    "RTL8153",
	},
	{
	    USB_VENDOR_LIEBERT, USB_PRODUCT_LIEBERT_UPS,
	    "UPS",
	},
	{
	    USB_VENDOR_LIEBERT2, USB_PRODUCT_LIEBERT2_PSA,
	    "PowerSure PSA UPS",
	},
	{
	    USB_VENDOR_LINKINSTRUMENTS, USB_PRODUCT_LINKINSTRUMENTS_MSO19,
	    "Link Instruments MSO-19",
	},
	{
	    USB_VENDOR_LINKINSTRUMENTS, USB_PRODUCT_LINKINSTRUMENTS_MSO28,
	    "Link Instruments MSO-28",
	},
	{
	    USB_VENDOR_LINKINSTRUMENTS, USB_PRODUCT_LINKINSTRUMENTS_MSO28_2,
	    "Link Instruments MSO-28",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_MAUSB2,
	    "Camedia MAUSB-2",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10TX1,
	    "USB10TX",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_HG20F9,
	    "HG20F9 Ethernet",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10T,
	    "USB10T Ethernet",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB100TX,
	    "USB100TX Ethernet",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB100H1,
	    "USB100H1 Ethernet/HPNA",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10TA,
	    "USB10TA Ethernet",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_WUSB11,
	    "WUSB11 802.11b",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_WUSB11_25,
	    "WUSB11 802.11b v2.5",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_WUSB12_11,
	    "WUSB12 802.11b v1.1",
	},
	{
	    USB_VENDOR_LINKSYS, USB_PRODUCT_LINKSYS_USB10TX2,
	    "USB10TX",
	},
	{
	    USB_VENDOR_LINKSYS2, USB_PRODUCT_LINKSYS2_NWU11B,
	    "NWU11B",
	},
	{
	    USB_VENDOR_LINKSYS2, USB_PRODUCT_LINKSYS2_USB200M,
	    "USB 2.0 10/100 Ethernet controller",
	},
	{
	    USB_VENDOR_LINKSYS3, USB_PRODUCT_LINKSYS3_WUSB11V28,
	    "WUSB11 v2.8",
	},
	{
	    USB_VENDOR_LINKSYS3, USB_PRODUCT_LINKSYS3_WUSB11V30,
	    "WUSB11 v3.0",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_USB1000,
	    "USB1000",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_WUSB100,
	    "WUSB100",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_WUSB600N,
	    "WUSB600N",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_WUSB54GCV2,
	    "WUSB54GC v2",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_WUSB54GCV3,
	    "WUSB54GC v3",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_LINKSYS4, USB_PRODUCT_LINKSYS4_WUSB600NV2,
	    "WUSB600N v2",
	},
	{
	    USB_VENDOR_LITEON, USB_PRODUCT_LITEON_AR9271,
	    "AR9271",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_LAN_GTJU2,
	    "LAN-GTJ/U2",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_LANTX,
	    "LAN-TX",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_RTL8187,
	    "RTL8187",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_LANW300NU2,
	    "LAN-W300N/U2",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_LANW150NU2,
	    "LAN-W150N/U2",
	},
	{
	    USB_VENDOR_LOGITEC, USB_PRODUCT_LOGITEC_LANW300NU2S,
	    "LAN-W300N/U2S",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_M2452,
	    "M2452 keyboard",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_M4848,
	    "M4848 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_PAGESCAN,
	    "PageScan",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMWEB,
	    "QuickCam Web",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WEBCAMC200,
	    "Webcam C200",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WEBCAMC250,
	    "Webcam C250",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WEBCAMC500,
	    "Webcam C500",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WEBCAMPRO9000,
	    "Webcam Pro 9000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO,
	    "QuickCam Pro",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WEBCAMC210,
	    "Webcam C210",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WEBCAMC310,
	    "Webcam C310",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_HDPROC910,
	    "HD Pro Webcam C910",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WEBCAMC270,
	    "Webcam C270",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMEXP,
	    "QuickCam Express",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAM,
	    "QuickCam",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMNBDLX,
	    "QuickCam Notebook Deluxe",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO3K,
	    "QuickCam Pro 3000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMNBPRO_1,
	    "QuickCam Notebook Pro",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO4K,
	    "QuickCam Pro 4000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMZOOM,
	    "QuickCam Zoom",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMFUSION_1,
	    "QuickCam Fusion",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMORBITMP_1,
	    "QuickCam Orbit MP",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMNBPRO,
	    "QuickCam Notebook Pro",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO5K_1,
	    "QuickCam Pro 5000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMOEM_1,
	    "QuickCam OEM",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMOEM_2,
	    "QuickCam OEM",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMULTVIS,
	    "QuickCam Ultra Vision",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMFUSION_2,
	    "QuickCam Fusion",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMNBPRO_2,
	    "QuickCam Notebook Pro",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMORBITMP_2,
	    "QuickCam Orbit MP",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO5K_2,
	    "QuickCam Pro 5000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO9K,
	    "QuickCam Pro 9000",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRONB,
	    "QuickCam Pro Notebook",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMCOMMDLX,
	    "QuickCam Communicate Deluxe",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMORBITAF,
	    "QuickCam Orbit AF",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMCOMMMP,
	    "QuickCam Communicate MP",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAME3500P,
	    "QuickCam E 3500 Plus",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMDLXNB,
	    "QuickCam Deluxe Notebook",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_N43,
	    "N43",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_N48,
	    "N48 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_MBA47,
	    "M-BA47 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMMOUSE,
	    "WingMan Gaming Mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_BD58,
	    "BD58 mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_UN58A,
	    "iFeel Mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMPAD,
	    "WingMan GamePad Extreme",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMRPAD,
	    "WingMan RumblePad",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMJOY,
	    "WingMan Force joystick",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_WMFFGP,
	    "WingMan Formula Force GP (GT-Force)",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_ITOUCH,
	    "iTouch Keyboard",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_BB13,
	    "USB-PS/2 Trackball",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_BB18,
	    "TrackMan Wheel",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_RK53,
	    "Cordless mouse",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_RB6,
	    "Cordless keyboard",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_CDO,
	    "Cordless Desktop Optical",
	},
	{
	    USB_VENDOR_LOGITECH, USB_PRODUCT_LOGITECH_QUICKCAMPRO2,
	    "QuickCam Pro",
	},
	{
	    USB_VENDOR_LONGCHEER, USB_PRODUCT_LONGCHEER_D21LCMASS,
	    "Emobile D21LC Mass only mode",
	},
	{
	    USB_VENDOR_LONGCHEER, USB_PRODUCT_LONGCHEER_D21LC,
	    "Emobile D21LC",
	},
	{
	    USB_VENDOR_LONGCHEER, USB_PRODUCT_LONGCHEER_510FU,
	    "IIJmobile 510FU",
	},
	{
	    USB_VENDOR_LONGCHEER, USB_PRODUCT_LONGCHEER_510FUMASS,
	    "IIJmobile 510FU Mass only mode",
	},
	{
	    USB_VENDOR_LUCENT, USB_PRODUCT_LUCENT_EVALKIT,
	    "USS-720 evaluation kit",
	},
	{
	    USB_VENDOR_LUXSHARE, USB_PRODUCT_LUXSHARE_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_MACALLY, USB_PRODUCT_MACALLY_MOUSE1,
	    "mouse",
	},
	{
	    USB_VENDOR_MARVELL, USB_PRODUCT_MARVELL_SHEEVAPLUG,
	    "SheevaPlug",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0100,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0101,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0102,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0103,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0104,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0105,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0106,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0107,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0108,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0109,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0110,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0111,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0112,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0113,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0114,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0115,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0116,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0117,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0118,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0119,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0120,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0121,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0122,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0123,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0124,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0125,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0126,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0127,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0128,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0129,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0130,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0131,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0132,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0133,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0134,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0135,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0136,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0137,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0138,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0139,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0140,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0141,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0142,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0143,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0144,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0145,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0146,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0147,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0148,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0149,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0150,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0151,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0152,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0153,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0154,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0155,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0156,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0157,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0158,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0159,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0160,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0161,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0162,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0163,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0164,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0165,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0166,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0167,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0168,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0169,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0170,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0171,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0172,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0173,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0174,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0175,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0176,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0177,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0178,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0179,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0180,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0181,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0182,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0183,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0184,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0185,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0186,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0187,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0188,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0189,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0190,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0191,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0192,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0193,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0194,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0195,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0196,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0197,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0198,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0199,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019A,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019B,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019C,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019D,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019E,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019F,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A0,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A1,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A2,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A3,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A4,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A5,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A6,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A7,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A8,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A9,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AA,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AB,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AC,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AD,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AE,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AF,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B0,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B1,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B2,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B3,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B4,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B5,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B6,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B7,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B8,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B9,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BA,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BB,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BC,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BD,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BE,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BF,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C0,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C1,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C2,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C3,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C4,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C5,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C6,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C7,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C8,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C9,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CA,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CB,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CC,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CD,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CE,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CF,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D0,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D1,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D2,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D3,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D4,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D5,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D6,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D7,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D8,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D9,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DA,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DB,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DC,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DD,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DE,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DF,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E0,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E1,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E2,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E3,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E4,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E5,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E6,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E7,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E8,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E9,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EA,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EB,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EC,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01ED,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EE,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EF,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F0,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F1,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F2,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F3,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F4,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F5,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F6,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F7,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F8,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F9,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FA,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FB,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FC,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FD,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FE,
	    "LCD",
	},
	{
	    USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FF,
	    "LCD",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_HUB0100,
	    "Hub",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_DU_H3SP_USB232,
	    "D-Link DU-H3SP BAY Hub",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_USB232,
	    "RS232",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_SITECOM_USB232,
	    "Sitecom RS232",
	},
	{
	    USB_VENDOR_MCT, USB_PRODUCT_MCT_ML_4500,
	    "ML-4500",
	},
	{
	    USB_VENDOR_MDS, USB_PRODUCT_MDS_ISDBT,
	    "MDS ISDB-T tuner",
	},
	{
	    USB_VENDOR_MECANIQUE, USB_PRODUCT_MECANIQUE_WISPY,
	    "MetaGeek Wi-Spy",
	},
	{
	    USB_VENDOR_MECANIQUE, USB_PRODUCT_MECANIQUE_TELLSTICK,
	    "Telldus Tellstick",
	},
	{
	    USB_VENDOR_MEDIATEK, USB_PRODUCT_MEDIATEK_UMASS,
	    "USB MSM installer",
	},
	{
	    USB_VENDOR_MEDIATEK, USB_PRODUCT_MEDIATEK_DC_4COM,
	    "UMTS USB modem",
	},
	{
	    USB_VENDOR_MEI, USB_PRODUCT_MEI_CASHFLOW_SC,
	    "Cashflow-SC",
	},
	{
	    USB_VENDOR_MEI, USB_PRODUCT_MEI_S2000,
	    "Series 2000",
	},
	{
	    USB_VENDOR_MEINBERG, USB_PRODUCT_MEINBERG_USB5131,
	    "USB 5131 DCF77 - Radio Clock",
	},
	{
	    USB_VENDOR_MEINBERG, USB_PRODUCT_MEINBERG_DCF600USB,
	    "DCF600USB - Radio Clock",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUATX1,
	    "LUA-TX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUATX5,
	    "LUA-TX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUA2TX5,
	    "LUA2-TX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUAKTX,
	    "LUA-KTX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_S11,
	    "WLI-USB-S11",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_MCRSM2,
	    "MCR-SM2 SmartMedia",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_DUBPXXG,
	    "USB-IDE Bridge: DUB-PxxG",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KS11G,
	    "WLI-USB-KS11G wlan",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUAU2KTX,
	    "LUA-U2-KTX Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KB11,
	    "WLI-USB-KB11 WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54YB,
	    "WLI-U2-KG54-YB WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54,
	    "WLI-U2-KG54 WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54AI,
	    "WLI-U2-KG54-AI WLAN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_LUAU2GT,
	    "LUA-U2-GT Ethernet",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_NINWIFI,
	    "Nintendo Wi-Fi",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIU2KAMG54,
	    "WLI-U2-KAMG54",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIU2KAMG54_NF,
	    "WLI-U2-KAMG54",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_PCOPRS1,
	    "PC-OP-RS1 RemoteStation",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_SG54HP,
	    "WLI-U2-SG54HP",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_G54HP,
	    "WLI-U2-G54HP",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_KG54L,
	    "WLI-U2-KG54L",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIUCG300N,
	    "WLI-UC-G300N",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_SG54HG,
	    "WLI-U2-SG54HG",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIUCAG300N,
	    "WLI-UC-AG300N",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIUCGNHP,
	    "WLI-UC-GNHP",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIUCGN,
	    "WLI-UC-GN",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIUCG301N,
	    "WLI-UC-G301N",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIUCGNM,
	    "WLI-UC-GNM",
	},
	{
	    USB_VENDOR_MELCO, USB_PRODUCT_MELCO_WLIUCGNM2,
	    "WLI-UC-GNM2",
	},
	{
	    USB_VENDOR_METAGEEK, USB_PRODUCT_METAGEEK_WISPY24I,
	    "Wi-Spy 2.4i",
	},
	{
	    USB_VENDOR_METRICOM, USB_PRODUCT_METRICOM_RICOCHET_GS,
	    "Ricochet GS",
	},
	{
	    USB_VENDOR_MGE, USB_PRODUCT_MGE_UPS1,
	    "UPS",
	},
	{
	    USB_VENDOR_MGE, USB_PRODUCT_MGE_UPS2,
	    "UPS",
	},
	{
	    USB_VENDOR_MICROCHIP, USB_PRODUCT_MICROCHIP_USBLCD20X2,
	    "USB-LCD-20x2",
	},
	{
	    USB_VENDOR_MICROCHIP, USB_PRODUCT_MICROCHIP_USBLCD256X64,
	    "USB-LCD-256x64",
	},
	{
	    USB_VENDOR_MICRODIA, USB_PRODUCT_MICRODIA_YUREX,
	    "YUREX",
	},
	{
	    USB_VENDOR_MICRODIA, USB_PRODUCT_MICRODIA_CAM_1,
	    "CAM_1",
	},
	{
	    USB_VENDOR_MICRODIA, USB_PRODUCT_MICRODIA_TEMPER,
	    "TEMPer sensor",
	},
	{
	    USB_VENDOR_MICRODIA, USB_PRODUCT_MICRODIA_TEMPERHUM,
	    "TEMPerHUM sensor",
	},
	{
	    USB_VENDOR_MICRONET, USB_PRODUCT_MICRONET_SP128AR,
	    "SP128AR EtherFast",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_SIDEPREC,
	    "SideWinder Precision Pro",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_INTELLIMOUSE,
	    "IntelliMouse",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_NATURALKBD,
	    "Natural",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_DDS80,
	    "Digital Sound System 80",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_SIDEWINDER,
	    "Sidewinder Precision Racing Wheel",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_INETPRO,
	    "Internet Keyboard Pro",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_TBEXPLORER,
	    "Trackball Explorer",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_INTELLIEYE,
	    "IntelliEye mouse",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_INETPRO2,
	    "Internet Keyboard Pro",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_MN510,
	    "MN510 Wireless",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_700WX,
	    "Palm 700WX",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_MN110,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_WLINTELLIMOUSE,
	    "Wireless Optical IntelliMouse",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_WLNOTEBOOK,
	    "Wireless Optical Mouse (Model 1023)",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_WLNOTEBOOK3,
	    "Wireless Optical Mouse 3000 (Model 1049)",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_WLNOTEBOOK2,
	    "Wireless Optical Mouse 3000 (Model 1056)",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_XBOX360_CONTROLLER,
	    "XBOX 360 Controller",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_XBOX360,
	    "XBOX 360 WLAN",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_WLMOBILEMOUSE3500,
	    "Wireless Mobile Mouse 3500",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_LIFECAM,
	    "Microsoft LifeCam",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_WLARCMOUSE,
	    "Wireless Arc Mouse (Model 1350)",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_DOCKETH,
	    "Surface Dock Ethernet",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_DOCKETH2,
	    "Surface Dock Ethernet",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_SURFETH,
	    "Surface Ethernet",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_TYPECOVER,
	    "Surface Go Type Cover",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_TYPECOVER2,
	    "Surface Go Type Cover",
	},
	{
	    USB_VENDOR_MICROSOFT, USB_PRODUCT_MICROSOFT_TYPECOVER3,
	    "Surface Pro Type Cover",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_SCSIDB25,
	    "SCSI-DB25",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_SCSIHD50,
	    "SCSI-HD50",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_DPCM,
	    "CameraMate",
	},
	{
	    USB_VENDOR_MICROTECH, USB_PRODUCT_MICROTECH_FREECOM,
	    "Freecom IDE",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_336CX,
	    "Phantom 336CX - C3",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_X6U,
	    "ScanMaker X6 - X6U",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_C6,
	    "Phantom C6",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_336CX2,
	    "Phantom 336CX - C3",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_V6USL,
	    "ScanMaker V6USL",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_V6USL2,
	    "ScanMaker V6USL",
	},
	{
	    USB_VENDOR_MICROTEK, USB_PRODUCT_MICROTEK_V6UL,
	    "ScanMaker V6UL",
	},
	{
	    USB_VENDOR_MIDIMAN, USB_PRODUCT_MIDIMAN_MIDISPORT2X2,
	    "Midisport 2x2",
	},
	{
	    USB_VENDOR_MINDSATWORK, USB_PRODUCT_MINDSATWORK_DW,
	    "Digital Wallet",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_S304,
	    "Dimage S304",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_X,
	    "Dimage X",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_DIMAGE7I,
	    "Dimage 7i",
	},
	{
	    USB_VENDOR_MINOLTA, USB_PRODUCT_MINOLTA_DIMAGEA1,
	    "Dimage A1",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_CDRRW,
	    "CD-R/RW Drive",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_MOUSE,
	    "Mouse",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_MITSUMI, USB_PRODUCT_MITSUMI_FDD,
	    "FDD",
	},
	{
	    USB_VENDOR_MOBILEACTION, USB_PRODUCT_MOBILEACTION_MA620,
	    "MA-620 IrDA",
	},
	{
	    USB_VENDOR_MOBILITY, USB_PRODUCT_MOBILITY_ED200H,
	    "EasiDock 200 Serial",
	},
	{
	    USB_VENDOR_MOBILITY, USB_PRODUCT_MOBILITY_EA,
	    "Ethernet",
	},
	{
	    USB_VENDOR_MOBILITY, USB_PRODUCT_MOBILITY_EASIDOCK,
	    "EasiDock Ethernet",
	},
	{
	    USB_VENDOR_MODACOM, USB_PRODUCT_MODACOM_MWIMAX,
	    "MODACOM Mobile wimax adaptor",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7703,
	    "MCS7703 Serial",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7715,
	    "MCS7715 Serial Parallel",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7730,
	    "MCS7730 Ethernet",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7810,
	    "MCS7810 Serial",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7820,
	    "MCS7820 Serial",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7830,
	    "MCS7830 Ethernet",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7832,
	    "MCS7832 Ethernet",
	},
	{
	    USB_VENDOR_MOSCHIP, USB_PRODUCT_MOSCHIP_MCS7840,
	    "MCS7840 Serial",
	},
	{
	    USB_VENDOR_MOTOROLA, USB_PRODUCT_MOTOROLA_MC141555,
	    "MC141555 hub controller",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_T720C,
	    "T720c",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_V360,
	    "V360",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_USBLAN,
	    "USBLAN",
	},
	{
	    USB_VENDOR_MOTOROLA2, USB_PRODUCT_MOTOROLA2_USBLAN2,
	    "USBLAN",
	},
	{
	    USB_VENDOR_MOTOROLA3, USB_PRODUCT_MOTOROLA3_SB4100,
	    "SB4100 Cable Modem",
	},
	{
	    USB_VENDOR_MOTOROLA3, USB_PRODUCT_MOTOROLA3_SB5100,
	    "SB5100 Cable Modem",
	},
	{
	    USB_VENDOR_MOTOROLA4, USB_PRODUCT_MOTOROLA4_RT2770,
	    "RT2770",
	},
	{
	    USB_VENDOR_MOTOROLA4, USB_PRODUCT_MOTOROLA4_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_MOXA, USB_PRODUCT_MOXA_UPORT1110,
	    "UPort 1110",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_WLAN,
	    "WLAN",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_8,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_9,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2570_2,
	    "RT2570",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2570_3,
	    "RT2570",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_1,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_4,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_5,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_10,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_12,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_13,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_6,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_11,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_14,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_15,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT3070_7,
	    "RT3070",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_3,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_RT2573_4,
	    "RT2573",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_AX88772A,
	    "AX88772A",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_BLUETOOTH_2,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_MSI, USB_PRODUCT_MSI_BLUETOOTH_3,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_MSYSTEMS, USB_PRODUCT_MSYSTEMS_DISKONKEY,
	    "DiskOnKey",
	},
	{
	    USB_VENDOR_MSYSTEMS, USB_PRODUCT_MSYSTEMS_DISKONKEY2,
	    "DiskOnKey",
	},
	{
	    USB_VENDOR_MULTITECH, USB_PRODUCT_MULTITECH_ATLAS,
	    "MT5634ZBA modem",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200CU,
	    "1200 CU",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_600CU,
	    "600 CU",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200USB,
	    "1200",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200UB,
	    "1200 UB",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200USBPLUS,
	    "1200 Plus",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_1200CUPLUS,
	    "1200 CU Plus",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_BEARPAW1200F,
	    "BearPaw 1200F",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_600USB,
	    "600",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_MDC800,
	    "MDC-800",
	},
	{
	    USB_VENDOR_MUSTEK, USB_PRODUCT_MUSTEK_DV2000,
	    "DV2000",
	},
	{
	    USB_VENDOR_MUSTEK2, USB_PRODUCT_MUSTEK2_PM800,
	    "PowerMust 800",
	},
	{
	    USB_VENDOR_NATIONAL, USB_PRODUCT_NATIONAL_BEARPAW1200,
	    "BearPaw 1200",
	},
	{
	    USB_VENDOR_NATIONAL, USB_PRODUCT_NATIONAL_BEARPAW2400,
	    "BearPaw 2400",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_HUB,
	    "hub",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_WL300NUG,
	    "WL300NU-G",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_USB2EXTEND,
	    "Repeater",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_HUB_B,
	    "hub",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_HUB_C,
	    "hub",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY760,
	    "Picty760",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY900,
	    "Picty900",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY920,
	    "Picty920",
	},
	{
	    USB_VENDOR_NEC, USB_PRODUCT_NEC_PICTY800,
	    "Picty800",
	},
	{
	    USB_VENDOR_NEC2, USB_PRODUCT_NEC2_HUB2_0,
	    "USB2.0 Hub",
	},
	{
	    USB_VENDOR_NEODIO, USB_PRODUCT_NEODIO_ND3050,
	    "6-in-1 Flash Device Controller",
	},
	{
	    USB_VENDOR_NEODIO, USB_PRODUCT_NEODIO_ND3260,
	    "8-in-1 Flash Device Controller",
	},
	{
	    USB_VENDOR_NEODIO, USB_PRODUCT_NEODIO_ND5010,
	    "Multi-format Flash Controller",
	},
	{
	    USB_VENDOR_NETCHIP, USB_PRODUCT_NETCHIP_TURBOCONNECT,
	    "Turbo-Connect",
	},
	{
	    USB_VENDOR_NETCHIP, USB_PRODUCT_NETCHIP_CLIK40,
	    "Clik! 40",
	},
	{
	    USB_VENDOR_NETCHIP, USB_PRODUCT_NETCHIP_ETHERNETGADGET,
	    "EthernetGadget",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_EA101,
	    "Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_EA101X,
	    "Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_FA101,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_FA120,
	    "USB 2.0 Fast Ethernet",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_M7100,
	    "M7100",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_MA111NA,
	    "802.11b",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_MA111V2,
	    "802.11b V2",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111V2_2,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111V3,
	    "WG111v3",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111U,
	    "WG111U",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111U_NF,
	    "WG111U",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WG111V2,
	    "WG111v2",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WN111V2,
	    "WN111V2",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WNDA3100,
	    "WNDA3100",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WNDA3200,
	    "WNDA3200",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WNA1100,
	    "WNA1100",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WNA1000,
	    "WNA1000",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WNA1000M,
	    "WNA1000M",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_WNA1000MV2,
	    "WNA1000Mv2",
	},
	{
	    USB_VENDOR_NETGEAR, USB_PRODUCT_NETGEAR_N300MA,
	    "N300MA",
	},
	{
	    USB_VENDOR_NETGEAR2, USB_PRODUCT_NETGEAR2_MA101,
	    "MA101",
	},
	{
	    USB_VENDOR_NETGEAR2, USB_PRODUCT_NETGEAR2_MA101B,
	    "MA101 Rev B",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WG111T,
	    "WG111T",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WG111T_NF,
	    "WG111T",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WG111T_1,
	    "WG111T",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WPN111,
	    "WPN111",
	},
	{
	    USB_VENDOR_NETGEAR3, USB_PRODUCT_NETGEAR3_WPN111_NF,
	    "WPN111",
	},
	{
	    USB_VENDOR_NETGEAR4, USB_PRODUCT_NETGEAR4_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_NETWEEN, USB_PRODUCT_NETWEEN_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_NHJ, USB_PRODUCT_NHJ_CAM2,
	    "Camera",
	},
	{
	    USB_VENDOR_NI, USB_PRODUCT_NI_GPIB_USB_A,
	    "GPIB-USB-A",
	},
	{
	    USB_VENDOR_NIKON, USB_PRODUCT_NIKON_E990,
	    "E990",
	},
	{
	    USB_VENDOR_NIKON, USB_PRODUCT_NIKON_E880,
	    "E880",
	},
	{
	    USB_VENDOR_NIKON, USB_PRODUCT_NIKON_E885,
	    "E885",
	},
	{
	    USB_VENDOR_NOKIA, USB_PRODUCT_NOKIA_CA42,
	    "CA-42 Serial",
	},
	{
	    USB_VENDOR_NOKIA2, USB_PRODUCT_NOKIA2_CS15UMASS,
	    "Internet Stick CS-15 (umass mode)",
	},
	{
	    USB_VENDOR_NOKIA2, USB_PRODUCT_NOKIA2_CS15,
	    "Internet Stick CS-15",
	},
	{
	    USB_VENDOR_NORITAKE, USB_PRODUCT_NORITAKE_COMEMO,
	    "Noritake COMEMO",
	},
	{
	    USB_VENDOR_NOVATECH, USB_PRODUCT_NOVATECH_NV902W,
	    "NV-902W",
	},
	{
	    USB_VENDOR_NOVATECH, USB_PRODUCT_NOVATECH_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_NOVATECH, USB_PRODUCT_NOVATECH_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_EXPRESSCARD,
	    "ExpressCard 3G",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MERLINV620,
	    "V620",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MERLINV740,
	    "V740",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_V720,
	    "V720",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MERLINU740,
	    "U740",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MERLINU740_2,
	    "U740",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_U870,
	    "U870",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_XU870,
	    "XU870",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_X950D,
	    "X950D",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_ES620,
	    "ES620 CDMA",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_U720,
	    "U720",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_EU870D,
	    "EU870D",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_U727,
	    "U727",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MC950D,
	    "MC950D HSUPA",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MERLINX950D,
	    "X950D",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_ZEROCD2,
	    "ZeroCD",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MC760CD,
	    "MC760 CD",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_U760,
	    "U760",
	},
	{
	    USB_VENDOR_NOVATEL, USB_PRODUCT_NOVATEL_MC760,
	    "MC760",
	},
	{
	    USB_VENDOR_NOVATEL1, USB_PRODUCT_NOVATEL1_FLEXPACKGPS,
	    "NovAtel FlexPack GPS",
	},
	{
	    USB_VENDOR_NVIDIA, USB_PRODUCT_NVIDIA_TEGRAETH,
	    "Tegra Ethernet",
	},
	{
	    USB_VENDOR_O2MICRO, USB_PRODUCT_O2MICRO_OZ776HUB,
	    "OZ776 Hub",
	},
	{
	    USB_VENDOR_OCT, USB_PRODUCT_OCT_USBTOETHER,
	    "Ethernet",
	},
	{
	    USB_VENDOR_OCT, USB_PRODUCT_OCT_US2308,
	    "Serial",
	},
	{
	    USB_VENDOR_OLIMEX, USB_PRODUCT_OLIMEX_OPENOCD_JTAG,
	    "OpenOCD JTAG",
	},
	{
	    USB_VENDOR_OLYMPUS, USB_PRODUCT_OLYMPUS_C1,
	    "C-1",
	},
	{
	    USB_VENDOR_OLYMPUS, USB_PRODUCT_OLYMPUS_C700,
	    "C-700 Ultra Zoom",
	},
	{
	    USB_VENDOR_OMNIVISION, USB_PRODUCT_OMNIVISION_OV511,
	    "OV511",
	},
	{
	    USB_VENDOR_OMNIVISION, USB_PRODUCT_OMNIVISION_OV511PLUS,
	    "OV511+",
	},
	{
	    USB_VENDOR_OMRON, USB_PRODUCT_OMRON_BX50F,
	    "BX50F UPS",
	},
	{
	    USB_VENDOR_OMRON, USB_PRODUCT_OMRON_BX35F,
	    "BX35F UPS",
	},
	{
	    USB_VENDOR_OMRON, USB_PRODUCT_OMRON_BY35S,
	    "BY35S UPS",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_MD2,
	    "disk",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_MDCFEB,
	    "MDCFE-B CF",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_SIIGMS,
	    "Memory Stick+CF",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_DATAFAB3,
	    "Datafab-based",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_DATAFAB4,
	    "Datafab-based",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_PNYCFSM,
	    "PNY/Datafab CF+SM",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_STECHCFSM,
	    "Simple Tech/Datafab CF+SM",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_LC1,
	    "CF + SM Combo (LC1)",
	},
	{
	    USB_VENDOR_ONSPEC, USB_PRODUCT_ONSPEC_MD1II,
	    "Datafab MD1-II PC-Card",
	},
	{
	    USB_VENDOR_ONSPEC2, USB_PRODUCT_ONSPEC2_8IN2,
	    "8In2",
	},
	{
	    USB_VENDOR_OPENMOKO, USB_PRODUCT_OPENMOKO_N1793D,
	    "Neo1973 Debug",
	},
	{
	    USB_VENDOR_OPENMOKO2, USB_PRODUCT_OPENMOKO2_ONERNG,
	    "Moonbase Otago OneRNG",
	},
	{
	    USB_VENDOR_OPENMOKO2, USB_PRODUCT_OPENMOKO2_CHAOSKEY,
	    "Altusmetrum ChaosKey 1.0",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_VODAFONEMC3G,
	    "Vodafone Mobile Connect 3G",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GT3GFUSION,
	    "GlobeTrotter 3G FUSION",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GT3GQUAD,
	    "GlobeTrotter 3G QUAD",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GT3GQUADPLUS,
	    "GlobeTrotter 3G QUAD PLUS",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GTMAX36,
	    "GlobeTrotter MAX 3.6/7.2",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GT3GPLUS,
	    "GlobeTrotter 3G PLUS",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_SCORPION,
	    "GlobeTrotter HSDPA Modem",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GSICON72,
	    "GlobeSurfer iCON 7.2",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_ICON225,
	    "iCON 225",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_GTHSUPA380E,
	    "GlobeTrotter HSUPA 380E",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_ICON322,
	    "iCON 322",
	},
	{
	    USB_VENDOR_OPTION, USB_PRODUCT_OPTION_ICON505,
	    "iCON 505",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_WIFI01,
	    "model 01 WiFi",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_BT01,
	    "model 01 Bluetooth",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_ETHER01PLUS,
	    "model 01+ Ethernet",
	},
	{
	    USB_VENDOR_OQO, USB_PRODUCT_OQO_ETHER01,
	    "model 01 Ethernet",
	},
	{
	    USB_VENDOR_OREGONSCI, USB_PRODUCT_OREGONSCI_OWL_CM160,
	    "OWL CM-160",
	},
	{
	    USB_VENDOR_OTI, USB_PRODUCT_OTI_SOLID,
	    "Solid state disk",
	},
	{
	    USB_VENDOR_OTI, USB_PRODUCT_OTI_DKU5,
	    "DKU-5 Serial",
	},
	{
	    USB_VENDOR_OVISLINK, USB_PRODUCT_OVISLINK_RT3071,
	    "RT3071",
	},
	{
	    USB_VENDOR_OVISLINK, USB_PRODUCT_OVISLINK_RT3072,
	    "RT3072",
	},
	{
	    USB_VENDOR_OWEN, USB_PRODUCT_OWEN_AC4,
	    "AC4 USB-RS485",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M500,
	    "Palm m500",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M505,
	    "Palm m505",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M515,
	    "Palm m515",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_I705,
	    "Palm i705",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_TUNGSTEN_Z,
	    "Palm Tungsten Z",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M125,
	    "Palm m125",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_M130,
	    "Palm m130",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_TUNGSTEN_T,
	    "Palm Tungsten T",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_ZIRE_31,
	    "Palm Zire 31",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_ZIRE,
	    "Palm Zire",
	},
	{
	    USB_VENDOR_PALM, USB_PRODUCT_PALM_SERIAL,
	    "USB Serial Adaptor",
	},
	{
	    USB_VENDOR_PANASONIC, USB_PRODUCT_PANASONIC_LS120,
	    "LS-120",
	},
	{
	    USB_VENDOR_PANASONIC, USB_PRODUCT_PANASONIC_SDCAAE,
	    "MultiMediaCard",
	},
	{
	    USB_VENDOR_PANASONIC, USB_PRODUCT_PANASONIC_TYTP50P6S,
	    "TY-TP50P6-S 50in Touch Panel",
	},
	{
	    USB_VENDOR_PANASONIC, USB_PRODUCT_PANASONIC_N5HBZ0000055,
	    "UB94",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485_1,
	    "SB485 USB-485/422",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_AP485_1,
	    "AP485 USB-RS485",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB422_1,
	    "SB422 USB-RS422",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485_2,
	    "SB485 USB-485/422",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_AP485_2,
	    "AP485 USB-RS485",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB422_2,
	    "SB422 USB-RS422",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485S,
	    "SB485S USB-485/422",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485C,
	    "SB485C USB-485/422",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_LEC,
	    "Serial",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB232,
	    "SB232 USB-RS232",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_TMU,
	    "TMU Thermometer",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_IRAMP,
	    "IRAmp Duplex",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_DRAK5,
	    "DRAK5",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO88,
	    "QUIDO USB 8/8",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO44,
	    "QUIDO USB 4/4",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO22,
	    "QUIDO USB 2/2",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO101,
	    "QUIDO USB 10/1",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO303,
	    "QUIDO USB 30/3",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO603,
	    "QUIDO USB 60(100)/3",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO216,
	    "QUIDO USB 2/16",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO332,
	    "QUIDO USB 3/32",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_DRAK6,
	    "DRAK6 USB",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_STAVOVY,
	    "UPS-USB Stavovy",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_MUC,
	    "MU Controller",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SIMUKEY,
	    "SimuKey",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_AD4USB,
	    "AD4USB",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_GOLIATH_MUX,
	    "GOLIATH MUX",
	},
	{
	    USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_GOLIATH_MSR,
	    "GOLIATH MSR",
	},
	{
	    USB_VENDOR_PARA, USB_PRODUCT_PARA_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_PCSENSORS, USB_PRODUCT_PCSENSORS_TEMPER,
	    "TEMPer",
	},
	{
	    USB_VENDOR_PEGATRON, USB_PRODUCT_PEGATRON_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_PEGATRON, USB_PRODUCT_PEGATRON_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_PEGATRON, USB_PRODUCT_PEGATRON_RT3070_2,
	    "RT3070",
	},
	{
	    USB_VENDOR_PEGATRON, USB_PRODUCT_PEGATRON_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_PEGATRON, USB_PRODUCT_PEGATRON_RT3072,
	    "RT3072",
	},
	{
	    USB_VENDOR_PEN, USB_PRODUCT_PEN_USBREADER,
	    "6 in 1",
	},
	{
	    USB_VENDOR_PEN, USB_PRODUCT_PEN_MOBILEDRIVE,
	    "3 in 1",
	},
	{
	    USB_VENDOR_PEN, USB_PRODUCT_PEN_USBDISK,
	    "Disk",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_SERIAL1,
	    "Serial Converter",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_ENET,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_ENET3,
	    "At-Home Ethernet",
	},
	{
	    USB_VENDOR_PERACOM, USB_PRODUCT_PERACOM_ENET2,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PHEENET, USB_PRODUCT_PHEENET_WM168B,
	    "WM-168b",
	},
	{
	    USB_VENDOR_PHEENET, USB_PRODUCT_PHEENET_WL503IA,
	    "WL-503IA",
	},
	{
	    USB_VENDOR_PHEENET, USB_PRODUCT_PHEENET_GWU513,
	    "GWU513",
	},
	{
	    USB_VENDOR_PHIDGETS, USB_PRODUCT_PHIDGETS_2X2,
	    "2x2 Interface Kit",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DSS350,
	    "DSS 350 Digital Speaker System",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DSS,
	    "DSS XXX Digital Speaker System",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_HUB,
	    "hub",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCA645VC,
	    "PCA645VC",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCA646VC,
	    "PCA646VC",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC675K,
	    "PCVC675K Vesta",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC680K,
	    "PCVC680K Vesta Pro",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC690K,
	    "PCVC690K Vesta Pro Scan Camera",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC730K,
	    "PCVC730K ToUCam Fun",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC740K,
	    "PCVC740K ToUCam Pro PC",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_PCVC750K,
	    "PCVC750K ToUCam Pro Scan",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DSS150,
	    "DSS 150 Digital Speaker System",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_ACE1001,
	    "AKTAKOM ACE-1001",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_CPWUA054,
	    "CPWUA054",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_SNU6500,
	    "SNU6500",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_SNU6500_NF,
	    "SNU6500",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_SNU5600,
	    "SNU5600",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_SNU5630NS05,
	    "SNU5630NS/05",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_DIVAUSB,
	    "DIVA mp3 player",
	},
	{
	    USB_VENDOR_PHILIPS, USB_PRODUCT_PHILIPS_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_PHILIPSSEMI, USB_PRODUCT_PHILIPSSEMI_HUB1122,
	    "hub",
	},
	{
	    USB_VENDOR_PIENGINEERING, USB_PRODUCT_PIENGINEERING_PS2USB,
	    "PS2 to Mac",
	},
	{
	    USB_VENDOR_PIENGINEERING, USB_PRODUCT_PIENGINEERING_XKEYS,
	    "Xkeys Programmable Keyboard",
	},
	{
	    USB_VENDOR_PILOTECH, USB_PRODUCT_PILOTECH_CRW600,
	    "CRW-600 6-in-1",
	},
	{
	    USB_VENDOR_PIONEERDJ, USB_PRODUCT_PIONEERDJ_RTL8152B,
	    "RTL8152B",
	},
	{
	    USB_VENDOR_PIONEERDJ, USB_PRODUCT_PIONEERDJ_RTL8153B,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_PLANEX, USB_PRODUCT_PLANEX_GW_US11H,
	    "GW-US11H WLAN",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RTL8188CUS,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GW_US11S,
	    "GW-US11S WLAN",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RTL8188CU_3,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GW_US54GXS,
	    "GW-US54GXS WLAN",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GW_US300,
	    "GW-US300",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54HP,
	    "GW-US54HP",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS300MINIS,
	    "GW-US300MiniS",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUSNANO,
	    "GW-USNano",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUSMICRO300,
	    "GW-USMicro300",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RTL8188CU_1,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RTL8188CU_4,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54MINI2,
	    "GW-US54Mini2",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54SG,
	    "GW-US54SG",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54GZL,
	    "GW-US54GZL",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUS54GD,
	    "GW-US54GD",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUSMM,
	    "GW-USMM",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUSMICRON,
	    "GW-USMicroN",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_GWUSMICRON2W,
	    "GW-USMicroN2W",
	},
	{
	    USB_VENDOR_PLANEX2, USB_PRODUCT_PLANEX2_RTL8188CU_2,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_PLANEX3, USB_PRODUCT_PLANEX3_GWUS54GZ,
	    "GW-US54GZ",
	},
	{
	    USB_VENDOR_PLANEX3, USB_PRODUCT_PLANEX3_GU1000T,
	    "GU-1000T",
	},
	{
	    USB_VENDOR_PLANEX3, USB_PRODUCT_PLANEX3_GWUS54MINI,
	    "GW-US54Mini",
	},
	{
	    USB_VENDOR_PLANEX4, USB_PRODUCT_PLANEX4_GWUS54ZGL,
	    "GW-US54ZGL",
	},
	{
	    USB_VENDOR_PLANEX4, USB_PRODUCT_PLANEX4_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_PLANTRONICS, USB_PRODUCT_PLANTRONICS_HEADSET,
	    "DSP-400 Headset",
	},
	{
	    USB_VENDOR_PLX, USB_PRODUCT_PLX_TESTBOARD,
	    "test board",
	},
	{
	    USB_VENDOR_PLX, USB_PRODUCT_PLX_CA42,
	    "CA-42 Serial",
	},
	{
	    USB_VENDOR_PORTGEAR, USB_PRODUCT_PORTGEAR_EA8,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PORTGEAR, USB_PRODUCT_PORTGEAR_EA9,
	    "Ethernet",
	},
	{
	    USB_VENDOR_PORTSMITH, USB_PRODUCT_PORTSMITH_EEA,
	    "Express Ethernet",
	},
	{
	    USB_VENDOR_POSIFLEX, USB_PRODUCT_POSIFLEX_PP7000_1,
	    "PP7000 series printer",
	},
	{
	    USB_VENDOR_POSIFLEX, USB_PRODUCT_POSIFLEX_PP7000_2,
	    "PP7000 series printer",
	},
	{
	    USB_VENDOR_PQI, USB_PRODUCT_PQI_TRAVELFLASH,
	    "Travel Flash Drive",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2X300,
	    "G2-200",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2E300,
	    "G2E-300",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2300,
	    "G2-300",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2E3002,
	    "G2E-300",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_9600,
	    "Colorado 9600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_600U,
	    "Colorado 600u",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_6200,
	    "Visioneer 6200",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_19200,
	    "Colorado 19200",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_1200U,
	    "Colorado 1200u",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G600,
	    "G2-600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_636I,
	    "ReadyScan 636i",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2600,
	    "G2-600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_G2E600,
	    "G2E-600",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_COMFORT,
	    "Comfort",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_MOUSEINABOX,
	    "Mouse-in-a-Box",
	},
	{
	    USB_VENDOR_PRIMAX, USB_PRODUCT_PRIMAX_PCGAUMS1,
	    "Sony PCGA-UMS1",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2301,
	    "PL2301 Host-Host",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2302,
	    "PL2302 Host-Host",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_RSAQ2,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303BENQ,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2305,
	    "Parallel printer",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_ATAPI4,
	    "ATAPI-4 Bridge Controller",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303GC,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2501,
	    "PL2501 Host-Host",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303X,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC, USB_PRODUCT_PROLIFIC_PL2303X2,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PROLIFIC2, USB_PRODUCT_PROLIFIC2_PL2303,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_PUTERCOM, USB_PRODUCT_PUTERCOM_UPA100,
	    "USB-1284 BRIDGE",
	},
	{
	    USB_VENDOR_QCOM, USB_PRODUCT_QCOM_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_QCOM, USB_PRODUCT_QCOM_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_QCOM, USB_PRODUCT_QCOM_RT2573_3,
	    "RT2573",
	},
	{
	    USB_VENDOR_QCOM, USB_PRODUCT_QCOM_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_QTRONIX, USB_PRODUCT_QTRONIX_980N,
	    "Scorpion-980N",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_DRIVER,
	    "MSM driver",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_MODEM,
	    "CDMA MSM modem",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_HSDPA2,
	    "HSDPA MSM",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_HSDPA,
	    "HSDPA MSM",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_HSDPA3,
	    "HSDPA MSM",
	},
	{
	    USB_VENDOR_QUALCOMM, USB_PRODUCT_QUALCOMM_MSM_DRIVER2,
	    "MSM driver",
	},
	{
	    USB_VENDOR_QUALCOMM2, USB_PRODUCT_QUALCOMM2_MSM_PHONE,
	    "CDMA MSM phone",
	},
	{
	    USB_VENDOR_QUANTA, USB_PRODUCT_QUANTA_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_QUANTA2, USB_PRODUCT_QUANTA2_UMASS,
	    "Quanta USB MSM (umass mode)",
	},
	{
	    USB_VENDOR_QUANTA2, USB_PRODUCT_QUANTA2_Q101,
	    "Quanta Q101 HSDPA USB modem",
	},
	{
	    USB_VENDOR_QUICKSHOT, USB_PRODUCT_QUICKSHOT_STRIKEPAD,
	    "USB StrikePad",
	},
	{
	    USB_VENDOR_RADIOSHACK, USB_PRODUCT_RADIOSHACK_PL2303,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_RAINBOW, USB_PRODUCT_RAINBOW_IKEY2000,
	    "i-Key 2000",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2070,
	    "RT2070",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2570_2,
	    "RT2570",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2671,
	    "RT2671",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2770,
	    "RT2770",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2870,
	    "RT2870",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT3071,
	    "RT3071",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT3072,
	    "RT3072",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT3370,
	    "RT3370",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT3572,
	    "RT3572",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT3573,
	    "RT3573",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT5370,
	    "RT5370",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT5572,
	    "RT5572",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_MT7601,
	    "MT7601",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT8070,
	    "RT8070",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2570_3,
	    "RT2570",
	},
	{
	    USB_VENDOR_RALINK, USB_PRODUCT_RALINK_RT2573_2,
	    "RT2573",
	},
	{
	    USB_VENDOR_RATOC, USB_PRODUCT_RATOC_REXUSB60,
	    "USB serial REX-USB60",
	},
	{
	    USB_VENDOR_RATOC, USB_PRODUCT_RATOC_REXUSB60F,
	    "REX-USB60F",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188ETV,
	    "RTL8188ETV",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CTV,
	    "RTL8188CTV",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188RU_2,
	    "RTL8188RU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CU_4,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8152B,
	    "RTL8152B",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8150,
	    "RTL8150",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8151,
	    "RTL8151 PNA",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8152,
	    "RTL8152",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8156,
	    "RTL8156",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CE_0,
	    "RTL8188CE",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8171,
	    "RTL8171",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8172,
	    "RTL8172",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8173,
	    "RTL8173",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8174,
	    "RTL8174",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CU_0,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8191CU,
	    "RTL8191CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188EU,
	    "RTL8188EU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CU_1,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CU_2,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8192CE,
	    "RTL8192CE",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188RU,
	    "RTL8188RU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CE_1,
	    "RTL8188CE",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188RU_3,
	    "RTL8188RU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8192CE_VAU,
	    "RTL8192CE",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8187,
	    "RTL8187",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8187B_0,
	    "RTL8187B",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CUS,
	    "RTL8188CUS",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8192EU,
	    "RTL8192EU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CU_3,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8192U,
	    "RTL8192U",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8187B_1,
	    "RTL8187B",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8187B_2,
	    "RTL8187B",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CU_5,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8712,
	    "RTL8712",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8713,
	    "RTL8713",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8188CU_COMBO,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8723BU,
	    "RTL8723BU",
	},
	{
	    USB_VENDOR_REALTEK, USB_PRODUCT_REALTEK_RTL8192SU,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_RENESAS, USB_PRODUCT_RENESAS_RX610,
	    "RX610 RX-Stick",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC2,
	    "VGP-VCC2 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC3,
	    "VGP-VCC3 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC2_2,
	    "VGP-VCC2 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC2_3,
	    "VGP-VCC2 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC5,
	    "VGP-VCC5 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC4,
	    "VGP-VCC4 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC4_2,
	    "VGP-VCC4 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC6,
	    "VGP-VCC6 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC7,
	    "VGP-VCC7 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC8,
	    "VGP-VCC8 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VGPVCC9,
	    "VGP-VCC9 Camera",
	},
	{
	    USB_VENDOR_RICOH, USB_PRODUCT_RICOH_VPGVCCX,
	    "VGP-VCCX Camera",
	},
	{
	    USB_VENDOR_RIM, USB_PRODUCT_RIM_BLACKBERRY,
	    "BlackBerry",
	},
	{
	    USB_VENDOR_RIM, USB_PRODUCT_RIM_PEARL_DUAL,
	    "RIM Mass Storage Device",
	},
	{
	    USB_VENDOR_RIM, USB_PRODUCT_RIM_PEARL,
	    "BlackBerry pearl",
	},
	{
	    USB_VENDOR_ROCKFIRE, USB_PRODUCT_ROCKFIRE_GAMEPAD,
	    "Gamepad 203USB",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UA100,
	    "UA-100 Audio I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM4,
	    "UM-4 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SC8850,
	    "SC-8850 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_U8,
	    "U-8 Audio I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM2,
	    "UM-2 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SC8820,
	    "SC-8820 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_PC300,
	    "PC-300 MIDI Keyboard",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM1,
	    "UM-1 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SK500,
	    "SK-500 MIDI Keyboard",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SCD70,
	    "SC-D70 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM880N,
	    "UM-880 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SD90,
	    "SD-90 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UM550,
	    "UM-550 MIDI I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SD20,
	    "SD-20 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_SD80,
	    "SD-80 MIDI Synth",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UA700,
	    "UA-700 Audio I/F",
	},
	{
	    USB_VENDOR_ROLAND, USB_PRODUCT_ROLAND_UMONE,
	    "UM-ONE MIDI I/F",
	},
	{
	    USB_VENDOR_RTSYSTEMS, USB_PRODUCT_RTSYSTEMS_CT57B,
	    "CT57B Radio Cable",
	},
	{
	    USB_VENDOR_SACOM, USB_PRODUCT_SACOM_USB485BL,
	    "USB-485-BL",
	},
	{
	    USB_VENDOR_SAGEM, USB_PRODUCT_SAGEM_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_SAGEM, USB_PRODUCT_SAGEM_XG760A,
	    "XG-760A",
	},
	{
	    USB_VENDOR_SAGEM, USB_PRODUCT_SAGEM_XG76NA,
	    "XG-76NA",
	},
	{
	    USB_VENDOR_SAITEK, USB_PRODUCT_SAITEK_CYBORG_3D_GOLD,
	    "Cyborg 3D Gold Joystick",
	},
	{
	    USB_VENDOR_SAMSUNG, USB_PRODUCT_SAMSUNG_WIS09ABGN,
	    "WIS09ABGN Wireless LAN adapter",
	},
	{
	    USB_VENDOR_SAMSUNG, USB_PRODUCT_SAMSUNG_SWL2100W,
	    "SWL-2100U",
	},
	{
	    USB_VENDOR_SAMSUNG2, USB_PRODUCT_SAMSUNG2_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_SAMSUNG2, USB_PRODUCT_SAMSUNG2_ANDROID2,
	    "Android v2",
	},
	{
	    USB_VENDOR_SAMSUNG2, USB_PRODUCT_SAMSUNG2_ANDROID,
	    "Android",
	},
	{
	    USB_VENDOR_SAMSUNG2, USB_PRODUCT_SAMSUNG2_I330,
	    "I330",
	},
	{
	    USB_VENDOR_SAMSUNG2, USB_PRODUCT_SAMSUNG2_AX88179,
	    "AX88179",
	},
	{
	    USB_VENDOR_SAMSUNG2, USB_PRODUCT_SAMSUNG2_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR05A,
	    "ImageMate SDDR-05a",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR31,
	    "ImageMate SDDR-31",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR05,
	    "ImageMate SDDR-05",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR12,
	    "ImageMate SDDR-12",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR09,
	    "ImageMate SDDR-09",
	},
	{
	    USB_VENDOR_SANDISK, USB_PRODUCT_SANDISK_SDDR75,
	    "ImageMate SDDR-75",
	},
	{
	    USB_VENDOR_SANWASUPPLY, USB_PRODUCT_SANWASUPPLY_JYDV9USB,
	    "JY-DV9USB gamepad",
	},
	{
	    USB_VENDOR_SANYO, USB_PRODUCT_SANYO_SCP4900,
	    "Sanyo SCP-4900 Phone",
	},
	{
	    USB_VENDOR_SCANLOGIC, USB_PRODUCT_SCANLOGIC_SL11R,
	    "SL11R-IDE",
	},
	{
	    USB_VENDOR_SCANLOGIC, USB_PRODUCT_SCANLOGIC_336CX,
	    "Phantom 336CX - C3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2101,
	    "SeaLINK+232 (2101/2105)",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2102,
	    "SeaLINK+485 (2102)",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2103,
	    "SeaLINK+232I (2103)",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2104,
	    "SeaLINK+485I (2104)",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2201_1,
	    "SeaPORT+2/232 (2201) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2202_1,
	    "SeaPORT+2/485 (2202) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2203_1,
	    "SeaPORT+2 (2203) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2201_2,
	    "SeaPORT+2/232 (2201) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2202_2,
	    "SeaPORT+2/485 (2202) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2203_2,
	    "SeaPORT+2 (2203) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_1,
	    "SeaPORT+4/232 (2401) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_1,
	    "SeaPORT+4/485 (2402) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_1,
	    "SeaPORT+4 (2403) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_2,
	    "SeaPORT+4/232 (2401) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_2,
	    "SeaPORT+4/485 (2402) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_2,
	    "SeaPORT+4 (2403) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_3,
	    "SeaPORT+4/232 (2401) Port 3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_3,
	    "SeaPORT+4/485 (2402) Port 3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_3,
	    "SeaPORT+4 (2403) Port 3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_4,
	    "SeaPORT+4/232 (2401) Port 4",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_4,
	    "SeaPORT+4/485 (2402) Port 4",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_4,
	    "SeaPORT+4 (2403) Port 4",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_1,
	    "SeaLINK+8/232 (2801) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_1,
	    "SeaLINK+8/485 (2802) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_1,
	    "SeaLINK+8 (2803) Port 1",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_2,
	    "SeaLINK+8/232 (2801) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_2,
	    "SeaLINK+8/485 (2802) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_2,
	    "SeaLINK+8 (2803) Port 2",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_3,
	    "SeaLINK+8/232 (2801) Port 3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_3,
	    "SeaLINK+8/485 (2802) Port 3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_3,
	    "SeaLINK+8 (2803) Port 3",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_4,
	    "SeaLINK+8/232 (2801) Port 4",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_4,
	    "SeaLINK+8/485 (2802) Port 4",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_4,
	    "SeaLINK+8 (2803) Port 4",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_5,
	    "SeaLINK+8/232 (2801) Port 5",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_5,
	    "SeaLINK+8/485 (2802) Port 5",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_5,
	    "SeaLINK+8 (2803) Port 5",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_6,
	    "SeaLINK+8/232 (2801) Port 6",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_6,
	    "SeaLINK+8/485 (2802) Port 6",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_6,
	    "SeaLINK+8 (2803) Port 6",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_7,
	    "SeaLINK+8/232 (2801) Port 7",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_7,
	    "SeaLINK+8/485 (2802) Port 7",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_7,
	    "SeaLINK+8 (2803) Port 7",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_8,
	    "SeaLINK+8/232 (2801) Port 8",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_8,
	    "SeaLINK+8/485 (2802) Port 8",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_8,
	    "SeaLINK+8 (2803) Port 8",
	},
	{
	    USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2106,
	    "SeaLINK+422 (2106)",
	},
	{
	    USB_VENDOR_SEL, USB_PRODUCT_SEL_C662,
	    "C662",
	},
	{
	    USB_VENDOR_SELUXIT, USB_PRODUCT_SELUXIT_RF,
	    "RF Dongle",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT2870_4,
	    "RT2870",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_NUB8301,
	    "NUB-8301",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_NUB862,
	    "NUB-862",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RTL8192SU_1,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RTL8192SU_2,
	    "RTL8192SU",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT3071,
	    "RT3071",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT3072_1,
	    "RT3072",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT3072_2,
	    "RT3072",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT3072_3,
	    "RT3072",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT3072_4,
	    "RT3072",
	},
	{
	    USB_VENDOR_SENAO, USB_PRODUCT_SENAO_RT3072_5,
	    "RT3072",
	},
	{
	    USB_VENDOR_SERVERWORKS, USB_PRODUCT_SERVERWORKS_HUB,
	    "Root Hub",
	},
	{
	    USB_VENDOR_SGI, USB_PRODUCT_SGI_SN1_L1_SC,
	    "SN1 L1 System Controller",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_ST268,
	    "ST268",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9620A,
	    "DM9620A",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9621A,
	    "DM9621A",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_ZT6688,
	    "ZT6688",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_ADM8515,
	    "ADM8515 Ethernet",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9000E,
	    "DM9000E",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9601,
	    "DM9601",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9620,
	    "DM9620",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9621,
	    "DM9621",
	},
	{
	    USB_VENDOR_SHANTOU, USB_PRODUCT_SHANTOU_DM9622,
	    "DM9622",
	},
	{
	    USB_VENDOR_SHARK, USB_PRODUCT_SHARK_PA,
	    "Pocket Adapter",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_SL5500,
	    "SL5500",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_A300,
	    "A300",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_SL5600,
	    "SL5600",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_C700,
	    "C700",
	},
	{
	    USB_VENDOR_SHARP, USB_PRODUCT_SHARP_C750,
	    "C750",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSB,
	    "E-USB Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSCSI,
	    "eUSCSI Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_SDDR09,
	    "ImageMate SDDR09",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSBSMCF,
	    "eUSB SmartMedia / CompactFlash",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_ZIOMMC,
	    "eUSB MultiMediaCard",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_HIFD,
	    "Sony Hifd",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSBATAPI,
	    "eUSB ATA/ATAPI",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_CF,
	    "eUSB CompactFlash",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSCSI_B,
	    "eUSCSI Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_EUSCSI_C,
	    "eUSCSI Bridge",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_CDRW,
	    "CD-RW Device",
	},
	{
	    USB_VENDOR_SHUTTLE, USB_PRODUCT_SHUTTLE_SCM,
	    "SCM Micro",
	},
	{
	    USB_VENDOR_SIEMENS, USB_PRODUCT_SIEMENS_SPEEDSTREAM,
	    "SpeedStream",
	},
	{
	    USB_VENDOR_SIEMENS, USB_PRODUCT_SIEMENS_SPEEDSTREAM22,
	    "SpeedStream 1022",
	},
	{
	    USB_VENDOR_SIEMENS2, USB_PRODUCT_SIEMENS2_WLL013,
	    "WLL013",
	},
	{
	    USB_VENDOR_SIEMENS2, USB_PRODUCT_SIEMENS2_ES75,
	    "GSM module MC35",
	},
	{
	    USB_VENDOR_SIEMENS3, USB_PRODUCT_SIEMENS3_SX1,
	    "SX1",
	},
	{
	    USB_VENDOR_SIEMENS3, USB_PRODUCT_SIEMENS3_X65,
	    "X65",
	},
	{
	    USB_VENDOR_SIEMENS3, USB_PRODUCT_SIEMENS3_X75,
	    "X75",
	},
	{
	    USB_VENDOR_SIEMENS4, USB_PRODUCT_SIEMENS4_RUGGEDCOM,
	    "RUGGEDCOM",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_EM5625,
	    "EM5625",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC5720,
	    "MC5720",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_595,
	    "AirCard 595",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC5725,
	    "MC5725",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC597E,
	    "597E",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_C597,
	    "Compass 597",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_580,
	    "Aircard 580 EVDO",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC595U,
	    "595U",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC5720_2,
	    "MC5720",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC5725_2,
	    "MC5725",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_TRUINSTALL,
	    "Aircard Tru Installer",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8755_2,
	    "MC8755",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8765,
	    "MC8765",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8755,
	    "MC8755",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8775,
	    "MC8775",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8755_3,
	    "MC8755",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8775_2,
	    "MC8775",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_875,
	    "875",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8780,
	    "MC8780",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8781,
	    "MC8781",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8790,
	    "MC8790",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC880,
	    "880",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC881,
	    "881",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC880E,
	    "880E",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC881E,
	    "881E",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC880U,
	    "880U",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC881U,
	    "881U",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AC885U,
	    "885U",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_C01SW,
	    "C01SW",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC7700,
	    "MC7700",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_USB305,
	    "USB305",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC7304,
	    "MC7304",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC8355,
	    "MC8355",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_340U,
	    "Aircard 340U",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_AIRCARD_770S,
	    "Aircard 770S",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_MC7455,
	    "MC7455",
	},
	{
	    USB_VENDOR_SIERRA, USB_PRODUCT_SIERRA_EM7455,
	    "EM7455",
	},
	{
	    USB_VENDOR_SIGMATEL, USB_PRODUCT_SIGMATEL_IRDA,
	    "IrDA",
	},
	{
	    USB_VENDOR_SIGMATEL, USB_PRODUCT_SIGMATEL_DNSSF7X,
	    "Datum Networks SSF-7X Multi Players",
	},
	{
	    USB_VENDOR_SIIG, USB_PRODUCT_SIIG_DIGIFILMREADER,
	    "DigiFilm-Combo",
	},
	{
	    USB_VENDOR_SIIG, USB_PRODUCT_SIIG_MULTICARDREADER,
	    "MULTICARDREADER",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_VSTABI,
	    "VStabi Controller",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_ARKHAM_DS101_M,
	    "Arkham DS101 Monitor",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_ARKHAM_DS101_A,
	    "Arkham DS101 Adapter",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_BSM7DUSB,
	    "BSM7-D-USB",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_POLOLU,
	    "Pololu Serial",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_SB_PARAMOUNT_ME,
	    "Software Bisque Paramount ME",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CYGNAL_DEBUG,
	    "Cygnal Debug Adapter",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_SB_PARAMOUNT_ME2,
	    "Software Bisque Paramount ME",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_EDG1228,
	    "EDG1228",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_GSM2228,
	    "Enfora GSM2228",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_ARGUSISP,
	    "Argussoft ISP",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_IMS_USB_RS422,
	    "IMS USB-RS422",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CRUMB128,
	    "Crumb128",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_OPTRIS_MSPRO,
	    "Optris MSpro LT Thermometer",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_DEGREECONT,
	    "Degree Controls",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_TRACIENT,
	    "Tracient RFID",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_TRAQMATE,
	    "Track Systems Traqmate",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_SUUNTO,
	    "Suunto sports",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_ARYGON_MIFARE,
	    "Arygon Mifare RFID reader",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_DESKTOPMOBILE,
	    "Burnside Desktop mobile",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_TAMSMASTER,
	    "Tams Master Easy Control",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_RIGBLASTER,
	    "RIGblaster P&P",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_RIGTALK,
	    "RIGtalk",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_B_G_H3000,
	    "B&G H3000 Data Cable",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_IPLINK1220,
	    "IP-Link 1220",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_HAMLINKUSB,
	    "Timewave HamLinkUSB",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_AVIT_USB_TTL,
	    "AVIT Research USB-TTL",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_MJS_TOSLINK,
	    "MJS USB-TOSLINK",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_WAVIT,
	    "ThinkOptics WavIt",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_MULTIPLEX_RC,
	    "Multiplex RC adapter",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_MSD_DASHHAWK,
	    "MSD DashHawk",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_INSYS_MODEM,
	    "INSYS Modem",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_LIPOWSKY_JTAG,
	    "Lipowsky Baby-JTAG",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_LIPOWSKY_LIN,
	    "Lipowsky Baby-LIN",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_AEROCOMM,
	    "Aerocomm Radio",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_ZEPHYR_BIO,
	    "Zephyr Bioharness",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_EMS_C1007,
	    "EMS C1007 HF RFID reader",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_LIPOWSKY_HARP,
	    "Lipowsky HARP-1",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_C2_EDGE_MODEM,
	    "Commander 2 EDGE(GSM) Modem",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CYGNAL_GPS,
	    "Cygnal Fasttrax GPS",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_PLUGDRIVE,
	    "Nanotec Plug & Drive",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_TELEGESIS_ETRX2,
	    "Telegesis ETRX2USB",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_PROCYON_AVS,
	    "Procyon AVS",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_MC35PU,
	    "MC35pu",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CYGNAL,
	    "Cygnal",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_AMBER_AMB2560,
	    "Amber Wireless AMB2560",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_DEKTEK_DTAPLUS,
	    "DekTec DTA Plus VHF/UHF Booster",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_KYOCERA_GPS,
	    "Kyocera GPS",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_IRZ_SG10,
	    "IRZ SG-10 GSM/GPRS Modem",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_BEI_VCP,
	    "BEI USB Sensor (VCP)",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_JUNIPER_BX_CONS,
	    "Juniper BX Console",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_BALLUFF_RFID,
	    "Balluff RFID reader",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_AC_SERV_IBUS,
	    "AC-Services IBUS",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_AC_SERV_CIS,
	    "AC-Services CIS-IBUS",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_PREON32,
	    "Virtenio Preon32",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_AC_SERV_CAN,
	    "AC-Services CAN",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_AC_SERV_OBD,
	    "AC-Services OBD",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_EM357LR,
	    "CEL EM357 LR",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_EM357,
	    "CEL EM357",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_MMB_ZIGBEE,
	    "MMB Networks ZigBee",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_PII_ZIGBEE,
	    "Planet Innovation Ingeni ZigBee",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_KETRA_N1,
	    "Ketra N1",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CELDEVKIT,
	    "CEL MeshWorks DevKit",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_KCF_PRN,
	    "KCF Technologies PRN",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_HUBZ,
	    "HubZ ZigBee/Z-Wave",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CP210X_1,
	    "CP210x Serial",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CP210X_2,
	    "CP210x Serial",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CP210X_3,
	    "CP210x Serial",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_INFINITY_MIC,
	    "Infinity GPS-MIC-1",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_CP2110,
	    "CP2110 USB HID Serial",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_USBSCOPE50,
	    "USBscope50",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_USBWAVE12,
	    "USBwave12",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_USBPULSE100,
	    "USBpulse100",
	},
	{
	    USB_VENDOR_SILABS, USB_PRODUCT_SILABS_USBCOUNT50,
	    "USBcount50",
	},
	{
	    USB_VENDOR_SILABS2, USB_PRODUCT_SILABS2_DCU11CLONE,
	    "DCU-11 clone",
	},
	{
	    USB_VENDOR_SILABS3, USB_PRODUCT_SILABS3_GPRS_MODEM,
	    "GPRS Modem",
	},
	{
	    USB_VENDOR_SILABS4, USB_PRODUCT_SILABS4_100EU_MODEM,
	    "GPRS Modem 100EU",
	},
	{
	    USB_VENDOR_SILABS5, USB_PRODUCT_SILABS5_EM358X,
	    "EM358x",
	},
	{
	    USB_VENDOR_SILICOM, USB_PRODUCT_SILICOM_U2E,
	    "U2E",
	},
	{
	    USB_VENDOR_SILICOM, USB_PRODUCT_SILICOM_GPE,
	    "Psion Dacom Gold Port Ethernet",
	},
	{
	    USB_VENDOR_SILICONPORTALS, USB_PRODUCT_SILICONPORTALS_YAPPH_NF,
	    "YAP Phone (no firmware)",
	},
	{
	    USB_VENDOR_SILICONPORTALS, USB_PRODUCT_SILICONPORTALS_YAPPHONE,
	    "YAP Phone",
	},
	{
	    USB_VENDOR_SIMCOM, USB_PRODUCT_SIMCOM_SIM7600E,
	    "SIM7600E modem",
	},
	{
	    USB_VENDOR_SIRIUS, USB_PRODUCT_SIRIUS_ROADSTER,
	    "NetComm Roadster II 56",
	},
	{
	    USB_VENDOR_SITECOM, USB_PRODUCT_SITECOM_LN029,
	    "LN029",
	},
	{
	    USB_VENDOR_SITECOM, USB_PRODUCT_SITECOM_CN104,
	    "CN104",
	},
	{
	    USB_VENDOR_SITECOM2, USB_PRODUCT_SITECOM2_WL022,
	    "WL-022",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL168V1,
	    "WL-168 v1",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_LN030,
	    "LN-030",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL168V4,
	    "WL-168 v4",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT2870_3,
	    "RT2870",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL302,
	    "WL-302",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL603,
	    "WL-603",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL315,
	    "WL-315",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL321,
	    "WL-321",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT3070_3,
	    "RT3070",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL324,
	    "WL-324",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL343,
	    "WL-343",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL608,
	    "WL-608",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL344,
	    "WL-344",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL329,
	    "WL-329",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL345,
	    "WL-345",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL353,
	    "WL-353",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT3072_3,
	    "RT3072",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT3072_4,
	    "RT3072",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL349V1,
	    "WL-349 v1",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT3072_6,
	    "RT3072",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL349V4,
	    "WL-349 v4",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT3070_1,
	    "RT3070",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RTL8188CU_2,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RT3072_5,
	    "RT3072",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WLA4000,
	    "WLA-4000",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WLA5000,
	    "WLA-5000",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_RTL8192CU_2,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_LN032,
	    "LN-032",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WLA2100V2,
	    "WLA-2100 v2",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_LN028,
	    "LN-028",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL113,
	    "WL-113",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL172,
	    "WL-172",
	},
	{
	    USB_VENDOR_SITECOMEU, USB_PRODUCT_SITECOMEU_WL113R2,
	    "WL-113 rev 2",
	},
	{
	    USB_VENDOR_SMART, USB_PRODUCT_SMART_PL2303,
	    "Serial",
	},
	{
	    USB_VENDOR_SMARTBRIDGES, USB_PRODUCT_SMARTBRIDGES_SMARTLINK,
	    "SmartLink Ethernet",
	},
	{
	    USB_VENDOR_SMARTBRIDGES, USB_PRODUCT_SMARTBRIDGES_SMARTNIC,
	    "smartNIC 2 PnP",
	},
	{
	    USB_VENDOR_SMC, USB_PRODUCT_SMC_2102USB,
	    "10Mbps Ethernet",
	},
	{
	    USB_VENDOR_SMC, USB_PRODUCT_SMC_2202USB,
	    "10/100 Ethernet",
	},
	{
	    USB_VENDOR_SMC, USB_PRODUCT_SMC_2206USB,
	    "EZ Connect Ethernet",
	},
	{
	    USB_VENDOR_SMC, USB_PRODUCT_SMC_2862WG,
	    "EZ Connect 54Mbps",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_2020HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_2504HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_2513HUB,
	    "Hub",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN7500,
	    "LAN7500",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN7505,
	    "LAN7505",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN7800,
	    "LAN7800",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN7801,
	    "LAN7801",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN7850,
	    "LAN7850",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9500,
	    "SMSC9500",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9505,
	    "SMSC9505",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN9530,
	    "LAN9530",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN9730,
	    "LAN9730",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9500_SAL10,
	    "SMSC9500",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9505_SAL10,
	    "SMSC9505",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9500A_SAL10,
	    "SMSC9500A",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9505A_SAL10,
	    "SMSC9505A",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9512_14_SAL10,
	    "SMSC9512/14",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9500A_HAL,
	    "SMSC9500A",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9505A_HAL,
	    "SMSC9505A",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9500_ALT,
	    "SMSC9500",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9500A_ALT,
	    "SMSC9500A",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9512_14_ALT,
	    "SMSC9512",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9500A,
	    "SMSC9500A",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9505A,
	    "SMSC9505A",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_LAN89530,
	    "LAN89530",
	},
	{
	    USB_VENDOR_SMC2, USB_PRODUCT_SMC2_SMSC9512_14,
	    "SMSC9512/14",
	},
	{
	    USB_VENDOR_SMC3, USB_PRODUCT_SMC3_2662WV1,
	    "EZ Connect 11Mbps",
	},
	{
	    USB_VENDOR_SMC3, USB_PRODUCT_SMC3_2662WV2,
	    "EZ Connect 11Mbps v2",
	},
	{
	    USB_VENDOR_SOHOWARE, USB_PRODUCT_SOHOWARE_NUB100,
	    "NUB100 Ethernet",
	},
	{
	    USB_VENDOR_SOHOWARE, USB_PRODUCT_SOHOWARE_NUB110,
	    "NUB110 Ethernet",
	},
	{
	    USB_VENDOR_SOLIDYEAR, USB_PRODUCT_SOLIDYEAR_KEYBOARD,
	    "Keyboard",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_DSC,
	    "DSC Cameras",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_NWMS7,
	    "Memorystick NW-MS7",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_DRIVEV2,
	    "Harddrive V2",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_MSACUS1,
	    "Memorystick MSAC-US1",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_HANDYCAM,
	    "Handycam",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_MSC,
	    "MSC Memorystick",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_35,
	    "Clie v3.5",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_PS2KEYBOARD,
	    "PlayStation2 keyboard",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_PS2KEYBOARDHUB,
	    "PlayStation2 keyboard hub",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_PS2MOUSE,
	    "PlayStation2 mouse",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_40,
	    "Clie v4.0",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_40_MS,
	    "Clie v4.0 Memory Stick",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_S360,
	    "Clie s360",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_41_MS,
	    "Clie v4.1 Memory Stick",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_41,
	    "Clie v4.1",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_NX60,
	    "Clie nx60",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CLIE_TJ25,
	    "Clie tj25",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_IFU_WLM2,
	    "IFU-WLM2",
	},
	{
	    USB_VENDOR_SONY, USB_PRODUCT_SONY_CXD9192,
	    "1seg TV tuner",
	},
	{
	    USB_VENDOR_SOURCENEXT, USB_PRODUCT_SOURCENEXT_KEIKAI8_CHG,
	    "KeikaiDenwa 8 with charger",
	},
	{
	    USB_VENDOR_SOURCENEXT, USB_PRODUCT_SOURCENEXT_KEIKAI8,
	    "KeikaiDenwa 8",
	},
	{
	    USB_VENDOR_SPARKLAN, USB_PRODUCT_SPARKLAN_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_SPARKLAN, USB_PRODUCT_SPARKLAN_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_SPARKLAN, USB_PRODUCT_SPARKLAN_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_SPARKLAN, USB_PRODUCT_SPARKLAN_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_SPEEDDRAGON, USB_PRODUCT_SPEEDDRAGON_MS3303H,
	    "MS3303H Serial",
	},
	{
	    USB_VENDOR_SPHAIRON, USB_PRODUCT_SPHAIRON_UB801R,
	    "UB801R",
	},
	{
	    USB_VENDOR_SPHAIRON, USB_PRODUCT_SPHAIRON_RTL8187,
	    "RTL8187",
	},
	{
	    USB_VENDOR_STARTECH, USB_PRODUCT_STARTECH_ICUSB232X,
	    "ICUSB2321X/2X/4X",
	},
	{
	    USB_VENDOR_STMICRO, USB_PRODUCT_STMICRO_BIOMETRIC_COPR,
	    "Biometric Coprocessor",
	},
	{
	    USB_VENDOR_STMICRO, USB_PRODUCT_STMICRO_COMMUNICATOR,
	    "Communicator",
	},
	{
	    USB_VENDOR_STOLLMANN, USB_PRODUCT_STOLLMANN_ISDN_TA_USBA,
	    "ISDN TA+USBA",
	},
	{
	    USB_VENDOR_STRAWBERRYLINUX, USB_PRODUCT_STRAWBERRYLINUX_USBRH,
	    "USBRH sensor",
	},
	{
	    USB_VENDOR_STSN, USB_PRODUCT_STSN_STSN0001,
	    "Internet Access Device",
	},
	{
	    USB_VENDOR_SUNCOMM, USB_PRODUCT_SUNCOMM_MB_ADAPTOR,
	    "Mobile Adaptor",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_DS96L,
	    "U-Cable type D2",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_PS64P1,
	    "U-Cable type P1",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_VS10U,
	    "Slipper U",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_IS96U,
	    "Ir-Trinity",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_AS64LX,
	    "U-Cable type A3",
	},
	{
	    USB_VENDOR_SUNTAC, USB_PRODUCT_SUNTAC_AS144L4,
	    "U-Cable type A4",
	},
	{
	    USB_VENDOR_SUPERTOP, USB_PRODUCT_SUPERTOP_IDEBRIDGE,
	    "SuperTop IDE Bridge",
	},
	{
	    USB_VENDOR_SURECOM, USB_PRODUCT_SURECOM_EP9001G2A,
	    "EP-9001-G rev 2A",
	},
	{
	    USB_VENDOR_SURECOM, USB_PRODUCT_SURECOM_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_SURECOM, USB_PRODUCT_SURECOM_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_SUSTEEN, USB_PRODUCT_SUSTEEN_DCU11,
	    "Ericsson DCU-10/11",
	},
	{
	    USB_VENDOR_SWEEX, USB_PRODUCT_SWEEX_ZD1211,
	    "ZD1211",
	},
	{
	    USB_VENDOR_SWEEX2, USB_PRODUCT_SWEEX2_LW153,
	    "LW153",
	},
	{
	    USB_VENDOR_SWEEX2, USB_PRODUCT_SWEEX2_LW154,
	    "LW154",
	},
	{
	    USB_VENDOR_SWEEX2, USB_PRODUCT_SWEEX2_LW303,
	    "LW303",
	},
	{
	    USB_VENDOR_SWEEX2, USB_PRODUCT_SWEEX2_LW313,
	    "LW313",
	},
	{
	    USB_VENDOR_SYNAPTICS, USB_PRODUCT_SYNAPTICS_FPRINT,
	    "Fingerprint Reader",
	},
	{
	    USB_VENDOR_SYNAPTICS, USB_PRODUCT_SYNAPTICS_FPRINT_2,
	    "Fingerprint Reader",
	},
	{
	    USB_VENDOR_SYNTECH, USB_PRODUCT_SYNTECH_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_SYNTECH, USB_PRODUCT_SYNTECH_CIPHERLAB100,
	    "CipherLab Barcode Scanner",
	},
	{
	    USB_VENDOR_SYSTEMTALKS, USB_PRODUCT_SYSTEMTALKS_SGCX2UL,
	    "SGC-X2UL",
	},
	{
	    USB_VENDOR_TANGTOP, USB_PRODUCT_TANGTOP_USBPS2,
	    "USBPS2",
	},
	{
	    USB_VENDOR_TAPWAVE, USB_PRODUCT_TAPWAVE_ZODIAC,
	    "Zodiac",
	},
	{
	    USB_VENDOR_TAUGA, USB_PRODUCT_TAUGA_CAMERAMATE,
	    "CameraMate (DPCM_USB)",
	},
	{
	    USB_VENDOR_TCTMOBILE, USB_PRODUCT_TCTMOBILE_UMSM,
	    "Modem mode",
	},
	{
	    USB_VENDOR_TCTMOBILE, USB_PRODUCT_TCTMOBILE_UMSM_2,
	    "Modem mode",
	},
	{
	    USB_VENDOR_TCTMOBILE, USB_PRODUCT_TCTMOBILE_UMSM_3,
	    "Modem mode",
	},
	{
	    USB_VENDOR_TCTMOBILE, USB_PRODUCT_TCTMOBILE_UMASS,
	    "Storage mode",
	},
	{
	    USB_VENDOR_TCTMOBILE, USB_PRODUCT_TCTMOBILE_UMASS_2,
	    "Storage mode",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UPA9664,
	    "USB-PDC Adapter UPA9664",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UCA1464,
	    "USB-cdmaOne Adapter UCA1464",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UHA6400,
	    "USB-PHS Adapter UHA6400",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_UPA6400,
	    "USB-PHS Adapter UPA6400",
	},
	{
	    USB_VENDOR_TDK, USB_PRODUCT_TDK_BLUETOOTH,
	    "Bluetooth",
	},
	{
	    USB_VENDOR_TEAC, USB_PRODUCT_TEAC_FD05PUB,
	    "FD-05PUB",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_0193,
	    "ALLNET 0193 WLAN",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_ZYAIR_B200,
	    "ZyXEL ZyAIR B200 WLAN",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_U300C,
	    "U-300C",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_QUICKWLAN,
	    "QuickWLAN",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_ZD1211_1,
	    "ZD1211",
	},
	{
	    USB_VENDOR_TEKRAM, USB_PRODUCT_TEKRAM_ZD1211_2,
	    "ZD1211",
	},
	{
	    USB_VENDOR_TELEX, USB_PRODUCT_TELEX_MIC1,
	    "Microphone",
	},
	{
	    USB_VENDOR_TENDA, USB_PRODUCT_TENDA_TWL541U,
	    "TWL541U WLAN",
	},
	{
	    USB_VENDOR_TENX, USB_PRODUCT_TENX_MISSILE,
	    "Missile Launcher",
	},
	{
	    USB_VENDOR_TENX, USB_PRODUCT_TENX_TEMPER,
	    "TEMPer sensor",
	},
	{
	    USB_VENDOR_TERRATEC, USB_PRODUCT_TERRATEC_AUREON,
	    "Aureon Dual USB",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_175,
	    "175/177 USB interface",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_330,
	    "330 USB interface",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_435,
	    "435/635/735 USB interface",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_845,
	    "845 USB interface",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_SERVICE,
	    "Service adapter",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_580,
	    "580 USB interface",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_174,
	    "174 USB interface",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_556,
	    "556/560 USB interface",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_SERIAL_1,
	    "USB adapter",
	},
	{
	    USB_VENDOR_TESTO, USB_PRODUCT_TESTO_SERIAL_2,
	    "USB to serial converter",
	},
	{
	    USB_VENDOR_THINGM, USB_PRODUCT_THINGM_BLINK1,
	    "USB notification light",
	},
	{
	    USB_VENDOR_THRUST, USB_PRODUCT_THRUST_FUSION_PAD,
	    "Fusion Digital Gamepad",
	},
	{
	    USB_VENDOR_THURLBY, USB_PRODUCT_THURLBY_QL355P,
	    "QL355P power supply",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_UTUSB41,
	    "UT-USB41 hub",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_TUSB2046,
	    "TUSB2046 hub",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_TUSB3410,
	    "TUSB3410",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_NEXII,
	    "Nex II Digital",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_MSP430_JTAG,
	    "MSP-FET430UIF JTAG",
	},
	{
	    USB_VENDOR_TI, USB_PRODUCT_TI_MSP430,
	    "MSP-FET430UIF",
	},
	{
	    USB_VENDOR_TML, USB_PRODUCT_TML_SERIAL,
	    "Serial",
	},
	{
	    USB_VENDOR_TODOS, USB_PRODUCT_TODOS_ARGOS_MINI,
	    "Argos Mini Smartcard",
	},
	{
	    USB_VENDOR_TOPRE, USB_PRODUCT_TOPRE_HHKB,
	    "HHKB Professional",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_RH,
	    "Toradex OAK RH sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_P,
	    "Toradex OAK P sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_LUX,
	    "Toradex OAK LUX sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_TILT,
	    "Toradex OAK Tilt sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_DIST,
	    "Toradex OAK DIST sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_MOVE,
	    "Toradex OAK MOVE sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_4_20,
	    "Toradex OAK 4-20mA sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_G,
	    "Toradex OAK G sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_MAGR,
	    "Toradex OAK MAGR sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_RELAY,
	    "Toradex OAK RELAY",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_10V,
	    "Toradex OAK 10V sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_LN,
	    "Toradex OAK LN sensor",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_IO,
	    "Toradex OAK IO",
	},
	{
	    USB_VENDOR_TORADEX, USB_PRODUCT_TORADEX_ORIENT,
	    "Toradex ORIENT Tilt sensor",
	},
	{
	    USB_VENDOR_TOSHIBA, USB_PRODUCT_TOSHIBA_RTL8153B,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_TOSHIBA, USB_PRODUCT_TOSHIBA_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_TOSHIBA, USB_PRODUCT_TOSHIBA_HSDPA,
	    "HSDPA",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8812AU,
	    "RTL8812AU",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8192EU,
	    "RTL8192EU",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8192EU_2,
	    "RTL8192EU",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8192EU_3,
	    "RTL8192EU",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8188EUS,
	    "RTL8188EUS",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_EU300,
	    "EU300",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8152B_1,
	    "RTL8152B",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8152B_2,
	    "RTL8152B",
	},
	{
	    USB_VENDOR_TPLINK, USB_PRODUCT_TPLINK_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_TREK, USB_PRODUCT_TREK_THUMBDRIVE,
	    "ThumbDrive",
	},
	{
	    USB_VENDOR_TREK, USB_PRODUCT_TREK_THUMBDRIVE_8MB,
	    "ThumbDrive 8MB",
	},
	{
	    USB_VENDOR_TRENDNET, USB_PRODUCT_TRENDNET_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_TRENDNET, USB_PRODUCT_TRENDNET_RTL8188CU,
	    "RTL8188CU",
	},
	{
	    USB_VENDOR_TRENDNET, USB_PRODUCT_TRENDNET_RTL8156,
	    "RTL8156",
	},
	{
	    USB_VENDOR_TRIPPLITE, USB_PRODUCT_TRIPPLITE_U209,
	    "U209 Serial",
	},
	{
	    USB_VENDOR_TRUMPION, USB_PRODUCT_TRUMPION_T33521,
	    "USB/MP3 decoder",
	},
	{
	    USB_VENDOR_TRUMPION, USB_PRODUCT_TRUMPION_XXX1100,
	    "XXX 1100",
	},
	{
	    USB_VENDOR_TRUST, USB_PRODUCT_TRUST_OPTMOUSE,
	    "Optical Mouse",
	},
	{
	    USB_VENDOR_TRUST, USB_PRODUCT_TRUST_MOUSE,
	    "Mouse",
	},
	{
	    USB_VENDOR_TSUNAMI, USB_PRODUCT_TSUNAMI_SM2000,
	    "SM-2000",
	},
	{
	    USB_VENDOR_TTL, USB_PRODUCT_TTL_RTL8153,
	    "RTL8153",
	},
	{
	    USB_VENDOR_TWINHEAD, USB_PRODUCT_TWINHEAD_RTL8153B,
	    "RTL8153B",
	},
	{
	    USB_VENDOR_TWINMOS, USB_PRODUCT_TWINMOS_G240,
	    "G240",
	},
	{
	    USB_VENDOR_UBLOX, USB_PRODUCT_UBLOX_ANTARIS4,
	    "ANTARIS4 GPS",
	},
	{
	    USB_VENDOR_ULTIMA, USB_PRODUCT_ULTIMA_1200UBPLUS,
	    "1200 UB Plus",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA1236U,
	    "Astra 1236U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA1220U,
	    "Astra 1220U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA2000U,
	    "Astra 2000U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA3400,
	    "Astra 3400",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA2100U,
	    "Astra 2100U",
	},
	{
	    USB_VENDOR_UMAX, USB_PRODUCT_UMAX_ASTRA2200U,
	    "Astra 2200U",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW444UBEU,
	    "TEW-444UB EU",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW444UBEU_NF,
	    "TEW-444UB EU",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW429UB_A,
	    "TEW-429UB_A",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW429UB,
	    "TEW-429UB",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW429UBC1,
	    "TEW-429UB C1",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_TEW645UB,
	    "TEW-645UB",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_ALL0298V2,
	    "ALL0298 v2",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_UMEDIA, USB_PRODUCT_UMEDIA_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_UNIACCESS, USB_PRODUCT_UNIACCESS_PANACHE,
	    "Panache Surf ISDN",
	},
	{
	    USB_VENDOR_UNKNOWN2, USB_PRODUCT_UNKNOWN2_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_UNKNOWN2, USB_PRODUCT_UNKNOWN2_NW3100,
	    "NW-3100",
	},
	{
	    USB_VENDOR_UNKNOWN3, USB_PRODUCT_UNKNOWN3_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_UNKNOWN4, USB_PRODUCT_UNKNOWN4_DM9601,
	    "DM9601",
	},
	{
	    USB_VENDOR_UNKNOWN4, USB_PRODUCT_UNKNOWN4_RD9700,
	    "RD9700",
	},
	{
	    USB_VENDOR_UNKNOWN5, USB_PRODUCT_UNKNOWN5_NF_RIC,
	    "NF RIC",
	},
	{
	    USB_VENDOR_UNKNOWN6, USB_PRODUCT_UNKNOWN6_DM9601,
	    "DM9601",
	},
	{
	    USB_VENDOR_USI, USB_PRODUCT_USI_MC60,
	    "MC60 Serial",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR1120,
	    "USR1120 WLAN",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_A,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_A_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_A,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_A_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_B,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_HEINEKEN_B_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_B,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_MILLER_B_NF,
	    "USR9000 SureConnect ADSL",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR5422,
	    "USR5422 WLAN",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR5421A,
	    "USR5421A WLAN",
	},
	{
	    USB_VENDOR_USR, USB_PRODUCT_USR_USR5423,
	    "USR5423 WLAN",
	},
	{
	    USB_VENDOR_VAISALA, USB_PRODUCT_VAISALA_USBINSTCABLE,
	    "USB instrument cable",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS101,
	    "VFS101 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS301,
	    "VFS301 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS451,
	    "VFS451 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS300,
	    "VFS300 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS5011,
	    "VFS5011 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS5011_2,
	    "VFS5011 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS5011_3,
	    "VFS5011 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VALIDITY, USB_PRODUCT_VALIDITY_VFS5471,
	    "VFS471 Fingerprint Reader",
	},
	{
	    USB_VENDOR_VELLEMAN, USB_PRODUCT_VELLEMAN_K8055,
	    "K8055 USB Experiment interface board",
	},
	{
	    USB_VENDOR_VERTEX, USB_PRODUCT_VERTEX_VW110L,
	    "VW110L",
	},
	{
	    USB_VENDOR_VIA, USB_PRODUCT_VIA_AR9271,
	    "AR9271",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_G773HUB,
	    "G773 Monitor Hub",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_P815HUB,
	    "P815 Monitor Hub",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_AIRSYNC,
	    "Airsync",
	},
	{
	    USB_VENDOR_VIEWSONIC, USB_PRODUCT_VIEWSONIC_G773CTRL,
	    "G773 Monitor Control",
	},
	{
	    USB_VENDOR_VISION, USB_PRODUCT_VISION_VC6452V002,
	    "CPiA Camera",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_7600,
	    "OneTouch 7600",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_5300,
	    "OneTouch 5300",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_3000,
	    "Scanport 3000",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_6100,
	    "OneTouch 6100",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_6200,
	    "OneTouch 6200",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_8100,
	    "OneTouch 8100",
	},
	{
	    USB_VENDOR_VISIONEER, USB_PRODUCT_VISIONEER_8600,
	    "OneTouch 8600",
	},
	{
	    USB_VENDOR_VIVITAR, USB_PRODUCT_VIVITAR_DSC350,
	    "DSC350",
	},
	{
	    USB_VENDOR_VOTI, USB_PRODUCT_VOTI_SELETEK_1,
	    "Lunatico Seletek",
	},
	{
	    USB_VENDOR_VOTI, USB_PRODUCT_VOTI_SELETEK_2,
	    "Lunatico Seletek",
	},
	{
	    USB_VENDOR_VTECH, USB_PRODUCT_VTECH_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_VTECH, USB_PRODUCT_VTECH_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_CT0405U,
	    "CT-0405-U Tablet",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_GRAPHIRE,
	    "Graphire",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_GRAPHIRE3_4X5,
	    "Graphire3 4x5",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_GRAPHIRE4_4X5,
	    "Graphire4 Classic A6",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_INTUOSA5,
	    "Intuos A5",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_INTUOS_DRAW,
	    "Intuos Draw (CTL-490)",
	},
	{
	    USB_VENDOR_WACOM, USB_PRODUCT_WACOM_INTUOS_PRO_S,
	    "Intuos Pro S",
	},
	{
	    USB_VENDOR_WAGO, USB_PRODUCT_WAGO_SERVICECABLE,
	    "Service Cable 750-923",
	},
	{
	    USB_VENDOR_WAVESENSE, USB_PRODUCT_WAVESENSE_JAZZ,
	    "Jazz blood glucose meter",
	},
	{
	    USB_VENDOR_WCH, USB_PRODUCT_WCH_CH341,
	    "CH341 serial/parallel",
	},
	{
	    USB_VENDOR_WCH2, USB_PRODUCT_WCH2_CH341A,
	    "CH341A serial/parallel",
	},
	{
	    USB_VENDOR_WCH2, USB_PRODUCT_WCH2_CH340,
	    "CH340 serial/parallel",
	},
	{
	    USB_VENDOR_WIENERPLEINBAUS, USB_PRODUCT_WIENERPLEINBAUS_PL512,
	    "PL512 PSU",
	},
	{
	    USB_VENDOR_WIENERPLEINBAUS, USB_PRODUCT_WIENERPLEINBAUS_RCM,
	    "RCM Remote Control",
	},
	{
	    USB_VENDOR_WIENERPLEINBAUS, USB_PRODUCT_WIENERPLEINBAUS_MPOD,
	    "MPOD PSU",
	},
	{
	    USB_VENDOR_WIENERPLEINBAUS, USB_PRODUCT_WIENERPLEINBAUS_CML,
	    "CML Data Logger",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_WNC0600,
	    "WNC-0600USB",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_UR045G,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_UR055G,
	    "UR055G",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_O8494,
	    "ORiNOCO 802.11n",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_1,
	    "AR5523",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_1_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_2_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_WISTRONNEWEB, USB_PRODUCT_WISTRONNEWEB_AR5523_2,
	    "AR5523",
	},
	{
	    USB_VENDOR_WMR, USB_PRODUCT_WMR_RIGBLASTER,
	    "RIGblaster",
	},
	{
	    USB_VENDOR_XIAOMI, USB_PRODUCT_XIAOMI_RTL8152B,
	    "RTL8152B",
	},
	{
	    USB_VENDOR_XIAOMI, USB_PRODUCT_XIAOMI_MT7601U,
	    "MT7601U",
	},
	{
	    USB_VENDOR_XIRING, USB_PRODUCT_XIRING_XIMAX,
	    "Ximax CDC",
	},
	{
	    USB_VENDOR_XIRLINK, USB_PRODUCT_XIRLINK_IMAGING,
	    "Imaging Device",
	},
	{
	    USB_VENDOR_XIRLINK, USB_PRODUCT_XIRLINK_PCCAM,
	    "IBM PC Camera",
	},
	{
	    USB_VENDOR_XYRATEX, USB_PRODUCT_XYRATEX_PRISM_GT_1,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_XYRATEX, USB_PRODUCT_XYRATEX_PRISM_GT_2,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_UX256,
	    "UX256 MIDI I/F",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_UX96,
	    "UX96 MIDI I/F",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_UR22,
	    "UR22",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RPU200,
	    "RP-U200",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTA54I,
	    "NetVolante RTA54i",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTW65B,
	    "NetVolante RTW65b",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTW65I,
	    "NetVolante RTW65i",
	},
	{
	    USB_VENDOR_YAMAHA, USB_PRODUCT_YAMAHA_RTA55I,
	    "NetVolante RTA55i",
	},
	{
	    USB_VENDOR_YANO, USB_PRODUCT_YANO_U640MO,
	    "U640MO-03",
	},
	{
	    USB_VENDOR_YCCABLE, USB_PRODUCT_YCCABLE_PL2303,
	    "PL2303 Serial",
	},
	{
	    USB_VENDOR_YEDATA, USB_PRODUCT_YEDATA_FLASHBUSTERU,
	    "Flashbuster-U",
	},
	{
	    USB_VENDOR_YUBICO, USB_PRODUCT_YUBICO_YUBIKEY,
	    "Yubikey",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_M4Y750,
	    "M4Y-750",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_XI725,
	    "XI-725/726",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_XI735,
	    "XI-735",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_MD40900,
	    "MD40900",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_XG703A,
	    "PrismGT USB 2.0 WLAN",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_ZD1211,
	    "ZD1211",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_AR5523,
	    "AR5523",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_AR5523_NF,
	    "AR5523",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_UB81,
	    "UB81",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_ZCOM, USB_PRODUCT_ZCOM_UB82,
	    "UB82",
	},
	{
	    USB_VENDOR_ZINWELL, USB_PRODUCT_ZINWELL_RT2570,
	    "RT2570",
	},
	{
	    USB_VENDOR_ZINWELL, USB_PRODUCT_ZINWELL_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_ZINWELL, USB_PRODUCT_ZINWELL_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_ZINWELL, USB_PRODUCT_ZINWELL_RT3072_1,
	    "RT3072",
	},
	{
	    USB_VENDOR_ZINWELL, USB_PRODUCT_ZINWELL_RT3072_2,
	    "RT3072",
	},
	{
	    USB_VENDOR_ZINWELL, USB_PRODUCT_ZINWELL_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_ZOOM, USB_PRODUCT_ZOOM_2986L,
	    "2986L Fax Modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_CDMA_MSM,
	    "CDMA Technologies MSM modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_MF633,
	    "ZTE MF633 USUPA USB modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_MF637,
	    "ZTE MF637 HSUPA USB modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_K3565Z,
	    "ZTE K3565-Z USB MSM modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_UMASS_INSTALLER4,
	    "ZTE USB MSM installer",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_MSA110UP,
	    "ONDA MSA110UP USB MSM modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_UMASS_INSTALLER2,
	    "ZTE USB MSM installer",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_MF112,
	    "ZTE MF112 HSUPA USB modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_HSUSB,
	    "ZTE HSUSB",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_UMASS_INSTALLER,
	    "ZTE USB MSM installer",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_AC2746,
	    "AC2746 CDMA USB modem",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_UMASS_INSTALLER3,
	    "ZTE USB CDMA installer",
	},
	{
	    USB_VENDOR_ZTE, USB_PRODUCT_ZTE_AC8700,
	    "AC8700 CDMA USB modem",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1201,
	    "ZD1201",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1211,
	    "ZD1211",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1211B,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1221,
	    "ZD1221",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ALL0298,
	    "ALL0298",
	},
	{
	    USB_VENDOR_ZYDAS, USB_PRODUCT_ZYDAS_ZD1211B_2,
	    "ZD1211B",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_OMNI56K,
	    "Omni 56K Plus",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_980N,
	    "Scorpion-980N",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G220,
	    "G-220",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G220F,
	    "G-220F",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G200V2,
	    "G-200 v2",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_AG225H,
	    "AG-225H",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_M202,
	    "M-202",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G270S,
	    "G-270S",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G220V2,
	    "G-220 v2",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_G202,
	    "G-202",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_AG220,
	    "AG-220",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_AG225HV2,
	    "AG-225H v2",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_RT2573,
	    "RT2573",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_RT2870_1,
	    "RT2870",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_NWD271N,
	    "NWD-271N",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_NWD211AN,
	    "NWD-211AN",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_RT2870_2,
	    "RT2870",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_NWD2105,
	    "NWD2105",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_RTL8192CU,
	    "RTL8192CU",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_RT3070,
	    "RT3070",
	},
	{
	    USB_VENDOR_ZYXEL, USB_PRODUCT_ZYXEL_PRESTIGE,
	    "Prestige",
	},
	{ 0, 0, NULL }
};

const struct usb_known_vendor usb_known_vendors[] = {
	{
	    USB_VENDOR_PLANEX4,
	    "Planex Communications",
	},
	{
	    USB_VENDOR_UNKNOWN2,
	    "Unknown vendor",
	},
	{
	    USB_VENDOR_EGALAX2,
	    "eGalax",
	},
	{
	    USB_VENDOR_UNKNOWN6,
	    "Unknown vendor",
	},
	{
	    USB_VENDOR_HUMAX,
	    "HUMAX",
	},
	{
	    USB_VENDOR_BWCT,
	    "Bernd Walter Computer Technology",
	},
	{
	    USB_VENDOR_AOX,
	    "AOX",
	},
	{
	    USB_VENDOR_ATMEL,
	    "Atmel",
	},
	{
	    USB_VENDOR_MITSUMI,
	    "Mitsumi",
	},
	{
	    USB_VENDOR_HP,
	    "Hewlett Packard",
	},
	{
	    USB_VENDOR_ADAPTEC,
	    "Adaptec",
	},
	{
	    USB_VENDOR_NATIONAL,
	    "National Semiconductor",
	},
	{
	    USB_VENDOR_ACERLABS,
	    "Acer Labs",
	},
	{
	    USB_VENDOR_FTDI,
	    "Future Technology Devices",
	},
	{
	    USB_VENDOR_QUANTA2,
	    "Quanta",
	},
	{
	    USB_VENDOR_NEC,
	    "NEC",
	},
	{
	    USB_VENDOR_KODAK,
	    "Eastman Kodak",
	},
	{
	    USB_VENDOR_VIA,
	    "VIA",
	},
	{
	    USB_VENDOR_MELCO,
	    "Melco",
	},
	{
	    USB_VENDOR_LEADTEK,
	    "Leadtek",
	},
	{
	    USB_VENDOR_CREATIVE,
	    "Creative Labs",
	},
	{
	    USB_VENDOR_NOKIA2,
	    "Nokia",
	},
	{
	    USB_VENDOR_ADI,
	    "ADI Systems",
	},
	{
	    USB_VENDOR_CATC,
	    "Computer Access Technology",
	},
	{
	    USB_VENDOR_SMC2,
	    "Standard Microsystems",
	},
	{
	    USB_VENDOR_GRAVIS,
	    "Advanced Gravis Computer",
	},
	{
	    USB_VENDOR_FUJITSUCOMP,
	    "Fujitsu Component",
	},
	{
	    USB_VENDOR_TAUGA,
	    "Taugagreining HF",
	},
	{
	    USB_VENDOR_AMD,
	    "Advanced Micro Devices",
	},
	{
	    USB_VENDOR_LEXMARK,
	    "Lexmark International",
	},
	{
	    USB_VENDOR_LG,
	    "LG USA",
	},
	{
	    USB_VENDOR_NANAO,
	    "NANAO",
	},
	{
	    USB_VENDOR_ALPS,
	    "Alps Electric",
	},
	{
	    USB_VENDOR_THRUST,
	    "Thrustmaster",
	},
	{
	    USB_VENDOR_TI,
	    "Texas Instruments",
	},
	{
	    USB_VENDOR_ANALOGDEVICES,
	    "Analog Devices",
	},
	{
	    USB_VENDOR_SIS,
	    "Silicon Integrated Systems Corp.",
	},
	{
	    USB_VENDOR_KYE,
	    "KYE Systems",
	},
	{
	    USB_VENDOR_DIAMOND2,
	    "Diamond (Supra)",
	},
	{
	    USB_VENDOR_RENESAS,
	    "Renesas",
	},
	{
	    USB_VENDOR_MICROSOFT,
	    "Microsoft",
	},
	{
	    USB_VENDOR_PRIMAX,
	    "Primax Electronics",
	},
	{
	    USB_VENDOR_MGE,
	    "Eaton (MGE)",
	},
	{
	    USB_VENDOR_AMP,
	    "AMP",
	},
	{
	    USB_VENDOR_CHERRY,
	    "Cherry Mikroschalter",
	},
	{
	    USB_VENDOR_MEGATRENDS,
	    "American Megatrends",
	},
	{
	    USB_VENDOR_LOGITECH,
	    "Logitech",
	},
	{
	    USB_VENDOR_BTC,
	    "Behavior Tech. Computer",
	},
	{
	    USB_VENDOR_PHILIPS,
	    "Philips",
	},
	{
	    USB_VENDOR_SANYO,
	    "Sanyo Electric",
	},
	{
	    USB_VENDOR_CONNECTIX,
	    "Connectix",
	},
	{
	    USB_VENDOR_DELL2,
	    "Dell",
	},
	{
	    USB_VENDOR_KENSINGTON,
	    "Kensington",
	},
	{
	    USB_VENDOR_LUCENT,
	    "Lucent",
	},
	{
	    USB_VENDOR_PLANTRONICS,
	    "Plantronics",
	},
	{
	    USB_VENDOR_KYOCERA,
	    "Kyocera",
	},
	{
	    USB_VENDOR_STMICRO,
	    "STMicroelectronics",
	},
	{
	    USB_VENDOR_FOXCONN,
	    "Foxconn",
	},
	{
	    USB_VENDOR_YAMAHA,
	    "YAMAHA",
	},
	{
	    USB_VENDOR_COMPAQ,
	    "Compaq",
	},
	{
	    USB_VENDOR_HITACHI,
	    "Hitachi",
	},
	{
	    USB_VENDOR_ACERP,
	    "Acer Peripherals",
	},
	{
	    USB_VENDOR_DAVICOM,
	    "Davicom",
	},
	{
	    USB_VENDOR_VISIONEER,
	    "Visioneer",
	},
	{
	    USB_VENDOR_CANON,
	    "Canon",
	},
	{
	    USB_VENDOR_NIKON,
	    "Nikon",
	},
	{
	    USB_VENDOR_IBM,
	    "IBM",
	},
	{
	    USB_VENDOR_CYPRESS,
	    "Cypress Semiconductor",
	},
	{
	    USB_VENDOR_EPSON,
	    "Seiko Epson",
	},
	{
	    USB_VENDOR_RAINBOW,
	    "Rainbow Technologies",
	},
	{
	    USB_VENDOR_IODATA,
	    "I/O Data",
	},
	{
	    USB_VENDOR_TDK,
	    "TDK",
	},
	{
	    USB_VENDOR_3COMUSR,
	    "U.S. Robotics",
	},
	{
	    USB_VENDOR_METHODE,
	    "Methode Electronics Far East",
	},
	{
	    USB_VENDOR_MAXISWITCH,
	    "Maxi Switch",
	},
	{
	    USB_VENDOR_LOCKHEEDMER,
	    "Lockheed Martin Energy Research",
	},
	{
	    USB_VENDOR_FUJITSU,
	    "Fujitsu",
	},
	{
	    USB_VENDOR_TOSHIBAAM,
	    "Toshiba America",
	},
	{
	    USB_VENDOR_MICROMACRO,
	    "Micro Macro Technologies",
	},
	{
	    USB_VENDOR_KONICA,
	    "Konica",
	},
	{
	    USB_VENDOR_LITEON,
	    "Lite-On Technology",
	},
	{
	    USB_VENDOR_FUJIPHOTO,
	    "Fuji Photo Film",
	},
	{
	    USB_VENDOR_PHILIPSSEMI,
	    "Philips Semiconductors",
	},
	{
	    USB_VENDOR_TATUNG,
	    "Tatung Co. Of America",
	},
	{
	    USB_VENDOR_SCANLOGIC,
	    "ScanLogic",
	},
	{
	    USB_VENDOR_MYSON,
	    "Myson Technology",
	},
	{
	    USB_VENDOR_DIGI2,
	    "Digi",
	},
	{
	    USB_VENDOR_ITTCANON,
	    "ITT Canon",
	},
	{
	    USB_VENDOR_ALTEC,
	    "Altec Lansing",
	},
	{
	    USB_VENDOR_MICROCHIP,
	    "Microchip Technology, Inc.",
	},
	{
	    USB_VENDOR_HOLTEK,
	    "Holtek",
	},
	{
	    USB_VENDOR_PANASONIC,
	    "Panasonic (Matsushita)",
	},
	{
	    USB_VENDOR_SHARP,
	    "Sharp",
	},
	{
	    USB_VENDOR_IIYAMA,
	    "Iiyama",
	},
	{
	    USB_VENDOR_EXAR,
	    "Exar",
	},
	{
	    USB_VENDOR_SHUTTLE,
	    "Shuttle Technology",
	},
	{
	    USB_VENDOR_SAMSUNG2,
	    "Samsung Electronics",
	},
	{
	    USB_VENDOR_ANNABOOKS,
	    "Annabooks",
	},
	{
	    USB_VENDOR_JVC,
	    "JVC",
	},
	{
	    USB_VENDOR_CHICONY,
	    "Chicony Electronics",
	},
	{
	    USB_VENDOR_ELAN,
	    "Elan",
	},
	{
	    USB_VENDOR_BROTHER,
	    "Brother Industries",
	},
	{
	    USB_VENDOR_DALLAS,
	    "Dallas Semiconductor",
	},
	{
	    USB_VENDOR_ACER,
	    "Acer",
	},
	{
	    USB_VENDOR_3COM,
	    "3Com",
	},
	{
	    USB_VENDOR_AZTECH,
	    "Aztech Systems",
	},
	{
	    USB_VENDOR_BELKIN,
	    "Belkin Components",
	},
	{
	    USB_VENDOR_KAWATSU,
	    "Kawatsu Semiconductor",
	},
	{
	    USB_VENDOR_APC,
	    "American Power Conversion",
	},
	{
	    USB_VENDOR_CONNECTEK,
	    "Advanced Connectek USA",
	},
	{
	    USB_VENDOR_NETCHIP,
	    "NetChip Technology",
	},
	{
	    USB_VENDOR_ALTRA,
	    "ALTRA",
	},
	{
	    USB_VENDOR_ATI,
	    "ATI Technologies",
	},
	{
	    USB_VENDOR_AKS,
	    "Aladdin Knowledge Systems",
	},
	{
	    USB_VENDOR_UNIACCESS,
	    "Universal Access",
	},
	{
	    USB_VENDOR_VIEWSONIC,
	    "ViewSonic",
	},
	{
	    USB_VENDOR_XIRLINK,
	    "Xirlink",
	},
	{
	    USB_VENDOR_ANCHOR,
	    "Anchor Chips",
	},
	{
	    USB_VENDOR_SONY,
	    "Sony",
	},
	{
	    USB_VENDOR_VISION,
	    "VLSI Vision",
	},
	{
	    USB_VENDOR_ASAHIKASEI,
	    "Asahi Kasei Microsystems",
	},
	{
	    USB_VENDOR_ATEN,
	    "ATEN International",
	},
	{
	    USB_VENDOR_SAMSUNG,
	    "Samsung",
	},
	{
	    USB_VENDOR_MUSTEK,
	    "Mustek Systems",
	},
	{
	    USB_VENDOR_TELEX,
	    "Telex Communications",
	},
	{
	    USB_VENDOR_PERACOM,
	    "Peracom Networks",
	},
	{
	    USB_VENDOR_ALCOR2,
	    "Alcor Micro",
	},
	{
	    USB_VENDOR_WACOM,
	    "WACOM",
	},
	{
	    USB_VENDOR_ETEK,
	    "e-TEK Labs",
	},
	{
	    USB_VENDOR_EIZO,
	    "EIZO",
	},
	{
	    USB_VENDOR_ELECOM,
	    "Elecom",
	},
	{
	    USB_VENDOR_XYRATEX,
	    "Xyratex",
	},
	{
	    USB_VENDOR_HAUPPAUGE,
	    "Hauppauge Computer Works",
	},
	{
	    USB_VENDOR_BAFO,
	    "BAFO/Quality Computer Accessories",
	},
	{
	    USB_VENDOR_YEDATA,
	    "Y-E Data",
	},
	{
	    USB_VENDOR_AVM,
	    "AVM",
	},
	{
	    USB_VENDOR_QUICKSHOT,
	    "Quickshot",
	},
	{
	    USB_VENDOR_ROLAND,
	    "Roland",
	},
	{
	    USB_VENDOR_ROCKFIRE,
	    "Rockfire",
	},
	{
	    USB_VENDOR_RATOC,
	    "RATOC Systems",
	},
	{
	    USB_VENDOR_ZYXEL,
	    "ZyXEL Communication",
	},
	{
	    USB_VENDOR_ALCOR,
	    "Alcor Micro",
	},
	{
	    USB_VENDOR_OMRON,
	    "OMRON Corporation",
	},
	{
	    USB_VENDOR_IOMEGA,
	    "Iomega",
	},
	{
	    USB_VENDOR_ATREND,
	    "A-Trend Technology",
	},
	{
	    USB_VENDOR_AID,
	    "Advanced Input Devices",
	},
	{
	    USB_VENDOR_LACIE,
	    "LaCie",
	},
	{
	    USB_VENDOR_THRUSTMASTER,
	    "Thrustmaster",
	},
	{
	    USB_VENDOR_CISCOLINKSYS3,
	    "Cisco-Linksys",
	},
	{
	    USB_VENDOR_OMNIVISION,
	    "OmniVision",
	},
	{
	    USB_VENDOR_INSYSTEM,
	    "In-System Design",
	},
	{
	    USB_VENDOR_APPLE,
	    "Apple Computer",
	},
	{
	    USB_VENDOR_YCCABLE,
	    "Y.C. Cable",
	},
	{
	    USB_VENDOR_JINGMOLD,
	    "Jing Mold",
	},
	{
	    USB_VENDOR_DIGI,
	    "Digi International",
	},
	{
	    USB_VENDOR_QUALCOMM,
	    "Qualcomm",
	},
	{
	    USB_VENDOR_QTRONIX,
	    "Qtronix",
	},
	{
	    USB_VENDOR_RICOH,
	    "Ricoh",
	},
	{
	    USB_VENDOR_ELSA,
	    "ELSA",
	},
	{
	    USB_VENDOR_BRAINBOXES,
	    "Brainboxes",
	},
	{
	    USB_VENDOR_ULTIMA,
	    "Ultima",
	},
	{
	    USB_VENDOR_AXIOHM,
	    "Axiohm Transaction Solutions",
	},
	{
	    USB_VENDOR_MICROTEK,
	    "Microtek",
	},
	{
	    USB_VENDOR_SUNTAC,
	    "SUN Corporation",
	},
	{
	    USB_VENDOR_LEXAR,
	    "Lexar Media",
	},
	{
	    USB_VENDOR_ADDTRON,
	    "Addtron",
	},
	{
	    USB_VENDOR_SYMBOL,
	    "Symbol Technologies",
	},
	{
	    USB_VENDOR_GENESYS,
	    "Genesys Logic",
	},
	{
	    USB_VENDOR_FUJI,
	    "Fuji Electric",
	},
	{
	    USB_VENDOR_KEITHLEY,
	    "Keithley Instruments",
	},
	{
	    USB_VENDOR_EIZONANAO,
	    "EIZO Nanao",
	},
	{
	    USB_VENDOR_KLSI,
	    "Kawasaki LSI",
	},
	{
	    USB_VENDOR_FFC,
	    "FFC",
	},
	{
	    USB_VENDOR_ANKO,
	    "Anko Electronic",
	},
	{
	    USB_VENDOR_PIENGINEERING,
	    "P.I. Engineering",
	},
	{
	    USB_VENDOR_AOC,
	    "AOC International",
	},
	{
	    USB_VENDOR_CHIC,
	    "Chic Technology",
	},
	{
	    USB_VENDOR_BARCO,
	    "Barco Display Systems",
	},
	{
	    USB_VENDOR_BRIDGE,
	    "Bridge Information",
	},
	{
	    USB_VENDOR_SOLIDYEAR,
	    "Solid Year",
	},
	{
	    USB_VENDOR_BIORAD,
	    "Bio-Rad Laboratories",
	},
	{
	    USB_VENDOR_MACALLY,
	    "Macally",
	},
	{
	    USB_VENDOR_ACTLABS,
	    "Act Labs",
	},
	{
	    USB_VENDOR_ALARIS,
	    "Alaris",
	},
	{
	    USB_VENDOR_APEX,
	    "Apex",
	},
	{
	    USB_VENDOR_VIVITAR,
	    "Vivitar",
	},
	{
	    USB_VENDOR_GUNZE,
	    "Gunze Electronics USA",
	},
	{
	    USB_VENDOR_AVISION,
	    "Avision",
	},
	{
	    USB_VENDOR_TEAC,
	    "TEAC",
	},
	{
	    USB_VENDOR_SGI,
	    "Silicon Graphics",
	},
	{
	    USB_VENDOR_SANWASUPPLY,
	    "Sanwa Supply",
	},
	{
	    USB_VENDOR_MUSTEK2,
	    "Mustek Systems",
	},
	{
	    USB_VENDOR_LINKSYS,
	    "Linksys",
	},
	{
	    USB_VENDOR_ACERSA,
	    "Acer Semiconductor America",
	},
	{
	    USB_VENDOR_SIGMATEL,
	    "Sigmatel",
	},
	{
	    USB_VENDOR_DRAYTEK,
	    "DrayTek",
	},
	{
	    USB_VENDOR_AIWA,
	    "Aiwa",
	},
	{
	    USB_VENDOR_ACARD,
	    "ACARD Technology",
	},
	{
	    USB_VENDOR_PROLIFIC,
	    "Prolific Technology",
	},
	{
	    USB_VENDOR_SIEMENS,
	    "Siemens",
	},
	{
	    USB_VENDOR_AVANCELOGIC,
	    "Avance Logic",
	},
	{
	    USB_VENDOR_SIEMENS2,
	    "Siemens",
	},
	{
	    USB_VENDOR_MINOLTA,
	    "Minolta",
	},
	{
	    USB_VENDOR_CHPRODUCTS,
	    "CH Products",
	},
	{
	    USB_VENDOR_HAGIWARA,
	    "Hagiwara Sys-Com",
	},
	{
	    USB_VENDOR_CTX,
	    "Chuntex",
	},
	{
	    USB_VENDOR_ASKEY,
	    "Askey Computer",
	},
	{
	    USB_VENDOR_SAITEK,
	    "Saitek",
	},
	{
	    USB_VENDOR_ALCATELT,
	    "Alcatel Telecom",
	},
	{
	    USB_VENDOR_AGFA,
	    "AGFA-Gevaert",
	},
	{
	    USB_VENDOR_ASIAMD,
	    "Asia Microelectronic Development",
	},
	{
	    USB_VENDOR_PHIDGETS,
	    "Phidgets",
	},
	{
	    USB_VENDOR_BIZLINK,
	    "Bizlink International",
	},
	{
	    USB_VENDOR_SYNAPTICS,
	    "Synaptics",
	},
	{
	    USB_VENDOR_KEYSPAN,
	    "Keyspan",
	},
	{
	    USB_VENDOR_AASHIMA,
	    "Aashima Technology",
	},
	{
	    USB_VENDOR_LIEBERT,
	    "Liebert",
	},
	{
	    USB_VENDOR_MULTITECH,
	    "MultiTech",
	},
	{
	    USB_VENDOR_ADS,
	    "ADS Technologies",
	},
	{
	    USB_VENDOR_ALCATELM,
	    "Alcatel Microelectronics",
	},
	{
	    USB_VENDOR_SIRIUS,
	    "Sirius Technologies",
	},
	{
	    USB_VENDOR_GUILLEMOT,
	    "Guillemot",
	},
	{
	    USB_VENDOR_BOSTON,
	    "Boston Acoustics",
	},
	{
	    USB_VENDOR_SMC,
	    "Standard Microsystems",
	},
	{
	    USB_VENDOR_PUTERCOM,
	    "Putercom",
	},
	{
	    USB_VENDOR_MCT,
	    "MCT",
	},
	{
	    USB_VENDOR_IMATION,
	    "Imation",
	},
	{
	    USB_VENDOR_DOMAIN,
	    "Domain Technologies, Inc.",
	},
	{
	    USB_VENDOR_SUSTEEN,
	    "Susteen",
	},
	{
	    USB_VENDOR_EICON,
	    "Eicon Networks",
	},
	{
	    USB_VENDOR_STOLLMANN,
	    "Stollmann",
	},
	{
	    USB_VENDOR_SYNTECH,
	    "Syntech Information",
	},
	{
	    USB_VENDOR_DIGITALSTREAM,
	    "Digital Stream",
	},
	{
	    USB_VENDOR_AUREAL,
	    "Aureal Semiconductor",
	},
	{
	    USB_VENDOR_IDOWELL,
	    "iDowell",
	},
	{
	    USB_VENDOR_MIDIMAN,
	    "Midiman",
	},
	{
	    USB_VENDOR_CYBERPOWER,
	    "CyberPower",
	},
	{
	    USB_VENDOR_SURECOM,
	    "Surecom Technology",
	},
	{
	    USB_VENDOR_LINKSYS2,
	    "Linksys",
	},
	{
	    USB_VENDOR_GRIFFIN,
	    "Griffin Technology",
	},
	{
	    USB_VENDOR_SANDISK,
	    "SanDisk",
	},
	{
	    USB_VENDOR_JENOPTIK,
	    "Jenoptik",
	},
	{
	    USB_VENDOR_LOGITEC,
	    "Logitec",
	},
	{
	    USB_VENDOR_NOKIA,
	    "Nokia",
	},
	{
	    USB_VENDOR_BRIMAX,
	    "Brimax",
	},
	{
	    USB_VENDOR_AXIS,
	    "Axis Communications",
	},
	{
	    USB_VENDOR_ABL,
	    "ABL Electronics",
	},
	{
	    USB_VENDOR_SAGEM,
	    "Sagem",
	},
	{
	    USB_VENDOR_SUNCOMM,
	    "Sun Communications",
	},
	{
	    USB_VENDOR_ALFADATA,
	    "Alfadata Computer",
	},
	{
	    USB_VENDOR_NATIONALTECH,
	    "National Technical Systems",
	},
	{
	    USB_VENDOR_ONNTO,
	    "Onnto",
	},
	{
	    USB_VENDOR_BE,
	    "Be",
	},
	{
	    USB_VENDOR_ADMTEK,
	    "ADMtek",
	},
	{
	    USB_VENDOR_COREGA,
	    "Corega",
	},
	{
	    USB_VENDOR_FREECOM,
	    "Freecom",
	},
	{
	    USB_VENDOR_MICROTECH,
	    "Microtech",
	},
	{
	    USB_VENDOR_MOTOROLA3,
	    "Motorola",
	},
	{
	    USB_VENDOR_OLYMPUS,
	    "Olympus",
	},
	{
	    USB_VENDOR_ABOCOM,
	    "AboCom Systems",
	},
	{
	    USB_VENDOR_KEISOKUGIKEN,
	    "Keisokugiken",
	},
	{
	    USB_VENDOR_ONSPEC,
	    "OnSpec",
	},
	{
	    USB_VENDOR_APG,
	    "APG Cash Drawer",
	},
	{
	    USB_VENDOR_BUG,
	    "B.U.G.",
	},
	{
	    USB_VENDOR_ALLIEDTELESYN,
	    "Allied Telesyn International",
	},
	{
	    USB_VENDOR_AVERMEDIA,
	    "AVerMedia Technologies",
	},
	{
	    USB_VENDOR_SIIG,
	    "SIIG",
	},
	{
	    USB_VENDOR_CASIO,
	    "CASIO",
	},
	{
	    USB_VENDOR_DLINK2,
	    "D-Link",
	},
	{
	    USB_VENDOR_APTIO,
	    "Aptio Products",
	},
	{
	    USB_VENDOR_ARASAN,
	    "Arasan Chip Systems",
	},
	{
	    USB_VENDOR_ALLIEDCABLE,
	    "Allied Cable",
	},
	{
	    USB_VENDOR_STSN,
	    "STSN",
	},
	{
	    USB_VENDOR_BEWAN,
	    "Bewan",
	},
	{
	    USB_VENDOR_ZOOM,
	    "Zoom Telephonics",
	},
	{
	    USB_VENDOR_BROADLOGIC,
	    "BroadLogic",
	},
	{
	    USB_VENDOR_HANDSPRING,
	    "Handspring",
	},
	{
	    USB_VENDOR_PALM,
	    "Palm Computing",
	},
	{
	    USB_VENDOR_SOURCENEXT,
	    "SOURCENEXT",
	},
	{
	    USB_VENDOR_ACTIONSTAR,
	    "Action Star Enterprise",
	},
	{
	    USB_VENDOR_ACCTON,
	    "Accton Technology",
	},
	{
	    USB_VENDOR_DIAMOND,
	    "Diamond",
	},
	{
	    USB_VENDOR_NETGEAR,
	    "BayNETGEAR",
	},
	{
	    USB_VENDOR_TOPRE,
	    "Topre Corporation",
	},
	{
	    USB_VENDOR_ACTIVEWIRE,
	    "ActiveWire",
	},
	{
	    USB_VENDOR_BBELECTR,
	    "B&B Electronics",
	},
	{
	    USB_VENDOR_PORTGEAR,
	    "PortGear",
	},
	{
	    USB_VENDOR_NETGEAR2,
	    "Netgear",
	},
	{
	    USB_VENDOR_SYSTEMTALKS,
	    "System Talks",
	},
	{
	    USB_VENDOR_METRICOM,
	    "Metricom",
	},
	{
	    USB_VENDOR_ADESSOKBTEK,
	    "ADESSO/Kbtek America",
	},
	{
	    USB_VENDOR_JATON,
	    "Jaton",
	},
	{
	    USB_VENDOR_APT,
	    "APT Technologies",
	},
	{
	    USB_VENDOR_BOCARESEARCH,
	    "Boca Research",
	},
	{
	    USB_VENDOR_ANDREA,
	    "Andrea Electronics",
	},
	{
	    USB_VENDOR_BURRBROWN,
	    "Burr-Brown Japan",
	},
	{
	    USB_VENDOR_2WIRE,
	    "2Wire",
	},
	{
	    USB_VENDOR_AIPTEK,
	    "AIPTEK International",
	},
	{
	    USB_VENDOR_SMARTBRIDGES,
	    "SmartBridges",
	},
	{
	    USB_VENDOR_BILLIONTON,
	    "Billionton Systems",
	},
	{
	    USB_VENDOR_GEMPLUS,
	    "GEMPLUS",
	},
	{
	    USB_VENDOR_EXTENDED,
	    "Extended Systems",
	},
	{
	    USB_VENDOR_MSYSTEMS,
	    "M-Systems",
	},
	{
	    USB_VENDOR_DIGIANSWER,
	    "Digianswer",
	},
	{
	    USB_VENDOR_AUTHENTEC,
	    "AuthenTec",
	},
	{
	    USB_VENDOR_SIEMENS4,
	    "Siemens",
	},
	{
	    USB_VENDOR_AUDIOTECHNICA,
	    "Audio-Technica",
	},
	{
	    USB_VENDOR_TRUMPION,
	    "Trumpion Microelectronics",
	},
	{
	    USB_VENDOR_ALATION,
	    "Alation Systems",
	},
	{
	    USB_VENDOR_GLOBESPAN,
	    "Globespan",
	},
	{
	    USB_VENDOR_CONCORDCAMERA,
	    "Concord Camera",
	},
	{
	    USB_VENDOR_GARMIN,
	    "Garmin International",
	},
	{
	    USB_VENDOR_GOHUBS,
	    "GoHubs",
	},
	{
	    USB_VENDOR_BIOMETRIC,
	    "American Biometric Company",
	},
	{
	    USB_VENDOR_TOSHIBA,
	    "Toshiba Corp",
	},
	{
	    USB_VENDOR_INTREPIDCS,
	    "Intrepid",
	},
	{
	    USB_VENDOR_YANO,
	    "Yano",
	},
	{
	    USB_VENDOR_KINGSTON,
	    "Kingston Technology",
	},
	{
	    USB_VENDOR_NVIDIA,
	    "NVIDIA",
	},
	{
	    USB_VENDOR_BLUEWATER,
	    "BlueWater Systems",
	},
	{
	    USB_VENDOR_AGILENT,
	    "Agilent Technologies",
	},
	{
	    USB_VENDOR_GUDE,
	    "Gude ADS",
	},
	{
	    USB_VENDOR_PORTSMITH,
	    "Portsmith",
	},
	{
	    USB_VENDOR_ACERW,
	    "Acer",
	},
	{
	    USB_VENDOR_ADIRONDACK,
	    "Adirondack Wire & Cable",
	},
	{
	    USB_VENDOR_BECKHOFF,
	    "Beckhoff",
	},
	{
	    USB_VENDOR_MINDSATWORK,
	    "Minds At Work",
	},
	{
	    USB_VENDOR_INTERSIL,
	    "Intersil",
	},
	{
	    USB_VENDOR_ALTIUS,
	    "Altius Solutions",
	},
	{
	    USB_VENDOR_ARRIS,
	    "Arris Interactive",
	},
	{
	    USB_VENDOR_ACTIVCARD,
	    "ACTIVCARD",
	},
	{
	    USB_VENDOR_ACTISYS,
	    "ACTiSYS",
	},
	{
	    USB_VENDOR_NOVATEL1,
	    "Novatel",
	},
	{
	    USB_VENDOR_AFOURTECH,
	    "A-FOUR TECH",
	},
	{
	    USB_VENDOR_AIMEX,
	    "AIMEX",
	},
	{
	    USB_VENDOR_ADDONICS,
	    "Addonics Technologies",
	},
	{
	    USB_VENDOR_AKAI,
	    "AKAI professional M.I.",
	},
	{
	    USB_VENDOR_ARESCOM,
	    "ARESCOM",
	},
	{
	    USB_VENDOR_BAY,
	    "Bay Associates",
	},
	{
	    USB_VENDOR_ALTERA,
	    "Altera",
	},
	{
	    USB_VENDOR_CSR,
	    "Cambridge Silicon Radio",
	},
	{
	    USB_VENDOR_TREK,
	    "Trek Technology",
	},
	{
	    USB_VENDOR_ASAHIOPTICAL,
	    "Asahi Optical",
	},
	{
	    USB_VENDOR_BOCASYSTEMS,
	    "Boca Systems",
	},
	{
	    USB_VENDOR_SHANTOU,
	    "ShanTou",
	},
	{
	    USB_VENDOR_HIROSE,
	    "Hirose",
	},
	{
	    USB_VENDOR_BROADCOM,
	    "Broadcom",
	},
	{
	    USB_VENDOR_GREENHOUSE,
	    "GREENHOUSE",
	},
	{
	    USB_VENDOR_GEOCAST,
	    "Geocast Network Systems",
	},
	{
	    USB_VENDOR_DREAMCHEEKY,
	    "Dream Cheeky",
	},
	{
	    USB_VENDOR_IDQUANTIQUE,
	    "id Quantique",
	},
	{
	    USB_VENDOR_IDTECH,
	    "ID TECH",
	},
	{
	    USB_VENDOR_ZYDAS,
	    "ZyDAS Technology",
	},
	{
	    USB_VENDOR_CHENSOURCE,
	    "Chen-Source",
	},
	{
	    USB_VENDOR_NEODIO,
	    "Neodio",
	},
	{
	    USB_VENDOR_OPTION,
	    "Option",
	},
	{
	    USB_VENDOR_ASUS,
	    "ASUS",
	},
	{
	    USB_VENDOR_TODOS,
	    "Todos Data System",
	},
	{
	    USB_VENDOR_GEARHEAD,
	    "Gear Head",
	},
	{
	    USB_VENDOR_OCT,
	    "Omnidirectional Control Technology",
	},
	{
	    USB_VENDOR_TEKRAM,
	    "Tekram Technology",
	},
	{
	    USB_VENDOR_HAL,
	    "HAL Corporation",
	},
	{
	    USB_VENDOR_NEC2,
	    "NEC",
	},
	{
	    USB_VENDOR_ATI2,
	    "ATI",
	},
	{
	    USB_VENDOR_KURUSUGAWA,
	    "Kurusugawa Electronics",
	},
	{
	    USB_VENDOR_SMART,
	    "Smart Technologies",
	},
	{
	    USB_VENDOR_ASIX,
	    "ASIX Electronics",
	},
	{
	    USB_VENDOR_O2MICRO,
	    "O2 Micro",
	},
	{
	    USB_VENDOR_SACOM,
	    "System SACOM Industry Co.,Ltd",
	},
	{
	    USB_VENDOR_USR,
	    "U.S. Robotics",
	},
	{
	    USB_VENDOR_AMBIT,
	    "Ambit Microsystems",
	},
	{
	    USB_VENDOR_HTC,
	    "HTC",
	},
	{
	    USB_VENDOR_REALTEK,
	    "Realtek",
	},
	{
	    USB_VENDOR_ERICSSON,
	    "Ericsson",
	},
	{
	    USB_VENDOR_MEI,
	    "MEI",
	},
	{
	    USB_VENDOR_ADDONICS2,
	    "Addonics Technology",
	},
	{
	    USB_VENDOR_FSC,
	    "Fujitsu Siemens Computers",
	},
	{
	    USB_VENDOR_AGATE,
	    "Agate Technologies",
	},
	{
	    USB_VENDOR_DMI,
	    "DMI",
	},
	{
	    USB_VENDOR_ICOM,
	    "Icom",
	},
	{
	    USB_VENDOR_GNOTOMETRICS,
	    "GN Otometrics",
	},
	{
	    USB_VENDOR_MICRODIA,
	    "Microdia / Sonix Technology Co., Ltd.",
	},
	{
	    USB_VENDOR_SEALEVEL,
	    "Sealevel System",
	},
	{
	    USB_VENDOR_JETI,
	    "JETI",
	},
	{
	    USB_VENDOR_EASYDISK,
	    "EasyDisk",
	},
	{
	    USB_VENDOR_ELEKTOR,
	    "Elektor Electronics",
	},
	{
	    USB_VENDOR_KYOCERA2,
	    "Kyocera",
	},
	{
	    USB_VENDOR_TERRATEC,
	    "TerraTec Electronic GmbH",
	},
	{
	    USB_VENDOR_ZCOM,
	    "Z-Com",
	},
	{
	    USB_VENDOR_ATHEROS2,
	    "Atheros Communications",
	},
	{
	    USB_VENDOR_POSIFLEX,
	    "Posiflex Technologies",
	},
	{
	    USB_VENDOR_TANGTOP,
	    "Tangtop",
	},
	{
	    USB_VENDOR_KOBIL,
	    "Kobil Systems",
	},
	{
	    USB_VENDOR_SMC3,
	    "SMC",
	},
	{
	    USB_VENDOR_PEN,
	    "Pen Drive",
	},
	{
	    USB_VENDOR_ABC,
	    "ABC",
	},
	{
	    USB_VENDOR_CONCEPTRONIC,
	    "Conceptronic",
	},
	{
	    USB_VENDOR_MSI,
	    "Micro Star International",
	},
	{
	    USB_VENDOR_ELCON,
	    "ELCON Systemtechnik",
	},
	{
	    USB_VENDOR_UNKNOWN5,
	    "Unknown Vendor",
	},
	{
	    USB_VENDOR_SITECOMEU,
	    "Sitecom Europe",
	},
	{
	    USB_VENDOR_MOBILEACTION,
	    "Mobile Action",
	},
	{
	    USB_VENDOR_AMIGO,
	    "Amigo Technology",
	},
	{
	    USB_VENDOR_VMWARE,
	    "VMware",
	},
	{
	    USB_VENDOR_SPEEDDRAGON,
	    "Speed Dragon Multimedia",
	},
	{
	    USB_VENDOR_CTC,
	    "CONWISE Technology",
	},
	{
	    USB_VENDOR_HAWKING,
	    "Hawking",
	},
	{
	    USB_VENDOR_FOSSIL,
	    "Fossil",
	},
	{
	    USB_VENDOR_GMATE,
	    "G.Mate",
	},
	{
	    USB_VENDOR_MEDIATEK,
	    "MediaTek Inc.",
	},
	{
	    USB_VENDOR_OTI,
	    "Ours Technology",
	},
	{
	    USB_VENDOR_PILOTECH,
	    "Pilotech",
	},
	{
	    USB_VENDOR_NOVATECH,
	    "Nova Tech",
	},
	{
	    USB_VENDOR_ITEGNO,
	    "iTegno",
	},
	{
	    USB_VENDOR_NORITAKE,
	    "Noritake itron Corp",
	},
	{
	    USB_VENDOR_EGALAX,
	    "eGalax",
	},
	{
	    USB_VENDOR_XIRING,
	    "XIRING",
	},
	{
	    USB_VENDOR_IOI,
	    "IOI",
	},
	{
	    USB_VENDOR_AIRPRIME,
	    "Airprime",
	},
	{
	    USB_VENDOR_VTECH,
	    "VTech",
	},
	{
	    USB_VENDOR_FALCOM,
	    "Falcom Wireless Communications",
	},
	{
	    USB_VENDOR_RIM,
	    "Research In Motion",
	},
	{
	    USB_VENDOR_DYNASTREAM,
	    "Dynastream Innovations",
	},
	{
	    USB_VENDOR_LARSENBRUSGAARD,
	    "Larsen and Brusgaard",
	},
	{
	    USB_VENDOR_OREGONSCI,
	    "Oregon Scientific",
	},
	{
	    USB_VENDOR_UNKNOWN4,
	    "Unknown Vendor",
	},
	{
	    USB_VENDOR_DVICO,
	    "DViCO",
	},
	{
	    USB_VENDOR_QUALCOMM2,
	    "Qualcomm",
	},
	{
	    USB_VENDOR_MOTOROLA4,
	    "Motorola",
	},
	{
	    USB_VENDOR_TTL,
	    "Technology Testing Lab",
	},
	{
	    USB_VENDOR_HP3,
	    "Hewlett Packard",
	},
	{
	    USB_VENDOR_THURLBY,
	    "Thurlby Thandar Instruments",
	},
	{
	    USB_VENDOR_GIGABYTE,
	    "GIGABYTE",
	},
	{
	    USB_VENDOR_YUBICO,
	    "Yubico.com",
	},
	{
	    USB_VENDOR_MOTOROLA,
	    "Motorola",
	},
	{
	    USB_VENDOR_CCYU,
	    "CCYU Technology",
	},
	{
	    USB_VENDOR_HYUNDAI,
	    "Hyundai",
	},
	{
	    USB_VENDOR_GCTSEMICON,
	    "GCT Semiconductor",
	},
	{
	    USB_VENDOR_SILABS2,
	    "Silicon Labs",
	},
	{
	    USB_VENDOR_USI,
	    "USI",
	},
	{
	    USB_VENDOR_LIEBERT2,
	    "Liebert",
	},
	{
	    USB_VENDOR_PLX,
	    "PLX",
	},
	{
	    USB_VENDOR_ASANTE,
	    "Asante",
	},
	{
	    USB_VENDOR_SILABS,
	    "Silicon Labs",
	},
	{
	    USB_VENDOR_SILABS3,
	    "Silicon Labs",
	},
	{
	    USB_VENDOR_SILABS4,
	    "Silicon Labs",
	},
	{
	    USB_VENDOR_VELLEMAN,
	    "Velleman",
	},
	{
	    USB_VENDOR_MOXA,
	    "Moxa Technologies",
	},
	{
	    USB_VENDOR_ANALOG,
	    "Analog Devices",
	},
	{
	    USB_VENDOR_TENX,
	    "Ten X Technology, Inc.",
	},
	{
	    USB_VENDOR_ISSC,
	    "Integrated System Solution Corp.",
	},
	{
	    USB_VENDOR_JRC,
	    "Japan Radio Company",
	},
	{
	    USB_VENDOR_SPHAIRON,
	    "Sphairon Access Systems",
	},
	{
	    USB_VENDOR_DELORME,
	    "DeLorme",
	},
	{
	    USB_VENDOR_SERVERWORKS,
	    "ServerWorks",
	},
	{
	    USB_VENDOR_ACERCM,
	    "Acer Communications & Multimedia",
	},
	{
	    USB_VENDOR_SIERRA,
	    "Sierra Wireless",
	},
	{
	    USB_VENDOR_SIEMENS3,
	    "Siemens",
	},
	{
	    USB_VENDOR_ALCATEL,
	    "Alcatel",
	},
	{
	    USB_VENDOR_INTERBIO,
	    "InterBiometrics",
	},
	{
	    USB_VENDOR_UNKNOWN3,
	    "Unknown vendor",
	},
	{
	    USB_VENDOR_TSUNAMI,
	    "Tsunami",
	},
	{
	    USB_VENDOR_PHEENET,
	    "Pheenet",
	},
	{
	    USB_VENDOR_RAPTORGAMING,
	    "Raptor Gaming",
	},
	{
	    USB_VENDOR_TWINMOS,
	    "TwinMOS",
	},
	{
	    USB_VENDOR_TENDA,
	    "Tenda",
	},
	{
	    USB_VENDOR_TESTO,
	    "Testo AG",
	},
	{
	    USB_VENDOR_CREATIVE2,
	    "Creative Labs",
	},
	{
	    USB_VENDOR_BELKIN2,
	    "Belkin Components",
	},
	{
	    USB_VENDOR_CYBERTAN,
	    "CyberTAN Technology",
	},
	{
	    USB_VENDOR_HUAWEI,
	    "HUAWEI Technologies",
	},
	{
	    USB_VENDOR_ARANEUS,
	    "Araneus Information Systems",
	},
	{
	    USB_VENDOR_TAPWAVE,
	    "Tapwave",
	},
	{
	    USB_VENDOR_AINCOMM,
	    "Aincomm",
	},
	{
	    USB_VENDOR_MOBILITY,
	    "Mobility",
	},
	{
	    USB_VENDOR_DICKSMITH,
	    "Dick Smith Electronics",
	},
	{
	    USB_VENDOR_NETGEAR3,
	    "Netgear",
	},
	{
	    USB_VENDOR_VALIDITY,
	    "Validity Sensors",
	},
	{
	    USB_VENDOR_BALTECH,
	    "Baltech",
	},
	{
	    USB_VENDOR_CISCOLINKSYS,
	    "Cisco-Linksys",
	},
	{
	    USB_VENDOR_SHARK,
	    "Shark",
	},
	{
	    USB_VENDOR_AZUREWAVE,
	    "AsureWave",
	},
	{
	    USB_VENDOR_NOVATEL,
	    "Novatel",
	},
	{
	    USB_VENDOR_WISTRONNEWEB,
	    "Wistron NeWeb",
	},
	{
	    USB_VENDOR_RADIOSHACK,
	    "Radio Shack",
	},
	{
	    USB_VENDOR_OPENMOKO,
	    "OpenMoko",
	},
	{
	    USB_VENDOR_HUAWEI3COM,
	    "Huawei 3Com",
	},
	{
	    USB_VENDOR_ABOCOM2,
	    "AboCom Systems",
	},
	{
	    USB_VENDOR_SILICOM,
	    "Silicom",
	},
	{
	    USB_VENDOR_RALINK,
	    "Ralink Technology",
	},
	{
	    USB_VENDOR_STARTECH,
	    "StarTech.com",
	},
	{
	    USB_VENDOR_CONCEPTRONIC2,
	    "Conceptronic",
	},
	{
	    USB_VENDOR_SUPERTOP,
	    "SuperTop",
	},
	{
	    USB_VENDOR_PLANEX3,
	    "Planex Communications",
	},
	{
	    USB_VENDOR_TWINHEAD,
	    "Twinhead",
	},
	{
	    USB_VENDOR_SILICONPORTALS,
	    "Silicon Portals",
	},
	{
	    USB_VENDOR_UBLOX,
	    "U-blox",
	},
	{
	    USB_VENDOR_OWEN,
	    "Owen",
	},
	{
	    USB_VENDOR_OQO,
	    "OQO",
	},
	{
	    USB_VENDOR_UMEDIA,
	    "U-MEDIA Communications",
	},
	{
	    USB_VENDOR_FIBERLINE,
	    "Fiberline",
	},
	{
	    USB_VENDOR_SPARKLAN,
	    "SparkLAN",
	},
	{
	    USB_VENDOR_OLIMEX,
	    "Olimex",
	},
	{
	    USB_VENDOR_AMIT2,
	    "AMIT",
	},
	{
	    USB_VENDOR_TRUST,
	    "Trust",
	},
	{
	    USB_VENDOR_SOHOWARE,
	    "SOHOware",
	},
	{
	    USB_VENDOR_UMAX,
	    "UMAX Data Systems",
	},
	{
	    USB_VENDOR_INSIDEOUT,
	    "Inside Out Networks",
	},
	{
	    USB_VENDOR_GOODWAY,
	    "Good Way Technology",
	},
	{
	    USB_VENDOR_ENTREGA,
	    "Entrega",
	},
	{
	    USB_VENDOR_ACTIONTEC,
	    "Actiontec Electronics",
	},
	{
	    USB_VENDOR_CLIPSAL,
	    "Clipsal",
	},
	{
	    USB_VENDOR_CISCOLINKSYS2,
	    "Cisco-Linksys",
	},
	{
	    USB_VENDOR_ATHEROS,
	    "Atheros Communications",
	},
	{
	    USB_VENDOR_GIGASET,
	    "Gigaset",
	},
	{
	    USB_VENDOR_GLOBALSUN,
	    "Global Sun Technology",
	},
	{
	    USB_VENDOR_VOTI,
	    "Van Ooijen Technische Informatica",
	},
	{
	    USB_VENDOR_ANYDATA,
	    "AnyDATA Inc.",
	},
	{
	    USB_VENDOR_JABLOTRON,
	    "Jablotron",
	},
	{
	    USB_VENDOR_CMOTECH,
	    "CMOTECH",
	},
	{
	    USB_VENDOR_WIENERPLEINBAUS,
	    "WIENER Plein & Baus",
	},
	{
	    USB_VENDOR_AXESSTEL,
	    "Axesstel",
	},
	{
	    USB_VENDOR_LINKSYS4,
	    "Linksys",
	},
	{
	    USB_VENDOR_SENAO,
	    "Senao",
	},
	{
	    USB_VENDOR_ASUS2,
	    "ASUS",
	},
	{
	    USB_VENDOR_STRAWBERRYLINUX,
	    "Strawberry linux Co., Ltd.",
	},
	{
	    USB_VENDOR_SWEEX2,
	    "Sweex",
	},
	{
	    USB_VENDOR_MECANIQUE,
	    "Mecanique",
	},
	{
	    USB_VENDOR_KAMSTRUP,
	    "Kamstrup A/S",
	},
	{
	    USB_VENDOR_DISPLAYLINK,
	    "DisplayLink",
	},
	{
	    USB_VENDOR_LENOVO,
	    "Lenovo",
	},
	{
	    USB_VENDOR_WAVESENSE,
	    "WaveSense",
	},
	{
	    USB_VENDOR_VAISALA,
	    "VAISALA",
	},
	{
	    USB_VENDOR_AMIT,
	    "AMIT",
	},
	{
	    USB_VENDOR_GOOGLE,
	    "Google",
	},
	{
	    USB_VENDOR_QCOM,
	    "Qcom",
	},
	{
	    USB_VENDOR_ELV,
	    "ELV",
	},
	{
	    USB_VENDOR_LINKSYS3,
	    "Linksys",
	},
	{
	    USB_VENDOR_AVAGO,
	    "Avago",
	},
	{
	    USB_VENDOR_MEINBERG,
	    "Meinberg Funkuhren",
	},
	{
	    USB_VENDOR_ZTE,
	    "ZTE Inc.",
	},
	{
	    USB_VENDOR_QUANTA,
	    "Quanta",
	},
	{
	    USB_VENDOR_TERMINUS,
	    "Terminus Technology",
	},
	{
	    USB_VENDOR_ABBOTT,
	    "Abbott Labs",
	},
	{
	    USB_VENDOR_BAYER,
	    "Bayer Health Care",
	},
	{
	    USB_VENDOR_WCH2,
	    "QinHeng Electronics",
	},
	{
	    USB_VENDOR_SEL,
	    "Schweitzer Engineering Laboratories",
	},
	{
	    USB_VENDOR_CORSAIR,
	    "Corsair",
	},
	{
	    USB_VENDOR_MATRIXORB,
	    "Matrix Orbital",
	},
	{
	    USB_VENDOR_TORADEX,
	    "Toradex inc.",
	},
	{
	    USB_VENDOR_FUSHICAI,
	    "Fushicai",
	},
	{
	    USB_VENDOR_OVISLINK,
	    "OvisLink",
	},
	{
	    USB_VENDOR_TML,
	    "The Mobility Lab",
	},
	{
	    USB_VENDOR_SILABS5,
	    "Silicon Labs",
	},
	{
	    USB_VENDOR_TCTMOBILE,
	    "TCT Mobile",
	},
	{
	    USB_VENDOR_MDS,
	    "MDS",
	},
	{
	    USB_VENDOR_ALTI2,
	    "Alti-2",
	},
	{
	    USB_VENDOR_SUNPLUS,
	    "Sunplus",
	},
	{
	    USB_VENDOR_WAGO,
	    "WAGO Kontakttechnik",
	},
	{
	    USB_VENDOR_LONGCHEER,
	    "Longcheer Technology",
	},
	{
	    USB_VENDOR_DRESDENELEC,
	    "Dresden Elektronic",
	},
	{
	    USB_VENDOR_DREAMLINK,
	    "Dream Link",
	},
	{
	    USB_VENDOR_PEGATRON,
	    "Pegatron",
	},
	{
	    USB_VENDOR_OPENMOKO2,
	    "OpenMoko",
	},
	{
	    USB_VENDOR_SELUXIT,
	    "Seluxit",
	},
	{
	    USB_VENDOR_METAGEEK,
	    "MetaGeek",
	},
	{
	    USB_VENDOR_SIMCOM,
	    "SIMCom Wireless Solutions Co., Ltd.",
	},
	{
	    USB_VENDOR_FESTO,
	    "Festo",
	},
	{
	    USB_VENDOR_MODACOM,
	    "Modacom",
	},
	{
	    USB_VENDOR_AIRTIES,
	    "AirTies",
	},
	{
	    USB_VENDOR_LAKESHORE,
	    "Lake Shore",
	},
	{
	    USB_VENDOR_VERTEX,
	    "Vertex Wireless Co., Ltd.",
	},
	{
	    USB_VENDOR_DLINK,
	    "D-Link",
	},
	{
	    USB_VENDOR_PLANEX2,
	    "Planex Communications",
	},
	{
	    USB_VENDOR_ENCORE,
	    "Encore",
	},
	{
	    USB_VENDOR_LUXSHARE,
	    "Luxshare",
	},
	{
	    USB_VENDOR_PARA,
	    "PARA Industrial",
	},
	{
	    USB_VENDOR_TRENDNET,
	    "TRENDnet",
	},
	{
	    USB_VENDOR_RTSYSTEMS,
	    "RT Systems",
	},
	{
	    USB_VENDOR_DLINK3,
	    "D-Link",
	},
	{
	    USB_VENDOR_VIALABS,
	    "VIA Labs",
	},
	{
	    USB_VENDOR_MOTOROLA2,
	    "Motorola",
	},
	{
	    USB_VENDOR_ARDUINO,
	    "Arduino SA",
	},
	{
	    USB_VENDOR_TPLINK,
	    "TP-Link",
	},
	{
	    USB_VENDOR_WMR,
	    "West Mountain Radio",
	},
	{
	    USB_VENDOR_TRIPPLITE,
	    "Tripp-Lite",
	},
	{
	    USB_VENDOR_HAILUCK,
	    "HAILUCK Co., Ltd",
	},
	{
	    USB_VENDOR_ARUBA,
	    "Aruba",
	},
	{
	    USB_VENDOR_XIAOMI,
	    "Xiaomi",
	},
	{
	    USB_VENDOR_NHJ,
	    "NHJ",
	},
	{
	    USB_VENDOR_THINGM,
	    "ThingM",
	},
	{
	    USB_VENDOR_ASUSTEK,
	    "ASUSTeK Computer",
	},
	{
	    USB_VENDOR_PIONEERDJ,
	    "Pioneer DJ",
	},
	{
	    USB_VENDOR_PLANEX,
	    "Planex Communications",
	},
	{
	    USB_VENDOR_CLUB3D,
	    "Club 3D",
	},
	{
	    USB_VENDOR_CLEVO,
	    "CLEVO",
	},
	{
	    USB_VENDOR_DYNABOOK,
	    "Dynabook",
	},
	{
	    USB_VENDOR_LINKINSTRUMENTS,
	    "Link Instruments",
	},
	{
	    USB_VENDOR_AEI,
	    "AEI",
	},
	{
	    USB_VENDOR_PQI,
	    "PQI",
	},
	{
	    USB_VENDOR_DAISY,
	    "Daisy Technology",
	},
	{
	    USB_VENDOR_NI,
	    "National Instruments",
	},
	{
	    USB_VENDOR_MICRONET,
	    "Micronet Communications",
	},
	{
	    USB_VENDOR_IODATA2,
	    "I-O Data",
	},
	{
	    USB_VENDOR_IRIVER,
	    "iRiver",
	},
	{
	    USB_VENDOR_DELL,
	    "Dell",
	},
	{
	    USB_VENDOR_PCSENSORS,
	    "PC Sensors",
	},
	{
	    USB_VENDOR_WCH,
	    "QinHeng Electronics",
	},
	{
	    USB_VENDOR_ACEECA,
	    "Aceeca",
	},
	{
	    USB_VENDOR_FEIXUN,
	    "FeiXun Communication",
	},
	{
	    USB_VENDOR_NETWEEN,
	    "NetweeN",
	},
	{
	    USB_VENDOR_PAPOUCH,
	    "Papouch s.r.o.",
	},
	{
	    USB_VENDOR_AVERATEC,
	    "Averatec",
	},
	{
	    USB_VENDOR_SWEEX,
	    "Sweex",
	},
	{
	    USB_VENDOR_PROLIFIC2,
	    "Prolific Technology",
	},
	{
	    USB_VENDOR_ONSPEC2,
	    "OnSpec",
	},
	{
	    USB_VENDOR_ACERLABS2,
	    "Acer",
	},
	{
	    USB_VENDOR_ZINWELL,
	    "Zinwell",
	},
	{
	    USB_VENDOR_SITECOM,
	    "Sitecom",
	},
	{
	    USB_VENDOR_ARKMICRO,
	    "Arkmicro",
	},
	{
	    USB_VENDOR_3COM2,
	    "3Com",
	},
	{
	    USB_VENDOR_EDIMAX,
	    "EDIMAX",
	},
	{
	    USB_VENDOR_INTEL,
	    "Intel",
	},
	{
	    USB_VENDOR_INTEL2,
	    "Intel",
	},
	{
	    USB_VENDOR_ALLWIN,
	    "ALLWIN Tech",
	},
	{
	    USB_VENDOR_SITECOM2,
	    "Sitecom",
	},
	{
	    USB_VENDOR_MOSCHIP,
	    "MosChip",
	},
	{
	    USB_VENDOR_NETGEAR4,
	    "Netgear",
	},
	{
	    USB_VENDOR_MARVELL,
	    "Marvell",
	},
	{
	    USB_VENDOR_3COM3,
	    "3Com",
	},
	{
	    USB_VENDOR_CACE,
	    "CACE Technologies",
	},
	{
	    USB_VENDOR_COMPARE,
	    "Compare",
	},
	{
	    USB_VENDOR_DATAAPEX,
	    "DataApex",
	},
	{
	    USB_VENDOR_EVOLUTION,
	    "Evolution Robotics",
	},
	{
	    USB_VENDOR_EMPIA,
	    "eMPIA Technology",
	},
	{
	    USB_VENDOR_HP2,
	    "Hewlett Packard",
	},
	{ 0, NULL }
};
