##########################################################################
# This file is part of Vacuum Magic
# Copyright (C) 2008-2009 by UPi <upi at sourceforge.net>
##########################################################################

use strict;
use POSIX qw(setlocale LC_ALL LC_CTYPE);

sub T {
  my ($text) = @_;

  if (defined($Translate{$text}) && ($Translate{$text} ne ''))  {
    return $Translate{$text};
  }
  return $text;
}

sub Ts {
  my ($text, $string) = @_;

  $text = T($text);
  $text =~ s/\%s/$string/;
  return $text;
}

sub Tss {
  my $text = $_[0];

  $text = T($text);
  $text =~ s/\%([1-9])/$_[$1]/ge;
  return $text;
}

sub InferLanguage {
  my ($locale, $language);
  
  return $Language  if $Language;  # Config file override
  $locale = setlocale(LC_CTYPE) || $ENV{'LANGUAGE'} || $ENV{'LANG'};
  ($language) = $locale =~ /^([a-zA-Z]+)/;
  print "The current locale is $locale\n";
  print "The current language is $language\n";
  if (&IsMicrosoftWindows()) {
    # Windows language strings are from MSDN
    # http://msdn.microsoft.com/en-us/library/39cwe7zf(VS.80).aspx
    $language = lc($language);
    if    ($language =~ /spanish/){ $language = 'es'; }
    elsif ($language =~ /finnish/){ $language = 'fi'; }
    elsif ($language =~ /french/) { $language = 'fr'; }
    elsif ($language =~ /hungarian/) { $language = 'hu'; }
    elsif ($language =~ /polish/) { $language = 'pl'; }
    elsif ($language =~ /portuguese/) { $language = 'pt'; }
    elsif ($language =~ /slovak/) { $language = 'sk'; }
  }
  return $language;
}

sub LoadLanguage {
  my ($language, $languageFile);
  
  $language = &InferLanguage();
  $languageFile = "$BinDir/translate_$language.pl";
  if (-e $languageFile) {
    print "Loading language file '$languageFile'\n";
    do "$languageFile";
    warn $@ || $!  if $@ || $!;
  } else {
    print "No language file $languageFile.\n";
  }
}


1;
