require 'test_helper'

class CdfTest < GSL::TestCase

  TEST_TOL = [2.0, 16.0, 256.0, 2048.0, 16384.0, 131072.0, 1048576.0]

  {
    ugaussian_P: [
      [0, 0.5, 0.0],
      [0, 0.5, 1e-32],
      [0, 0.6914624612740131036377046105, 0.5],
      [0, 0.7580363477769269852506495717, 0.7],
    ],
    ugaussian_Q: [
      [0, 0.5, 0.0],
      [0, 0.5, 1e-32],
      [0, 0.3085375387259868963622953894, 0.5],
      [0, 0.2419636522230730147493504282, 0.7],
      [0, 0.0000002866515718791939116737523329, 5.0],
    ],
    ugaussian_Pinv: [
      [1e-4, 5.0, 0.9999997133],
      [1e-4, 0.1, 0.539827837277029],
    ],
    ugaussian_Qinv: [
      [1e-4, 5.0, 2.86648e-7],
      [1e-14, 2.0, 2.2750131948179e-2],
      [1, 0.1, 4.60172162722971e-1],
    ],
    exponential_P: [
      [0, 1.33122100249818372e-1, 0.1, 0.7],
    ],
    exponential_Q: [
      [0, 8.66877899750181628e-1, 0.1, 0.7],
    ],
    exponential_Pinv: [
      [0, 9.74834471334553546e-2, 0.13, 0.7],
    ],
    exponential_Qinv: [
      [0, 1.05576022814208545e-1, 0.86, 0.7],
    ],
    beta_P: [
      [6, 0.0, 0.0, 1.3, 2.7],
      [6, 3.329258013904e-13, 1.0e-10, 1.3, 2.7],
      [6, 6.642743046207e-12, 1.0e-09, 1.3, 2.7],
      [6, 1.32540147535e-10, 1.0e-08, 1.3, 2.7],
      [6, 2.644523387276e-09, 1.0e-07, 1.3, 2.7],
      [6, 5.276513292646e-08, 1.0e-06, 1.3, 2.7],
      [6, 1.052793708285e-06, 1.0e-05, 1.3, 2.7],
      [6, 2.100417958505e-05, 0.0001, 1.3, 2.7],
      [6, 0.00041872612184, 0.001, 1.3, 2.7],
      [6, 0.008282559388393, 0.01, 1.3, 2.7],
      [6, 0.151219457801, 0.1, 1.3, 2.7],
      [6, 0.3358123280407, 0.2, 1.3, 2.7],
      [6, 0.5104163996495, 0.3, 1.3, 2.7],
      [6, 0.662068239941, 0.4, 1.3, 2.7],
      [6, 0.7852786981833, 0.5, 1.3, 2.7],
      [6, 0.878400587895, 0.6, 1.3, 2.7],
      [6, 0.9801824171406, 0.8, 1.3, 2.7],
      [6, 0.9968736852365, 0.9, 1.3, 2.7],
      [6, 0.9999936324464, 0.99, 1.3, 2.7],
      [6, 0.9999999872699, 0.999, 1.3, 2.7],
      [6, 0.9999999999746, 0.9999, 1.3, 2.7],
      [6, 0.9999999999999, 0.99999, 1.3, 2.7],
      [6, 1.0, 1.0, 1.3, 2.7],
    ],
    beta_Q: [
      [6, 0.0, 1.0, 1.3, 2.7],
      [6, 5.069044353228e-14, 0.99999, 1.3, 2.7],
      [6, 2.540490259443e-11, 0.9999, 1.3, 2.7],
      [6, 1.273010336738e-08, 0.999, 1.3, 2.7],
      [6, 6.367553598351e-06, 0.99, 1.3, 2.7],
      [6, 0.003126314763488, 0.9, 1.3, 2.7],
      [6, 0.01981758285937, 0.8, 1.3, 2.7],
      [6, 0.121599412105, 0.6, 1.3, 2.7],
      [6, 0.2147213018167, 0.5, 1.3, 2.7],
      [6, 0.337931760059, 0.4, 1.3, 2.7],
      [6, 0.4895836003505, 0.3, 1.3, 2.7],
      [6, 0.6641876719593, 0.2, 1.3, 2.7],
      [6, 0.848780542199, 0.1, 1.3, 2.7],
      [6, 0.9917174406116, 0.01, 1.3, 2.7],
      [6, 0.9995812738782, 0.001, 1.3, 2.7],
      [6, 0.9999789958204, 0.0001, 1.3, 2.7],
      [6, 0.9999989472063, 1.0e-05, 1.3, 2.7],
      [6, 0.9999999472349, 1.0e-06, 1.3, 2.7],
      [6, 0.9999999973555, 1.0e-07, 1.3, 2.7],
      [6, 0.9999999998675, 1.0e-08, 1.3, 2.7],
      [6, 0.9999999999934, 1.0e-09, 1.3, 2.7],
      [6, 0.9999999999997, 1.0e-10, 1.3, 2.7],
      [6, 1.0, 0.0, 1.3, 2.7],
    ],
    fdist_P: [
      [6, 3.14130045246195449e-1, 0.325, 1.2, 1.3],
      [6, 0.0, 0.0, 5.3, 2.7],
      [6, 3.23138066309e-26, 1.0e-10, 5.3, 2.7],
      [6, 1.443404714791e-23, 1.0e-09, 5.3, 2.7],
      [6, 6.447451698511e-21, 1.0e-08, 5.3, 2.7],
      [6, 2.879969407315e-18, 1.0e-07, 5.3, 2.7],
      [6, 1.286428479993e-15, 1.0e-06, 5.3, 2.7],
      [6, 5.745970138195e-13, 1.0e-05, 5.3, 2.7],
      [6, 2.565314230632e-10, 0.0001, 5.3, 2.7],
      [6, 1.14002620376e-07, 0.001, 5.3, 2.7],
      [6, 4.840333162527e-05, 0.01, 5.3, 2.7],
      [6, 0.01360698992545, 0.1, 5.3, 2.7],
      [6, 0.4532720490874, 1.0, 5.3, 2.7],
      [6, 0.9461328174717, 10.0, 5.3, 2.7],
      [6, 0.9973356976994, 100.0, 5.3, 2.7],
      [6, 0.999879733805, 1000.0, 5.3, 2.7],
      [6, 0.9999946222456, 10000.0, 5.3, 2.7],
      [6, 0.9999997597592, 100000.0, 5.3, 2.7],
      [6, 0.9999999892687, 1000000.0, 5.3, 2.7],
      [6, 0.9999999995207, 10000000.0, 5.3, 2.7],
      [6, 0.9999999999786, 100000000.0, 5.3, 2.7],
      [6, 0.999999999999, 1000000000.0, 5.3, 2.7],
      [6, 1.0, 10000000000.0, 5.3, 2.7],
    ],
    fdist_Q: [
      [6, 6.85869954753804551e-1, 0.325, 1.2, 1.3],
      [6, 4.272202262298e-14, 10000000000.0, 5.3, 2.7],
      [6, 9.56426950277e-13, 1000000000.0, 5.3, 2.7],
      [6, 2.141173208523e-11, 100000000.0, 5.3, 2.7],
      [6, 4.793489218238e-10, 10000000.0, 5.3, 2.7],
      [6, 1.07312743344e-08, 1000000.0, 5.3, 2.7],
      [6, 2.402407758939e-07, 100000.0, 5.3, 2.7],
      [6, 5.377754447932e-06, 10000.0, 5.3, 2.7],
      [6, 0.0001202661950234, 1000.0, 5.3, 2.7],
      [6, 0.002664302300604, 100.0, 5.3, 2.7],
      [6, 0.05386718252832, 10.0, 5.3, 2.7],
      [6, 0.5467279509126, 1.0, 5.3, 2.7],
      [6, 0.9863930100746, 0.1, 5.3, 2.7],
      [6, 0.9999515966684, 0.01, 5.3, 2.7],
      [6, 0.9999998859974, 0.001, 5.3, 2.7],
      [6, 0.9999999997435, 0.0001, 5.3, 2.7],
      [6, 0.9999999999994, 1.0e-05, 5.3, 2.7],
      [6, 1.0, 1.0e-06, 5.3, 2.7],
      [6, 1.0, 1.0e-07, 5.3, 2.7],
      [6, 1.0, 1.0e-08, 5.3, 2.7],
      [6, 1.0, 1.0e-09, 5.3, 2.7],
      [6, 1.0, 1.0e-10, 5.3, 2.7],
      [6, 1.0, 0.0, 5.3, 2.7],
    ],
    cauchy_P: [
      [6, 4.138028520389e-11, -10000000000.0, 1.3],
      [6, 4.138028520389e-10, -1000000000.0, 1.3],
      [6, 4.138028520389e-09, -100000000.0, 1.3],
      [6, 4.138028520389e-08, -10000000.0, 1.3],
      [6, 4.138028520387e-07, -1000000.0, 1.3],
      [6, 4.138028520156e-06, -100000.0, 1.3],
      [6, 4.138028497078e-05, -10000.0, 1.3],
      [6, 0.0004138026189302, -1000.0, 1.3],
      [6, 0.004137795435084, -100.0, 1.3],
      [6, 0.04114951182497, -10.0, 1.3],
      [6, 0.2912855998398, -1.0, 1.3],
      [6, 0.4755627480278, -0.1, 1.3],
      [6, 0.4975515107069, -0.01, 1.3],
      [6, 0.4997551462897, -0.001, 1.3],
      [6, 0.4999755146242, -0.0001, 1.3],
      [6, 0.4999975514624, -1.0e-05, 1.3],
      [6, 0.4999997551462, -1.0e-06, 1.3],
      [6, 0.4999999755146, -1.0e-07, 1.3],
      [6, 0.4999999975515, -1.0e-08, 1.3],
      [6, 0.4999999997551, -1.0e-09, 1.3],
      [6, 0.4999999999755, -1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000245, 1.0e-10, 1.3],
      [6, 0.5000000002449, 1.0e-09, 1.3],
      [6, 0.5000000024485, 1.0e-08, 1.3],
      [6, 0.5000000244854, 1.0e-07, 1.3],
      [6, 0.5000002448538, 1.0e-06, 1.3],
      [6, 0.5000024485376, 1.0e-05, 1.3],
      [6, 0.5000244853758, 0.0001, 1.3],
      [6, 0.5002448537103, 0.001, 1.3],
      [6, 0.5024484892931, 0.01, 1.3],
      [6, 0.5244372519722, 0.1, 1.3],
      [6, 0.7087144001602, 1.0, 1.3],
      [6, 0.958850488175, 10.0, 1.3],
      [6, 0.9958622045649, 100.0, 1.3],
      [6, 0.9995861973811, 1000.0, 1.3],
      [6, 0.999958619715, 10000.0, 1.3],
      [6, 0.9999958619715, 100000.0, 1.3],
      [6, 0.9999995861971, 1000000.0, 1.3],
      [6, 0.9999999586197, 10000000.0, 1.3],
      [6, 0.999999995862, 100000000.0, 1.3],
      [6, 0.9999999995862, 1000000000.0, 1.3],
      [6, 0.9999999999586, 10000000000.0, 1.3],
    ],
    cauchy_Pinv: [
      [6, -10000000000.0, 4.138028520389278e-11, 1.3],
      [6, -1000000000.0, 4.138028520389279e-10, 1.3],
      [6, -100000000.0, 4.138028520389279e-09, 1.3],
      [6, -10000000.0, 4.1380285203892555e-08, 1.3],
      [6, -1000000.0, 4.138028520386949e-07, 1.3],
      [6, -100000.0, 4.138028520156169e-06, 1.3],
      [6, -10000.0, 4.1380284970783855e-05, 1.3],
      [6, -1000.0, 0.00041380261893022424, 1.3],
      [6, -100.0, 0.004137795435083691, 1.3],
      [6, -10.0, 0.041149511824973506, 1.3],
      [6, -1.0, 0.29128559983984725, 1.3],
      [6, -0.1, 0.4755627480278025, 1.3],
      [6, -0.01, 0.49755151070688325, 1.3],
      [6, -0.001, 0.4997551462896916, 1.3],
      [6, 0.0, 0.5000000000000001, 1.3],
      [6, 0.001, 0.5002448537103084, 1.3],
      [6, 0.01, 0.5024484892931167, 1.3],
      [6, 0.1, 0.5244372519721975, 1.3],
      [6, 1.0, 0.7087144001601527, 1.3],
      [6, 10.0, 0.9588504881750265, 1.3],
      [6, 100.0, 0.9958622045649164, 1.3],
      [6, 1000.0, 0.9995861973810698, 1.3],
    ],
    cauchy_Q: [
      [6, 4.138028520389e-11, 10000000000.0, 1.3],
      [6, 4.138028520389e-10, 1000000000.0, 1.3],
      [6, 4.138028520389e-09, 100000000.0, 1.3],
      [6, 4.138028520389e-08, 10000000.0, 1.3],
      [6, 4.138028520387e-07, 1000000.0, 1.3],
      [6, 4.138028520156e-06, 100000.0, 1.3],
      [6, 4.138028497078e-05, 10000.0, 1.3],
      [6, 0.0004138026189302, 1000.0, 1.3],
      [6, 0.004137795435084, 100.0, 1.3],
      [6, 0.04114951182497, 10.0, 1.3],
      [6, 0.2912855998398, 1.0, 1.3],
      [6, 0.4755627480278, 0.1, 1.3],
      [6, 0.4975515107069, 0.01, 1.3],
      [6, 0.4997551462897, 0.001, 1.3],
      [6, 0.4999755146242, 0.0001, 1.3],
      [6, 0.4999975514624, 1.0e-05, 1.3],
      [6, 0.4999997551462, 1.0e-06, 1.3],
      [6, 0.4999999755146, 1.0e-07, 1.3],
      [6, 0.4999999975515, 1.0e-08, 1.3],
      [6, 0.4999999997551, 1.0e-09, 1.3],
      [6, 0.4999999999755, 1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000245, -1.0e-10, 1.3],
      [6, 0.5000000002449, -1.0e-09, 1.3],
      [6, 0.5000000024485, -1.0e-08, 1.3],
      [6, 0.5000000244854, -1.0e-07, 1.3],
      [6, 0.5000002448538, -1.0e-06, 1.3],
      [6, 0.5000024485376, -1.0e-05, 1.3],
      [6, 0.5000244853758, -0.0001, 1.3],
      [6, 0.5002448537103, -0.001, 1.3],
      [6, 0.5024484892931, -0.01, 1.3],
      [6, 0.5244372519722, -0.1, 1.3],
      [6, 0.7087144001602, -1.0, 1.3],
      [6, 0.958850488175, -10.0, 1.3],
      [6, 0.9958622045649, -100.0, 1.3],
      [6, 0.9995861973811, -1000.0, 1.3],
      [6, 0.999958619715, -10000.0, 1.3],
      [6, 0.9999958619715, -100000.0, 1.3],
      [6, 0.9999995861971, -1000000.0, 1.3],
      [6, 0.9999999586197, -10000000.0, 1.3],
      [6, 0.999999995862, -100000000.0, 1.3],
      [6, 0.9999999995862, -1000000000.0, 1.3],
      [6, 0.9999999999586, -10000000000.0, 1.3],
    ],
    cauchy_Qinv: [
      [6, 10000000000.0, 4.138028520389278e-11, 1.3],
      [6, 1000000000.0, 4.138028520389279e-10, 1.3],
      [6, 100000000.0, 4.138028520389279e-09, 1.3],
      [6, 10000000.0, 4.1380285203892555e-08, 1.3],
      [6, 1000000.0, 4.138028520386949e-07, 1.3],
      [6, 100000.0, 4.138028520156169e-06, 1.3],
      [6, 10000.0, 4.1380284970783855e-05, 1.3],
      [6, 1000.0, 0.00041380261893022424, 1.3],
      [6, 100.0, 0.004137795435083691, 1.3],
      [6, 10.0, 0.041149511824973506, 1.3],
      [6, 1.0, 0.29128559983984725, 1.3],
      [6, 0.1, 0.4755627480278025, 1.3],
      [6, 0.01, 0.49755151070688325, 1.3],
      [6, 0.001, 0.4997551462896916, 1.3],
      [6, 0.0, 0.5000000000000001, 1.3],
      [6, -0.001, 0.5002448537103084, 1.3],
      [6, -0.01, 0.5024484892931167, 1.3],
      [6, -0.1, 0.5244372519721975, 1.3],
      [6, -1.0, 0.7087144001601527, 1.3],
      [6, -10.0, 0.9588504881750265, 1.3],
      [6, -100.0, 0.9958622045649164, 1.3],
      [6, -1000.0, 0.9995861973810698, 1.3],
    ],
    gaussian_P: [
      [6, 0.0, -10000000000.0, 1.3],
      [6, 0.0, -1000000000.0, 1.3],
      [6, 0.0, -100000000.0, 1.3],
      [6, 0.0, -10000000.0, 1.3],
      [6, 0.0, -1000000.0, 1.3],
      [6, 0.0, -100000.0, 1.3],
      [6, 0.0, -10000.0, 1.3],
      [6, 0.0, -1000.0, 1.3],
      [6, 0.0, -100.0, 1.3],
      [6, 7.225229227927e-15, -10.0, 1.3],
      [6, 0.2208781637125, -1.0, 1.3],
      [6, 0.4693423696034, -0.1, 1.3],
      [6, 0.4969312434916, -0.01, 1.3],
      [6, 0.499693121353, -0.001, 1.3],
      [6, 0.4999693121323, -0.0001, 1.3],
      [6, 0.4999969312132, -1.0e-05, 1.3],
      [6, 0.4999996931213, -1.0e-06, 1.3],
      [6, 0.4999999693121, -1.0e-07, 1.3],
      [6, 0.4999999969312, -1.0e-08, 1.3],
      [6, 0.4999999996931, -1.0e-09, 1.3],
      [6, 0.4999999999693, -1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000307, 1.0e-10, 1.3],
      [6, 0.5000000003069, 1.0e-09, 1.3],
      [6, 0.5000000030688, 1.0e-08, 1.3],
      [6, 0.5000000306879, 1.0e-07, 1.3],
      [6, 0.5000003068787, 1.0e-06, 1.3],
      [6, 0.5000030687868, 1.0e-05, 1.3],
      [6, 0.5000306878677, 0.0001, 1.3],
      [6, 0.500306878647, 0.001, 1.3],
      [6, 0.5030687565084, 0.01, 1.3],
      [6, 0.5306576303966, 0.1, 1.3],
      [6, 0.7791218362875, 1.0, 1.3],
      [6, 1.0, 10.0, 1.3],
      [6, 1.0, 100.0, 1.3],
      [6, 1.0, 1000.0, 1.3],
      [6, 1.0, 10000.0, 1.3],
      [6, 1.0, 100000.0, 1.3],
      [6, 1.0, 1000000.0, 1.3],
      [6, 1.0, 10000000.0, 1.3],
      [6, 1.0, 100000000.0, 1.3],
      [6, 1.0, 1000000000.0, 1.3],
      [6, 1.0, 10000000000.0, 1.3],
    ],
    gaussian_Pinv: [
      [6, -10.0, 7.225229227926508e-15, 1.3],
      [6, -1.0, 0.22087816371245972, 1.3],
      [6, -0.1, 0.4693423696033875, 1.3],
      [6, -0.01, 0.49693124349158196, 1.3],
      [6, -0.001, 0.4996931213530323, 1.3],
      [6, 0.0, 0.5, 1.3],
      [6, 0.001, 0.5003068786469678, 1.3],
      [6, 0.01, 0.503068756508418, 1.3],
      [6, 0.1, 0.5306576303966125, 1.3],
      [6, 1.0, 0.7791218362875403, 1.3],
    ],
    gaussian_Q: [
      [6, 0.0, 10000000000.0, 1.3],
      [6, 0.0, 1000000000.0, 1.3],
      [6, 0.0, 100000000.0, 1.3],
      [6, 0.0, 10000000.0, 1.3],
      [6, 0.0, 1000000.0, 1.3],
      [6, 0.0, 100000.0, 1.3],
      [6, 0.0, 10000.0, 1.3],
      [6, 0.0, 1000.0, 1.3],
      [6, 0.0, 100.0, 1.3],
      [6, 7.225229227927e-15, 10.0, 1.3],
      [6, 0.2208781637125, 1.0, 1.3],
      [6, 0.4693423696034, 0.1, 1.3],
      [6, 0.4969312434916, 0.01, 1.3],
      [6, 0.499693121353, 0.001, 1.3],
      [6, 0.4999693121323, 0.0001, 1.3],
      [6, 0.4999969312132, 1.0e-05, 1.3],
      [6, 0.4999996931213, 1.0e-06, 1.3],
      [6, 0.4999999693121, 1.0e-07, 1.3],
      [6, 0.4999999969312, 1.0e-08, 1.3],
      [6, 0.4999999996931, 1.0e-09, 1.3],
      [6, 0.4999999999693, 1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000307, -1.0e-10, 1.3],
      [6, 0.5000000003069, -1.0e-09, 1.3],
      [6, 0.5000000030688, -1.0e-08, 1.3],
      [6, 0.5000000306879, -1.0e-07, 1.3],
      [6, 0.5000003068787, -1.0e-06, 1.3],
      [6, 0.5000030687868, -1.0e-05, 1.3],
      [6, 0.5000306878677, -0.0001, 1.3],
      [6, 0.500306878647, -0.001, 1.3],
      [6, 0.5030687565084, -0.01, 1.3],
      [6, 0.5306576303966, -0.1, 1.3],
      [6, 0.7791218362875, -1.0, 1.3],
      [6, 1.0, -10.0, 1.3],
      [6, 1.0, -100.0, 1.3],
      [6, 1.0, -1000.0, 1.3],
      [6, 1.0, -10000.0, 1.3],
      [6, 1.0, -100000.0, 1.3],
      [6, 1.0, -1000000.0, 1.3],
      [6, 1.0, -10000000.0, 1.3],
      [6, 1.0, -100000000.0, 1.3],
      [6, 1.0, -1000000000.0, 1.3],
      [6, 1.0, -10000000000.0, 1.3],
    ],
    gaussian_Qinv: [
      [6, 10.0, 7.225229227926508e-15, 1.3],
      [6, 1.0, 0.22087816371245972, 1.3],
      [6, 0.1, 0.4693423696033875, 1.3],
      [6, 0.01, 0.49693124349158196, 1.3],
      [6, 0.001, 0.4996931213530323, 1.3],
      [6, 0.0, 0.5, 1.3],
      [6, -0.001, 0.5003068786469678, 1.3],
      [6, -0.01, 0.503068756508418, 1.3],
      [6, -0.1, 0.5306576303966125, 1.3],
      [6, -1.0, 0.7791218362875403, 1.3],
    ],
    laplace_P: [
      [6, 0.0, -10000000000.0, 1.3],
      [6, 0.0, -1000000000.0, 1.3],
      [6, 0.0, -100000000.0, 1.3],
      [6, 0.0, -10000000.0, 1.3],
      [6, 0.0, -1000000.0, 1.3],
      [6, 0.0, -100000.0, 1.3],
      [6, 0.0, -10000.0, 1.3],
      [6, 0.0, -1000.0, 1.3],
      [6, 1.957501779912e-34, -100.0, 1.3],
      [6, 0.0002281619502905, -10.0, 1.3],
      [6, 0.2316846846156, -1.0, 1.3],
      [6, 0.4629805393212, -0.1, 1.3],
      [6, 0.4961686011956, -0.01, 1.3],
      [6, 0.4996155325065, -0.001, 1.3],
      [6, 0.4999615399408, -0.0001, 1.3],
      [6, 0.4999961538609, -1.0e-05, 1.3],
      [6, 0.4999996153848, -1.0e-06, 1.3],
      [6, 0.4999999615385, -1.0e-07, 1.3],
      [6, 0.4999999961538, -1.0e-08, 1.3],
      [6, 0.4999999996154, -1.0e-09, 1.3],
      [6, 0.4999999999615, -1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000385, 1.0e-10, 1.3],
      [6, 0.5000000003846, 1.0e-09, 1.3],
      [6, 0.5000000038462, 1.0e-08, 1.3],
      [6, 0.5000000384615, 1.0e-07, 1.3],
      [6, 0.5000003846152, 1.0e-06, 1.3],
      [6, 0.5000038461391, 1.0e-05, 1.3],
      [6, 0.5000384600592, 0.0001, 1.3],
      [6, 0.5003844674935, 0.001, 1.3],
      [6, 0.5038313988044, 0.01, 1.3],
      [6, 0.5370194606788, 0.1, 1.3],
      [6, 0.7683153153844, 1.0, 1.3],
      [6, 0.9997718380497, 10.0, 1.3],
      [6, 1.0, 100.0, 1.3],
      [6, 1.0, 1000.0, 1.3],
      [6, 1.0, 10000.0, 1.3],
      [6, 1.0, 100000.0, 1.3],
      [6, 1.0, 1000000.0, 1.3],
      [6, 1.0, 10000000.0, 1.3],
      [6, 1.0, 100000000.0, 1.3],
      [6, 1.0, 1000000000.0, 1.3],
      [6, 1.0, 10000000000.0, 1.3],
    ],
    laplace_Pinv: [
      [6, -100.0, 1.957501779912233e-34, 1.3],
      [6, -10.0, 0.0002281619502905156, 1.3],
      [6, -1.0, 0.23168468461558764, 1.3],
      [6, -0.1, 0.462980539321158, 1.3],
      [6, -0.01, 0.4961686011955743, 1.3],
      [6, -0.001, 0.49961553250645546, 1.3],
      [6, 0.0, 0.5, 1.3],
      [6, 0.001, 0.5003844674935445, 1.3],
      [6, 0.01, 0.5038313988044256, 1.3],
      [6, 0.1, 0.537019460678842, 1.3],
      [6, 1.0, 0.7683153153844123, 1.3],
      [6, 10.0, 0.9997718380497095, 1.3],
    ],
    laplace_Q: [
      [6, 0.0, 10000000000.0, 1.3],
      [6, 0.0, 1000000000.0, 1.3],
      [6, 0.0, 100000000.0, 1.3],
      [6, 0.0, 10000000.0, 1.3],
      [6, 0.0, 1000000.0, 1.3],
      [6, 0.0, 100000.0, 1.3],
      [6, 0.0, 10000.0, 1.3],
      [6, 0.0, 1000.0, 1.3],
      [6, 1.957501779912e-34, 100.0, 1.3],
      [6, 0.0002281619502905, 10.0, 1.3],
      [6, 0.2316846846156, 1.0, 1.3],
      [6, 0.4629805393212, 0.1, 1.3],
      [6, 0.4961686011956, 0.01, 1.3],
      [6, 0.4996155325065, 0.001, 1.3],
      [6, 0.4999615399408, 0.0001, 1.3],
      [6, 0.4999961538609, 1.0e-05, 1.3],
      [6, 0.4999996153848, 1.0e-06, 1.3],
      [6, 0.4999999615385, 1.0e-07, 1.3],
      [6, 0.4999999961538, 1.0e-08, 1.3],
      [6, 0.4999999996154, 1.0e-09, 1.3],
      [6, 0.4999999999615, 1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000385, -1.0e-10, 1.3],
      [6, 0.5000000003846, -1.0e-09, 1.3],
      [6, 0.5000000038462, -1.0e-08, 1.3],
      [6, 0.5000000384615, -1.0e-07, 1.3],
      [6, 0.5000003846152, -1.0e-06, 1.3],
      [6, 0.5000038461391, -1.0e-05, 1.3],
      [6, 0.5000384600592, -0.0001, 1.3],
      [6, 0.5003844674935, -0.001, 1.3],
      [6, 0.5038313988044, -0.01, 1.3],
      [6, 0.5370194606788, -0.1, 1.3],
      [6, 0.7683153153844, -1.0, 1.3],
      [6, 0.9997718380497, -10.0, 1.3],
      [6, 1.0, -100.0, 1.3],
      [6, 1.0, -1000.0, 1.3],
      [6, 1.0, -10000.0, 1.3],
      [6, 1.0, -100000.0, 1.3],
      [6, 1.0, -1000000.0, 1.3],
      [6, 1.0, -10000000.0, 1.3],
      [6, 1.0, -100000000.0, 1.3],
      [6, 1.0, -1000000000.0, 1.3],
      [6, 1.0, -10000000000.0, 1.3],
    ],
    laplace_Qinv: [
      [6, 100.0, 1.957501779912233e-34, 1.3],
      [6, 10.0, 0.0002281619502905156, 1.3],
      [6, 1.0, 0.23168468461558764, 1.3],
      [6, 0.1, 0.462980539321158, 1.3],
      [6, 0.01, 0.4961686011955743, 1.3],
      [6, 0.001, 0.49961553250645546, 1.3],
      [6, 0.0, 0.5, 1.3],
      [6, -0.001, 0.5003844674935445, 1.3],
      [6, -0.01, 0.5038313988044256, 1.3],
      [6, -0.1, 0.537019460678842, 1.3],
      [6, -1.0, 0.7683153153844123, 1.3],
      [6, -10.0, 0.9997718380497095, 1.3],
    ],
    rayleigh_P: [
      [6, 0.0, 0.0, 1.3],
      [6, 2.958579881657e-21, 1.0e-10, 1.3],
      [6, 2.958579881657e-19, 1.0e-09, 1.3],
      [6, 2.958579881657e-17, 1.0e-08, 1.3],
      [6, 2.958579881657e-15, 1.0e-07, 1.3],
      [6, 2.958579881656e-13, 1.0e-06, 1.3],
      [6, 2.958579881613e-11, 1.0e-05, 1.3],
      [6, 2.95857987728e-09, 0.0001, 1.3],
      [6, 2.958579443997e-07, 0.001, 1.3],
      [6, 2.958536116114e-05, 0.01, 1.3],
      [6, 0.002954207597179, 0.1, 1.3],
      [6, 0.2561069378624, 1.0, 1.3],
      [6, 0.9999999999999, 10.0, 1.3],
      [6, 1.0, 100.0, 1.3],
      [6, 1.0, 1000.0, 1.3],
      [6, 1.0, 10000.0, 1.3],
      [6, 1.0, 100000.0, 1.3],
      [6, 1.0, 1000000.0, 1.3],
      [6, 1.0, 10000000.0, 1.3],
      [6, 1.0, 100000000.0, 1.3],
      [6, 1.0, 1000000000.0, 1.3],
      [6, 1.0, 10000000000.0, 1.3],
    ],
    rayleigh_Pinv: [
      [6, 1.0e-10, 2.958579881656805e-21, 1.3],
      [6, 1.0e-09, 2.958579881656805e-19, 1.3],
      [6, 1.0e-08, 2.958579881656805e-17, 1.3],
      [6, 1.0e-07, 2.9585798816568e-15, 1.3],
      [6, 1.0e-06, 2.9585798816563665e-13, 1.3],
      [6, 1.0e-05, 2.958579881613039e-11, 1.3],
      [6, 0.0001, 2.9585798772802076e-09, 1.3],
      [6, 0.001, 2.9585794439971025e-07, 1.3],
      [6, 0.01, 2.9585361161138382e-05, 1.3],
      [6, 0.1, 0.0029542075971792496, 1.3],
      [6, 1.0, 0.2561069378623536, 1.3],
    ],
    rayleigh_Q: [
      [6, 0.0, 10000000000.0, 1.3],
      [6, 0.0, 1000000000.0, 1.3],
      [6, 0.0, 100000000.0, 1.3],
      [6, 0.0, 10000000.0, 1.3],
      [6, 0.0, 1000000.0, 1.3],
      [6, 0.0, 100000.0, 1.3],
      [6, 0.0, 10000.0, 1.3],
      [6, 0.0, 1000.0, 1.3],
      [6, 0.0, 100.0, 1.3],
      [6, 1.415959498849e-13, 10.0, 1.3],
      [6, 0.7438930621376, 1.0, 1.3],
      [6, 0.9970457924028, 0.1, 1.3],
      [6, 0.9999704146388, 0.01, 1.3],
      [6, 0.9999997041421, 0.001, 1.3],
      [6, 0.9999999970414, 0.0001, 1.3],
      [6, 0.9999999999704, 1.0e-05, 1.3],
      [6, 0.9999999999997, 1.0e-06, 1.3],
      [6, 1.0, 1.0e-07, 1.3],
      [6, 1.0, 1.0e-08, 1.3],
      [6, 1.0, 1.0e-09, 1.3],
      [6, 1.0, 1.0e-10, 1.3],
      [6, 1.0, 0.0, 1.3],
    ],
    rayleigh_Qinv: [
      [6, 10.0, 1.4159594988487832e-13, 1.3],
      [6, 1.0, 0.7438930621376464, 1.3],
      [6, 0.1, 0.9970457924028208, 1.3],
    ],
    flat_P: [
      [6, 0.0, 0.0, 1.3, 750.0],
      [6, 0.0, 1.0e-10, 1.3, 750.0],
      [6, 0.0, 1.0e-09, 1.3, 750.0],
      [6, 0.0, 1.0e-08, 1.3, 750.0],
      [6, 0.0, 1.0e-07, 1.3, 750.0],
      [6, 0.0, 1.0e-06, 1.3, 750.0],
      [6, 0.0, 1.0e-05, 1.3, 750.0],
      [6, 0.0, 0.0001, 1.3, 750.0],
      [6, 0.0, 0.001, 1.3, 750.0],
      [6, 0.0, 0.01, 1.3, 750.0],
      [6, 0.0, 0.1, 1.3, 750.0],
      [6, 0.0, 1.0, 1.3, 750.0],
      [6, 0.01162014157874, 10.0, 1.3, 750.0],
      [6, 0.1318285027381, 100.0, 1.3, 750.0],
      [6, 1.0, 1000.0, 1.3, 750.0],
      [6, 1.0, 10000.0, 1.3, 750.0],
      [6, 1.0, 100000.0, 1.3, 750.0],
      [6, 1.0, 1000000.0, 1.3, 750.0],
      [6, 1.0, 10000000.0, 1.3, 750.0],
      [6, 1.0, 100000000.0, 1.3, 750.0],
      [6, 1.0, 1000000000.0, 1.3, 750.0],
      [6, 1.0, 10000000000.0, 1.3, 750.0],
    ],
    flat_Pinv: [
      [6, 10.0, 0.011620141578738545, 1.3, 750.0],
      [6, 100.0, 0.13182850273808142, 1.3, 750.0],
    ],
    flat_Q: [
      [6, 0.0, 10000000000.0, 1.3, 750.0],
      [6, 0.0, 1000000000.0, 1.3, 750.0],
      [6, 0.0, 100000000.0, 1.3, 750.0],
      [6, 0.0, 10000000.0, 1.3, 750.0],
      [6, 0.0, 1000000.0, 1.3, 750.0],
      [6, 0.0, 100000.0, 1.3, 750.0],
      [6, 0.0, 10000.0, 1.3, 750.0],
      [6, 0.0, 1000.0, 1.3, 750.0],
      [6, 0.8681714972619, 100.0, 1.3, 750.0],
      [6, 0.9883798584213, 10.0, 1.3, 750.0],
      [6, 1.0, 1.0, 1.3, 750.0],
      [6, 1.0, 0.1, 1.3, 750.0],
      [6, 1.0, 0.01, 1.3, 750.0],
      [6, 1.0, 0.001, 1.3, 750.0],
      [6, 1.0, 0.0001, 1.3, 750.0],
      [6, 1.0, 1.0e-05, 1.3, 750.0],
      [6, 1.0, 1.0e-06, 1.3, 750.0],
      [6, 1.0, 1.0e-07, 1.3, 750.0],
      [6, 1.0, 1.0e-08, 1.3, 750.0],
      [6, 1.0, 1.0e-09, 1.3, 750.0],
      [6, 1.0, 1.0e-10, 1.3, 750.0],
      [6, 1.0, 0.0, 1.3, 750.0],
    ],
    flat_Qinv: [
      [6, 100.0, 0.8681714972619037, 1.3, 750.0],
      [6, 10.0, 0.9883798584212535, 1.3, 750.0],
    ],
    lognormal_P: [
      [6, 0.0, 0.0, 1.3, 2.7],
      [6, 1.034288276012e-19, 1.0e-10, 1.3, 2.7],
      [6, 1.720583234428e-16, 1.0e-09, 1.3, 2.7],
      [6, 1.39714069655e-13, 1.0e-08, 1.3, 2.7],
      [6, 5.550354890102e-11, 1.0e-07, 1.3, 2.7],
      [6, 1.082087222875e-08, 1.0e-06, 1.3, 2.7],
      [6, 1.03981596749e-06, 1.0e-05, 1.3, 2.7],
      [6, 4.956354352667e-05, 0.0001, 1.3, 2.7],
      [6, 0.001183246775456, 0.001, 1.3, 2.7],
      [6, 0.01436760981041, 0.01, 1.3, 2.7],
      [6, 0.09105428982941, 0.1, 1.3, 2.7],
      [6, 0.3150871690838, 1.0, 1.3, 2.7],
      [6, 0.6448033073717, 10.0, 1.3, 2.7],
      [6, 0.889549744837, 100.0, 1.3, 2.7],
      [6, 0.9810967467052, 1000.0, 1.3, 2.7],
      [6, 0.9983038570318, 10000.0, 1.3, 2.7],
      [6, 0.9999223897251, 100000.0, 1.3, 2.7],
      [6, 0.9999982185389, 1000000.0, 1.3, 2.7],
      [6, 0.9999999796956, 10000000.0, 1.3, 2.7],
      [6, 0.9999999998859, 100000000.0, 1.3, 2.7],
      [6, 0.9999999999997, 1000000000.0, 1.3, 2.7],
      [6, 1.0, 10000000000.0, 1.3, 2.7],
    ],
    lognormal_Pinv: [
      [6, 1.0e-10, 1.0342882760115472e-19, 1.3, 2.7],
      [6, 1.0e-09, 1.7205832344275183e-16, 1.3, 2.7],
      [6, 1.0e-08, 1.3971406965496307e-13, 1.3, 2.7],
      [6, 1.0e-07, 5.550354890101576e-11, 1.3, 2.7],
      [6, 1.0e-06, 1.0820872228749844e-08, 1.3, 2.7],
      [6, 1.0e-05, 1.039815967490383e-06, 1.3, 2.7],
      [6, 0.0001, 4.956354352666784e-05, 1.3, 2.7],
      [6, 0.001, 0.001183246775456206, 1.3, 2.7],
      [6, 0.01, 0.014367609810406523, 1.3, 2.7],
      [6, 0.1, 0.09105428982940558, 1.3, 2.7],
      [6, 1.0, 0.31508716908375517, 1.3, 2.7],
      [6, 10.0, 0.6448033073717402, 1.3, 2.7],
      [6, 100.0, 0.8895497448370264, 1.3, 2.7],
      [6, 1000.0, 0.9810967467051815, 1.3, 2.7],
      [6, 10000.0, 0.9983038570318435, 1.3, 2.7],
      [6, 100000.0, 0.9999223897250857, 1.3, 2.7],
    ],
    lognormal_Q: [
      [6, 4.25589351365e-16, 10000000000.0, 1.3, 2.7],
      [6, 3.150574023842e-13, 1000000000.0, 1.3, 2.7],
      [6, 1.14144555008e-10, 100000000.0, 1.3, 2.7],
      [6, 2.030439602858e-08, 10000000.0, 1.3, 2.7],
      [6, 1.781461076603e-06, 1000000.0, 1.3, 2.7],
      [6, 7.761027491429e-05, 100000.0, 1.3, 2.7],
      [6, 0.001696142968157, 10000.0, 1.3, 2.7],
      [6, 0.01890325329482, 1000.0, 1.3, 2.7],
      [6, 0.110450255163, 100.0, 1.3, 2.7],
      [6, 0.3551966926283, 10.0, 1.3, 2.7],
      [6, 0.6849128309162, 1.0, 1.3, 2.7],
      [6, 0.9089457101706, 0.1, 1.3, 2.7],
      [6, 0.9856323901896, 0.01, 1.3, 2.7],
      [6, 0.9988167532245, 0.001, 1.3, 2.7],
      [6, 0.9999504364565, 0.0001, 1.3, 2.7],
      [6, 0.999998960184, 1.0e-05, 1.3, 2.7],
      [6, 0.9999999891791, 1.0e-06, 1.3, 2.7],
      [6, 0.9999999999445, 1.0e-07, 1.3, 2.7],
      [6, 0.9999999999999, 1.0e-08, 1.3, 2.7],
      [6, 1.0, 1.0e-09, 1.3, 2.7],
      [6, 1.0, 1.0e-10, 1.3, 2.7],
      [6, 1.0, 0.0, 1.3, 2.7],
    ],
    lognormal_Qinv: [
      [6, 10000000000.0, 4.2558935136502785e-16, 1.3, 2.7],
      [6, 1000000000.0, 3.1505740238418296e-13, 1.3, 2.7],
      [6, 100000000.0, 1.1414455500802107e-10, 1.3, 2.7],
      [6, 10000000.0, 2.0304396028576915e-08, 1.3, 2.7],
      [6, 1000000.0, 1.7814610766031938e-06, 1.3, 2.7],
      [6, 100000.0, 7.761027491429e-05, 1.3, 2.7],
      [6, 10000.0, 0.0016961429681565346, 1.3, 2.7],
      [6, 1000.0, 0.01890325329481853, 1.3, 2.7],
      [6, 100.0, 0.11045025516297369, 1.3, 2.7],
      [6, 10.0, 0.3551966926282599, 1.3, 2.7],
      [6, 1.0, 0.684912830916245, 1.3, 2.7],
      [6, 0.1, 0.9089457101705947, 1.3, 2.7],
      [6, 0.01, 0.9856323901895937, 1.3, 2.7],
      [6, 0.001, 0.998816753224544, 1.3, 2.7],
    ],
    gamma_P: [
      [6, 2.77472646357927811e-1, 0.325, 1.0, 1.0],
      [6, 0.0, 0.0, 1.3, 2.7],
      [6, 2.356478475164e-14, 1.0e-10, 1.3, 2.7],
      [6, 4.701792696644e-13, 1.0e-09, 1.3, 2.7],
      [6, 9.381309762735e-12, 1.0e-08, 1.3, 2.7],
      [6, 1.871817348197e-10, 1.0e-07, 1.3, 2.7],
      [6, 3.734765911711e-09, 1.0e-06, 1.3, 2.7],
      [6, 7.451823639191e-08, 1.0e-05, 1.3, 2.7],
      [6, 1.486806276026e-06, 0.0001, 1.3, 2.7],
      [6, 2.966009681152e-05, 0.001, 1.3, 2.7],
      [6, 0.000590683103295, 0.01, 1.3, 2.7],
      [6, 0.01156629233128, 0.1, 1.3, 2.7],
      [6, 0.1921237769663, 1.0, 1.3, 2.7],
      [6, 0.9565035356115, 10.0, 1.3, 2.7],
      [6, 1.0, 100.0, 1.3, 2.7],
      [6, 1.0, 1000.0, 1.3, 2.7],
      [6, 1.0, 10000.0, 1.3, 2.7],
      [6, 1.0, 100000.0, 1.3, 2.7],
      [6, 1.0, 1000000.0, 1.3, 2.7],
      [6, 1.0, 10000000.0, 1.3, 2.7],
      [6, 1.0, 100000000.0, 1.3, 2.7],
      [6, 1.0, 1000000000.0, 1.3, 2.7],
      [6, 1.0, 10000000000.0, 1.3, 2.7],
      [6, 0.0, 0.0, 1.3, 123.0],
      [6, 1.644976604681e-16, 1.0e-10, 1.3, 123.0],
      [6, 3.282159828312e-15, 1.0e-09, 1.3, 123.0],
      [6, 6.548769816865e-14, 1.0e-08, 1.3, 123.0],
      [6, 1.306651361959e-12, 1.0e-07, 1.3, 123.0],
      [6, 2.607112210538e-11, 1.0e-06, 1.3, 123.0],
      [6, 5.201872529446e-10, 1.0e-05, 1.3, 123.0],
      [6, 1.037909593275e-08, 0.0001, 1.3, 123.0],
      [6, 2.070893333124e-07, 0.001, 1.3, 123.0],
      [6, 4.131804542806e-06, 0.01, 1.3, 123.0],
      [6, 8.240625287202e-05, 0.1, 1.3, 123.0],
      [6, 0.001637438876041, 1.0, 1.3, 123.0],
      [6, 0.03135521671622, 10.0, 1.3, 123.0],
      [6, 0.4240385705334, 100.0, 1.3, 123.0],
      [6, 0.9993635318324, 1000.0, 1.3, 123.0],
      [6, 1.0, 10000.0, 1.3, 123.0],
      [6, 1.0, 100000.0, 1.3, 123.0],
      [6, 1.0, 1000000.0, 1.3, 123.0],
      [6, 1.0, 10000000.0, 1.3, 123.0],
      [6, 1.0, 100000000.0, 1.3, 123.0],
      [6, 1.0, 1000000000.0, 1.3, 123.0],
      [6, 1.0, 10000000000.0, 1.3, 123.0],
    ],
    gamma_Pinv: [
      [6, 1.0e-10, 2.356478475163866e-14, 1.3, 2.7],
      [6, 1.0e-09, 4.701792696643945e-13, 1.3, 2.7],
      [6, 1.0e-08, 9.381309762734639e-12, 1.3, 2.7],
      [6, 1.0e-07, 1.8718173481972823e-10, 1.3, 2.7],
      [6, 1.0e-06, 3.734765911711424e-09, 1.3, 2.7],
      [6, 1.0e-05, 7.451823639191012e-08, 1.3, 2.7],
      [6, 0.0001, 1.4868062760263472e-06, 1.3, 2.7],
      [6, 0.001, 2.9660096811518665e-05, 1.3, 2.7],
      [6, 0.01, 0.0005906831032949983, 1.3, 2.7],
      [6, 0.1, 0.011566292331279586, 1.3, 2.7],
      [6, 1.0, 0.19212377696630473, 1.3, 2.7],
      [6, 10.0, 0.9565035356115379, 1.3, 2.7],
      [6, 1.0e-10, 1.6449766046812008e-16, 1.3, 123.0],
      [6, 1.0e-09, 3.2821598283122862e-15, 1.3, 123.0],
      [6, 1.0e-08, 6.548769816865393e-14, 1.3, 123.0],
      [6, 1.0e-07, 1.3066513619593202e-12, 1.3, 123.0],
      [6, 1.0e-06, 2.6071122105378624e-11, 1.3, 123.0],
      [6, 1.0e-05, 5.201872529445639e-10, 1.3, 123.0],
      [6, 0.0001, 1.037909593275298e-08, 1.3, 123.0],
      [6, 0.001, 2.0708933331240137e-07, 1.3, 123.0],
      [6, 0.01, 4.131804542806129e-06, 1.3, 123.0],
      [6, 0.1, 8.240625287201719e-05, 1.3, 123.0],
      [6, 1.0, 0.0016374388760411608, 1.3, 123.0],
      [6, 10.0, 0.03135521671622352, 1.3, 123.0],
      [6, 100.0, 0.42403857053338523, 1.3, 123.0],
      [6, 1000.0, 0.9993635318323562, 1.3, 123.0],
    ],
    gamma_Q: [
      [6, 7.22527353642072189e-1, 0.325, 1.0, 1.0],
      [6, 0.0, 10000000000.0, 1.3, 2.7],
      [6, 0.0, 1000000000.0, 1.3, 2.7],
      [6, 0.0, 100000000.0, 1.3, 2.7],
      [6, 0.0, 10000000.0, 1.3, 2.7],
      [6, 0.0, 1000000.0, 1.3, 2.7],
      [6, 0.0, 100000.0, 1.3, 2.7],
      [6, 0.0, 10000.0, 1.3, 2.7],
      [6, 9.292091038794e-161, 1000.0, 1.3, 2.7],
      [6, 2.729167976527e-16, 100.0, 1.3, 2.7],
      [6, 0.04349646438846, 10.0, 1.3, 2.7],
      [6, 0.8078762230337, 1.0, 1.3, 2.7],
      [6, 0.9884337076687, 0.1, 1.3, 2.7],
      [6, 0.9994093168967, 0.01, 1.3, 2.7],
      [6, 0.9999703399032, 0.001, 1.3, 2.7],
      [6, 0.9999985131937, 0.0001, 1.3, 2.7],
      [6, 0.9999999254818, 1.0e-05, 1.3, 2.7],
      [6, 0.9999999962652, 1.0e-06, 1.3, 2.7],
      [6, 0.9999999998128, 1.0e-07, 1.3, 2.7],
      [6, 0.9999999999906, 1.0e-08, 1.3, 2.7],
      [6, 0.9999999999995, 1.0e-09, 1.3, 2.7],
      [6, 1.0, 1.0e-10, 1.3, 2.7],
      [6, 1.0, 0.0, 1.3, 2.7],
      [6, 0.0, 10000000000.0, 1.3, 123.0],
      [6, 0.0, 1000000000.0, 1.3, 123.0],
      [6, 0.0, 100000000.0, 1.3, 123.0],
      [6, 0.0, 10000000.0, 1.3, 123.0],
      [6, 0.0, 1000000.0, 1.3, 123.0],
      [6, 0.0, 100000.0, 1.3, 123.0],
      [6, 2.056363344745e-35, 10000.0, 1.3, 123.0],
      [6, 0.000636468167644, 1000.0, 1.3, 123.0],
      [6, 0.5759614294666, 100.0, 1.3, 123.0],
      [6, 0.9686447832838, 10.0, 1.3, 123.0],
      [6, 0.998362561124, 1.0, 1.3, 123.0],
      [6, 0.9999175937471, 0.1, 1.3, 123.0],
      [6, 0.9999958681955, 0.01, 1.3, 123.0],
      [6, 0.9999997929107, 0.001, 1.3, 123.0],
      [6, 0.9999999896209, 0.0001, 1.3, 123.0],
      [6, 0.9999999994798, 1.0e-05, 1.3, 123.0],
      [6, 0.9999999999739, 1.0e-06, 1.3, 123.0],
      [6, 0.9999999999987, 1.0e-07, 1.3, 123.0],
      [6, 0.9999999999999, 1.0e-08, 1.3, 123.0],
      [6, 1.0, 1.0e-09, 1.3, 123.0],
      [6, 1.0, 1.0e-10, 1.3, 123.0],
      [6, 1.0, 0.0, 1.3, 123.0],
    ],
    gamma_Qinv: [
      [6, 1000.0, 9.292091038793986e-161, 1.3, 2.7],
      [6, 100.0, 2.7291679765273174e-16, 1.3, 2.7],
      [6, 10.0, 0.04349646438846219, 1.3, 2.7],
      [6, 1.0, 0.8078762230336953, 1.3, 2.7],
      [6, 0.1, 0.9884337076687204, 1.3, 2.7],
      [6, 0.01, 0.999409316896705, 1.3, 2.7],
      [6, 10000.0, 2.0563633447452943e-35, 1.3, 123.0],
      [6, 1000.0, 0.0006364681676439553, 1.3, 123.0],
      [6, 100.0, 0.5759614294666149, 1.3, 123.0],
      [6, 10.0, 0.9686447832837765, 1.3, 123.0],
      [6, 1.0, 0.9983625611239588, 1.3, 123.0],
      [6, 0.1, 0.999917593747128, 1.3, 123.0],
    ],
    chisq_P: [
      [6, 3.06065632019251110e-1, 10.0, 13.0],
      [6, 0.0, 0.0, 1.3],
      [6, 2.238884178785e-07, 1.0e-10, 1.3],
      [6, 1.000072827212e-06, 1.0e-09, 1.3],
      [6, 4.467161220799e-06, 1.0e-08, 1.3],
      [6, 1.995407585451e-05, 1.0e-07, 1.3],
      [6, 8.913156700686e-05, 1.0e-06, 1.3],
      [6, 0.0003981353794611, 1.0e-05, 1.3],
      [6, 0.0017783738888, 0.0001, 1.3],
      [6, 0.00794229637959, 0.001, 1.3],
      [6, 0.0354141390254, 0.01, 1.3],
      [6, 0.155426889584, 0.1, 1.3],
      [6, 0.5878620132779, 1.0, 1.3],
      [6, 0.9973867890205, 10.0, 1.3],
      [6, 1.0, 100.0, 1.3],
      [6, 1.0, 1000.0, 1.3],
      [6, 1.0, 10000.0, 1.3],
      [6, 1.0, 100000.0, 1.3],
      [6, 1.0, 1000000.0, 1.3],
      [6, 1.0, 10000000.0, 1.3],
      [6, 1.0, 100000000.0, 1.3],
      [6, 1.0, 1000000000.0, 1.3],
      [6, 1.0, 10000000000.0, 1.3],
    ],
    chisq_Pinv: [
      [6, 1.0e-10, 2.2388841787852728e-07, 1.3],
      [6, 1.0e-09, 1.0000728272124926e-06, 1.3],
      [6, 1.0e-08, 4.467161220799411e-06, 1.3],
      [6, 1.0e-07, 1.9954075854510294e-05, 1.3],
      [6, 1.0e-06, 8.913156700685821e-05, 1.3],
      [6, 1.0e-05, 0.00039813537946105, 1.3],
      [6, 0.0001, 0.001778373888800392, 1.3],
      [6, 0.001, 0.00794229637958962, 1.3],
      [6, 0.01, 0.03541413902540241, 1.3],
      [6, 0.1, 0.15542688958403586, 1.3],
      [6, 1.0, 0.5878620132778858, 1.3],
      [6, 10.0, 0.9973867890205305, 1.3],
    ],
    chisq_Q: [
      [6, 6.93934367980748890e-1, 10.0, 13.0],
      [6, 0.0, 10000000000.0, 1.3],
      [6, 0.0, 1000000000.0, 1.3],
      [6, 0.0, 100000000.0, 1.3],
      [6, 0.0, 10000000.0, 1.3],
      [6, 0.0, 1000000.0, 1.3],
      [6, 0.0, 100000.0, 1.3],
      [6, 0.0, 10000.0, 1.3],
      [6, 5.840240518729e-219, 1000.0, 1.3],
      [6, 3.517864771108e-23, 100.0, 1.3],
      [6, 0.00261321097947, 10.0, 1.3],
      [6, 0.4121379867221, 1.0, 1.3],
      [6, 0.844573110416, 0.1, 1.3],
      [6, 0.9645858609746, 0.01, 1.3],
      [6, 0.9920577036204, 0.001, 1.3],
      [6, 0.9982216261112, 0.0001, 1.3],
      [6, 0.9996018646205, 1.0e-05, 1.3],
      [6, 0.999910868433, 1.0e-06, 1.3],
      [6, 0.9999800459241, 1.0e-07, 1.3],
      [6, 0.9999955328388, 1.0e-08, 1.3],
      [6, 0.9999989999272, 1.0e-09, 1.3],
      [6, 0.9999997761116, 1.0e-10, 1.3],
      [6, 1.0, 0.0, 1.3],
    ],
    chisq_Qinv: [
      [6, 1000.0, 5.840240518728896e-219, 1.3],
      [6, 100.0, 3.517864771107665e-23, 1.3],
      [6, 10.0, 0.002613210979469623, 1.3],
      [6, 1.0, 0.41213798672211427, 1.3],
      [6, 0.1, 0.8445731104159642, 1.3],
      [6, 0.01, 0.9645858609745978, 1.3],
      [6, 0.001, 0.9920577036204106, 1.3],
      [6, 0.0001, 0.9982216261111997, 1.3],
      [6, 1.0e-05, 0.9996018646205391, 1.3],
    ],
    tdist_P: [
      [6, 0.5, 0.0, 1.0],
      [6, 6.00023120032852123e-1, 0.325, 1.0],
      [6, 9.99968169011487724e-1, 10000.0, 1.0],
      [6, 6.11985772746873767e-01, 0.325, 2.0],
      [6, 3.46784811185e-14, -10000000000.0, 1.3],
      [6, 6.91926665161e-13, -1000000000.0, 1.3],
      [6, 1.380575199718e-11, -100000000.0, 1.3],
      [6, 2.754609668978e-10, -10000000.0, 1.3],
      [6, 5.496168864957e-09, -1000000.0, 1.3],
      [6, 1.096629861231e-07, -100000.0, 1.3],
      [6, 2.188064222827e-06, -10000.0, 1.3],
      [6, 4.365759541083e-05, -1000.0, 1.3],
      [6, 0.0008710327647608, -100.0, 1.3],
      [6, 0.0172789338682, -10.0, 1.3],
      [6, 0.2336211937932, -1.0, 1.3],
      [6, 0.4667575980083, -0.1, 1.3],
      [6, 0.4966660755117, -0.01, 1.3],
      [6, 0.4996665978189, -0.001, 1.3],
      [6, 0.4999666597722, -0.0001, 1.3],
      [6, 0.4999966659772, -1.0e-05, 1.3],
      [6, 0.4999996665977, -1.0e-06, 1.3],
      [6, 0.4999999666598, -1.0e-07, 1.3],
      [6, 0.499999996666, -1.0e-08, 1.3],
      [6, 0.4999999996666, -1.0e-09, 1.3],
      [6, 0.4999999999667, -1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000333, 1.0e-10, 1.3],
      [6, 0.5000000003334, 1.0e-09, 1.3],
      [6, 0.500000003334, 1.0e-08, 1.3],
      [6, 0.5000000333402, 1.0e-07, 1.3],
      [6, 0.5000003334023, 1.0e-06, 1.3],
      [6, 0.5000033340228, 1.0e-05, 1.3],
      [6, 0.5000333402278, 0.0001, 1.3],
      [6, 0.5003334021811, 0.001, 1.3],
      [6, 0.5033339244883, 0.01, 1.3],
      [6, 0.5332424019917, 0.1, 1.3],
      [6, 0.7663788062068, 1.0, 1.3],
      [6, 0.9827210661318, 10.0, 1.3],
      [6, 0.9991289672352, 100.0, 1.3],
      [6, 0.9999563424046, 1000.0, 1.3],
      [6, 0.9999978119358, 10000.0, 1.3],
      [6, 0.999999890337, 100000.0, 1.3],
      [6, 0.9999999945038, 1000000.0, 1.3],
      [6, 0.9999999997245, 10000000.0, 1.3],
      [6, 0.9999999999862, 100000000.0, 1.3],
      [6, 0.9999999999993, 1000000000.0, 1.3],
      [6, 1.0, 10000000000.0, 1.3],
    ],
    tdist_Pinv: [
      [6, -10000000000.0, 3.4678481118500305e-14, 1.3],
      [6, -1000000000.0, 6.919266651610352e-13, 1.3],
      [6, -100000000.0, 1.3805751997179027e-11, 1.3],
      [6, -10000000.0, 2.7546096689777484e-10, 1.3],
      [6, -1000000.0, 5.496168864956998e-09, 1.3],
      [6, -100000.0, 1.0966298612314582e-07, 1.3],
      [6, -10000.0, 2.1880642228271703e-06, 1.3],
      [6, -1000.0, 4.365759541083357e-05, 1.3],
      [6, -100.0, 0.000871032764760792, 1.3],
      [6, -10.0, 0.017278933868204446, 1.3],
      [6, -1.0, 0.23362119379322516, 1.3],
      [6, -0.1, 0.4667575980082614, 1.3],
      [6, -0.01, 0.49666607551169606, 1.3],
      [6, -0.001, 0.4996665978188763, 1.3],
      [6, 0.0, 0.499999999999999, 1.3],
      [6, 0.001, 0.5003334021811237, 1.3],
      [6, 0.01, 0.5033339244883039, 1.3],
      [6, 0.1, 0.5332424019917386, 1.3],
      [6, 1.0, 0.7663788062067749, 1.3],
      [6, 10.0, 0.9827210661317956, 1.3],
      [6, 100.0, 0.9991289672352393, 1.3],
    ],
    tdist_Q: [
      [6, 0.5, 0.0, 1.0],
      [6, 3.99976879967147876e-1, 0.325, 1.0],
      [6, 3.88014227253126233e-1, 0.325, 2.0],
      [6, 3.46784811185e-14, 10000000000.0, 1.3],
      [6, 6.91926665161e-13, 1000000000.0, 1.3],
      [6, 1.380575199718e-11, 100000000.0, 1.3],
      [6, 2.754609668978e-10, 10000000.0, 1.3],
      [6, 5.496168864957e-09, 1000000.0, 1.3],
      [6, 1.096629861231e-07, 100000.0, 1.3],
      [6, 2.188064222827e-06, 10000.0, 1.3],
      [6, 4.365759541083e-05, 1000.0, 1.3],
      [6, 0.0008710327647608, 100.0, 1.3],
      [6, 0.0172789338682, 10.0, 1.3],
      [6, 0.2336211937932, 1.0, 1.3],
      [6, 0.4667575980083, 0.1, 1.3],
      [6, 0.4966660755117, 0.01, 1.3],
      [6, 0.4996665978189, 0.001, 1.3],
      [6, 0.4999666597722, 0.0001, 1.3],
      [6, 0.4999966659772, 1.0e-05, 1.3],
      [6, 0.4999996665977, 1.0e-06, 1.3],
      [6, 0.4999999666598, 1.0e-07, 1.3],
      [6, 0.499999996666, 1.0e-08, 1.3],
      [6, 0.4999999996666, 1.0e-09, 1.3],
      [6, 0.4999999999667, 1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000333, -1.0e-10, 1.3],
      [6, 0.5000000003334, -1.0e-09, 1.3],
      [6, 0.500000003334, -1.0e-08, 1.3],
      [6, 0.5000000333402, -1.0e-07, 1.3],
      [6, 0.5000003334023, -1.0e-06, 1.3],
      [6, 0.5000033340228, -1.0e-05, 1.3],
      [6, 0.5000333402278, -0.0001, 1.3],
      [6, 0.5003334021811, -0.001, 1.3],
      [6, 0.5033339244883, -0.01, 1.3],
      [6, 0.5332424019917, -0.1, 1.3],
      [6, 0.7663788062068, -1.0, 1.3],
      [6, 0.9827210661318, -10.0, 1.3],
      [6, 0.9991289672352, -100.0, 1.3],
      [6, 0.9999563424046, -1000.0, 1.3],
      [6, 0.9999978119358, -10000.0, 1.3],
      [6, 0.999999890337, -100000.0, 1.3],
      [6, 0.9999999945038, -1000000.0, 1.3],
      [6, 0.9999999997245, -10000000.0, 1.3],
      [6, 0.9999999999862, -100000000.0, 1.3],
      [6, 0.9999999999993, -1000000000.0, 1.3],
      [6, 1.0, -10000000000.0, 1.3],
    ],
    tdist_Qinv: [
      [6, 10000000000.0, 3.4678481118500305e-14, 1.3],
      [6, 1000000000.0, 6.919266651610352e-13, 1.3],
      [6, 100000000.0, 1.3805751997179027e-11, 1.3],
      [6, 10000000.0, 2.7546096689777484e-10, 1.3],
      [6, 1000000.0, 5.496168864956998e-09, 1.3],
      [6, 100000.0, 1.0966298612314582e-07, 1.3],
      [6, 10000.0, 2.1880642228271703e-06, 1.3],
      [6, 1000.0, 4.365759541083357e-05, 1.3],
      [6, 100.0, 0.000871032764760792, 1.3],
      [6, 10.0, 0.017278933868204446, 1.3],
      [6, 1.0, 0.23362119379322516, 1.3],
      [6, 0.1, 0.4667575980082614, 1.3],
      [6, 0.01, 0.49666607551169606, 1.3],
      [6, 0.001, 0.4996665978188763, 1.3],
      [6, 0.0, 0.499999999999999, 1.3],
      [6, -0.001, 0.5003334021811237, 1.3],
      [6, -0.01, 0.5033339244883039, 1.3],
      [6, -0.1, 0.5332424019917386, 1.3],
      [6, -1.0, 0.7663788062067749, 1.3],
      [6, -10.0, 0.9827210661317956, 1.3],
      [6, -100.0, 0.9991289672352393, 1.3],
    ],
    gumbel1_P: [
      [6, 0.0, -10000000000.0, 1.3, 2.7],
      [6, 0.0, -1000000000.0, 1.3, 2.7],
      [6, 0.0, -100000000.0, 1.3, 2.7],
      [6, 0.0, -10000000.0, 1.3, 2.7],
      [6, 0.0, -1000000.0, 1.3, 2.7],
      [6, 0.0, -100000.0, 1.3, 2.7],
      [6, 0.0, -10000.0, 1.3, 2.7],
      [6, 0.0, -1000.0, 1.3, 2.7],
      [6, 0.0, -100.0, 1.3, 2.7],
      [6, 0.0, -10.0, 1.3, 2.7],
      [6, 4.981965353092e-05, -1.0, 1.3, 2.7],
      [6, 0.0461971747678, -0.1, 1.3, 2.7],
      [6, 0.06487265128366, -0.01, 1.3, 2.7],
      [6, 0.06696988203722, -0.001, 1.3, 2.7],
      [6, 0.06718192621136, -0.0001, 1.3, 2.7],
      [6, 0.06720315385232, -1.0e-05, 1.3, 2.7],
      [6, 0.06720527684866, -1.0e-06, 1.3, 2.7],
      [6, 0.06720548915062, -1.0e-07, 1.3, 2.7],
      [6, 0.06720551038084, -1.0e-08, 1.3, 2.7],
      [6, 0.06720551250386, -1.0e-09, 1.3, 2.7],
      [6, 0.06720551271616, -1.0e-10, 1.3, 2.7],
      [6, 0.06720551273975, 0.0, 1.3, 2.7],
      [6, 0.06720551276334, 1.0e-10, 1.3, 2.7],
      [6, 0.06720551297564, 1.0e-09, 1.3, 2.7],
      [6, 0.06720551509866, 1.0e-08, 1.3, 2.7],
      [6, 0.06720553632889, 1.0e-07, 1.3, 2.7],
      [6, 0.06720574863136, 1.0e-06, 1.3, 2.7],
      [6, 0.06720787167931, 1.0e-05, 1.3, 2.7],
      [6, 0.06722910448133, 0.0001, 1.3, 2.7],
      [6, 0.0674416647619, 0.001, 1.3, 2.7],
      [6, 0.06959050352518, 0.01, 1.3, 2.7],
      [6, 0.09340058564429, 0.1, 1.3, 2.7],
      [6, 0.4791048360125, 1.0, 1.3, 2.7],
      [6, 0.9999938971292, 10.0, 1.3, 2.7],
      [6, 1.0, 100.0, 1.3, 2.7],
      [6, 1.0, 1000.0, 1.3, 2.7],
      [6, 1.0, 10000.0, 1.3, 2.7],
      [6, 1.0, 100000.0, 1.3, 2.7],
      [6, 1.0, 1000000.0, 1.3, 2.7],
      [6, 1.0, 10000000.0, 1.3, 2.7],
      [6, 1.0, 100000000.0, 1.3, 2.7],
      [6, 1.0, 1000000000.0, 1.3, 2.7],
      [6, 1.0, 10000000000.0, 1.3, 2.7],
    ],
    gumbel1_Pinv: [
      [6, -1.0, 4.981965353091824e-05, 1.3, 2.7],
      [6, -0.1, 0.04619717476779808, 1.3, 2.7],
      [6, -0.01, 0.06487265128366305, 1.3, 2.7],
      [6, -0.001, 0.0669698820372176, 1.3, 2.7],
      [6, -0.0001, 0.06718192621136487, 1.3, 2.7],
      [6, 0.0, 0.06720551273974995, 1.3, 2.7],
      [6, 0.0001, 0.06722910448133346, 1.3, 2.7],
      [6, 0.001, 0.06744166476189883, 1.3, 2.7],
      [6, 0.01, 0.06959050352517981, 1.3, 2.7],
      [6, 0.1, 0.09340058564429043, 1.3, 2.7],
      [6, 1.0, 0.47910483601248477, 1.3, 2.7],
    ],
    gumbel1_Q: [
      [6, 0.0, 10000000000.0, 1.3, 2.7],
      [6, 0.0, 1000000000.0, 1.3, 2.7],
      [6, 0.0, 100000000.0, 1.3, 2.7],
      [6, 0.0, 10000000.0, 1.3, 2.7],
      [6, 0.0, 1000000.0, 1.3, 2.7],
      [6, 0.0, 100000.0, 1.3, 2.7],
      [6, 0.0, 10000.0, 1.3, 2.7],
      [6, 0.0, 1000.0, 1.3, 2.7],
      [6, 9.398988467742e-57, 100.0, 1.3, 2.7],
      [6, 6.102870776257e-06, 10.0, 1.3, 2.7],
      [6, 0.5208951639875, 1.0, 1.3, 2.7],
      [6, 0.9065994143557, 0.1, 1.3, 2.7],
      [6, 0.9304094964748, 0.01, 1.3, 2.7],
      [6, 0.9325583352381, 0.001, 1.3, 2.7],
      [6, 0.9327708955187, 0.0001, 1.3, 2.7],
      [6, 0.9327921283207, 1.0e-05, 1.3, 2.7],
      [6, 0.9327942513686, 1.0e-06, 1.3, 2.7],
      [6, 0.9327944636711, 1.0e-07, 1.3, 2.7],
      [6, 0.9327944849013, 1.0e-08, 1.3, 2.7],
      [6, 0.9327944870244, 1.0e-09, 1.3, 2.7],
      [6, 0.9327944872367, 1.0e-10, 1.3, 2.7],
      [6, 0.9327944872603, 0.0, 1.3, 2.7],
      [6, 0.9327944872838, -1.0e-10, 1.3, 2.7],
      [6, 0.9327944874961, -1.0e-09, 1.3, 2.7],
      [6, 0.9327944896192, -1.0e-08, 1.3, 2.7],
      [6, 0.9327945108494, -1.0e-07, 1.3, 2.7],
      [6, 0.9327947231513, -1.0e-06, 1.3, 2.7],
      [6, 0.9327968461477, -1.0e-05, 1.3, 2.7],
      [6, 0.9328180737886, -0.0001, 1.3, 2.7],
      [6, 0.9330301179628, -0.001, 1.3, 2.7],
      [6, 0.9351273487163, -0.01, 1.3, 2.7],
      [6, 0.9538028252322, -0.1, 1.3, 2.7],
      [6, 0.9999501803465, -1.0, 1.3, 2.7],
      [6, 1.0, -10.0, 1.3, 2.7],
      [6, 1.0, -100.0, 1.3, 2.7],
      [6, 1.0, -1000.0, 1.3, 2.7],
      [6, 1.0, -10000.0, 1.3, 2.7],
      [6, 1.0, -100000.0, 1.3, 2.7],
      [6, 1.0, -1000000.0, 1.3, 2.7],
      [6, 1.0, -10000000.0, 1.3, 2.7],
      [6, 1.0, -100000000.0, 1.3, 2.7],
      [6, 1.0, -1000000000.0, 1.3, 2.7],
      [6, 1.0, -10000000000.0, 1.3, 2.7],
    ],
    gumbel1_Qinv: [
      [6, 100.0, 9.398988467741606e-57, 1.3, 2.7],
      [6, 10.0, 6.10287077625722e-06, 1.3, 2.7],
      [6, 1.0, 0.5208951639875152, 1.3, 2.7],
      [6, 0.1, 0.9065994143557096, 1.3, 2.7],
      [6, 0.01, 0.9304094964748202, 1.3, 2.7],
      [6, 0.001, 0.9325583352381012, 1.3, 2.7],
      [6, 0.0, 0.9327944872602503, 1.3, 2.7],
      [6, -0.001, 0.9330301179627825, 1.3, 2.7],
      [6, -0.01, 0.935127348716337, 1.3, 2.7],
      [6, -0.1, 0.953802825232202, 1.3, 2.7],
      [6, -1.0, 0.9999501803464691, 1.3, 2.7],
    ],
    gumbel2_P: [
      [6, 0.0, 0.0, 1.3, 2.7],
      [6, 0.0, 1.0e-10, 1.3, 2.7],
      [6, 0.0, 1.0e-09, 1.3, 2.7],
      [6, 0.0, 1.0e-08, 1.3, 2.7],
      [6, 0.0, 1.0e-07, 1.3, 2.7],
      [6, 0.0, 1.0e-06, 1.3, 2.7],
      [6, 0.0, 1.0e-05, 1.3, 2.7],
      [6, 0.0, 0.0001, 1.3, 2.7],
      [6, 0.0, 0.001, 1.3, 2.7],
      [6, 0.0, 0.01, 1.3, 2.7],
      [6, 4.014688368993e-24, 0.1, 1.3, 2.7],
      [6, 0.06720551273975, 1.0, 1.3, 2.7],
      [6, 0.8734358842463, 10.0, 1.3, 2.7],
      [6, 0.9932408531257, 100.0, 1.3, 2.7],
      [6, 0.9996601479016, 1000.0, 1.3, 2.7],
      [6, 0.9999829642968, 10000.0, 1.3, 2.7],
      [6, 0.9999991461854, 100000.0, 1.3, 2.7],
      [6, 0.9999999572079, 1000000.0, 1.3, 2.7],
      [6, 0.9999999978553, 10000000.0, 1.3, 2.7],
      [6, 0.9999999998925, 100000000.0, 1.3, 2.7],
      [6, 0.9999999999946, 1000000000.0, 1.3, 2.7],
      [6, 0.9999999999997, 10000000000.0, 1.3, 2.7],
    ],
    gumbel2_Pinv: [
      [6, 0.1, 4.0146883689934746e-24, 1.3, 2.7],
      [6, 1.0, 0.06720551273974974, 1.3, 2.7],
      [6, 10.0, 0.8734358842462814, 1.3, 2.7],
      [6, 100.0, 0.9932408531257445, 1.3, 2.7],
      [6, 1000.0, 0.9996601479016278, 1.3, 2.7],
    ],
    gumbel2_Q: [
      [6, 2.7e-13, 10000000000.0, 1.3, 2.7],
      [6, 5.387208250401e-12, 1000000000.0, 1.3, 2.7],
      [6, 1.074889360437e-10, 100000000.0, 1.3, 2.7],
      [6, 2.144686231456e-09, 10000000.0, 1.3, 2.7],
      [6, 4.279211528087e-08, 1000000.0, 1.3, 2.7],
      [6, 8.538146037456e-07, 100000.0, 1.3, 2.7],
      [6, 1.703570319173e-05, 10000.0, 1.3, 2.7],
      [6, 0.0003398520983725, 1000.0, 1.3, 2.7],
      [6, 0.006759146874256, 100.0, 1.3, 2.7],
      [6, 0.1265641157537, 10.0, 1.3, 2.7],
      [6, 0.9327944872603, 1.0, 1.3, 2.7],
      [6, 1.0, 0.1, 1.3, 2.7],
      [6, 1.0, 0.01, 1.3, 2.7],
      [6, 1.0, 0.001, 1.3, 2.7],
      [6, 1.0, 0.0001, 1.3, 2.7],
      [6, 1.0, 1.0e-05, 1.3, 2.7],
      [6, 1.0, 1.0e-06, 1.3, 2.7],
      [6, 1.0, 1.0e-07, 1.3, 2.7],
      [6, 1.0, 1.0e-08, 1.3, 2.7],
      [6, 1.0, 1.0e-09, 1.3, 2.7],
      [6, 1.0, 1.0e-10, 1.3, 2.7],
      [6, 1.0, 0.0, 1.3, 2.7],
    ],
    gumbel2_Qinv: [
      [6, 10000000000.0, 2.699999999999649e-13, 1.3, 2.7],
      [6, 1000000000.0, 5.387208250401491e-12, 1.3, 2.7],
      [6, 100000000.0, 1.0748893604366781e-10, 1.3, 2.7],
      [6, 10000000.0, 2.1446862314557286e-09, 1.3, 2.7],
      [6, 1000000.0, 4.2792115280867646e-08, 1.3, 2.7],
      [6, 100000.0, 8.53814603745569e-07, 1.3, 2.7],
      [6, 10000.0, 1.7035703191725618e-05, 1.3, 2.7],
      [6, 1000.0, 0.0003398520983724625, 1.3, 2.7],
      [6, 100.0, 0.0067591468742558315, 1.3, 2.7],
      [6, 10.0, 0.12656411575371904, 1.3, 2.7],
      [6, 1.0, 0.9327944872602512, 1.3, 2.7],
    ],
    weibull_P: [
      [6, 0.0, 0.0, 1.3, 2.7],
      [6, 4.924395760785e-28, 1.0e-10, 1.3, 2.7],
      [6, 2.468044288634e-25, 1.0e-09, 1.3, 2.7],
      [6, 1.23695228949e-22, 1.0e-08, 1.3, 2.7],
      [6, 6.199446960984e-20, 1.0e-07, 1.3, 2.7],
      [6, 3.107083672395e-17, 1.0e-06, 1.3, 2.7],
      [6, 1.557230670416e-14, 1.0e-05, 1.3, 2.7],
      [6, 7.804641318223e-12, 0.0001, 1.3, 2.7],
      [6, 3.911586584098e-09, 0.001, 1.3, 2.7],
      [6, 1.960435341356e-06, 0.01, 1.3, 2.7],
      [6, 0.0009820635881537, 0.1, 1.3, 2.7],
      [6, 0.3888663329609, 1.0, 1.3, 2.7],
      [6, 1.0, 10.0, 1.3, 2.7],
      [6, 1.0, 100.0, 1.3, 2.7],
      [6, 1.0, 1000.0, 1.3, 2.7],
      [6, 1.0, 10000.0, 1.3, 2.7],
      [6, 1.0, 100000.0, 1.3, 2.7],
      [6, 1.0, 1000000.0, 1.3, 2.7],
      [6, 1.0, 10000000.0, 1.3, 2.7],
      [6, 1.0, 100000000.0, 1.3, 2.7],
      [6, 1.0, 1000000000.0, 1.3, 2.7],
      [6, 1.0, 10000000000.0, 1.3, 2.7],
    ],
    weibull_Pinv: [
      [6, 1.0e-10, 4.92439576078527e-28, 1.3, 2.7],
      [6, 1.0e-09, 2.468044288633838e-25, 1.3, 2.7],
      [6, 1.0e-08, 1.2369522894899823e-22, 1.3, 2.7],
      [6, 1.0e-07, 6.199446960984052e-20, 1.3, 2.7],
      [6, 1.0e-06, 3.107083672394598e-17, 1.3, 2.7],
      [6, 1.0e-05, 1.557230670415903e-14, 1.3, 2.7],
      [6, 0.0001, 7.804641318222502e-12, 1.3, 2.7],
      [6, 0.001, 3.9115865840980536e-09, 1.3, 2.7],
      [6, 0.01, 1.9604353413559907e-06, 1.3, 2.7],
      [6, 0.1, 0.000982063588153714, 1.3, 2.7],
      [6, 1.0, 0.38886633296085954, 1.3, 2.7],
    ],
    weibull_Q: [
      [6, 0.0, 10000000000.0, 1.3, 2.7],
      [6, 0.0, 1000000000.0, 1.3, 2.7],
      [6, 0.0, 100000000.0, 1.3, 2.7],
      [6, 0.0, 10000000.0, 1.3, 2.7],
      [6, 0.0, 1000000.0, 1.3, 2.7],
      [6, 0.0, 100000.0, 1.3, 2.7],
      [6, 0.0, 10000.0, 1.3, 2.7],
      [6, 0.0, 1000.0, 1.3, 2.7],
      [6, 0.0, 100.0, 1.3, 2.7],
      [6, 6.51926200407e-108, 10.0, 1.3, 2.7],
      [6, 0.6111336670391, 1.0, 1.3, 2.7],
      [6, 0.9990179364118, 0.1, 1.3, 2.7],
      [6, 0.9999980395647, 0.01, 1.3, 2.7],
      [6, 0.9999999960884, 0.001, 1.3, 2.7],
      [6, 0.9999999999922, 0.0001, 1.3, 2.7],
      [6, 1.0, 1.0e-05, 1.3, 2.7],
      [6, 1.0, 1.0e-06, 1.3, 2.7],
      [6, 1.0, 1.0e-07, 1.3, 2.7],
      [6, 1.0, 1.0e-08, 1.3, 2.7],
      [6, 1.0, 1.0e-09, 1.3, 2.7],
      [6, 1.0, 1.0e-10, 1.3, 2.7],
      [6, 1.0, 0.0, 1.3, 2.7],
    ],
    weibull_Qinv: [
      [6, 10.0, 6.519262004069862e-108, 1.3, 2.7],
      [6, 1.0, 0.6111336670391404, 1.3, 2.7],
      [6, 0.1, 0.9990179364118463, 1.3, 2.7],
    ],
    pareto_P: [
      [6, 0.0, 0.0, 1.3, 2.7],
      [6, 0.0, 1.0e-10, 1.3, 2.7],
      [6, 0.0, 1.0e-09, 1.3, 2.7],
      [6, 0.0, 1.0e-08, 1.3, 2.7],
      [6, 0.0, 1.0e-07, 1.3, 2.7],
      [6, 0.0, 1.0e-06, 1.3, 2.7],
      [6, 0.0, 1.0e-05, 1.3, 2.7],
      [6, 0.0, 0.0001, 1.3, 2.7],
      [6, 0.0, 0.001, 1.3, 2.7],
      [6, 0.0, 0.01, 1.3, 2.7],
      [6, 0.0, 0.1, 1.3, 2.7],
      [6, 0.0, 1.0, 1.3, 2.7],
      [6, 0.817705782224, 10.0, 1.3, 2.7],
      [6, 0.9908636465287, 100.0, 1.3, 2.7],
      [6, 0.9995420976279, 1000.0, 1.3, 2.7],
      [6, 0.9999770505177, 10000.0, 1.3, 2.7],
      [6, 0.9999988498013, 100000.0, 1.3, 2.7],
      [6, 0.9999999423535, 1000000.0, 1.3, 2.7],
      [6, 0.9999999971109, 10000000.0, 1.3, 2.7],
      [6, 0.9999999998552, 100000000.0, 1.3, 2.7],
      [6, 0.9999999999928, 1000000000.0, 1.3, 2.7],
      [6, 0.9999999999997, 10000000000.0, 1.3, 2.7],
    ],
    pareto_Pinv: [
      [6, 10.0, 0.8177057822239537, 1.3, 2.7],
      [6, 100.0, 0.9908636465286981, 1.3, 2.7],
      [6, 1000.0, 0.9995420976278682, 1.3, 2.7],
    ],
    pareto_Q: [
      [6, 3.637247829654e-13, 10000000000.0, 1.3, 2.7],
      [6, 7.25726352471e-12, 1000000000.0, 1.3, 2.7],
      [6, 1.448014442065e-10, 100000000.0, 1.3, 2.7],
      [6, 2.889168647783e-09, 10000000.0, 1.3, 2.7],
      [6, 5.764649324512e-08, 1000000.0, 1.3, 2.7],
      [6, 1.150198755621e-06, 100000.0, 1.3, 2.7],
      [6, 2.294948231815e-05, 10000.0, 1.3, 2.7],
      [6, 0.0004579023721744, 1000.0, 1.3, 2.7],
      [6, 0.009136353471345, 100.0, 1.3, 2.7],
      [6, 0.1822942177761, 10.0, 1.3, 2.7],
      [6, 1.0, 1.0, 1.3, 2.7],
      [6, 1.0, 0.1, 1.3, 2.7],
      [6, 1.0, 0.01, 1.3, 2.7],
      [6, 1.0, 0.001, 1.3, 2.7],
      [6, 1.0, 0.0001, 1.3, 2.7],
      [6, 1.0, 1.0e-05, 1.3, 2.7],
      [6, 1.0, 1.0e-06, 1.3, 2.7],
      [6, 1.0, 1.0e-07, 1.3, 2.7],
      [6, 1.0, 1.0e-08, 1.3, 2.7],
      [6, 1.0, 1.0e-09, 1.3, 2.7],
      [6, 1.0, 1.0e-10, 1.3, 2.7],
      [6, 1.0, 0.0, 1.3, 2.7],
    ],
    pareto_Qinv: [
      [6, 10000000000.0, 3.6372478296536173e-13, 1.3, 2.7],
      [6, 1000000000.0, 7.257263524710211e-12, 1.3, 2.7],
      [6, 100000000.0, 1.4480144420652496e-10, 1.3, 2.7],
      [6, 10000000.0, 2.8891686477834784e-09, 1.3, 2.7],
      [6, 1000000.0, 5.7646493245119715e-08, 1.3, 2.7],
      [6, 100000.0, 1.1501987556209536e-06, 1.3, 2.7],
      [6, 10000.0, 2.294948231814587e-05, 1.3, 2.7],
      [6, 1000.0, 0.0004579023721744107, 1.3, 2.7],
      [6, 100.0, 0.009136353471344562, 1.3, 2.7],
      [6, 10.0, 0.18229421777608898, 1.3, 2.7],
    ],
    logistic_P: [
      [6, 0.0, -10000000000.0, 1.3],
      [6, 0.0, -1000000000.0, 1.3],
      [6, 0.0, -100000000.0, 1.3],
      [6, 0.0, -10000000.0, 1.3],
      [6, 0.0, -1000000.0, 1.3],
      [6, 0.0, -100000.0, 1.3],
      [6, 0.0, -10000.0, 1.3],
      [6, 0.0, -1000.0, 1.3],
      [6, 3.915003559824e-34, -100.0, 1.3],
      [6, 0.0004561157640565, -10.0, 1.3],
      [6, 0.3166455298122, -1.0, 1.3],
      [6, 0.4807787077894, -0.1, 1.3],
      [6, 0.4980769325595, -0.01, 1.3],
      [6, 0.4998076923172, -0.001, 1.3],
      [6, 0.4999807692308, -0.0001, 1.3],
      [6, 0.4999980769231, -1.0e-05, 1.3],
      [6, 0.4999998076923, -1.0e-06, 1.3],
      [6, 0.4999999807692, -1.0e-07, 1.3],
      [6, 0.4999999980769, -1.0e-08, 1.3],
      [6, 0.4999999998077, -1.0e-09, 1.3],
      [6, 0.4999999999808, -1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000192, 1.0e-10, 1.3],
      [6, 0.5000000001923, 1.0e-09, 1.3],
      [6, 0.5000000019231, 1.0e-08, 1.3],
      [6, 0.5000000192308, 1.0e-07, 1.3],
      [6, 0.5000001923077, 1.0e-06, 1.3],
      [6, 0.5000019230769, 1.0e-05, 1.3],
      [6, 0.5000192307692, 0.0001, 1.3],
      [6, 0.5001923076828, 0.001, 1.3],
      [6, 0.5019230674405, 0.01, 1.3],
      [6, 0.5192212922106, 0.1, 1.3],
      [6, 0.6833544701878, 1.0, 1.3],
      [6, 0.9995438842359, 10.0, 1.3],
      [6, 1.0, 100.0, 1.3],
      [6, 1.0, 1000.0, 1.3],
      [6, 1.0, 10000.0, 1.3],
      [6, 1.0, 100000.0, 1.3],
      [6, 1.0, 1000000.0, 1.3],
      [6, 1.0, 10000000.0, 1.3],
      [6, 1.0, 100000000.0, 1.3],
      [6, 1.0, 1000000000.0, 1.3],
      [6, 1.0, 10000000000.0, 1.3],
    ],
    logistic_Pinv: [
      [6, -100.0, 3.915003559824466e-34, 1.3],
      [6, -10.0, 0.00045611576405646045, 1.3],
      [6, -1.0, 0.316645529812217, 1.3],
      [6, -0.1, 0.4807787077893918, 1.3],
      [6, -0.01, 0.4980769325594948, 1.3],
      [6, -0.001, 0.4998076923171749, 1.3],
      [6, 0.0, 0.5, 1.3],
      [6, 0.001, 0.5001923076828251, 1.3],
      [6, 0.01, 0.5019230674405052, 1.3],
      [6, 0.1, 0.5192212922106082, 1.3],
      [6, 1.0, 0.683354470187783, 1.3],
      [6, 10.0, 0.9995438842359435, 1.3],
    ],
    logistic_Q: [
      [6, 0.0, 10000000000.0, 1.3],
      [6, 0.0, 1000000000.0, 1.3],
      [6, 0.0, 100000000.0, 1.3],
      [6, 0.0, 10000000.0, 1.3],
      [6, 0.0, 1000000.0, 1.3],
      [6, 0.0, 100000.0, 1.3],
      [6, 0.0, 10000.0, 1.3],
      [6, 0.0, 1000.0, 1.3],
      [6, 3.915003559824e-34, 100.0, 1.3],
      [6, 0.0004561157640565, 10.0, 1.3],
      [6, 0.3166455298122, 1.0, 1.3],
      [6, 0.4807787077894, 0.1, 1.3],
      [6, 0.4980769325595, 0.01, 1.3],
      [6, 0.4998076923172, 0.001, 1.3],
      [6, 0.4999807692308, 0.0001, 1.3],
      [6, 0.4999980769231, 1.0e-05, 1.3],
      [6, 0.4999998076923, 1.0e-06, 1.3],
      [6, 0.4999999807692, 1.0e-07, 1.3],
      [6, 0.4999999980769, 1.0e-08, 1.3],
      [6, 0.4999999998077, 1.0e-09, 1.3],
      [6, 0.4999999999808, 1.0e-10, 1.3],
      [6, 0.5, 0.0, 1.3],
      [6, 0.5000000000192, -1.0e-10, 1.3],
      [6, 0.5000000001923, -1.0e-09, 1.3],
      [6, 0.5000000019231, -1.0e-08, 1.3],
      [6, 0.5000000192308, -1.0e-07, 1.3],
      [6, 0.5000001923077, -1.0e-06, 1.3],
      [6, 0.5000019230769, -1.0e-05, 1.3],
      [6, 0.5000192307692, -0.0001, 1.3],
      [6, 0.5001923076828, -0.001, 1.3],
      [6, 0.5019230674405, -0.01, 1.3],
      [6, 0.5192212922106, -0.1, 1.3],
      [6, 0.6833544701878, -1.0, 1.3],
      [6, 0.9995438842359, -10.0, 1.3],
      [6, 1.0, -100.0, 1.3],
      [6, 1.0, -1000.0, 1.3],
      [6, 1.0, -10000.0, 1.3],
      [6, 1.0, -100000.0, 1.3],
      [6, 1.0, -1000000.0, 1.3],
      [6, 1.0, -10000000.0, 1.3],
      [6, 1.0, -100000000.0, 1.3],
      [6, 1.0, -1000000000.0, 1.3],
      [6, 1.0, -10000000000.0, 1.3],
    ],
    logistic_Qinv: [
      [6, 100.0, 3.915003559824466e-34, 1.3],
      [6, 10.0, 0.00045611576405646045, 1.3],
      [6, 1.0, 0.316645529812217, 1.3],
      [6, 0.1, 0.4807787077893918, 1.3],
      [6, 0.01, 0.4980769325594948, 1.3],
      [6, 0.001, 0.4998076923171749, 1.3],
      [6, 0.0, 0.5, 1.3],
      [6, -0.001, 0.5001923076828251, 1.3],
      [6, -0.01, 0.5019230674405052, 1.3],
      [6, -0.1, 0.5192212922106082, 1.3],
      [6, -1.0, 0.683354470187783, 1.3],
      [6, -10.0, 0.9995438842359435, 1.3],
    ],
  }.each { |func, tests|
    define_method("test_#{func}") {
      tests.each { |tol, value, *args|
        tol = TEST_TOL[tol] * GSL::DBL_EPSILON if tol.integer?
        assert_rel GSL::Cdf.send(func, *args), value, tol, '%s(%p)' % [func, args]
      }
    }
  }

end
