// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeFix_FixSmallFace_HeaderFile
#define _ShapeFix_FixSmallFace_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_ShapeFix_FixSmallFace.hxx>

#include <TopoDS_Shape.hxx>
#include <Standard_Integer.hxx>
#include <ShapeAnalysis_CheckSmallFace.hxx>
#include <ShapeFix_Root.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
class TopoDS_Shape;
class TopoDS_Face;
class TopoDS_Edge;
class TopoDS_Compound;


//! Fixing face with small size
class ShapeFix_FixSmallFace : public ShapeFix_Root
{

public:

  
  Standard_EXPORT ShapeFix_FixSmallFace();
  
  Standard_EXPORT   void Init (const TopoDS_Shape& S) ;
  

  //! Fixing case of spot face
  Standard_EXPORT   void Perform() ;
  
  //! Fixing case of spot face, if tol = -1 used local tolerance.
  Standard_EXPORT   TopoDS_Shape FixSpotFace() ;
  
  //! Compute average vertex and replacing vertices by new one.
  Standard_EXPORT   Standard_Boolean ReplaceVerticesInCaseOfSpot (TopoDS_Face& F, const Standard_Real tol)  const;
  
  //! Remove spot face from compound
  Standard_EXPORT   Standard_Boolean RemoveFacesInCaseOfSpot (const TopoDS_Face& F)  const;
  
  //! Fixing case of strip face, if tol = -1 used local tolerance
  Standard_EXPORT   TopoDS_Shape FixStripFace (const Standard_Boolean wasdone = Standard_False) ;
  
  //! Replace veretces and edges.
  Standard_EXPORT   Standard_Boolean ReplaceInCaseOfStrip (TopoDS_Face& F, TopoDS_Edge& E1, TopoDS_Edge& E2, const Standard_Real tol)  const;
  
  //! Remove strip face from compound.
  Standard_EXPORT   Standard_Boolean RemoveFacesInCaseOfStrip (const TopoDS_Face& F)  const;
  
  //! Compute average edge for strip face
  Standard_EXPORT   TopoDS_Edge ComputeSharedEdgeForStripFace (const TopoDS_Face& F, const TopoDS_Edge& E1, const TopoDS_Edge& E2, const TopoDS_Face& F1, const Standard_Real tol)  const;
  
  Standard_EXPORT   TopoDS_Shape FixSplitFace (const TopoDS_Shape& S) ;
  
  //! Compute data for face splitting.
  Standard_EXPORT   Standard_Boolean SplitOneFace (TopoDS_Face& F, TopoDS_Compound& theSplittedFaces) ;
  
  Standard_EXPORT   TopoDS_Face FixFace (const TopoDS_Face& F) ;
  
  Standard_EXPORT   TopoDS_Shape FixShape() ;
  
  Standard_EXPORT   TopoDS_Shape Shape() ;
  
  Standard_EXPORT   Standard_Boolean FixPinFace (TopoDS_Face& F) ;




  DEFINE_STANDARD_RTTI(ShapeFix_FixSmallFace)

protected:




private: 


  TopoDS_Shape myShape;
  TopoDS_Shape myResult;
  Standard_Integer myStatus;
  ShapeAnalysis_CheckSmallFace myAnalyzer;


};







#endif // _ShapeFix_FixSmallFace_HeaderFile
