// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _AppParCurves_MultiPoint_HeaderFile
#define _AppParCurves_MultiPoint_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_MMgt_TShared.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Real.hxx>
#include <Standard_OStream.hxx>
class MMgt_TShared;
class Standard_OutOfRange;
class Standard_DimensionError;
class TColgp_Array1OfPnt;
class TColgp_Array1OfPnt2d;
class gp_Pnt;
class gp_Pnt2d;


//! This class describes Points composing a MultiPoint.
//! These points can be 2D or 3D. The user must first give the
//! 3D Points and then the 2D Points.
//! They are Poles of a Bezier Curve.
//! This class is used either to define data input or
//! results when performing the approximation of several lines in parallel.
class AppParCurves_MultiPoint 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! creates an indefinite MultiPoint.
  Standard_EXPORT AppParCurves_MultiPoint();
  
  //! constructs a set of Points used to approximate a
  //! Multiline.
  //! These Points can be of 2 or 3 dimensions.
  //! Points will be initialized with SetPoint and SetPoint2d.
  //! NbPoints is the number of 3D Points.
  //! NbPoints2d is the number of 2D Points.
  Standard_EXPORT AppParCurves_MultiPoint(const Standard_Integer NbPoints, const Standard_Integer NbPoints2d);
  
  //! creates a MultiPoint only composed of 3D points.
  Standard_EXPORT AppParCurves_MultiPoint(const TColgp_Array1OfPnt& tabP);
  
  //! creates a MultiPoint only composed of 2D points.
  Standard_EXPORT AppParCurves_MultiPoint(const TColgp_Array1OfPnt2d& tabP2d);
  
  //! constructs a set of Points used to approximate a
  //! Multiline.
  //! These Points can be of 2 or 3 dimensions.
  //! Points will be initialized with SetPoint and SetPoint2d.
  //! NbPoints is the total number of Points.
  Standard_EXPORT AppParCurves_MultiPoint(const TColgp_Array1OfPnt& tabP, const TColgp_Array1OfPnt2d& tabP2d);
  Standard_EXPORT virtual ~AppParCurves_MultiPoint();
  
  //! the 3d Point of range Index of this MultiPoint is
  //! set to <Point>.
  //! An exception is raised if Index < 0 or
  //! Index > number of 3d Points.
  Standard_EXPORT   void SetPoint (const Standard_Integer Index, const gp_Pnt& Point) ;
  
  //! returns the 3d Point of range Index.
  //! An exception is raised if Index < 0 or
  //! Index < number of 3d Points.
  Standard_EXPORT  const  gp_Pnt& Point (const Standard_Integer Index)  const;
  
  //! The 2d Point of range Index is set to <Point>.
  //! An exception is raised if Index > 3d Points or
  //! Index > total number of Points.
  Standard_EXPORT   void SetPoint2d (const Standard_Integer Index, const gp_Pnt2d& Point) ;
  
  //! returns the 2d Point of range Index.
  //! An exception is raised if index <= number of
  //! 3d Points or Index > total number of Points.
  Standard_EXPORT  const  gp_Pnt2d& Point2d (const Standard_Integer Index)  const;
  
  //! returns the dimension of the point of range Index.
  //! An exception is raised if Index <0 or Index > NbCurves.
      Standard_Integer Dimension (const Standard_Integer Index)  const;
  
  //! returns the number of points of dimension 3D.
      Standard_Integer NbPoints()  const;
  
  //! returns the number of points of dimension 2D.
      Standard_Integer NbPoints2d()  const;
  
  //! Applies a transformation to the curve of range
  //! <CuIndex>.
  //! newx = x + dx*oldx
  //! newy = y + dy*oldy    for all points of the curve.
  //! newz = z + dz*oldz
  Standard_EXPORT   void Transform (const Standard_Integer CuIndex, const Standard_Real x, const Standard_Real dx, const Standard_Real y, const Standard_Real dy, const Standard_Real z, const Standard_Real dz) ;
  
  //! Applies a transformation to the Curve of range
  //! <CuIndex>.
  //! newx = x + dx*oldx
  //! newy = y + dy*oldy    for all points of the curve.
  Standard_EXPORT   void Transform2d (const Standard_Integer CuIndex, const Standard_Real x, const Standard_Real dx, const Standard_Real y, const Standard_Real dy) ;
  
  //! Prints on the stream o information on the current
  //! state of the object.
  //! Is used to redefine the operator <<.
  Standard_EXPORT virtual   void Dump (Standard_OStream& o)  const;




protected:



  Handle(MMgt_TShared) ttabPoint;
  Handle(MMgt_TShared) ttabPoint2d;
  Standard_Integer nbP;
  Standard_Integer nbP2d;


private:





};


#include <AppParCurves_MultiPoint.lxx>





#endif // _AppParCurves_MultiPoint_HeaderFile
