/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.EditorColorChooserAction;

public class DrawingColorChooserAction
extends EditorColorChooserAction {
    public DrawingColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey) {
        this(drawingEditor, attributeKey, null, null);
    }

    public DrawingColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, Icon icon) {
        this(drawingEditor, attributeKey, null, icon);
    }

    public DrawingColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, String string) {
        this(drawingEditor, attributeKey, string, null);
    }

    public DrawingColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, String string, Icon icon) {
        this(drawingEditor, attributeKey, string, icon, new HashMap<AttributeKey, Object>());
    }

    public DrawingColorChooserAction(DrawingEditor drawingEditor, AttributeKey<Color> attributeKey, String string, Icon icon, Map<AttributeKey, Object> map) {
        super(drawingEditor, attributeKey, string, icon, map);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        Color color = this.getInitialColor();
        Color color2 = JColorChooser.showDialog((Component)actionEvent.getSource(), this.labels.getString("attribute.color.text"), color);
        if (color2 != null) {
            HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>(this.attributes);
            hashMap.put(this.key, color2);
            HashSet<Figure> hashSet = new HashSet<Figure>();
            hashSet.add(this.getView().getDrawing());
            this.applyAttributesTo(hashMap, hashSet);
        }
    }

    @Override
    protected Color getInitialColor() {
        Color color = null;
        DrawingView drawingView = this.getEditor().getActiveView();
        if (drawingView != null) {
            Drawing drawing = drawingView.getDrawing();
            color = (Color)drawing.get(this.key);
        }
        if (color == null) {
            color = super.getInitialColor();
        }
        return color;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled());
        } else {
            this.setEnabled(false);
        }
    }
}

