/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NCAL_H_
#define _SOPRANO_NCAL_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk {
    namespace Vocabulary {
        namespace NCAL {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#
             */
            NEPOMUK_EXPORT QUrl ncalNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#
             */
            NEPOMUK_EXPORT QUrl nrlOntologyGraph();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#AccessClassification 
             * 
             * Access classification of a calendar component. Introduced 
             * to express 
             * the set of values for the ncal:class property. The user may use 
             * instances 
             * provided with this ontology or create his/her own with desired 
             * semantics. 
             * See the documentation of ncal:class for details. 
             */
            NEPOMUK_EXPORT QUrl AccessClassification();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Alarm 
             * 
             * Provide a grouping of component properties that define an alarm. 
             */
            NEPOMUK_EXPORT QUrl Alarm();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#AlarmAction 
             * 
             * Action to be performed on alarm. This class has been introduced 
             * to express the limited set of values of the ncal:action property. 
             * Please refer to the documentation of ncal:action for details. 
             */
            NEPOMUK_EXPORT QUrl AlarmAction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Attachment 
             * 
             * An object attached to a calendar entity. This class has been 
             * introduced to serve as a structured value of the ncal:attach 
             * property. See the documentation of ncal:attach for details. 
             */
            NEPOMUK_EXPORT QUrl Attachment();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#AttachmentEncoding 
             * 
             * Attachment encoding. This class has been introduced to express 
             * the limited vocabulary of values for the ncal:encoding property. 
             * See the documentation of ncal:encoding for details. 
             */
            NEPOMUK_EXPORT QUrl AttachmentEncoding();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Attendee 
             * 
             * An attendee of an event. This class has been introduced to serve 
             * as the range for ncal:attendee property. See documentation 
             * of ncal:attendee for details. 
             */
            NEPOMUK_EXPORT QUrl Attendee();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#AttendeeOrOrganizer 
             * 
             * A common superclass for ncal:Attendee and ncal:Organizer. 
             */
            NEPOMUK_EXPORT QUrl AttendeeOrOrganizer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#AttendeeRole 
             * 
             * A role the attendee is going to play during an event. This class 
             * has been introduced to express the limited vocabulary for the 
             * values of ncal:role property. Please refer to the documentation 
             * of ncal:role for details. 
             */
            NEPOMUK_EXPORT QUrl AttendeeRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#BydayRulePart 
             * 
             * Expresses the compound value of a byday part of a recurrence 
             * rule. It stores the weekday and the integer modifier. Inspired 
             * by RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl BydayRulePart();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Calendar 
             * 
             * A calendar. Inspirations for this class can be traced to the 
             * VCALENDAR component defined in RFC 2445 sec. 4.4, but it may 
             * just as well be used to represent any kind of Calendar. 
             */
            NEPOMUK_EXPORT QUrl Calendar();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarDataObject 
             * 
             * A DataObject found in a calendar. It is usually interpreted 
             * as one of the calendar entity types (e.g. Event, Journal, Todo 
             * etc.) 
             */
            NEPOMUK_EXPORT QUrl CalendarDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarScale 
             * 
             * A calendar scale. This class has been introduced to provide 
             * the limited vocabulary for the ncal:calscale property. 
             */
            NEPOMUK_EXPORT QUrl CalendarScale();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarUserType 
             * 
             * A calendar user type. This class has been introduced to express 
             * the limited vocabulary for the ncal:cutype property. See documentation 
             * of ncal:cutype for details. 
             */
            NEPOMUK_EXPORT QUrl CalendarUserType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Event 
             * 
             * Provide a grouping of component properties that describe an 
             * event. 
             */
            NEPOMUK_EXPORT QUrl Event();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#EventStatus 
             * 
             * A status of an event. This class has been introduced to express 
             * the limited set of values for the ncal:status property. The 
             * user may 
             * use the instances provided with this ontology or create his/her 
             * own. 
             * See the documentation for ncal:eventStatus for details. 
             */
            NEPOMUK_EXPORT QUrl EventStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Freebusy 
             * 
             * Provide a grouping of component properties that describe either 
             * a request for free/busy time, describe a response to a request 
             * for free/busy time or describe a published set of busy time. 
             */
            NEPOMUK_EXPORT QUrl Freebusy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#FreebusyPeriod 
             * 
             * An aggregate of a period and a freebusy type. This class has been 
             * introduced to serve as a range of the ncal:freebusy property. 
             * See documentation for ncal:freebusy for details. Note that 
             * the specification of freebusy property states that the period 
             * is to be expressed using UTC time, so the timezone properties 
             * should NOT be used for instances of this class. 
             */
            NEPOMUK_EXPORT QUrl FreebusyPeriod();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#FreebusyType 
             * 
             * Type of a Freebusy indication. This class has been introduced 
             * to serve as a limited set of values for the ncal:fbtype property. 
             * See the documentation of ncal:fbtype for details. 
             */
            NEPOMUK_EXPORT QUrl FreebusyType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Journal 
             * 
             * Provide a grouping of component properties that describe a 
             * journal entry. 
             */
            NEPOMUK_EXPORT QUrl Journal();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#JournalStatus 
             * 
             * A status of a journal entry. This class has been introduced to 
             * express 
             * the limited set of values for the ncal:status property. The 
             * user may 
             * use the instances provided with this ontology or create his/her 
             * own. 
             * See the documentation for ncal:journalStatus for details. 
             */
            NEPOMUK_EXPORT QUrl JournalStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#NcalDateTime 
             */
            NEPOMUK_EXPORT QUrl NcalDateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#NcalPeriod 
             * 
             * A period of time. Inspired by the PERIOD datatype specified 
             * in RFC 2445 sec. 4.3.9 
             */
            NEPOMUK_EXPORT QUrl NcalPeriod();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#NcalTimeEntity 
             * 
             * A time entity. Conceived as a common superclass for NcalDateTime 
             * and NcalPeriod. According to RFC 2445 both DateTime and Period 
             * can be interpreted in different timezones. The first case is 
             * explored in many properties. The second case is theoretically 
             * possible in ncal:rdate property. Therefore the timezone properties 
             * have been defined at this level. 
             */
            NEPOMUK_EXPORT QUrl NcalTimeEntity();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Organizer 
             * 
             * An organizer of an event. This class has been introduced to serve 
             * as a range of ncal:organizer property. See documentation of 
             * ncal:organizer for details. 
             */
            NEPOMUK_EXPORT QUrl Organizer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#ParticipationStatus 
             * 
             * Participation Status. This class has been introduced to express 
             * the limited vocabulary of values for the ncal:partstat property. 
             * See the documentation of ncal:partstat for details. 
             */
            NEPOMUK_EXPORT QUrl ParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#RecurrenceFrequency 
             * 
             * Frequency of a recurrence rule. This class has been introduced 
             * to express a limited set of allowed values for the ncal:freq 
             * property. See the documentation of ncal:freq for details. 
             */
            NEPOMUK_EXPORT QUrl RecurrenceFrequency();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#RecurrenceIdentifier 
             * 
             * Recurrence Identifier. Introduced to provide a structure 
             * for the value of ncal:recurrenceId property. See the documentation 
             * of ncal:recurrenceId for details. 
             */
            NEPOMUK_EXPORT QUrl RecurrenceIdentifier();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#RecurrenceIdentifierRange 
             * 
             * Recurrence Identifier Range. This class has been created to 
             * provide means to express the limited set of values for the ncal:range 
             * property. See documentation for ncal:range for details. 
             */
            NEPOMUK_EXPORT QUrl RecurrenceIdentifierRange();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#RecurrenceRule 
             */
            NEPOMUK_EXPORT QUrl RecurrenceRule();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#RequestStatus 
             * 
             * Request Status. A class that was introduced to provide a structure 
             * for the value of ncal:requestStatus property. See documentation 
             * for ncal:requestStatus for details. 
             */
            NEPOMUK_EXPORT QUrl RequestStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#TimeTransparency 
             * 
             * Time transparency. Introduced to provide a way to express 
             * the limited vocabulary for the values of ncal:transp property. 
             * See documentation of ncal:transp for details. 
             */
            NEPOMUK_EXPORT QUrl TimeTransparency();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Timezone 
             * 
             * Provide a grouping of component properties that defines a time 
             * zone. 
             */
            NEPOMUK_EXPORT QUrl Timezone();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#TimezoneObservance 
             */
            NEPOMUK_EXPORT QUrl TimezoneObservance();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Todo 
             * 
             * Provide a grouping of calendar properties that describe a to-do. 
             */
            NEPOMUK_EXPORT QUrl Todo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#TodoStatus 
             * 
             * A status of a calendar entity. This class has been introduced 
             * to express 
             * the limited set of values for the ncal:status property. The 
             * user may 
             * use the instances provided with this ontology or create his/her 
             * own. 
             * See the documentation for ncal:todoStatus for details. 
             */
            NEPOMUK_EXPORT QUrl TodoStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Trigger 
             * 
             * An alarm trigger. This class has been created to serve as the 
             * range of ncal:trigger property. See the documentation for 
             * ncal:trigger for more details. 
             */
            NEPOMUK_EXPORT QUrl Trigger();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#TriggerRelation 
             * 
             * The relation between the trigger and its parent calendar component. 
             * This class has been introduced to express the limited vocabulary 
             * for the ncal:related property. See the documentation for ncal:related 
             * for more details. 
             */
            NEPOMUK_EXPORT QUrl TriggerRelation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfAlarmEventFreebusyJournalTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfAlarmEventFreebusyJournalTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfAlarmEventFreebusyTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfAlarmEventFreebusyTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfAlarmEventJournalTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfAlarmEventJournalTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfAlarmEventTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfAlarmEventTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfEventFreebusy 
             */
            NEPOMUK_EXPORT QUrl UnionOfEventFreebusy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfEventFreebusyJournalTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfEventFreebusyJournalTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfEventJournalTimezoneTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfEventJournalTimezoneTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfEventJournalTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfEventJournalTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfEventTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfEventTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfTimezoneObservanceEventFreebusyJournalTimezoneTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfTimezoneObservanceEventFreebusyJournalTimezoneTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfTimezoneObservanceEventFreebusyTimezoneTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfTimezoneObservanceEventFreebusyTimezoneTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionOfTimezoneObservanceEventJournalTimezoneTodo 
             */
            NEPOMUK_EXPORT QUrl UnionOfTimezoneObservanceEventJournalTimezoneTodo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#UnionParentClass 
             */
            NEPOMUK_EXPORT QUrl UnionParentClass();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Weekday 
             * 
             * Day of the week. This class has been created to provide the limited 
             * vocabulary for ncal:byday property. See the documentation 
             * for ncal:byday for details. 
             */
            NEPOMUK_EXPORT QUrl Weekday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#_8bitEncoding 
             */
            NEPOMUK_EXPORT QUrl _8bitEncoding();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#acceptedParticipationStatus 
             */
            NEPOMUK_EXPORT QUrl acceptedParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#action 
             * 
             * This property defines the action to be invoked when an alarm 
             * is triggered. Inspired by RFC 2445 sec 4.8.6.1. Originally 
             * this property had a limited set of values. They are expressed 
             * as instances of the AlarmAction class. 
             */
            NEPOMUK_EXPORT QUrl action();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#attach 
             * 
             * The property provides the capability to associate a document 
             * object with a calendar component. Defined in the RFC 2445 sec. 
             * 4.8.1.1 
             */
            NEPOMUK_EXPORT QUrl attach();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#attachmentContent 
             * 
             * The uri of the attachment. Created to express the actual value 
             * of the ATTACH property defined in RFC 2445 sec. 4.8.1.1. This 
             * property expresses the BINARY datatype of that property. see 
             * ncal:attachmentUri for the URI datatype. 
             */
            NEPOMUK_EXPORT QUrl attachmentContent();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#attachmentUri 
             * 
             * The uri of the attachment. Created to express the actual value 
             * of the ATTACH property defined in RFC 2445 sec. 4.8.1.1. This 
             * property expresses the default URI datatype of that property. 
             * see ncal:attachmentContents for the BINARY datatype. 
             */
            NEPOMUK_EXPORT QUrl attachmentUri();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#attendee 
             * 
             * The property defines an "Attendee" within a calendar component. 
             * Inspired by RFC 2445 sec. 4.8.4.1. Originally this property 
             * accepted many parameters. The Attendee class has been introduced 
             * to express them all. Note that NCAL is aligned with NCO. The actual 
             * value (of the CAL-ADDRESS type) is expressed as an instance 
             * of nco:Contact. Remember that the CN parameter has been removed 
             * from NCAL. Instead that value should be expressed using nco:fullname 
             * property of the above mentioned nco:Contact instance. The 
             * RFC stated that whenever this property is attached to a Valarm 
             * instance, the Attendee cannot have any parameters apart from 
             * involvedContact. 
             */
            NEPOMUK_EXPORT QUrl attendee();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#audioAction 
             */
            NEPOMUK_EXPORT QUrl audioAction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#base64Encoding 
             */
            NEPOMUK_EXPORT QUrl base64Encoding();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#busyFreebusyType 
             */
            NEPOMUK_EXPORT QUrl busyFreebusyType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#busyTentativeFreebusyType 
             */
            NEPOMUK_EXPORT QUrl busyTentativeFreebusyType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#busyUnavailableFreebusyType 
             */
            NEPOMUK_EXPORT QUrl busyUnavailableFreebusyType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#byday 
             * 
             * Weekdays the recurrence should occur. Defined in RFC 2445 sec. 
             * 4.3.10 
             */
            NEPOMUK_EXPORT QUrl byday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#bydayModifier 
             * 
             * An integer modifier for the BYDAY rule part. Each BYDAY value 
             * can also be preceded by a positive (+n) or negative (-n) integer. 
             * If present, this indicates the nth occurrence of the specific 
             * day within the MONTHLY or YEARLY RRULE. For example, within 
             * a MONTHLY rule, +1MO (or simply 1MO) represents the first Monday 
             * within the month, whereas -1MO represents the last Monday of 
             * the month. If an integer modifier is not present, it means all 
             * days of this type within the specified frequency. For example, 
             * within a MONTHLY rule, MO represents all Mondays within the 
             * month. Inspired by RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl bydayModifier();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#bydayWeekday 
             * 
             * Connects a BydayRulePath with a weekday. 
             */
            NEPOMUK_EXPORT QUrl bydayWeekday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#byhour 
             * 
             * Hour of recurrence. Defined in RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl byhour();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#byminute 
             * 
             * Minute of recurrence. Defined in RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl byminute();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#bymonth 
             * 
             * Number of the month of the recurrence. Valid values are integers 
             * from 1 (January) to 12 (December). Defined in RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl bymonth();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#bymonthday 
             * 
             * Day of the month when the event should recur. Defined in RFC 2445 
             * sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl bymonthday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#bysecond 
             * 
             * Second of a recurrence. Defined in RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl bysecond();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#bysetpos 
             * 
             * The BYSETPOS rule part specify values which correspond to the 
             * nth occurrence within the set of events specified by the rule. 
             * Valid values are 1 to 366 or -366 to -1. It MUST only be used in conjunction 
             * with another BYxxx rule part. For example "the last work day 
             * of the month" could be represented as: RRULE: FREQ=MONTHLY; 
             * BYDAY=MO, TU, WE, TH, FR; BYSETPOS=-1. Each BYSETPOS value 
             * can include a positive (+n) or negative (-n) integer. If present, 
             * this indicates the nth occurrence of the specific occurrence 
             * within the set of events specified by the rule. Defined in RFC 
             * 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl bysetpos();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#byweekno 
             * 
             * The number of the week an event should recur. Defined in RFC 2445 
             * sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl byweekno();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#byyearday 
             * 
             * Day of the year the event should occur. Defined in RFC 2445 sec. 
             * 4.3.10 
             */
            NEPOMUK_EXPORT QUrl byyearday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#calscale 
             * 
             * This property defines the calendar scale used for the calendar 
             * information specified in the iCalendar object. Defined in 
             * RFC 2445 sec. 4.7.1 
             */
            NEPOMUK_EXPORT QUrl calscale();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#cancelledEventStatus 
             */
            NEPOMUK_EXPORT QUrl cancelledEventStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#cancelledJournalStatus 
             */
            NEPOMUK_EXPORT QUrl cancelledJournalStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#cancelledTodoStatus 
             */
            NEPOMUK_EXPORT QUrl cancelledTodoStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#categories 
             * 
             * Categories for a calendar component. Inspired by RFC 2445 sec 
             * 4.8.1.2 with the following reservations: The LANGUAGE parameter 
             * has been discarded. Please use xml:lang literals to express 
             * multiple languages. This property can specify multiple comma-separated 
             * categories. The order of categories doesn't matter. Please 
             * use a separate triple for each category. 
             */
            NEPOMUK_EXPORT QUrl categories();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#chairRole 
             */
            NEPOMUK_EXPORT QUrl chairRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#class 
             * 
             * Defines the access classification for a calendar component. 
             * Inspired by RFC 2445 sec. 4.8.1.3 with the following reservations: 
             * this property has limited vocabulary. Possible values are: 
             * PUBLIC, PRIVATE and CONFIDENTIAL. The default is PUBLIC. Those 
             * values are expressed as instances of the AccessClassification 
             * class. The user may create his/her own if necessary. 
             */
            NEPOMUK_EXPORT QUrl ncalClass();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#comment 
             * 
             * Non-processing information intended to provide a comment 
             * to the calendar user. Inspired by RFC 2445 sec. 4.8.1.4 with 
             * the following reservations: the LANGUAGE parameter has been 
             * discarded. Please use xml:lang literals to express language. 
             * For the ALTREP parameter use the commentAltRep property. 
             */
            NEPOMUK_EXPORT QUrl comment();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#commentAltRep 
             * 
             * Alternate representation of the comment. Introduced to cover 
             * the ALTREP parameter of the COMMENT property. See 
             * documentation of ncal:comment for details. 
             */
            NEPOMUK_EXPORT QUrl commentAltRep();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#completed 
             * 
             * This property defines the date and time that a to-do was actually 
             * completed. Inspired by RFC 2445 sec. 4.8.2.1. Note that the 
             * RFC allows ONLY UTC time values for this property. 
             */
            NEPOMUK_EXPORT QUrl completed();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#completedParticipationStatus 
             */
            NEPOMUK_EXPORT QUrl completedParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#completedStatus 
             */
            NEPOMUK_EXPORT QUrl completedStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#component 
             * 
             * Links the Vcalendar instance with the calendar components. 
             * This property has no direct equivalent in the RFC specification. 
             * It has been introduced to express the containmnent relations. 
             */
            NEPOMUK_EXPORT QUrl component();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#confidentialClassification 
             */
            NEPOMUK_EXPORT QUrl confidentialClassification();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#confirmedStatus 
             */
            NEPOMUK_EXPORT QUrl confirmedStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#contact 
             * 
             * The property is used to represent contact information or alternately 
             * a reference to contact information associated with the calendar 
             * component. Inspired by RFC 2445 sec. 4.8.4.2 with the following 
             * reservations: the LANGUAGE parameter has been discarded. 
             * Please use xml:lang literals to express language. For the ALTREP 
             * parameter use the contactAltRep property.RFC doesn't define 
             * any format for the string. 
             */
            NEPOMUK_EXPORT QUrl contact();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#contactAltRep 
             * 
             * Alternate representation of the contact property. Introduced 
             * to cover 
             * the ALTREP parameter of the CONTACT property. See 
             * documentation of ncal:contact for details. 
             */
            NEPOMUK_EXPORT QUrl contactAltRep();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#count 
             * 
             * How many times should an event be repeated. Defined in RFC 2445 
             * sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl count();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#created 
             * 
             * This property specifies the date and time that the calendar 
             * information was created by the calendar user agent in the calendar 
             * store. Note: This is analogous to the creation date and time 
             * for a file in the file system. Inspired by RFC 2445 sec. 4.8.7.1. 
             * Note that this property is a subproperty of nie:created. The 
             * domain of nie:created is nie:DataObject. It is not a superclass 
             * of UnionOf_Vevent_Vjournal_Vtodo, but since that union is 
             * conceived as an 'abstract' class, and in real-life all resources 
             * referenced by this property will also be DataObjects, than 
             * this shouldn't cause too much of a problem. Note that RFC allows 
             * ONLY UTC time values for this property. 
             */
            NEPOMUK_EXPORT QUrl created();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#cutype 
             * 
             * To specify the type of calendar user specified by the property. 
             * Inspired by RFC 2445 sec. 4.2.3. This parameter has a limited 
             * vocabulary. The terms that may serve as values for this property 
             * have been expressed as instances of CalendarUserType class. 
             * The user may use instances provided with this ontology or create 
             * his own. 
             */
            NEPOMUK_EXPORT QUrl cutype();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#daily 
             */
            NEPOMUK_EXPORT QUrl daily();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#date 
             * 
             * Date an instance of NcalDateTime refers to. It was conceived 
             * to express values in DATE datatype specified in RFC 2445 4.3.4 
             */
            NEPOMUK_EXPORT QUrl date();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#dateTime 
             * 
             * Representation of a date an instance of NcalDateTime actually 
             * refers to. It's purpose is to express values in DATE-TIME datatype, 
             * as defined in RFC 2445 sec. 4.3.5 
             */
            NEPOMUK_EXPORT QUrl dateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#daylight 
             * 
             * Links a timezone with it's daylight observance. This property 
             * has no direct equivalent in the RFC 2445. It has been inspired 
             * by the structure of the Vtimezone component defined in sec.4.6.5 
             */
            NEPOMUK_EXPORT QUrl daylight();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#declinedParticipationStatus 
             */
            NEPOMUK_EXPORT QUrl declinedParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#delegatedFrom 
             * 
             * To specify the calendar users that have delegated their participation 
             * to the calendar user specified by the property. Inspired by 
             * RFC 2445 sec. 4.2.4. Originally the value type for this property 
             * was CAL-ADDRESS. This has been expressed as nco:Contact to 
             * promote integration between NCAL and NCO. 
             */
            NEPOMUK_EXPORT QUrl delegatedFrom();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#delegatedParticipationStatus 
             */
            NEPOMUK_EXPORT QUrl delegatedParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#delegatedTo 
             * 
             * To specify the calendar users to whom the calendar user specified 
             * by the property has delegated participation. Inspired by RFC 
             * 2445 sec. 4.2.5. Originally the value type for this parameter 
             * was CAL-ADDRESS. This has been expressed as nco:Contact to 
             * promote integration between NCAL and NCO. 
             */
            NEPOMUK_EXPORT QUrl delegatedTo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#description 
             * 
             * A more complete description of the calendar component, than 
             * that provided by the ncal:summary property.Inspired by RFC 
             * 2445 sec. 4.8.1.5 with following reservations: the LANGUAGE 
             * parameter has been discarded. Please use xml:lang literals 
             * to express language. For the ALTREP parameter use the descriptionAltRep 
             * property. 
             */
            NEPOMUK_EXPORT QUrl description();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#descriptionAltRep 
             * 
             * Alternate representation of the calendar entity description. 
             * Introduced to cover 
             * the ALTREP parameter of the DESCRIPTION property. See 
             * documentation of ncal:description for details. 
             */
            NEPOMUK_EXPORT QUrl descriptionAltRep();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#dir 
             * 
             * Specifies a reference to a directory entry associated with 
             * the calendar user specified by the property. Inspired by RFC 
             * 2445 sec. 4.2.6. Originally the data type of the value of this 
             * parameter was URI (Usually an LDAP URI). This has been expressed 
             * as rdfs:resource. 
             */
            NEPOMUK_EXPORT QUrl dir();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#displayAction 
             */
            NEPOMUK_EXPORT QUrl displayAction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#draftStatus 
             */
            NEPOMUK_EXPORT QUrl draftStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#dtend 
             * 
             * This property specifies the date and time that a calendar component 
             * ends. Inspired by RFC 2445 sec. 4.8.2.2 
             */
            NEPOMUK_EXPORT QUrl dtend();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#dtstamp 
             * 
             * The property indicates the date/time that the instance of the 
             * iCalendar object was created. Inspired by RFC 2445 sec. 4.8.7.1. 
             * Note that the RFC allows ONLY UTC values for this property. 
             */
            NEPOMUK_EXPORT QUrl dtstamp();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#dtstart 
             * 
             * This property specifies when the calendar component begins. 
             * Inspired by RFC 2445 sec. 4.8.2.4 
             */
            NEPOMUK_EXPORT QUrl dtstart();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#due 
             * 
             * This property defines the date and time that a to-do is expected 
             * to be completed. Inspired by RFC 2445 sec. 4.8.2.3 
             */
            NEPOMUK_EXPORT QUrl due();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#duration 
             * 
             * The property specifies a positive duration of time. Inspired 
             * by RFC 2445 sec. 4.8.2.5 
             */
            NEPOMUK_EXPORT QUrl duration();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#emailAction 
             */
            NEPOMUK_EXPORT QUrl emailAction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#encoding 
             * 
             * To specify an alternate inline encoding for the property value. 
             * Inspired by RFC 2445 sec. 4.2.7. Originally this property had 
             * a limited vocabulary. ('8BIT' and 'BASE64'). The terms of this 
             * vocabulary have been expressed as instances of the AttachmentEncoding 
             * class 
             */
            NEPOMUK_EXPORT QUrl encoding();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#endTriggerRelation 
             */
            NEPOMUK_EXPORT QUrl endTriggerRelation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#eventStatus 
             * 
             * Defines the overall status or confirmation for an Event. Based 
             * on the STATUS property defined in RFC 2445 sec. 4.8.1.11. 
             */
            NEPOMUK_EXPORT QUrl eventStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#exdate 
             * 
             * This property defines the list of date/time exceptions for 
             * a recurring calendar component. Inspired by RFC 2445 sec. 4.8.5.1 
             */
            NEPOMUK_EXPORT QUrl exdate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#exrule 
             * 
             * This property defines a rule or repeating pattern for an exception 
             * to a recurrence set. Inspired by RFC 2445 sec. 4.8.5.2. 
             */
            NEPOMUK_EXPORT QUrl exrule();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#fbtype 
             * 
             * To specify the free or busy time type. Inspired by RFC 2445 sec. 
             * 4.2.9. The RFC specified a limited vocabulary for the values 
             * of this property. The terms of this vocabulary have been expressed 
             * as instances of the FreebusyType class. The user can use instances 
             * provided with this ontology or create his own. 
             */
            NEPOMUK_EXPORT QUrl fbtype();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#finalStatus 
             */
            NEPOMUK_EXPORT QUrl finalStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#fmttype 
             * 
             * To specify the content type of a referenced object. Inspired 
             * by RFC 2445 sec. 4.2.8. The value of this property should be an 
             * IANA-registered content type (e.g. application/binary) 
             */
            NEPOMUK_EXPORT QUrl fmttype();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#freeFreebusyType 
             */
            NEPOMUK_EXPORT QUrl freeFreebusyType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#freebusy 
             * 
             * The property defines one or more free or busy time intervals. 
             * Inspired by RFC 2445 sec. 4.8.2.6. Note that the periods specified 
             * by this property can only be expressed with UTC times. Originally 
             * this property could have many comma-separated values. Please 
             * use a separate triple for each value. 
             */
            NEPOMUK_EXPORT QUrl freebusy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#freq 
             * 
             * Frequency of a recurrence rule. Defined in RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl freq();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#friday 
             */
            NEPOMUK_EXPORT QUrl friday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#geo 
             * 
             * This property specifies information related to the global 
             * position for the activity specified by a calendar component. 
             * Inspired by RFC 2445 sec. 4.8.1.6 
             */
            NEPOMUK_EXPORT QUrl geo();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#gregorianCalendarScale 
             */
            NEPOMUK_EXPORT QUrl gregorianCalendarScale();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#groupUserType 
             */
            NEPOMUK_EXPORT QUrl groupUserType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#hasAlarm 
             * 
             * Links an event or a todo with a DataObject that can be interpreted 
             * as an alarm. This property has no direct equivalent in the RFC 
             * 2445. It has been provided to express this relation. 
             */
            NEPOMUK_EXPORT QUrl hasAlarm();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#hourly 
             */
            NEPOMUK_EXPORT QUrl hourly();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#inProcessParticipationStatus 
             */
            NEPOMUK_EXPORT QUrl inProcessParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#inProcessStatus 
             */
            NEPOMUK_EXPORT QUrl inProcessStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#individualUserType 
             */
            NEPOMUK_EXPORT QUrl individualUserType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#interval 
             * 
             * The INTERVAL rule part contains a positive integer representing 
             * how often the recurrence rule repeats. The default value is 
             * "1", meaning every second for a SECONDLY rule, or every minute 
             * for a MINUTELY rule, every hour for an HOURLY rule, every day 
             * for a DAILY rule, every week for a WEEKLY rule, every month for 
             * a MONTHLY rule andevery year for a YEARLY rule. Defined in RFC 
             * 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl interval();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#involvedContact 
             * 
             * A contact of the Attendee or the organizer involved in an event 
             * or other calendar entity. This property has been introduced 
             * to express the actual value of the ATTENDEE and ORGANIZER properties. 
             * The contact will also represent the CN parameter of those properties. 
             * See documentation of ncal:attendee or ncal:organizer for 
             * more details. 
             */
            NEPOMUK_EXPORT QUrl involvedContact();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#journalStatus 
             * 
             * Defines the overall status or confirmation for a journal entry. 
             * Based on the STATUS property defined in RFC 2445 sec. 4.8.1.11. 
             */
            NEPOMUK_EXPORT QUrl journalStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#lastModified 
             * 
             * The property specifies the date and time that the information 
             * associated with the calendar component was last revised in 
             * the calendar store. Note: This is analogous to the modification 
             * date and time for a file in the file system. Inspired by RFC 2445 
             * sec. 4.8.7.3. Note that the RFC allows ONLY UTC time values for 
             * this property. 
             */
            NEPOMUK_EXPORT QUrl lastModified();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#location 
             * 
             * Defines the intended venue for the activity defined by a calendar 
             * component. Inspired by RFC 2445 sec 4.8.1.7 with the following 
             * reservations: the LANGUAGE parameter has been discarded. 
             * Please use xml:lang literals to express language. For the ALTREP 
             * parameter use the locationAltRep property. 
             */
            NEPOMUK_EXPORT QUrl location();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#locationAltRep 
             * 
             * Alternate representation of the event or todo location. 
             * Introduced to cover the ALTREP parameter of the LOCATION 
             * property. See documentation of ncal:location for details. 
             */
            NEPOMUK_EXPORT QUrl locationAltRep();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#member 
             * 
             * To specify the group or list membership of the calendar user 
             * specified by the property. Inspired by RFC 2445 sec. 4.2.11. 
             * Originally this parameter had a value type of CAL-ADDRESS. 
             * This has been expressed as nco:Contact to promote integration 
             * between NCAL and NCO 
             */
            NEPOMUK_EXPORT QUrl member();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#method 
             * 
             * This property defines the iCalendar object method associated 
             * with the calendar object. Defined in RFC 2445 sec. 4.7.2 
             */
            NEPOMUK_EXPORT QUrl method();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#minutely 
             */
            NEPOMUK_EXPORT QUrl minutely();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#monday 
             */
            NEPOMUK_EXPORT QUrl monday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#monthly 
             */
            NEPOMUK_EXPORT QUrl monthly();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#ncalRelation 
             * 
             * A common superproperty for all types of ncal relations. It is 
             * not to be used directly. 
             */
            NEPOMUK_EXPORT QUrl ncalRelation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#ncalTimezone 
             * 
             * The timezone instance that should be used to interpret an NcalDateTime. 
             * The purpose of this property is similar to the TZID parameter 
             * specified in RFC 2445 sec. 4.2.19 
             */
            NEPOMUK_EXPORT QUrl ncalTimezone();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#needsActionParticipationStatus 
             */
            NEPOMUK_EXPORT QUrl needsActionParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#needsActionStatus 
             */
            NEPOMUK_EXPORT QUrl needsActionStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#nonParticipantRole 
             */
            NEPOMUK_EXPORT QUrl nonParticipantRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#opaqueTransparency 
             */
            NEPOMUK_EXPORT QUrl opaqueTransparency();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#optParticipantRole 
             */
            NEPOMUK_EXPORT QUrl optParticipantRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#organizer 
             * 
             * The property defines the organizer for a calendar component. 
             * Inspired by RFC 2445 sec. 4.8.4.3. Originally this property 
             * accepted many parameters. The Organizer class has been introduced 
             * to express them all. Note that NCAL is aligned with NCO. The actual 
             * value (of the CAL-ADDRESS type) is expressed as an instance 
             * of nco:Contact. Remember that the CN parameter has been removed 
             * from NCAL. Instead that value should be expressed using nco:fullname 
             * property of the above mentioned nco:Contact instance. 
             */
            NEPOMUK_EXPORT QUrl organizer();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#partstat 
             * 
             * To specify the participation status for the calendar user specified 
             * by the property. Inspired by RFC 2445 sec. 4.2.12. Originally 
             * this parameter had three sets of allowed values. Which set applied 
             * to a particular case - depended on the type of calendar entity 
             * this parameter occured in. (event, todo, journal entry). This 
             * would be awkward to model in RDF so a single ParticipationStatus 
             * class has been introduced. Terms of the values vocabulary are 
             * expressed as instances of this class. Users are advised to pay 
             * attention which instances they use. 
             */
            NEPOMUK_EXPORT QUrl partstat();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#percentComplete 
             * 
             * This property is used by an assignee or delegatee of a to-do to 
             * convey the percent completion of a to-do to the Organizer. Inspired 
             * by RFC 2445 sec. 4.8.1.8 
             */
            NEPOMUK_EXPORT QUrl percentComplete();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#periodBegin 
             * 
             * Beginng of a period. Inspired by the first part of a structured 
             * value of the PERIOD datatype specified in RFC 2445 sec. 4.3.9 
             */
            NEPOMUK_EXPORT QUrl periodBegin();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#periodDuration 
             * 
             * Duration of a period of time. Inspired by the second part of a 
             * structured value of the PERIOD datatype specified in RFC 2445 
             * sec. 4.3.9. Note that a single NcalPeriod instance shouldn't 
             * have the periodEnd and periodDuration properties specified 
             * simultaneously. 
             */
            NEPOMUK_EXPORT QUrl periodDuration();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#periodEnd 
             * 
             * End of a period of time. Inspired by the second part of a structured 
             * value of a PERIOD datatype specified in RFC 2445 sec. 4.3.9. 
             * Note that a single NcalPeriod instance shouldn't have the periodEnd 
             * and periodDuration properties specified simultaneously. 
             */
            NEPOMUK_EXPORT QUrl periodEnd();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#priority 
             * 
             * The property defines the relative priority for a calendar component. 
             * Inspired by RFC 2445 sec. 4.8.1.9 
             */
            NEPOMUK_EXPORT QUrl priority();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#privateClassification 
             */
            NEPOMUK_EXPORT QUrl privateClassification();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#procedureAction 
             */
            NEPOMUK_EXPORT QUrl procedureAction();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#prodid 
             * 
             * This property specifies the identifier for the product that 
             * created the iCalendar object. Defined in RFC 2445 sec. 4.7.2 
             */
            NEPOMUK_EXPORT QUrl prodid();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#publicClassification 
             */
            NEPOMUK_EXPORT QUrl publicClassification();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#range 
             * 
             * To specify the effective range of recurrence instances from 
             * the instance specified by the recurrence identifier specified 
             * by the property. It is intended to express the RANGE parameter 
             * specified in RFC 2445 sec. 4.2.13. The set of possible values 
             * for this property is limited. See also the documentation for 
             * ncal:recurrenceId for more details. 
             */
            NEPOMUK_EXPORT QUrl range();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#rdate 
             * 
             * This property defines the list of date/times for a recurrence 
             * set. Inspired by RFC 2445 sec. 4.8.5.3. Note that RFC allows 
             * both DATE, DATE-TIME and PERIOD values for this property. That's 
             * why the range has been set to NcalTimeEntity. 
             */
            NEPOMUK_EXPORT QUrl rdate();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#recurrenceId 
             * 
             * This property is used in conjunction with the "UID" and "SEQUENCE" 
             * property to identify a specific instance of a recurring "VEVENT", 
             * "VTODO" or "VJOURNAL" calendar component. The property value 
             * is the effective value of the "DTSTART" property of the recurrence 
             * instance. Inspired by the RFC 2445 sec. 4.8.4.4 
             */
            NEPOMUK_EXPORT QUrl recurrenceId();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#recurrenceIdDateTime 
             * 
             * The date and time of a recurrence identifier. Provided to express 
             * the actual value of the ncal:recurrenceId property. See documentation 
             * for ncal:recurrenceId for details. 
             */
            NEPOMUK_EXPORT QUrl recurrenceIdDateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#related 
             * 
             * To specify the relationship of the alarm trigger with respect 
             * to the start or end of the calendar component. Inspired by RFC 
             * 2445 4.2.14. The RFC has specified two possible values for this 
             * property ('START' and 'END') they have been expressed as instances 
             * of the TriggerRelation class. 
             */
            NEPOMUK_EXPORT QUrl related();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#relatedToChild 
             * 
             * The property is used to represent a relationship or reference 
             * between one calendar component and another. Inspired by RFC 
             * 2445 sec. 4.8.4.5. Originally this property had a RELTYPE parameter. 
             * It has been decided to introduce three different properties 
             * to express the values of that parameter. This property expresses 
             * the RELATED-TO property with RELTYPE=CHILD parameter. 
             */
            NEPOMUK_EXPORT QUrl relatedToChild();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#relatedToParent 
             * 
             * The property is used to represent a relationship or reference 
             * between one calendar component and another. Inspired by RFC 
             * 2445 sec. 4.8.4.5. Originally this property had a RELTYPE parameter. 
             * It has been decided that it is more natural to introduce three 
             * different properties to express the values of that parameter. 
             * This property expresses the RELATED-TO property with no RELTYPE 
             * parameter (the default value is PARENT), or with explicit RELTYPE=PARENT 
             * parameter. 
             */
            NEPOMUK_EXPORT QUrl relatedToParent();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#relatedToSibling 
             * 
             * The property is used to represent a relationship or reference 
             * between one calendar component and another. Inspired by RFC 
             * 2445 sec. 4.8.4.5. Originally this property had a RELTYPE parameter. 
             * It has been decided that it is more natural to introduce three 
             * different properties to express the values of that parameter. 
             * This property expresses the RELATED-TO property with RELTYPE=SIBLING 
             * parameter. 
             */
            NEPOMUK_EXPORT QUrl relatedToSibling();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#repeat 
             * 
             * This property defines the number of time the alarm should be 
             * repeated, after the initial trigger. Inspired by RFC 2445 sec. 
             * 4.8.6.2 
             */
            NEPOMUK_EXPORT QUrl repeat();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#reqParticipantRole 
             */
            NEPOMUK_EXPORT QUrl reqParticipantRole();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#requestStatus 
             * 
             * This property defines the status code returned for a scheduling 
             * request. Inspired by RFC 2445 sec. 4.8.8.2. Original value 
             * of this property was a four-element structure. The RequestStatus 
             * class has been introduced to express it. In RFC 2445 this property 
             * could have the LANGUAGE parameter. This has been discarded 
             * in this ontology. Use xml:lang literals to express it if necessary. 
             */
            NEPOMUK_EXPORT QUrl requestStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#requestStatusData 
             * 
             * Additional data associated with a request status. Inspired 
             * by the third part of the structured value for the REQUEST-STATUS 
             * property defined in RFC 2445 sec. 4.8.8.2 ("Textual exception 
             * data. For example, the offending property name and value or 
             * complete property line") 
             */
            NEPOMUK_EXPORT QUrl requestStatusData();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#resourceUserType 
             */
            NEPOMUK_EXPORT QUrl resourceUserType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#resources 
             * 
             * Defines the equipment or resources anticipated for an activity 
             * specified by a calendar entity. Inspired by RFC 2445 sec. 4.8.1.10 
             * with the following reservations: the LANGUAGE parameter has 
             * been discarded. Please use xml:lang literals to express language. 
             * For the ALTREP parameter use the resourcesAltRep property. 
             * This property specifies multiple resources. The order is not 
             * important. it is recommended to introduce a separate triple 
             * for each resource. 
             */
            NEPOMUK_EXPORT QUrl resources();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#resourcesAltRep 
             * 
             * Alternate representation of the resources needed for an event 
             * or todo. Introduced to cover the ALTREP parameter of the resources 
             * property. See documentation for ncal:resources for details. 
             */
            NEPOMUK_EXPORT QUrl resourcesAltRep();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#returnStatus 
             * 
             * Short return status. Inspired by the first element of the structured 
             * value of the REQUEST-STATUS property described in RFC 2445 
             * sec. 4.8.8.2. 
             * 
             * The short return status is a PERIOD character (US-ASCII decimal 
             * 46) separated 3-tuple of integers. For example, "3.1.1". The 
             * successive levels of integers provide for a successive level 
             * of status code granularity. 
             * 
             * The following are initial classes for the return status code. 
             * Individual iCalendar object methods will define specific 
             * return status codes for these classes. In addition, other classes 
             * for the return status code may be defined using the registration 
             * process defined later in this memo. 
             * 
             * 1.xx - Preliminary success. This class of status of status code 
             * indicates that the request has request has been initially processed 
             * but that completion is pending. 
             * 
             * 2.xx -Successful. This class of status code indicates that 
             * the request was completed successfuly. However, the exact 
             * status code can indicate that a fallback has been taken. 
             * 
             * 3.xx - Client Error. This class of status code indicates that 
             * the request was not successful. The error is the result of either 
             * a syntax or a semantic error in the client formatted request. 
             * Request should not be retried until the condition in the request 
             * is corrected. 
             * 
             * 4.xx - Scheduling Error. This class of status code indicates 
             * that the request was not successful. Some sort of error occurred 
             * within the calendaring and scheduling service, not directly 
             * related to the request itself. 
             */
            NEPOMUK_EXPORT QUrl returnStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#role 
             * 
             * To specify the participation role for the calendar user specified 
             * by the property. Inspired by the RFC 2445 sec. 4.2.16. Originally 
             * this property had a limited vocabulary for values. The terms 
             * of that vocabulary have been expressed as instances of the AttendeeRole 
             * class. 
             */
            NEPOMUK_EXPORT QUrl role();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#roomUserType 
             */
            NEPOMUK_EXPORT QUrl roomUserType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#rrule 
             * 
             * This property defines a rule or repeating pattern for recurring 
             * events, to-dos, or time zone definitions. sec. 4.8.5.4 
             */
            NEPOMUK_EXPORT QUrl rrule();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#rsvp 
             * 
             * To specify whether there is an expectation of a favor of a reply 
             * from the calendar user specified by the property value. Inspired 
             * by RFC 2445 sec. 4.2.17 
             */
            NEPOMUK_EXPORT QUrl rsvp();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#saturday 
             */
            NEPOMUK_EXPORT QUrl saturday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#secondly 
             */
            NEPOMUK_EXPORT QUrl secondly();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#sentBy 
             * 
             * To specify the calendar user that is acting on behalf of the calendar 
             * user specified by the property. Inspired by RFC 2445 sec. 4.2.18. 
             * The original data type of this property was a mailto: URI. This 
             * has been changed to nco:Contact to promote integration between 
             * NCO and NCAL. 
             */
            NEPOMUK_EXPORT QUrl sentBy();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#sequence 
             * 
             * This property defines the revision sequence number of the calendar 
             * component within a sequence of revisions. Inspired by RFC 2445 
             * sec. 4.8.7.4 
             */
            NEPOMUK_EXPORT QUrl sequence();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#standard 
             * 
             * Links the timezone with the standard timezone observance. 
             * This property has no direct equivalent in the RFC 2445. It has 
             * been inspired by the structure of the Vtimezone component defined 
             * in sec.4.6.5 
             */
            NEPOMUK_EXPORT QUrl standard();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#startTriggerRelation 
             */
            NEPOMUK_EXPORT QUrl startTriggerRelation();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#statusDescription 
             * 
             * Longer return status description. Inspired by the second part 
             * of the structured value of the REQUEST-STATUS property defined 
             * in RFC 2445 sec. 4.8.8.2 
             */
            NEPOMUK_EXPORT QUrl statusDescription();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#summary 
             * 
             * Defines a short summary or subject for the calendar component. 
             * Inspired by RFC 2445 sec 4.8.1.12 with the following reservations: 
             * the LANGUAGE parameter has been discarded. Please use xml:lang 
             * literals to express language. For the ALTREP parameter use 
             * the summaryAltRep property. 
             */
            NEPOMUK_EXPORT QUrl summary();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#summaryAltRep 
             * 
             * Alternate representation of the comment. Introduced to cover 
             * the ALTREP parameter of the SUMMARY property. See 
             * documentation of ncal:summary for details. 
             */
            NEPOMUK_EXPORT QUrl summaryAltRep();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#sunday 
             */
            NEPOMUK_EXPORT QUrl sunday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tentativeParticipationStatus 
             */
            NEPOMUK_EXPORT QUrl tentativeParticipationStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tentativeStatus 
             */
            NEPOMUK_EXPORT QUrl tentativeStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#thisAndFutureRange 
             */
            NEPOMUK_EXPORT QUrl thisAndFutureRange();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#thisAndPriorRange 
             */
            NEPOMUK_EXPORT QUrl thisAndPriorRange();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#thursday 
             */
            NEPOMUK_EXPORT QUrl thursday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#todoStatus 
             * 
             * Defines the overall status or confirmation for a todo. Based 
             * on the STATUS property defined in RFC 2445 sec. 4.8.1.11. 
             */
            NEPOMUK_EXPORT QUrl todoStatus();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#transp 
             * 
             * Defines whether an event is transparent or not to busy time searches. 
             * Inspired by RFC 2445 sec.4.8.2.7. Values for this property 
             * can be chosen from a limited vocabulary. To express this a TimeTransparency 
             * class has been introduced. 
             */
            NEPOMUK_EXPORT QUrl transp();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#transparentTransparency 
             */
            NEPOMUK_EXPORT QUrl transparentTransparency();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#trigger 
             * 
             * This property specifies when an alarm will trigger. Inspired 
             * by RFC 2445 sec. 4.8.6.3 Originally the value of this property 
             * could accept two types : duration and date-time. To express 
             * this fact a Trigger class has been introduced. It also has a related 
             * property to account for the RELATED parameter. 
             */
            NEPOMUK_EXPORT QUrl trigger();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#triggerDateTime 
             * 
             * The exact date and time of the trigger. This property has been 
             * created to express the VALUE=DATE, and VALUE=DATE-TIME parameters 
             * of the TRIGGER property. See the documentation for ncal:trigger 
             * for more details 
             */
            NEPOMUK_EXPORT QUrl triggerDateTime();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#triggerDuration 
             * 
             * The duration of a trigger. This property has been created to 
             * express the VALUE=DURATION parameter of the TRIGGER property. 
             * See documentation for ncal:trigger for more details. 
             */
            NEPOMUK_EXPORT QUrl triggerDuration();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tuesday 
             */
            NEPOMUK_EXPORT QUrl tuesday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tzid 
             * 
             * This property specifies the text value that uniquely identifies 
             * the "VTIMEZONE" calendar component. Inspired by RFC 2445 sec 
             * 4.8.3.1 
             */
            NEPOMUK_EXPORT QUrl tzid();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tzname 
             * 
             * Specifies the customary designation for a timezone description. 
             * Inspired by RFC 2445 sec. 4.8.3.2 The LANGUAGE parameter has 
             * been discarded. Please xml:lang literals to express languages. 
             * Original specification for the domain of this property stated 
             * that it must appear within the timezone component. In this ontology 
             * the TimezoneObservance class has been itroduced to clarify 
             * this specification. 
             */
            NEPOMUK_EXPORT QUrl tzname();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tzoffsetfrom 
             * 
             * This property specifies the offset which is in use prior to this 
             * time zone observance. Inspired by RFC 2445 sec. 4.8.3.3. The 
             * original domain was underspecified. It said that this property 
             * must appear within a Timezone component. In this ontology a 
             * TimezoneObservance class has been introduced to clarify this 
             * specification. The original range was UTC-OFFSET. There is 
             * no equivalent among the XSD datatypes so plain string was chosen. 
             */
            NEPOMUK_EXPORT QUrl tzoffsetfrom();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tzoffsetto 
             * 
             * This property specifies the offset which is in use in this time 
             * zone observance. nspired by RFC 2445 sec. 4.8.3.4. The original 
             * domain was underspecified. It said that this property must 
             * appear within a Timezone component. In this ontology a TimezoneObservance 
             * class has been introduced to clarify this specification. The 
             * original range was UTC-OFFSET. There is no equivalent among 
             * the XSD datatypes so plain string was chosen. 
             */
            NEPOMUK_EXPORT QUrl tzoffsetto();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#tzurl 
             * 
             * The TZURL provides a means for a VTIMEZONE component to point 
             * to a network location that can be used to retrieve an up-to- date 
             * version of itself. Inspired by RFC 2445 sec. 4.8.3.5. Originally 
             * the range of this property had been specified as URI. 
             */
            NEPOMUK_EXPORT QUrl tzurl();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#uid 
             * 
             * This property defines the persistent, globally unique identifier 
             * for the calendar component. Inspired by the RFC 2445 sec 4.8.4.7 
             */
            NEPOMUK_EXPORT QUrl uid();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#unknownUserType 
             */
            NEPOMUK_EXPORT QUrl unknownUserType();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#until 
             * 
             * The UNTIL rule part defines a date-time value which bounds the 
             * recurrence rule in an inclusive manner. If the value specified 
             * by UNTIL is synchronized with the specified recurrence, this 
             * date or date-time becomes the last instance of the recurrence. 
             * If specified as a date-time value, then it MUST be specified 
             * in an UTC time format. If not present, and the COUNT rule part 
             * is also not present, the RRULE is considered to repeat forever. 
             */
            NEPOMUK_EXPORT QUrl until();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#url 
             * 
             * This property defines a Uniform Resource Locator (URL) associated 
             * with the iCalendar object. Inspired by the RFC 2445 sec. 4.8.4.6. 
             * Original range had been specified as URI. 
             */
            NEPOMUK_EXPORT QUrl url();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#version 
             * 
             * This property specifies the identifier corresponding to the 
             * highest version number or the minimum and maximum range of the 
             * iCalendar specification that is required in order to interpret 
             * the iCalendar object. Defined in RFC 2445 sec. 4.7.4 
             */
            NEPOMUK_EXPORT QUrl version();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#wednesday 
             */
            NEPOMUK_EXPORT QUrl wednesday();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#weekly 
             */
            NEPOMUK_EXPORT QUrl weekly();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#wkst 
             * 
             * The day that's counted as the start of the week. It is used to disambiguate 
             * the byweekno rule. Defined in RFC 2445 sec. 4.3.10 
             */
            NEPOMUK_EXPORT QUrl wkst();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#yearly 
             */
            NEPOMUK_EXPORT QUrl yearly();
        }
    }
}

#endif
