/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.ConfigurationController;
import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Database;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.utils.CommonUtils;
import java.io.File;
import org.simpleframework.xml.core.Persister;

public class DatabaseUtils {
    private static final LanguageController messages = LanguageController.getInstance();

    public static Database load() throws AraraException {
        if (!DatabaseUtils.exists()) {
            return new Database();
        }
        File file = new File(DatabaseUtils.getPath());
        try {
            Persister serializer = new Persister();
            Database database = (Database)((Object)serializer.read(Database.class, file));
            return database;
        }
        catch (Exception exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_LOAD_COULD_NOT_LOAD_XML, file.getName()), exception);
        }
    }

    public static void save(Database database) throws AraraException {
        File file = new File(DatabaseUtils.getPath());
        try {
            Persister serializer = new Persister();
            serializer.write((Object)database, file);
        }
        catch (Exception exception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_SAVE_COULD_NOT_SAVE_XML, file.getName()), exception);
        }
    }

    private static boolean exists() throws AraraException {
        File file = new File(DatabaseUtils.getPath());
        return file.exists();
    }

    private static String getPath() throws AraraException {
        String name = ((String)ConfigurationController.getInstance().get("execution.database.name")).concat(".xml");
        String path = CommonUtils.getParentCanonicalPath(DatabaseUtils.getReference());
        return CommonUtils.buildPath(path, name);
    }

    private static File getReference() {
        return (File)ConfigurationController.getInstance().get("execution.reference");
    }
}

