#!/usr/bin/perl -w
#
# Copyright (c) 2006 Zmanda Inc.  All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Contact information: Zmanda Inc, 505 N Mathlida Ave, Suite 120
# Sunnyvale, CA 94085, USA, or: http://www.zmanda.com
#

# This file contains a template for pre-scheduler plugin that can be used 
# with Zmanda Recovery Manager (ZRM) for MySQL. For more information about the
# product, please see http://mysqlbackup.zmanda.com/
#
# This plugin is executed before starting the backup run. This plugin can
# be used to delay the start time of the backup run or skip a backup run.
#
# Parameters passed to the plugin
# -------------------------------
# Plugin is called with backup set as the parameter. The syntax is 
#            --backup-set <backup set name>
#
# Return values
# -------------
# The plugin should return 0 to instruct mysql-zrm-scheduler(1) to perform 
# MySQL backup immediately.  Return positive numbers (< 11) to instruct 
# mysql-zrm-scheduler(1) to delay the MySQL backup by the value in hours. If a
# number greater than 11 is returned, the backup run will be skipped.
#
#
# How to use this plugin
# ----------------------
# 1. Make modifications to the plugin. The default plugin checks the number 
#    of processes running in the system and delays the backup run based on the
#    the number of processes.
# 2. Modify the mysql-zrm.conf file in the relevant backup-set directory 
#    (/etc/mysql-zrm/<backup set name>/mysql-zrm.conf) and add the 
#    following line to the configuration file.
#
# pre-scheduler-plugin="/usr/share/mysql-zrm/plugins/pre-scheduler-plugin.pl"
#    
# This simple plugin checks the number of processes running in the system.
# If the number of processes greater than 5000, returns 33 ( any number greater # than 11) to instruct mysql-zrm-scheduler(1) to skip this backup.
# If it's greater than 1000, returns 2 to instruct 
# mysql-zrm-scheduler(1) to delay backup by 2 hrs.
# If it's greater than 500,  returns 1 to instruct mysql-zrm-scheduler(1)
# to delay backup by 1 hr.
# Else, returns 0 to instruct mysql-zrm-scheduler to perform backup immediately.

use warnings;

my $oldPATH = $ENV{'PATH'};
$ENV{'PATH'} = "/usr/local/bin:/opt/csw/bin:/usr/bin:/usr/sbin:/sbin:/bin:/usr/ucb";

$num_of_process=`ps -ef |wc -l`;

if ( $num_of_process > 5000 ) {
	exit 33;  # skip the backup 
} elsif ( $num_of_process > 1000 ) {
        exit 2;	  # delay by 2 hours
} elsif ( $num_of_process > 500 ) {
	exit 1;	  # delay by 1 hoiur
} else {
	exit 0;	  # It's ok to do backup
}
