#!/usr/bin/perl
# -*- indent-tabs-mode: nil; -*-
# vim:ft=perl:et:sw=4
# $Id: testlogs.pl.in 12612 2016-01-01 01:48:29Z sikeda $

# Sympa - SYsteme de Multi-Postage Automatique
#
# Copyright (c) 1997, 1998, 1999 Institut Pasteur & Christophe Wolfhugel
# Copyright (c) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
# 2006, 2007, 2008, 2009, 2010, 2011 Comite Reseau des Universites
# Copyright (c) 2011, 2012, 2013, 2014, 2015, 2016 GIP RENATER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

use lib '/usr/local/libdata/perl5/site_perl';
use strict;
use warnings;
use Getopt::Long;

use Conf;
use Sympa::Log;

my %options;
GetOptions(\%main::options, 'debug|d', 'log_level=s', 'config|f=s');
$Conf::sympa_config = $main::options{config};

my $log = Sympa::Log->instance;

## Load configuration file
unless (Conf::load()) {
    printf STDERR "Configuration file %s has errors.\n",
        Conf::get_sympa_conf();
    exit 1;
}

## Open the syslog and say we're read out stuff.
$log->openlog(
    $Conf::Conf{'syslog'},
    $Conf::Conf{'log_socket_type'},
    service => 'sympa/testlogs'
);

# setting log_level using conf unless it is set by calling option
if ($main::options{'log_level'}) {
    $log->syslog(
        'info',
        'Logs seems OK, log level set using options: %s',
        $main::options{'log_level'}
    );
} else {
    $log->{level} = $Conf::Conf{'log_level'};
    $log->syslog(
        'info',
        'Logs seems OK, default log level %s',
        $Conf::Conf{'log_level'}
    );
}
printf "Ok, now check logs \n";
