Ext.namespace('Zarafa.plugins.files.backend.SMB');

/**
 *
 * @class Zarafa.plugins.files.backend.SMB.SMBBackend
 * @extends Zarafa.core.Plugin
 *
 * Plugin for the SMB backend. It requires the main files plugin.
 */
Zarafa.plugins.files.backend.SMB.SMBBackend = Ext.extend(Zarafa.core.Plugin, {

	/**
	 * Constructor
	 * @protected
	 */
	constructor: function (config) {
		config = config || {};

		Zarafa.plugins.files.backend.SMB.SMBBackend.superclass.constructor.call(this, config);
	},

	/**
	 * Initialze all insertion points.
	 */
	initPlugin: function () {
		Zarafa.plugins.files.backend.SMB.SMBBackend.superclass.initPlugin.apply(this, arguments);
	}
});

// Register plugin
Zarafa.onReady(function () {
	container.registerPlugin(new Zarafa.core.PluginMetaData({
		name             : 'filesbackendSMB', // this name must be in format "filesbackend<Backendname>"
		displayName      : dgettext('plugin_filesbackendSMB', 'Files: SMB/CIFS Backend'),
		allowUserDisable : false, // don't allow to disable this plugin - files will get confused if it is disabled
		pluginConstructor: Zarafa.plugins.files.backend.SMB.SMBBackend
	}));
});
