(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/signal-handler#system-signal-handler
    (make-promise
     (lambda ()
       (let ((__obj145714
              (make-object std/os/signal-handler#signal-handler::t '4)))
         (std/os/signal-handler#signal-handler:::init! __obj145714)
         __obj145714))))
  (define std/os/signal-handler#add-signal-handler!
    (lambda (_signo145709_ _thunk145710_)
      (if (and (fx> _signo145709_ '0) (fx< _signo145709_ std/os/signal#SIGMAX))
          '#!void
          (error '"Invalid signal" _signo145709_))
      (let ((_handler145712_
             (force std/os/signal-handler#system-signal-handler)))
        (std/os/signal-handler#signal-handler-add!
         _handler145712_
         _signo145709_
         _thunk145710_))))
  (define std/os/signal-handler#remove-signal-handler!
    (lambda (_signo145705_)
      (if (and (fx> _signo145705_ '0) (fx< _signo145705_ std/os/signal#SIGMAX))
          '#!void
          (error '"Invalid signal" _signo145705_))
      (let ((_handler145707_
             (force std/os/signal-handler#system-signal-handler)))
        (std/os/signal-handler#signal-handler-remove!
         _handler145707_
         _signo145705_))))
  (define std/os/signal-handler#signal-handler::t
    (make-struct-type
     'std/os/signal-handler#signal-handler::t
     '#f
     '4
     'signal-handler
     '((final: . #t))
     ':init!
     '(handlers default-handlers kq mx)))
  (define std/os/signal-handler#signal-handler?
    (make-struct-predicate std/os/signal-handler#signal-handler::t))
  (define std/os/signal-handler#make-signal-handler
    (lambda _$args145702_
      (apply make-struct-instance
             std/os/signal-handler#signal-handler::t
             _$args145702_)))
  (define std/os/signal-handler#signal-handler-handlers
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '0))
  (define std/os/signal-handler#signal-handler-default-handlers
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '1))
  (define std/os/signal-handler#signal-handler-kq
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '2))
  (define std/os/signal-handler#signal-handler-mx
    (make-struct-field-accessor std/os/signal-handler#signal-handler::t '3))
  (define std/os/signal-handler#signal-handler-handlers-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '0))
  (define std/os/signal-handler#signal-handler-default-handlers-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '1))
  (define std/os/signal-handler#signal-handler-kq-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '2))
  (define std/os/signal-handler#signal-handler-mx-set!
    (make-struct-field-mutator std/os/signal-handler#signal-handler::t '3))
  (define std/os/signal-handler#signal-handler:::init!
    (lambda (_self145691_)
      (let* ((_handlers145693_ (make-vector std/os/signal#SIGMAX '#f))
             (_default-handlers145695_ (make-vector std/os/signal#SIGMAX '#f))
             (_kq145697_ (std/os/kqueue#kqueue))
             (_mx145699_ (make-mutex 'signal-handler)))
        (if (##fx< '4 (##vector-length _self145691_))
            (begin
              (##vector-set! _self145691_ '1 _handlers145693_)
              (##vector-set! _self145691_ '2 _default-handlers145695_)
              (##vector-set! _self145691_ '3 _kq145697_)
              (##vector-set! _self145691_ '4 _mx145699_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self145691_))
        (std/logger#start-logger!__0)
        (gerbil/gambit/threads#spawn/name
         'signal-handler
         std/os/signal-handler#signal-handler-wait
         _self145691_))))
  (bind-method!
   std/os/signal-handler#signal-handler::t
   ':init!
   std/os/signal-handler#signal-handler:::init!
   '#f)
  (define std/os/signal-handler#signal-handler-wait
    (lambda (_sh145461_)
      (with-exception-catcher
       (lambda (_g145462145464_)
         (if '#t
             (let ((_e145467_ _g145462145464_))
               (std/logger#log-error '"Error handling signals" _e145467_)
               (raise _e145467_))
             (raise _g145462145464_)))
       (lambda ()
         (letrec* ((_events145512_ (std/os/kqueue#make-kevents '4)))
           (let* ((_sh145513145522_ _sh145461_)
                  (_E145515145526_
                   (lambda () (error '"No clause matching" _sh145513145522_)))
                  (_K145516145546_
                   (lambda (_mx145529_
                            _kq145530_
                            _default-handlers145531_
                            _handlers145532_)
                     (let _wait-loop145534_ ()
                       (##wait-for-io! (std/os/fd#fd-io-in _kq145530_) '#t)
                       (let ((_n145537_
                              (std/os/kqueue#kqueue-poll
                               _kq145530_
                               _events145512_
                               '4)))
                         (if (##fxpositive? _n145537_)
                             (let _event-loop145539_ ((_i145541_ '0))
                               (if (fx< _i145541_ _n145537_)
                                   (begin
                                     (if (##fxzero?
                                          (##fxand (std/os/kqueue#kevent-flags
                                                    _events145512_
                                                    _i145541_)
                                                   std/os/kqueue#EV_ERROR))
                                         (if (fx= (std/os/kqueue#kevent-filter
                                                   _events145512_
                                                   _i145541_)
                                                  std/os/kqueue#EVFILT_SIGNAL)
                                             (let ((_event-handler145544_
                                                    (gerbil/gambit/threads#with-lock
                                                     _mx145529_
                                                     (lambda ()
                                                       (vector-ref
                                                        _handlers145532_
                                                        (std/os/kqueue#kevent-ident
                                                         _events145512_
                                                         _i145541_))))))
                                               (if _event-handler145544_
                                                   (std/os/signal-handler#signal-handler-dispatch
                                                    _event-handler145544_)
                                                   '#!void))
                                             '#!void)
                                         (std/os/error#raise-os-error
                                          (std/os/kqueue#kevent-data
                                           _events145512_
                                           _i145541_)
                                          std/os/signal-handler#signal-handler-wait))
                                     (_event-loop145539_ (fx+ _i145541_ '1)))
                                   '#!void))
                             '#!void))
                       (_wait-loop145534_)))))
             (if (##structure-direct-instance-of?
                  _sh145513145522_
                  'std/os/signal-handler#signal-handler::t)
                 (let* ((_e145517145549_ (##vector-ref _sh145513145522_ '1))
                        (_handlers145552_ _e145517145549_)
                        (_e145518145554_ (##vector-ref _sh145513145522_ '2))
                        (_default-handlers145557_ _e145518145554_)
                        (_e145519145559_ (##vector-ref _sh145513145522_ '3))
                        (_kq145562_ _e145519145559_)
                        (_e145520145564_ (##vector-ref _sh145513145522_ '4))
                        (_mx145567_ _e145520145564_))
                   (_K145516145546_
                    _mx145567_
                    _kq145562_
                    _default-handlers145557_
                    _handlers145552_))
                 (_E145515145526_))))))))
  (define std/os/signal-handler#signal-handler-add!
    (lambda (_sh145411_ _signo145412_ _thunk145413_)
      (let* ((_sh145414145423_ _sh145411_)
             (_E145416145427_
              (lambda () (error '"No clause matching" _sh145414145423_)))
             (_K145417145438_
              (lambda (_mx145430_
                       _kq145431_
                       _default-handlers145432_
                       _handlers145433_)
                (gerbil/gambit/threads#with-lock
                 _mx145430_
                 (lambda ()
                   (let ((_ev145436_ (std/os/kqueue#make-kevents '1)))
                     (vector-set! _handlers145433_ _signo145412_ _thunk145413_)
                     (std/os/kqueue#kqueue-kevent-add__0
                      _kq145431_
                      _signo145412_
                      std/os/kqueue#EVFILT_SIGNAL)
                     (std/os/signal-handler#ignore-signal!
                      _sh145411_
                      _signo145412_)))))))
        (if (##structure-direct-instance-of?
             _sh145414145423_
             'std/os/signal-handler#signal-handler::t)
            (let* ((_e145418145441_ (##vector-ref _sh145414145423_ '1))
                   (_handlers145444_ _e145418145441_)
                   (_e145419145446_ (##vector-ref _sh145414145423_ '2))
                   (_default-handlers145449_ _e145419145446_)
                   (_e145420145451_ (##vector-ref _sh145414145423_ '3))
                   (_kq145454_ _e145420145451_)
                   (_e145421145456_ (##vector-ref _sh145414145423_ '4))
                   (_mx145459_ _e145421145456_))
              (_K145417145438_
               _mx145459_
               _kq145454_
               _default-handlers145449_
               _handlers145444_))
            (_E145416145427_)))))
  (define std/os/signal-handler#signal-handler-remove!
    (lambda (_sh145362_ _signo145363_)
      (let* ((_sh145364145373_ _sh145362_)
             (_E145366145377_
              (lambda () (error '"No clause matching" _sh145364145373_)))
             (_K145367145388_
              (lambda (_mx145380_
                       _kq145381_
                       _default-handlers145382_
                       _handlers145383_)
                (gerbil/gambit/threads#with-lock
                 _mx145380_
                 (lambda ()
                   (let ((_ev145386_ (std/os/kqueue#make-kevents '1)))
                     (std/os/signal-handler#restore-signal!
                      _sh145362_
                      _signo145363_)
                     (std/os/kqueue#kqueue-kevent-del
                      _kq145381_
                      _signo145363_
                      std/os/kqueue#EVFILT_SIGNAL)
                     (vector-set! _handlers145383_ _signo145363_ '#f)))))))
        (if (##structure-direct-instance-of?
             _sh145364145373_
             'std/os/signal-handler#signal-handler::t)
            (let* ((_e145368145391_ (##vector-ref _sh145364145373_ '1))
                   (_handlers145394_ _e145368145391_)
                   (_e145369145396_ (##vector-ref _sh145364145373_ '2))
                   (_default-handlers145399_ _e145369145396_)
                   (_e145370145401_ (##vector-ref _sh145364145373_ '3))
                   (_kq145404_ _e145370145401_)
                   (_e145371145406_ (##vector-ref _sh145364145373_ '4))
                   (_mx145409_ _e145371145406_))
              (_K145367145388_
               _mx145409_
               _kq145404_
               _default-handlers145399_
               _handlers145394_))
            (_E145366145377_)))))
  (define std/os/signal-handler#ignore-signal!
    (lambda (_sh145354_ _signo145355_)
      (let* ((_default-handlers145357_
              (##direct-structure-ref
               _sh145354_
               '2
               std/os/signal-handler#signal-handler::t
               '#f))
             (_default-handler145359_
              (std/os/signal-handler#set-signal!
               _signo145355_
               std/os/signal-handler#SIG_IGN)))
        (if (vector-ref _default-handlers145357_ _signo145355_)
            '#!void
            (vector-set!
             _default-handlers145357_
             _signo145355_
             _default-handler145359_)))))
  (define std/os/signal-handler#restore-signal!
    (lambda (_sh145346_ _signo145347_)
      (let* ((_default-handlers145349_
              (##direct-structure-ref
               _sh145346_
               '2
               std/os/signal-handler#signal-handler::t
               '#f))
             (_default-handler145351_
              (vector-ref _default-handlers145349_ _signo145347_)))
        (if (vector-ref _default-handlers145349_ _signo145347_)
            (std/os/signal-handler#set-signal!
             _signo145347_
             _default-handler145351_)
            '#!void))))
  (c-declare "#include <signal.h>")
  (namespace ("std/os/signal-handler#" SIG_IGN set-signal!))
  (define SIG_IGN
    ((c-lambda () (pointer "void") "___return((void *)SIG_IGN);")))
  (define set-signal!
    (c-lambda
     (int (pointer "void"))
     (pointer "void")
     "___return((void*)signal(___arg1, (void (*)(int))(___arg2)));"))
  (define std/os/signal-handler#signal-handler-dispatch
    (lambda (_handler145337_)
      (with-exception-catcher
       (lambda (_g145338145340_)
         (if '#t
             (let ((_e145343_ _g145338145340_))
               (std/logger#log-error
                '"error dispatching signal handler"
                _e145343_))
             (raise _g145338145340_)))
       (lambda () (_handler145337_))))))
