(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/actor/xdr#opaque::t
    (make-struct-type
     'std/actor/xdr#opaque::t
     '#f
     '2
     'opaque
     '((final: . #t))
     ':init!
     '(e bytes)))
  (define std/actor/xdr#opaque?
    (make-struct-predicate std/actor/xdr#opaque::t))
  (define std/actor/xdr#make-opaque
    (lambda _$args123617_
      (apply make-struct-instance std/actor/xdr#opaque::t _$args123617_)))
  (define std/actor/xdr#opaque-e
    (make-struct-field-accessor std/actor/xdr#opaque::t '0))
  (define std/actor/xdr#opaque-bytes
    (make-struct-field-accessor std/actor/xdr#opaque::t '1))
  (define std/actor/xdr#opaque-e-set!
    (make-struct-field-mutator std/actor/xdr#opaque::t '0))
  (define std/actor/xdr#opaque-bytes-set!
    (make-struct-field-mutator std/actor/xdr#opaque::t '1))
  (define std/actor/xdr#opaque:::init!__%
    (lambda (_self123601_ _e123602_ _bytes123603_)
      (if (##fx< '2 (##vector-length _self123601_))
          (begin
            (##vector-set! _self123601_ '1 _e123602_)
            (##vector-set! _self123601_ '2 _bytes123603_))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self123601_))))
  (define std/actor/xdr#opaque:::init!__0
    (lambda (_self123608_ _e123609_)
      (let ((_bytes123611_ '#f))
        (if (##fx< '2 (##vector-length _self123608_))
            (begin
              (##vector-set! _self123608_ '1 _e123609_)
              (##vector-set! _self123608_ '2 _bytes123611_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self123608_)))))
  (define std/actor/xdr#opaque:::init!
    (lambda _g123741_
      (let ((_g123740_ (length _g123741_)))
        (cond ((##fx= _g123740_ 2)
               (apply std/actor/xdr#opaque:::init!__0 _g123741_))
              ((##fx= _g123740_ 3)
               (apply (lambda (_self123613_ _e123614_ _bytes123615_)
                        (if (##fx< '2 (##vector-length _self123613_))
                            (begin
                              (##vector-set! _self123613_ '1 _e123614_)
                              (##vector-set! _self123613_ '2 _bytes123615_))
                            (error '"struct-instance-init!: too many arguments for struct"
                                   _self123613_)))
                      _g123741_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/xdr#opaque:::init!
                _g123741_))))))
  (bind-method!
   std/actor/xdr#opaque::t
   ':init!
   std/actor/xdr#opaque:::init!
   '#f)
  (define std/actor/xdr#opaque-value
    (lambda (_opq123469_)
      (let ((_$e123471_
             (##direct-structure-ref
              _opq123469_
              '2
              std/actor/xdr#opaque::t
              '#f)))
        (if _$e123471_
            ((lambda (_bytes123474_)
               (let ((_obj123476_ (u8vector->object _bytes123474_)))
                 (##direct-structure-set!
                  _opq123469_
                  _obj123476_
                  '1
                  std/actor/xdr#opaque::t
                  '#f)
                 (##direct-structure-set!
                  _opq123469_
                  '#f
                  '2
                  std/actor/xdr#opaque::t
                  '#f)
                 _obj123476_))
             _$e123471_)
            (##direct-structure-ref
             _opq123469_
             '1
             std/actor/xdr#opaque::t
             '#f)))))
  (define std/actor/xdr#xdr-error::t
    (make-struct-type
     'std/actor/xdr#xdr-error::t
     std/error#io-error::t
     '0
     'xdr-error
     '()
     '#f
     '()))
  (define std/actor/xdr#xdr-error?
    (make-struct-predicate std/actor/xdr#xdr-error::t))
  (define std/actor/xdr#make-xdr-error
    (lambda _$args123466_
      (apply make-struct-instance std/actor/xdr#xdr-error::t _$args123466_)))
  (define std/actor/xdr#raise-xdr-error
    (lambda (_where123462_ _what123463_ . _irritants123464_)
      (raise (make-struct-instance
              std/actor/xdr#xdr-error::t
              _what123463_
              _irritants123464_
              _where123462_))))
  (define std/actor/xdr#xdr-max-rope-length (expt '2 '20))
  (define std/actor/xdr#+xdr-read+ (make-vector '256 '#f))
  (define std/actor/xdr#+xdr-write+ (make-vector '256 '#f))
  (define std/actor/xdr#+xdr-type-tag+ (make-vector '4 false))
  (define std/actor/xdr#+xdr-subtype-tag+ (make-vector '32 false))
  (define std/actor/xdr#+xdr-default-type-registry+ (make-table 'test: eq?))
  (define std/actor/xdr#current-xdr-type-registry
    (make-parameter std/actor/xdr#+xdr-default-type-registry+))
  (define std/actor/xdr#XDR::t
    (make-struct-type
     'std/actor/xdr#XDR::t
     '#f
     '2
     'XDR
     '((final: . #t))
     '#f
     '(read write)))
  (define std/actor/xdr#XDR? (make-struct-predicate std/actor/xdr#XDR::t))
  (define std/actor/xdr#make-XDR
    (lambda _$args123459_
      (apply make-struct-instance std/actor/xdr#XDR::t _$args123459_)))
  (define std/actor/xdr#XDR-read
    (make-struct-field-accessor std/actor/xdr#XDR::t '0))
  (define std/actor/xdr#XDR-write
    (make-struct-field-accessor std/actor/xdr#XDR::t '1))
  (define std/actor/xdr#XDR-read-set!
    (make-struct-field-mutator std/actor/xdr#XDR::t '0))
  (define std/actor/xdr#XDR-write-set!
    (make-struct-field-mutator std/actor/xdr#XDR::t '1))
  (define std/actor/xdr#&XDR-read
    (make-struct-field-unchecked-accessor std/actor/xdr#XDR::t '0))
  (define std/actor/xdr#&XDR-write
    (make-struct-field-unchecked-accessor std/actor/xdr#XDR::t '1))
  (define std/actor/xdr#&XDR-read-set!
    (make-struct-field-unchecked-mutator std/actor/xdr#XDR::t '0))
  (define std/actor/xdr#&XDR-write-set!
    (make-struct-field-unchecked-mutator std/actor/xdr#XDR::t '1))
  (define std/actor/xdr#xdr-read
    (lambda (_buf123448_)
      (let ((_tag123450_ (std/net/bio/input#bio-read-u8 _buf123448_)))
        (if (eof-object? _tag123450_)
            (std/actor/xdr#raise-xdr-error
             'xdr-read
             '"premature end of input"
             _buf123448_)
            (let ((_$e123452_
                   (##vector-ref std/actor/xdr#+xdr-read+ _tag123450_)))
              (if _$e123452_
                  ((lambda (_g123454123456_) (_g123454123456_ _buf123448_))
                   _$e123452_)
                  (std/actor/xdr#raise-xdr-error
                   'xdr-read
                   '"unknown object tag"
                   _tag123450_)))))))
  (define std/actor/xdr#xdr-write
    (lambda (_obj123435_ _buf123436_)
      (let ((_$e123438_ (std/actor/xdr#xdr-object-tag _obj123435_)))
        (if _$e123438_
            ((lambda (_tag123441_)
               (let ((_$e123443_
                      (##vector-ref std/actor/xdr#+xdr-write+ _tag123441_)))
                 (if _$e123443_
                     ((lambda (_writef123446_)
                        (std/net/bio/output#bio-write-u8
                         _tag123441_
                         _buf123436_)
                        (_writef123446_ _obj123435_ _buf123436_))
                      _$e123443_)
                     (std/actor/xdr#raise-xdr-error
                      'xdr-write
                      '"unknown object tag"
                      _tag123441_))))
             _$e123438_)
            (std/actor/xdr#raise-xdr-error
             'xdr-write
             '"cannot serialize object"
             _obj123435_)))))
  (define std/actor/xdr#xdr-tag-void '0)
  (define std/actor/xdr#xdr-tag-null '1)
  (define std/actor/xdr#xdr-tag-false '2)
  (define std/actor/xdr#xdr-tag-true '3)
  (define std/actor/xdr#xdr-tag-eof '4)
  (define std/actor/xdr#xdr-tag-char '5)
  (define std/actor/xdr#xdr-tag-uint '6)
  (define std/actor/xdr#xdr-tag-sint '7)
  (define std/actor/xdr#xdr-tag-flonum '8)
  (define std/actor/xdr#xdr-tag-pair '9)
  (define std/actor/xdr#xdr-tag-vector '10)
  (define std/actor/xdr#xdr-tag-values '11)
  (define std/actor/xdr#xdr-tag-symbol '12)
  (define std/actor/xdr#xdr-tag-keyword '13)
  (define std/actor/xdr#xdr-tag-string '14)
  (define std/actor/xdr#xdr-tag-u8vector '15)
  (define std/actor/xdr#xdr-tag-hash '16)
  (define std/actor/xdr#xdr-tag-object '17)
  (define std/actor/xdr#xdr-tag-ratnum '18)
  (define std/actor/xdr#xdr-tag-cpxnum '19)
  (define std/actor/xdr#xdr-tag-time '20)
  (define std/actor/xdr#xdr-tag-opaque '64)
  (define std/actor/xdr#xdr-tag-hash-equal '0)
  (define std/actor/xdr#xdr-tag-hash-eq '1)
  (define std/actor/xdr#xdr-tag-hash-eqv '2)
  (define std/actor/xdr#xdr-object-tag
    (lambda (_obj123433_)
      ((##vector-ref std/actor/xdr#+xdr-type-tag+ (##type _obj123433_))
       _obj123433_)))
  (define std/actor/xdr#xdr-type-fixnum-tag
    (lambda (_obj123431_)
      (if (##fx< _obj123431_ '0)
          std/actor/xdr#xdr-tag-sint
          std/actor/xdr#xdr-tag-uint)))
  (define std/actor/xdr#xdr-type-subtyped-tag
    (lambda (_obj123429_)
      ((##vector-ref std/actor/xdr#+xdr-subtype-tag+ (##subtype _obj123429_))
       _obj123429_)))
  (define std/actor/xdr#xdr-type-immediate-tag
    (lambda (_obj123427_)
      (if (eq? _obj123427_ '#!void)
          std/actor/xdr#xdr-tag-void
          (if (eq? _obj123427_ '())
              std/actor/xdr#xdr-tag-null
              (if (eq? _obj123427_ '#f)
                  std/actor/xdr#xdr-tag-false
                  (if (eq? _obj123427_ '#t)
                      std/actor/xdr#xdr-tag-true
                      (if (char? _obj123427_)
                          std/actor/xdr#xdr-tag-char
                          (if (eof-object? _obj123427_)
                              std/actor/xdr#xdr-tag-eof
                              '#f))))))))
  (define std/actor/xdr#xdr-subtype-structure-tag
    (lambda (_obj123425_)
      (if (table-ref
           (std/actor/xdr#current-xdr-type-registry)
           (##type-id (##structure-type _obj123425_))
           '#f)
          std/actor/xdr#xdr-tag-object
          (if (table? _obj123425_)
              std/actor/xdr#xdr-tag-hash
              (if (time? _obj123425_)
                  std/actor/xdr#xdr-tag-time
                  (if (##structure-direct-instance-of?
                       _obj123425_
                       'std/actor/xdr#opaque::t)
                      std/actor/xdr#xdr-tag-opaque
                      '#f))))))
  (define std/actor/xdr#xdr-subtype-bigint-tag
    (lambda (_obj123423_)
      (if (< _obj123423_ '0)
          std/actor/xdr#xdr-tag-sint
          std/actor/xdr#xdr-tag-uint)))
  (vector-set!
   std/actor/xdr#+xdr-type-tag+
   (macro-type-fixnum)
   std/actor/xdr#xdr-type-fixnum-tag)
  (vector-set!
   std/actor/xdr#+xdr-type-tag+
   (macro-type-mem1)
   std/actor/xdr#xdr-type-subtyped-tag)
  (vector-set!
   std/actor/xdr#+xdr-type-tag+
   (macro-type-special)
   std/actor/xdr#xdr-type-immediate-tag)
  (vector-set!
   std/actor/xdr#+xdr-type-tag+
   (macro-type-mem2)
   (lambda (_obj123420_) std/actor/xdr#xdr-tag-pair))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-vector)
   (lambda (_obj123417_) std/actor/xdr#xdr-tag-vector))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-pair)
   (lambda (_obj123414_) std/actor/xdr#xdr-tag-pair))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-structure)
   std/actor/xdr#xdr-subtype-structure-tag)
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-boxvalues)
   (lambda (_obj123411_) std/actor/xdr#xdr-tag-values))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-symbol)
   (lambda (_obj123408_) std/actor/xdr#xdr-tag-symbol))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-keyword)
   (lambda (_obj123405_) std/actor/xdr#xdr-tag-keyword))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-string)
   (lambda (_obj123402_) std/actor/xdr#xdr-tag-string))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-u8vector)
   (lambda (_obj123399_) std/actor/xdr#xdr-tag-u8vector))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-flonum)
   (lambda (_obj123396_) std/actor/xdr#xdr-tag-flonum))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-bignum)
   std/actor/xdr#xdr-subtype-bigint-tag)
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-ratnum)
   (lambda (_obj123393_) std/actor/xdr#xdr-tag-ratnum))
  (vector-set!
   std/actor/xdr#+xdr-subtype-tag+
   (macro-subtype-cpxnum)
   (lambda (_obj123390_) std/actor/xdr#xdr-tag-cpxnum))
  (define std/actor/xdr#xdr-read-void (lambda (_buf123388_) '#!void))
  (define std/actor/xdr#xdr-write-void void)
  (define std/actor/xdr#xdr-read-null (lambda (_buf123386_) '()))
  (define std/actor/xdr#xdr-write-null void)
  (define std/actor/xdr#xdr-read-false (lambda (_buf123384_) '#f))
  (define std/actor/xdr#xdr-write-false void)
  (define std/actor/xdr#xdr-read-true (lambda (_buf123382_) '#t))
  (define std/actor/xdr#xdr-write-true void)
  (define std/actor/xdr#xdr-read-eof (lambda (_buf123380_) (eof-object)))
  (define std/actor/xdr#xdr-write-eof void)
  (define std/actor/xdr#xdr-read-char
    (lambda (_buf123378_)
      (integer->char (std/actor/xdr#xdr-read-uint _buf123378_))))
  (define std/actor/xdr#xdr-write-char
    (lambda (_obj123375_ _buf123376_)
      (std/actor/xdr#xdr-write-uint
       (##char->integer _obj123375_)
       _buf123376_)))
  (define std/actor/xdr#xdr-read-flonum
    (lambda (_buf123368_)
      (let* ((_bytes123370_ (make-u8vector '8))
             (_rd123372_
              (std/net/bio/input#bio-read-subu8vector
               _bytes123370_
               '0
               '8
               _buf123368_)))
        (if (##fx= _rd123372_ '8)
            (std/actor/xdr#xdr-bytes->float _bytes123370_)
            (std/actor/xdr#raise-xdr-error
             'xdr-read-flonum
             '"premature end of input"
             _buf123368_)))))
  (define std/actor/xdr#xdr-write-flonum
    (lambda (_obj123363_ _buf123364_)
      (let ((_bytes123366_ (make-u8vector '8)))
        (std/actor/xdr#xdr-float->bytes! _obj123363_ _bytes123366_)
        (std/net/bio/output#bio-write-subu8vector
         _bytes123366_
         '0
         '8
         _buf123364_))))
  (define std/actor/xdr#xdr-read-pair
    (lambda (_buf123356_)
      (let* ((_hd123358_ (std/actor/xdr#xdr-read _buf123356_))
             (_tl123360_ (std/actor/xdr#xdr-read _buf123356_)))
        (cons _hd123358_ _tl123360_))))
  (define std/actor/xdr#xdr-write-pair
    (lambda (_obj123353_ _buf123354_)
      (std/actor/xdr#xdr-write (##car _obj123353_) _buf123354_)
      (std/actor/xdr#xdr-write (##cdr _obj123353_) _buf123354_)))
  (define std/actor/xdr#xdr-read-vector
    (lambda (_buf123341_)
      (let* ((_len123343_ (std/actor/xdr#xdr-read-uint _buf123341_))
             (_g123742_
              (if (##fx<= _len123343_ std/actor/xdr#xdr-max-rope-length)
                  '#!void
                  (std/actor/xdr#raise-xdr-error
                   'xdr-read-vector
                   '"maxium rope length exceeded"
                   _len123343_)))
             (_obj123346_ (make-vector _len123343_)))
        (let _lp123349_ ((_i123351_ '0))
          (if (##fx< _i123351_ _len123343_)
              (begin
                (##vector-set!
                 _obj123346_
                 _i123351_
                 (std/actor/xdr#xdr-read _buf123341_))
                (_lp123349_ (##fx+ _i123351_ '1)))
              _obj123346_)))))
  (define std/actor/xdr#xdr-write-vector
    (lambda (_obj123332_ _buf123333_)
      (let ((_len123335_ (##vector-length _obj123332_)))
        (std/actor/xdr#xdr-write-uint _len123335_ _buf123333_)
        (let _lp123337_ ((_i123339_ '0))
          (if (##fx< _i123339_ _len123335_)
              (begin
                (std/actor/xdr#xdr-write
                 (##vector-ref _obj123332_ _i123339_)
                 _buf123333_)
                (_lp123337_ (##fx+ _i123339_ '1)))
              '#!void)))))
  (define std/actor/xdr#xdr-read-values
    (lambda (_buf123328_)
      (let ((_obj123330_ (std/actor/xdr#xdr-read-vector _buf123328_)))
        (##subtype-set! _obj123330_ (macro-subtype-boxvalues))
        _obj123330_)))
  (define std/actor/xdr#xdr-write-values std/actor/xdr#xdr-write-vector)
  (define std/actor/xdr#xdr-read-symbol
    (lambda (_buf123326_)
      (##string->symbol (std/actor/xdr#xdr-read-string _buf123326_))))
  (define std/actor/xdr#xdr-write-symbol
    (lambda (_obj123323_ _buf123324_)
      (std/actor/xdr#xdr-write-string
       (##symbol->string _obj123323_)
       _buf123324_)))
  (define std/actor/xdr#xdr-read-keyword
    (lambda (_buf123321_)
      (##string->keyword (std/actor/xdr#xdr-read-string _buf123321_))))
  (define std/actor/xdr#xdr-write-keyword
    (lambda (_obj123318_ _buf123319_)
      (std/actor/xdr#xdr-write-string
       (##keyword->string _obj123318_)
       _buf123319_)))
  (define std/actor/xdr#xdr-read-string
    (lambda (_buf123306_)
      (let* ((_len123308_ (std/actor/xdr#xdr-read-uint _buf123306_))
             (_g123743_
              (if (##fx<= _len123308_ std/actor/xdr#xdr-max-rope-length)
                  '#!void
                  (std/actor/xdr#raise-xdr-error
                   'xdr-read-string
                   '"maxium rope length exceeded"
                   _len123308_)))
             (_str123311_ (make-string _len123308_)))
        (let _lp123314_ ((_i123316_ '0))
          (if (##fx< _i123316_ _len123308_)
              (begin
                (##string-set!
                 _str123311_
                 _i123316_
                 (std/actor/xdr#xdr-read-char _buf123306_))
                (_lp123314_ (##fx+ _i123316_ '1)))
              _str123311_)))))
  (define std/actor/xdr#xdr-write-string
    (lambda (_obj123297_ _buf123298_)
      (let ((_len123300_ (##string-length _obj123297_)))
        (std/actor/xdr#xdr-write-uint _len123300_ _buf123298_)
        (let _lp123302_ ((_i123304_ '0))
          (if (##fx< _i123304_ _len123300_)
              (begin
                (std/actor/xdr#xdr-write-char
                 (##string-ref _obj123297_ _i123304_)
                 _buf123298_)
                (_lp123302_ (##fx+ _i123304_ '1)))
              '#!void)))))
  (define std/actor/xdr#xdr-read-u8vector
    (lambda (_buf123289_)
      (let* ((_len123291_ (std/actor/xdr#xdr-read-uint _buf123289_))
             (_g123744_
              (if (##fx<= _len123291_ std/actor/xdr#xdr-max-rope-length)
                  '#!void
                  (std/actor/xdr#raise-xdr-error
                   'xdr-read-u8vector
                   '"maxium rope length exceeded"
                   _len123291_)))
             (_bytes123294_ (make-u8vector _len123291_)))
        (std/net/bio/input#bio-read-bytes _bytes123294_ _buf123289_)
        _bytes123294_)))
  (define std/actor/xdr#xdr-write-u8vector
    (lambda (_obj123286_ _buf123287_)
      (std/actor/xdr#xdr-write-uint
       (##u8vector-length _obj123286_)
       _buf123287_)
      (std/net/bio/output#bio-write-bytes _obj123286_ _buf123287_)))
  (define std/actor/xdr#xdr-read-hash
    (lambda (_buf123277_)
      (let* ((_htype123279_ (std/net/bio/input#bio-read-u8 _buf123277_))
             (_makef123281_
              (if (##fx= _htype123279_ std/actor/xdr#xdr-tag-hash-equal)
                  list->hash-table
                  (if (##fx= _htype123279_ std/actor/xdr#xdr-tag-hash-eq)
                      list->hash-table-eq
                      (if (##fx= _htype123279_ std/actor/xdr#xdr-tag-hash-eqv)
                          list->hash-table-eqv
                          (std/actor/xdr#raise-xdr-error
                           'xdr-read-hash
                           '"unknown hash table type"
                           _htype123279_)))))
             (_lst123283_ (std/actor/xdr#xdr-read-inline-list _buf123277_)))
        (_makef123281_ _lst123283_))))
  (define std/actor/xdr#xdr-write-hash
    (lambda (_obj123260_ _buf123261_)
      (let ((_testf123263_ (##vector-ref _obj123260_ '2)))
        (if (or (not _testf123263_)
                (eq? _testf123263_ eq?)
                (eq? _testf123263_ ##eq?))
            (std/net/bio/output#bio-write-u8
             std/actor/xdr#xdr-tag-hash-eq
             _buf123261_)
            (if (or (eq? _testf123263_ eqv?) (eq? _testf123263_ ##eqv?))
                (std/net/bio/output#bio-write-u8
                 std/actor/xdr#xdr-tag-hash-eqv
                 _buf123261_)
                (if (or (eq? _testf123263_ equal?)
                        (eq? _testf123263_ ##equal?))
                    (std/net/bio/output#bio-write-u8
                     std/actor/xdr#xdr-tag-hash-equal
                     _buf123261_)
                    (std/actor/xdr#raise-xdr-error
                     'xdr-wrie-hash
                     '"unknown hash test function"
                     _testf123263_))))
        (std/actor/xdr#xdr-write-inline-list
         (table->list _obj123260_)
         _buf123261_))))
  (define std/actor/xdr#xdr-read-object
    (lambda (_buf123251_)
      (let* ((_tid123253_ (std/actor/xdr#xdr-read-symbol _buf123251_))
             (_$e123255_
              (table-ref
               (std/actor/xdr#current-xdr-type-registry)
               _tid123253_
               '#f)))
        (if _$e123255_
            ((lambda (_xdr123258_)
               ((##unchecked-structure-ref
                 _xdr123258_
                 '1
                 std/actor/xdr#XDR::t
                 '#f)
                _buf123251_))
             _$e123255_)
            (std/actor/xdr#raise-xdr-error
             'xdr-read-object
             '"unknown type id"
             _tid123253_)))))
  (define std/actor/xdr#xdr-write-object
    (lambda (_obj123241_ _buf123242_)
      (let* ((_tid123244_ (##type-id (##structure-type _obj123241_)))
             (_$e123246_
              (table-ref
               (std/actor/xdr#current-xdr-type-registry)
               _tid123244_
               '#f)))
        (if _$e123246_
            ((lambda (_xdr123249_)
               (std/actor/xdr#xdr-write-symbol _tid123244_ _buf123242_)
               ((##unchecked-structure-ref
                 _xdr123249_
                 '2
                 std/actor/xdr#XDR::t
                 '#f)
                _obj123241_
                _buf123242_))
             _$e123246_)
            (std/actor/xdr#raise-xdr-error
             'xdr-write-object
             '"unknown type id"
             _tid123244_)))))
  (define std/actor/xdr#xdr-read-opaque
    (lambda (_buf123237_)
      (let* ((_bytes123239_ (std/actor/xdr#xdr-read-u8vector _buf123237_))
             (__obj123739 (make-object std/actor/xdr#opaque::t '2)))
        (if (##fx< '2 (##vector-length __obj123739))
            (begin
              (##vector-set! __obj123739 '1 '#f)
              (##vector-set! __obj123739 '2 _bytes123239_))
            (error '"struct-instance-init!: too many arguments for struct"
                   __obj123739))
        __obj123739)))
  (define std/actor/xdr#xdr-write-opaque
    (lambda (_obj123229_ _buf123230_)
      (let ((_bytes123235_
             (let ((_$e123232_
                    (##direct-structure-ref
                     _obj123229_
                     '2
                     std/actor/xdr#opaque::t
                     '#f)))
               (if _$e123232_
                   _$e123232_
                   (object->u8vector
                    (##direct-structure-ref
                     _obj123229_
                     '1
                     std/actor/xdr#opaque::t
                     '#f))))))
        (std/actor/xdr#xdr-write-u8vector _bytes123235_ _buf123230_))))
  (define std/actor/xdr#xdr-read-uint
    (lambda (_buf123202_)
      (let ((_bits123204_ (std/net/bio/input#bio-read-u8 _buf123202_)))
        (if (##fxzero? (##fxand _bits123204_ '128))
            _bits123204_
            (let _lp123206_ ((_val123208_ (##fxand _bits123204_ '127))
                             (_shift123209_ '7))
              (let ((_bits123211_ (std/net/bio/input#bio-read-u8 _buf123202_)))
                (if (##fxzero? (##fxand _bits123211_ '128))
                    (let ((_$e123213_
                           (##fxarithmetic-shift-left?
                            _bits123211_
                            _shift123209_)))
                      (if _$e123213_
                          ((lambda (_bits123216_)
                             (##fxior _bits123216_ _val123208_))
                           _$e123213_)
                          (let ((_bits123218_
                                 (arithmetic-shift
                                  _bits123211_
                                  _shift123209_)))
                            (bitwise-ior _bits123218_ _val123208_))))
                    (let* ((_bits123220_ (##fxand _bits123211_ '127))
                           (_$e123222_
                            (##fxarithmetic-shift-left?
                             _bits123220_
                             _shift123209_)))
                      (if _$e123222_
                          ((lambda (_bits123225_)
                             (_lp123206_
                              (##fxior _bits123225_ _val123208_)
                              (##fx+ _shift123209_ '7)))
                           _$e123222_)
                          (let ((_bits123227_
                                 (arithmetic-shift
                                  _bits123220_
                                  _shift123209_)))
                            (_lp123206_
                             (bitwise-ior _bits123227_ _val123208_)
                             (##fx+ _shift123209_ '7))))))))))))
  (define std/actor/xdr#xdr-write-uint
    (lambda (_obj123191_ _buf123192_)
      (if (fixnum? _obj123191_)
          (let _lp123194_ ((_val123196_ _obj123191_))
            (if (##fx> _val123196_ '127)
                (let ((_bits123198_ (##fxior (##fxand _val123196_ '127) '128)))
                  (std/net/bio/output#bio-write-u8 _bits123198_ _buf123192_)
                  (_lp123194_ (##fxarithmetic-shift-right _val123196_ '7)))
                (std/net/bio/output#bio-write-u8 _val123196_ _buf123192_)))
          (let ((_bits123200_ (##fxior (bitwise-and _obj123191_ '127) '128)))
            (std/net/bio/output#bio-write-u8 _bits123200_ _buf123192_)
            (std/actor/xdr#xdr-write-uint
             (arithmetic-shift _obj123191_ '-7)
             _buf123192_)))))
  (define std/actor/xdr#xdr-read-sint
    (lambda (_buf123189_) (- (std/actor/xdr#xdr-read-uint _buf123189_))))
  (define std/actor/xdr#xdr-write-sint
    (lambda (_obj123186_ _buf123187_)
      (std/actor/xdr#xdr-write-uint (- _obj123186_) _buf123187_)))
  (define std/actor/xdr#xdr-read-ratnum
    (lambda (_buf123179_)
      (let* ((_num123181_ (std/actor/xdr#xdr-read _buf123179_))
             (_den123183_ (std/actor/xdr#xdr-read _buf123179_)))
        (if (and (integer? _num123181_)
                 (exact? _num123181_)
                 (integer? _den123183_)
                 (exact? _den123183_))
            (##ratnum-make _num123181_ _den123183_)
            (std/actor/xdr#raise-xdr-error
             'xdr-read-ratnum
             '"malformed rational number"
             _num123181_
             _den123183_)))))
  (define std/actor/xdr#xdr-write-ratnum
    (lambda (_obj123176_ _buf123177_)
      (std/actor/xdr#xdr-write (##ratnum-numerator _obj123176_) _buf123177_)
      (std/actor/xdr#xdr-write
       (##ratnum-denominator _obj123176_)
       _buf123177_)))
  (define std/actor/xdr#xdr-read-cpxnum
    (lambda (_buf123169_)
      (let* ((_real123171_ (std/actor/xdr#xdr-read _buf123169_))
             (_imag123173_ (std/actor/xdr#xdr-read _buf123169_)))
        (if (and (real? _real123171_) (real? _imag123173_))
            (##cpxnum-make _real123171_ _imag123173_)
            (std/actor/xdr#raise-xdr-error
             'xdr-read-cpxnum
             '"malformed complex number"
             _real123171_
             _imag123173_)))))
  (define std/actor/xdr#xdr-write-cpxnum
    (lambda (_obj123166_ _buf123167_)
      (std/actor/xdr#xdr-write (##cpxnum-real _obj123166_) _buf123167_)
      (std/actor/xdr#xdr-write (##cpxnum-imag _obj123166_) _buf123167_)))
  (define std/actor/xdr#xdr-read-time
    (lambda (_buf123164_)
      (seconds->time (std/actor/xdr#xdr-read-flonum _buf123164_))))
  (define std/actor/xdr#xdr-write-time
    (lambda (_tm123161_ _buf123162_)
      (std/actor/xdr#xdr-write-flonum (time->seconds _tm123161_) _buf123162_)))
  (define std/actor/xdr#xdr-read-inline-list
    (lambda (_buf123153_)
      (let _lp123155_ ((_r123157_ '()))
        (let ((_next123159_ (std/actor/xdr#xdr-read _buf123153_)))
          (if (null? _next123159_)
              (std/srfi/1#reverse! _r123157_)
              (_lp123155_ (cons _next123159_ _r123157_)))))))
  (define std/actor/xdr#xdr-write-inline-list
    (lambda (_lst123146_ _buf123147_)
      (let _lp123149_ ((_rest123151_ _lst123146_))
        (if (pair? _rest123151_)
            (begin
              (std/actor/xdr#xdr-write (##car _rest123151_) _buf123147_)
              (_lp123149_ (##cdr _rest123151_)))
            (std/net/bio/output#bio-write-u8
             std/actor/xdr#xdr-tag-null
             _buf123147_)))))
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-void
   std/actor/xdr#xdr-read-void)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-null
   std/actor/xdr#xdr-read-null)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-false
   std/actor/xdr#xdr-read-false)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-true
   std/actor/xdr#xdr-read-true)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-eof
   std/actor/xdr#xdr-read-eof)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-char
   std/actor/xdr#xdr-read-char)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-uint
   std/actor/xdr#xdr-read-uint)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-sint
   std/actor/xdr#xdr-read-sint)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-flonum
   std/actor/xdr#xdr-read-flonum)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-pair
   std/actor/xdr#xdr-read-pair)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-vector
   std/actor/xdr#xdr-read-vector)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-values
   std/actor/xdr#xdr-read-values)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-symbol
   std/actor/xdr#xdr-read-symbol)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-keyword
   std/actor/xdr#xdr-read-keyword)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-string
   std/actor/xdr#xdr-read-string)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-u8vector
   std/actor/xdr#xdr-read-u8vector)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-hash
   std/actor/xdr#xdr-read-hash)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-object
   std/actor/xdr#xdr-read-object)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-ratnum
   std/actor/xdr#xdr-read-ratnum)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-cpxnum
   std/actor/xdr#xdr-read-cpxnum)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-time
   std/actor/xdr#xdr-read-time)
  (vector-set!
   std/actor/xdr#+xdr-read+
   std/actor/xdr#xdr-tag-opaque
   std/actor/xdr#xdr-read-opaque)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-void
   std/actor/xdr#xdr-write-void)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-null
   std/actor/xdr#xdr-write-null)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-false
   std/actor/xdr#xdr-write-false)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-true
   std/actor/xdr#xdr-write-true)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-eof
   std/actor/xdr#xdr-write-eof)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-char
   std/actor/xdr#xdr-write-char)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-uint
   std/actor/xdr#xdr-write-uint)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-sint
   std/actor/xdr#xdr-write-sint)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-flonum
   std/actor/xdr#xdr-write-flonum)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-pair
   std/actor/xdr#xdr-write-pair)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-vector
   std/actor/xdr#xdr-write-vector)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-values
   std/actor/xdr#xdr-write-values)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-symbol
   std/actor/xdr#xdr-write-symbol)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-keyword
   std/actor/xdr#xdr-write-keyword)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-string
   std/actor/xdr#xdr-write-string)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-u8vector
   std/actor/xdr#xdr-write-u8vector)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-hash
   std/actor/xdr#xdr-write-hash)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-object
   std/actor/xdr#xdr-write-object)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-ratnum
   std/actor/xdr#xdr-write-ratnum)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-cpxnum
   std/actor/xdr#xdr-write-cpxnum)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-time
   std/actor/xdr#xdr-write-time)
  (vector-set!
   std/actor/xdr#+xdr-write+
   std/actor/xdr#xdr-tag-opaque
   std/actor/xdr#xdr-write-opaque)
  (define std/actor/xdr#xdr-read-struct
    (lambda (_klass123133_ _buf123134_)
      (let ((_fields123136_ (std/actor/xdr#xdr-read-uint _buf123134_)))
        (if (##fx= _fields123136_ (type-descriptor-fields _klass123133_))
            (let ((_obj123138_ (make-object _klass123133_ _fields123136_)))
              (let _lp123140_ ((_i123142_ '0))
                (if (##fx< _i123142_ _fields123136_)
                    (let ((_i+1123144_ (##fx+ _i123142_ '1)))
                      (##vector-set!
                       _obj123138_
                       _i+1123144_
                       (std/actor/xdr#xdr-read _buf123134_))
                      (_lp123140_ _i+1123144_))
                    _obj123138_)))
            (std/actor/xdr#raise-xdr-error
             'xdr-read-struct
             '"type descriptor field mismatch"
             _klass123133_
             _fields123136_)))))
  (define std/actor/xdr#xdr-write-struct
    (lambda (_obj123121_ _buf123122_)
      (let* ((_len123124_ (##vector-length _obj123121_))
             (_fields123126_ (##fx- _len123124_ '1)))
        (std/actor/xdr#xdr-write-uint _fields123126_ _buf123122_)
        (let _lp123129_ ((_i123131_ '1))
          (if (##fx< _i123131_ _len123124_)
              (begin
                (std/actor/xdr#xdr-write
                 (##vector-ref _obj123121_ _i123131_)
                 _buf123122_)
                (_lp123129_ (##fx+ _i123131_ '1)))
              '#!void)))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (c-declare "#include <stdlib.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace ("std/actor/xdr#" xdr-float->bytes! xdr-bytes->float))
  (c-declare
   "static double ffi_xdr_read_float_bytes (___SCMOBJ bytes)\n{\n return *(double*)(U8_DATA (bytes));\n}\n\nstatic int ffi_xdr_write_float_bytes (double val, ___SCMOBJ bytes)\n{\n *(double*)(U8_DATA (bytes)) = val;\n  return 0;\n}")
  (define-c-lambda
   std/actor/xdr#xdr-float->bytes!
   (double scheme-object)
   int
   "ffi_xdr_write_float_bytes")
  (define-c-lambda
   std/actor/xdr#xdr-bytes->float
   (scheme-object)
   double
   "ffi_xdr_read_float_bytes")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
