/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawTextShape;
import org.apache.poi.sl.usermodel.TableShape;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTableStyle;
import org.apache.poi.xslf.usermodel.XSLFTableStyles;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTable;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTableRow;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrameNonVisual;

public class XSLFTable
extends XSLFGraphicFrame
implements Iterable<XSLFTableRow>,
TableShape<XSLFShape, XSLFTextParagraph> {
    static final String TABLE_URI = "http://schemas.openxmlformats.org/drawingml/2006/table";
    private CTTable _table;
    private List<XSLFTableRow> _rows;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XSLFTable(CTGraphicalObjectFrame shape, XSLFSheet sheet) {
        super(shape, sheet);
        CTGraphicalObjectData god = shape.getGraphic().getGraphicData();
        XmlCursor xc = god.newCursor();
        try {
            if (!xc.toChild("http://schemas.openxmlformats.org/drawingml/2006/main", "tbl")) {
                throw new IllegalStateException("a:tbl element was not found in\n " + god);
            }
            XmlObject xo = xc.getObject();
            if (xo instanceof XmlAnyTypeImpl) {
                String errStr = "Schemas (*.xsb) for CTTable can't be loaded - usually this happens when OSGI loading is used and the thread context classloader has no reference to the xmlbeans classes";
                throw new IllegalStateException(errStr);
            }
            this._table = (CTTable)xo;
        }
        finally {
            xc.dispose();
        }
        this._rows = new ArrayList<XSLFTableRow>(this._table.sizeOfTrArray());
        for (CTTableRow row : this._table.getTrList()) {
            this._rows.add(new XSLFTableRow(row, this));
        }
        this.updateRowColIndexes();
    }

    public XSLFTableCell getCell(int row, int col) {
        List<XSLFTableRow> rows = this.getRows();
        if (row < 0 || rows.size() <= row) {
            return null;
        }
        XSLFTableRow r = rows.get(row);
        if (r == null) {
            return null;
        }
        List<XSLFTableCell> cells = r.getCells();
        if (col < 0 || cells.size() <= col) {
            return null;
        }
        return cells.get(col);
    }

    @Internal
    public CTTable getCTTable() {
        return this._table;
    }

    public int getNumberOfColumns() {
        return this._table.getTblGrid().sizeOfGridColArray();
    }

    public int getNumberOfRows() {
        return this._table.sizeOfTrArray();
    }

    public double getColumnWidth(int idx) {
        return Units.toPoints((long)this._table.getTblGrid().getGridColArray(idx).getW());
    }

    public void setColumnWidth(int idx, double width) {
        this._table.getTblGrid().getGridColArray(idx).setW((long)Units.toEMU((double)width));
    }

    public double getRowHeight(int row) {
        return Units.toPoints((long)this._table.getTrArray(row).getH());
    }

    public void setRowHeight(int row, double height) {
        this._table.getTrArray(row).setH((long)Units.toEMU((double)height));
    }

    @Override
    public Iterator<XSLFTableRow> iterator() {
        return this._rows.iterator();
    }

    public List<XSLFTableRow> getRows() {
        return Collections.unmodifiableList(this._rows);
    }

    public XSLFTableRow addRow() {
        CTTableRow tr = this._table.addNewTr();
        XSLFTableRow row = new XSLFTableRow(tr, this);
        row.setHeight(20.0);
        this._rows.add(row);
        this.updateRowColIndexes();
        return row;
    }

    static CTGraphicalObjectFrame prototype(int shapeId) {
        CTGraphicalObjectFrame frame = CTGraphicalObjectFrame.Factory.newInstance();
        CTGraphicalObjectFrameNonVisual nvGr = frame.addNewNvGraphicFramePr();
        CTNonVisualDrawingProps cnv = nvGr.addNewCNvPr();
        cnv.setName("Table " + shapeId);
        cnv.setId((long)shapeId);
        nvGr.addNewCNvGraphicFramePr().addNewGraphicFrameLocks().setNoGrp(true);
        nvGr.addNewNvPr();
        frame.addNewXfrm();
        CTGraphicalObjectData gr = frame.addNewGraphic().addNewGraphicData();
        XmlCursor grCur = gr.newCursor();
        grCur.toNextToken();
        grCur.beginElement(new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "tbl"));
        CTTable tbl = CTTable.Factory.newInstance();
        tbl.addNewTblPr();
        tbl.addNewTblGrid();
        XmlCursor tblCur = tbl.newCursor();
        tblCur.moveXmlContents(grCur);
        tblCur.dispose();
        grCur.dispose();
        gr.setUri(TABLE_URI);
        return frame;
    }

    public void mergeCells(int firstRow, int lastRow, int firstCol, int lastCol) {
        if (firstRow > lastRow) {
            throw new IllegalArgumentException("Cannot merge, first row > last row : " + firstRow + " > " + lastRow);
        }
        if (firstCol > lastCol) {
            throw new IllegalArgumentException("Cannot merge, first column > last column : " + firstCol + " > " + lastCol);
        }
        int rowSpan = lastRow - firstRow + 1;
        boolean mergeRowRequired = rowSpan > 1;
        int colSpan = lastCol - firstCol + 1;
        boolean mergeColumnRequired = colSpan > 1;
        for (int i = firstRow; i <= lastRow; ++i) {
            XSLFTableRow row = this._rows.get(i);
            for (int colPos = firstCol; colPos <= lastCol; ++colPos) {
                XSLFTableCell cell = row.getCells().get(colPos);
                if (mergeRowRequired) {
                    if (i == firstRow) {
                        cell.setRowSpan(rowSpan);
                    } else {
                        cell.setVMerge();
                    }
                }
                if (!mergeColumnRequired) continue;
                if (colPos == firstCol) {
                    cell.setGridSpan(colSpan);
                    continue;
                }
                cell.setHMerge();
            }
        }
    }

    protected XSLFTableStyle getTableStyle() {
        CTTable tab = this.getCTTable();
        if (!tab.isSetTblPr() || !tab.getTblPr().isSetTableStyleId()) {
            return null;
        }
        String styleId = tab.getTblPr().getTableStyleId();
        XSLFTableStyles styles = this.getSheet().getSlideShow().getTableStyles();
        for (XSLFTableStyle style : styles.getStyles()) {
            if (!style.getStyleId().equals(styleId)) continue;
            return style;
        }
        return null;
    }

    void updateRowColIndexes() {
        int rowIdx = 0;
        for (XSLFTableRow xr : this) {
            int colIdx = 0;
            for (XSLFTableCell tc : xr) {
                tc.setRowColIndex(rowIdx, colIdx);
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    void updateCellAnchor() {
        int col;
        int row;
        int rows = this.getNumberOfRows();
        int cols = this.getNumberOfColumns();
        double[] colWidths = new double[cols];
        double[] rowHeights = new double[rows];
        for (int row2 = 0; row2 < rows; ++row2) {
            rowHeights[row2] = this.getRowHeight(row2);
        }
        for (int col2 = 0; col2 < cols; ++col2) {
            colWidths[col2] = this.getColumnWidth(col2);
        }
        Rectangle2D tblAnc = this.getAnchor();
        DrawFactory df = DrawFactory.getInstance(null);
        double newY = tblAnc.getY();
        for (row = 0; row < rows; ++row) {
            double maxHeight = 0.0;
            for (col = 0; col < cols; ++col) {
                XSLFTableCell tc = this.getCell(row, col);
                if (tc == null || tc.getGridSpan() != 1 || tc.getRowSpan() != 1) continue;
                tc.setAnchor(new Rectangle2D.Double(0.0, 0.0, colWidths[col], 0.0));
                DrawTextShape dts = df.getDrawable((TextShape)tc);
                maxHeight = Math.max(maxHeight, dts.getTextHeight());
            }
            rowHeights[row] = Math.max(rowHeights[row], maxHeight);
        }
        for (row = 0; row < rows; ++row) {
            double newX = tblAnc.getX();
            for (col = 0; col < cols; ++col) {
                Rectangle2D.Double bounds = new Rectangle2D.Double(newX, newY, colWidths[col], rowHeights[row]);
                XSLFTableCell tc = this.getCell(row, col);
                if (tc == null) continue;
                tc.setAnchor(bounds);
                newX += colWidths[col] + 2.0;
            }
            newY += rowHeights[row] + 2.0;
        }
        for (row = 0; row < rows; ++row) {
            for (int col3 = 0; col3 < cols; ++col3) {
                XSLFTableCell tc2;
                XSLFTableCell tc = this.getCell(row, col3);
                if (tc == null) continue;
                Rectangle2D mergedBounds = tc.getAnchor();
                for (int col2 = col3 + 1; col2 < col3 + tc.getGridSpan(); ++col2) {
                    assert (col2 < cols);
                    tc2 = this.getCell(row, col2);
                    assert (tc2.getGridSpan() == 1 && tc2.getRowSpan() == 1);
                    mergedBounds.add(tc2.getAnchor());
                }
                for (int row2 = row + 1; row2 < row + tc.getRowSpan(); ++row2) {
                    assert (row2 < rows);
                    tc2 = this.getCell(row2, col3);
                    assert (tc2.getGridSpan() == 1 && tc2.getRowSpan() == 1);
                    mergedBounds.add(tc2.getAnchor());
                }
                tc.setAnchor(mergedBounds);
            }
        }
    }
}

