/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DateUtil;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class OsmAndProtocolDecoder
extends BaseHttpProtocolDecoder {
    public OsmAndProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        Map params = decoder.parameters();
        if (params.isEmpty()) {
            decoder = new QueryStringDecoder(request.content().toString(StandardCharsets.US_ASCII), false);
            params = decoder.parameters();
        }
        Position position = new Position(this.getProtocolName());
        position.setValid(true);
        Network network = new Network();
        for (Map.Entry entry : params.entrySet()) {
            for (String value : (List)entry.getValue()) {
                block21 : switch ((String)entry.getKey()) {
                    case "id": 
                    case "deviceid": {
                        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                        if (deviceSession == null) {
                            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
                            return null;
                        }
                        position.setDeviceId(deviceSession.getDeviceId());
                        break;
                    }
                    case "valid": {
                        position.setValid(Boolean.parseBoolean(value) || "1".equals(value));
                        break;
                    }
                    case "timestamp": {
                        try {
                            long timestamp = Long.parseLong(value);
                            if (timestamp < Integer.MAX_VALUE) {
                                timestamp *= 1000L;
                            }
                            position.setTime(new Date(timestamp));
                        }
                        catch (NumberFormatException error) {
                            if (value.contains("T")) {
                                position.setTime(DateUtil.parseDate(value));
                                break;
                            }
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            position.setTime(dateFormat.parse(value));
                        }
                        break;
                    }
                    case "lat": {
                        position.setLatitude(Double.parseDouble(value));
                        break;
                    }
                    case "lon": {
                        position.setLongitude(Double.parseDouble(value));
                        break;
                    }
                    case "location": {
                        String[] location = value.split(",");
                        position.setLatitude(Double.parseDouble(location[0]));
                        position.setLongitude(Double.parseDouble(location[1]));
                        break;
                    }
                    case "cell": {
                        String[] cell = value.split(",");
                        if (cell.length > 4) {
                            network.addCellTower(CellTower.from(Integer.parseInt(cell[0]), Integer.parseInt(cell[1]), Integer.parseInt(cell[2]), Integer.parseInt(cell[3]), Integer.parseInt(cell[4])));
                            break;
                        }
                        network.addCellTower(CellTower.from(Integer.parseInt(cell[0]), Integer.parseInt(cell[1]), Integer.parseInt(cell[2]), Integer.parseInt(cell[3])));
                        break;
                    }
                    case "wifi": {
                        String[] wifi = value.split(",");
                        network.addWifiAccessPoint(WifiAccessPoint.from(wifi[0].replace('-', ':'), Integer.parseInt(wifi[1])));
                        break;
                    }
                    case "speed": {
                        position.setSpeed(this.convertSpeed(Double.parseDouble(value), "kn"));
                        break;
                    }
                    case "bearing": 
                    case "heading": {
                        position.setCourse(Double.parseDouble(value));
                        break;
                    }
                    case "altitude": {
                        position.setAltitude(Double.parseDouble(value));
                        break;
                    }
                    case "accuracy": {
                        position.setAccuracy(Double.parseDouble(value));
                        break;
                    }
                    case "hdop": {
                        position.set("hdop", Double.parseDouble(value));
                        break;
                    }
                    case "batt": {
                        position.set("batteryLevel", Double.parseDouble(value));
                        break;
                    }
                    case "driverUniqueId": {
                        position.set("driverUniqueId", value);
                        break;
                    }
                    default: {
                        try {
                            position.set((String)entry.getKey(), Double.parseDouble(value));
                            break;
                        }
                        catch (NumberFormatException e) {
                            switch (value) {
                                case "true": {
                                    position.set((String)entry.getKey(), true);
                                    break block21;
                                }
                                case "false": {
                                    position.set((String)entry.getKey(), false);
                                    break block21;
                                }
                            }
                            position.set((String)entry.getKey(), value);
                        }
                    }
                }
            }
        }
        if (position.getFixTime() == null) {
            position.setTime(new Date());
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        if (position.getLatitude() == 0.0 && position.getLongitude() == 0.0) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (position.getDeviceId() != 0L) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return position;
        }
        this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
        return null;
    }
}

