/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Face {
    private List<MGraph.Edge> edges = new ArrayList<MGraph.Edge>();
    private Set<MGraph.Edge> edgeMap = new HashSet<MGraph.Edge>();
    private List<Dart> darts = new ArrayList<Dart>();
    private Set<Dart> dartMap = new HashSet<Dart>();
    private Map<Dart, Integer> dartIndices = new HashMap<Dart, Integer>();
    private boolean isOuterFace;

    public int getDegree() {
        return this.edges.size();
    }

    public void setOuterFace(boolean bl) {
        this.isOuterFace = bl;
    }

    public boolean isOuterFace() {
        return this.isOuterFace;
    }

    public List<MGraph.Vertex> getVertices() {
        ArrayList<MGraph.Vertex> arrayList = new ArrayList<MGraph.Vertex>();
        List<Dart> list = this.getDarts();
        for (Dart dart : list) {
            arrayList.add(dart.getV());
        }
        return arrayList;
    }

    public void addEdge(MGraph.Edge edge) {
        this.edgeMap.add(edge);
        this.edges.add(edge);
    }

    public void addEdges(Collection<MGraph.Edge> collection) {
        this.edges.addAll(collection);
        this.edgeMap.addAll(collection);
    }

    private void addEdge(int n, MGraph.Edge edge) {
        this.edges.add(n, edge);
        this.edgeMap.add(edge);
    }

    private void removeEdge(MGraph.Edge edge) {
        this.edges.remove(edge);
        if (!this.edges.contains(edge)) {
            this.edgeMap.remove(edge);
        }
    }

    private void removeEdge(int n) {
        MGraph.Edge edge = this.edges.remove(n);
        if (!this.edges.contains(edge)) {
            this.edgeMap.remove(edge);
        }
    }

    public List<MGraph.Edge> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public MGraph.Edge getBorderingEdge(Face face) {
        for (MGraph.Edge edge : face.getEdges()) {
            if (!this.edgeMap.contains(edge)) continue;
            return edge;
        }
        return null;
    }

    public List<Dart> replaceEdge(MGraph.Edge edge, Collection<MGraph.Edge> collection) {
        HashSet<MGraph.Edge> hashSet = new HashSet<MGraph.Edge>(collection);
        ArrayList<Dart> arrayList = new ArrayList<Dart>();
        Dart dart = this.getDart(edge);
        MGraph.Vertex vertex = dart.getV();
        MGraph.Vertex vertex2 = dart.getW();
        int n = this.getDartIndex(dart);
        this.removeEdge(n);
        this.removeDart(n);
        while (vertex != vertex2) {
            MGraph.Edge edge2 = this.searchAndRemoveEdge(vertex, hashSet);
            MGraph.Vertex vertex3 = edge2.getOppositeVertex(vertex);
            Dart dart2 = new Dart(vertex, vertex3, edge2);
            this.addEdge(n, edge2);
            this.addDart(n, dart2);
            arrayList.add(dart2);
            ++n;
            vertex = vertex3;
        }
        return arrayList;
    }

    public List<Dart> replaceDart(Dart dart, Collection<MGraph.Edge> collection) {
        HashSet<MGraph.Edge> hashSet = new HashSet<MGraph.Edge>(collection);
        ArrayList<Dart> arrayList = new ArrayList<Dart>();
        MGraph.Vertex vertex = dart.getV();
        MGraph.Vertex vertex2 = dart.getW();
        int n = this.getDartIndex(dart);
        this.removeEdge(n);
        this.removeDart(n);
        while (vertex != vertex2) {
            MGraph.Edge edge = this.searchAndRemoveEdge(vertex, hashSet);
            MGraph.Vertex vertex3 = edge.getOppositeVertex(vertex);
            Dart dart2 = new Dart(vertex, vertex3, edge);
            this.addEdge(n, edge);
            this.addDart(n, dart2);
            arrayList.add(dart2);
            ++n;
            vertex = vertex3;
        }
        return arrayList;
    }

    public List<Dart> replaceDarts(MGraph.Edge edge) {
        return this.replaceDarts(edge, null);
    }

    public List<Dart> replaceDarts(MGraph.Edge edge, MGraph.Vertex vertex) {
        ArrayList<Dart> arrayList = new ArrayList<Dart>();
        MGraph.Vertex vertex2 = null;
        MGraph.Vertex vertex3 = null;
        if (vertex == null) {
            vertex2 = edge.getV();
            vertex3 = edge.getW();
        } else {
            vertex2 = vertex;
            vertex3 = edge.getOppositeVertex(vertex2);
        }
        List<Dart> list = this.getDartsTo(vertex2);
        if (list.isEmpty()) {
            return arrayList;
        }
        Dart dart = list.get(list.size() - 1);
        if (dart == null) {
            return arrayList;
        }
        Dart dart2 = this.getDartFrom(vertex3);
        Dart dart3 = this.getNextDart(dart);
        while (dart3 != dart2) {
            int n = this.darts.indexOf(dart3);
            dart3 = this.getNextDart(dart3);
            this.removeEdge(n);
            arrayList.add(this.darts.get(n));
            this.removeDart(n);
        }
        Dart dart4 = new Dart(vertex2, vertex3, edge);
        int n = this.getDartIndex(dart) + 1;
        this.addDart(n, dart4);
        this.addEdge(n, edge);
        return arrayList;
    }

    private MGraph.Edge searchAndRemoveEdge(MGraph.Vertex vertex, Collection<MGraph.Edge> collection) {
        MGraph.Edge edge = null;
        for (MGraph.Edge edge2 : collection) {
            if (!edge2.contains(vertex)) continue;
            edge = edge2;
            break;
        }
        collection.remove(edge);
        return edge;
    }

    public List<Dart> getDarts() {
        if (this.darts.size() != this.edges.size()) {
            this.createDarts();
        }
        return Collections.unmodifiableList(this.darts);
    }

    public void createDarts(MGraph.Vertex vertex) {
        Object object = null;
        this.darts.clear();
        this.dartMap.clear();
        for (MGraph.Edge edge : this.edges) {
            Object object2;
            MGraph.Vertex vertex2;
            if (object == null) {
                vertex2 = edge.getV();
                object2 = edge.getW();
                object = vertex == null ? (this.isOuterFace ? (vertex2.getNumber() < ((MGraph.Vertex)object2).getNumber() ? object2 : vertex2) : (vertex2.getNumber() < ((MGraph.Vertex)object2).getNumber() ? vertex2 : object2)) : vertex;
            }
            vertex2 = edge.getOppositeVertex((MGraph.Vertex)object);
            object2 = new Dart((MGraph.Vertex)object, vertex2, edge);
            this.addDart((Dart)object2);
            object = vertex2;
        }
    }

    public void createDarts() {
        this.createDarts(null);
    }

    private void addDart(Dart dart) {
        this.darts.add(dart);
        this.dartMap.add(dart);
        this.updateDartIndices(this.darts.size() - 1, null);
    }

    private void addDart(int n, Dart dart) {
        this.darts.add(n, dart);
        this.dartMap.add(dart);
        this.updateDartIndices(n, null);
    }

    private void removeDart(Dart dart) {
        int n = this.getDartIndex(dart);
        this.darts.remove(n);
        this.dartMap.remove(dart);
        this.updateDartIndices(n, dart);
    }

    private void removeDart(int n) {
        Dart dart = this.darts.remove(n);
        this.dartMap.remove(dart);
        this.updateDartIndices(n, dart);
    }

    private void updateDartIndices(int n, Dart dart) {
        if (dart != null) {
            this.dartIndices.remove(dart);
        }
        int n2 = this.darts.size();
        for (int i = n; i < n2; ++i) {
            this.dartIndices.put(this.darts.get(i), i);
        }
    }

    public List<Dart> getDartsFrom(MGraph.Vertex vertex) {
        ArrayList<Dart> arrayList = new ArrayList<Dart>();
        for (Dart dart : this.getDarts()) {
            if (vertex != dart.getV()) continue;
            arrayList.add(dart);
        }
        return arrayList;
    }

    public Dart getDartFrom(MGraph.Vertex vertex) {
        for (Dart dart : this.getDarts()) {
            if (vertex != dart.getV()) continue;
            return dart;
        }
        return null;
    }

    public List<Dart> getDartsTo(MGraph.Vertex vertex) {
        ArrayList<Dart> arrayList = new ArrayList<Dart>();
        for (Dart dart : this.getDarts()) {
            if (vertex != dart.getW()) continue;
            arrayList.add(dart);
        }
        return arrayList;
    }

    public Dart getDartTo(MGraph.Vertex vertex) {
        for (Dart dart : this.getDarts()) {
            if (vertex != dart.getW()) continue;
            return dart;
        }
        return null;
    }

    public Dart getDart(MGraph.Edge edge) {
        for (Dart dart : this.getDarts()) {
            if (dart.getEdge() != edge) continue;
            return dart;
        }
        return null;
    }

    public List<Dart> getDarts(MGraph.Edge edge) {
        ArrayList<Dart> arrayList = new ArrayList<Dart>();
        for (Dart dart : this.getDarts()) {
            if (dart.getEdge() != edge) continue;
            arrayList.add(dart);
        }
        return arrayList;
    }

    public Dart getDart(MGraph.Edge edge, MGraph.Vertex vertex) {
        for (Dart dart : this.getDarts()) {
            if (dart.getEdge() != edge || dart.getV() != vertex) continue;
            return dart;
        }
        return null;
    }

    public Dart getBorderingDart(Face face) {
        MGraph.Edge edge = this.getBorderingEdge(face);
        for (Dart dart : this.getDarts()) {
            if (dart.getEdge() != edge) continue;
            return dart;
        }
        return null;
    }

    public boolean containsEdge(MGraph.Edge edge) {
        return this.edgeMap.contains(edge);
    }

    public boolean containsDart(Dart dart) {
        return this.dartMap.contains(dart);
    }

    public boolean containsVertex(MGraph.Vertex vertex) {
        for (MGraph.Edge edge : this.edges) {
            if (!edge.contains(vertex)) continue;
            return true;
        }
        return false;
    }

    public boolean connects(Face face) {
        for (MGraph.Edge edge : this.getEdges()) {
            for (MGraph.Edge edge2 : face.getEdges()) {
                if (!edge.shareVertex(edge2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean borders(Face face) {
        for (MGraph.Edge edge : face.edges) {
            if (!this.edgeMap.contains(edge)) continue;
            return true;
        }
        return false;
    }

    public MGraph.Vertex getCornerVertex(MGraph.Edge edge) {
        MGraph.Edge edge2 = this.getNextEdge(edge);
        MGraph.Vertex vertex = edge.getV();
        MGraph.Vertex vertex2 = edge.getW();
        MGraph.Vertex vertex3 = edge2.getV();
        MGraph.Vertex vertex4 = edge2.getW();
        if (vertex == vertex3 || vertex == vertex4) {
            return vertex;
        }
        if (vertex2 == vertex3 || vertex2 == vertex4) {
            return vertex2;
        }
        return null;
    }

    public MGraph.Edge getNextEdge(MGraph.Edge edge) {
        int n = this.getEdgeIndex(edge);
        return this.edges.get((n + 1) % this.edges.size());
    }

    private int getEdgeIndex(MGraph.Edge edge) {
        return this.edges.indexOf(edge);
    }

    public MGraph.Vertex getCornerVertex(Dart dart) {
        Dart dart2 = this.getNextDart(dart);
        MGraph.Vertex vertex = dart.getV();
        MGraph.Vertex vertex2 = dart.getW();
        MGraph.Vertex vertex3 = dart2.getV();
        MGraph.Vertex vertex4 = dart2.getW();
        if (vertex == vertex3 || vertex == vertex4) {
            return vertex;
        }
        if (vertex2 == vertex3 || vertex2 == vertex4) {
            return vertex2;
        }
        return null;
    }

    public Dart getNextDart(Dart dart) {
        int n = this.getDartIndex(dart);
        if (n == -1) {
            return null;
        }
        return this.darts.get((n + 1) % this.darts.size());
    }

    private int getDartIndex(Dart dart) {
        return this.dartIndices.get(dart);
    }

    public void reverseDirection() {
        ArrayList<MGraph.Edge> arrayList = new ArrayList<MGraph.Edge>(this.edges);
        this.edges.clear();
        this.edgeMap.clear();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this.addEdge(arrayList.get(i));
        }
        this.darts.clear();
        this.dartMap.clear();
    }

    public String toString() {
        String string = "Face:\n";
        if (this.isOuterFace) {
            string = "Outer Face:\n";
        }
        string = string + "Edges:\n";
        for (MGraph.Edge edge : this.edges) {
            string = string + "\t" + edge + "\n";
        }
        string = string + "Darts:\n";
        for (Dart dart : this.getDarts()) {
            string = string + "\t" + dart + "\n";
        }
        return string;
    }

    public static class Dart
    extends MGraph.Edge {
        private MGraph.Edge e;

        public Dart(MGraph.Vertex vertex, MGraph.Vertex vertex2, MGraph.Edge edge) {
            super(vertex, vertex2, null);
            this.e = edge;
        }

        public MGraph.Edge getEdge() {
            return this.e;
        }

        public MGraph.Edge.Direction getDirection() {
            return this.e.getDirection();
        }

        public String toString() {
            return "dart : v = " + this.getV() + " w = " + this.getW() + " direction = " + (Object)((Object)this.getDirection());
        }
    }
}

