/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.codecs.uniformsplit.DeltaBaseTermStateSerializer;
import org.apache.lucene.index.TermState;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;

public class RamUsageUtil {
    private static final long BYTES_REF_BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    private static final long BYTES_REF_BUILDER_BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(BytesRefBuilder.class);
    private static final long HASH_MAP_BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(HashMap.class);
    private static final long HASH_MAP_ENTRY_BASE_RAM_USAGE;
    private static final long UNMODIFIABLE_ARRAY_LIST_BASE_RAM_USAGE;

    public static long ramBytesUsed(BytesRef bytesRef) {
        return BYTES_REF_BASE_RAM_USAGE + RamUsageEstimator.sizeOf((byte[])bytesRef.bytes);
    }

    public static long ramBytesUsed(BytesRefBuilder bytesRefBuilder) {
        return BYTES_REF_BUILDER_BASE_RAM_USAGE + RamUsageUtil.ramBytesUsed(bytesRefBuilder.get());
    }

    public static long ramBytesUsed(TermState termState) {
        return DeltaBaseTermStateSerializer.ramBytesUsed(termState);
    }

    public static long ramBytesUsedByByteArrayOfLength(int length) {
        return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 1L * (long)length));
    }

    public static long ramBytesUsedByHashMapOfSize(int size) {
        return HASH_MAP_BASE_RAM_USAGE + RamUsageUtil.ramBytesUsedByObjectArrayOfLength((int)((double)size / 0.6)) + HASH_MAP_ENTRY_BASE_RAM_USAGE * (long)size;
    }

    public static long ramBytesUsedByUnmodifiableArrayListOfSize(int size) {
        return UNMODIFIABLE_ARRAY_LIST_BASE_RAM_USAGE + RamUsageUtil.ramBytesUsedByObjectArrayOfLength(size);
    }

    public static long ramBytesUsedByObjectArrayOfLength(int length) {
        return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)length));
    }

    static {
        HashMap map = new HashMap();
        map.put(map, map);
        HASH_MAP_ENTRY_BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOf(map.entrySet().iterator().next());
        UNMODIFIABLE_ARRAY_LIST_BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOf(Collections.unmodifiableList(new ArrayList())) + RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    }
}

