/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.V3Extension;

public class KeyUsage
implements V3Extension {
    String value = null;

    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.BIT_STRING)) {
            throw new Exception("Wrong ASN.1 type for KeyUsage");
        }
        byte[] o = (byte[])asn1object.getValue();
        StringBuffer buff = new StringBuffer();
        if ((o[1] & 0xFFFFFF80) != 0) {
            buff.append("digitalSignature, ");
        }
        if ((o[1] & 0x40) != 0) {
            buff.append("nonRepudiation, ");
        }
        if ((o[1] & 0x20) != 0) {
            buff.append("keyEncipherment, ");
        }
        if ((o[1] & 0x10) != 0) {
            buff.append("dataEncipherment, ");
        }
        if ((o[1] & 8) != 0) {
            buff.append("keyAgreement, ");
        }
        if ((o[1] & 4) != 0) {
            buff.append("keyCertSign, ");
        }
        if ((o[1] & 2) != 0) {
            buff.append("cRLSign, ");
        }
        if ((o[1] & 1) != 0) {
            buff.append("encipherOnly, ");
        }
        if ((o[0] & 0xFFFFFF80) != 0) {
            buff.append("decipherOnly, ");
        }
        this.value = buff.toString();
        if (this.value.endsWith(", ")) {
            this.value = this.value.substring(0, this.value.length() - 2);
        }
    }

    public String toString() {
        return this.value;
    }
}

