/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeNamedPhaseWrapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.AnnotationLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\bH\u0002\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\u0004\u0018\u00010\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"annotationPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedPhaseWrapper;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getAnnotationPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedPhaseWrapper;", "singleTypeArgumentOrNull", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getSingleTypeArgumentOrNull", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "singleTypeProjectionOrNull", "getSingleTypeProjectionOrNull", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/types/IrType;", "getFunctionByName", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "name", "", "numParams", "", "isKClassArray", "", "backend.jvm"})
public final class AnnotationLoweringKt {
    @NotNull
    private static final SameTypeNamedPhaseWrapper<JvmBackendContext, IrFile> annotationPhase = PhaseBuildersKt.makeIrFilePhase$default(annotationPhase.1.INSTANCE, "Annotation", "Remove constructors and modify field types in annotation classes", null, null, null, null, null, 248, null);

    @NotNull
    public static final SameTypeNamedPhaseWrapper<JvmBackendContext, IrFile> getAnnotationPhase() {
        return annotationPhase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKClassArray(@NotNull IrType $this$isKClassArray) {
        if (!IrTypeUtilsKt.isNonPrimitiveArray($this$isKClassArray)) return false;
        IrType irType = AnnotationLoweringKt.getSingleTypeProjectionOrNull($this$isKClassArray);
        if (irType == null) return false;
        boolean bl = IrTypeUtilsKt.isKClass(irType);
        if (!bl) return false;
        return true;
    }

    private static final IrType getSingleTypeProjectionOrNull(@NotNull IrType $this$singleTypeProjectionOrNull) {
        IrTypeArgument irTypeArgument = AnnotationLoweringKt.getSingleTypeArgumentOrNull($this$singleTypeProjectionOrNull);
        if (!(irTypeArgument instanceof IrTypeProjection)) {
            irTypeArgument = null;
        }
        IrTypeProjection irTypeProjection = (IrTypeProjection)irTypeArgument;
        return irTypeProjection != null ? irTypeProjection.getType() : null;
    }

    private static final IrTypeArgument getSingleTypeArgumentOrNull(@NotNull IrType $this$singleTypeArgumentOrNull) {
        Object object;
        IrType irType = $this$singleTypeArgumentOrNull;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        return (object = (IrSimpleType)irType) != null && (object = object.getArguments()) != null ? (IrTypeArgument)CollectionsKt.singleOrNull((List)object) : null;
    }

    public static final /* synthetic */ boolean access$isKClassArray(IrType $this$access_u24isKClassArray) {
        return AnnotationLoweringKt.isKClassArray($this$access_u24isKClassArray);
    }

    public static final /* synthetic */ IrType access$getSingleTypeProjectionOrNull$p(IrType $this$access_u24singleTypeProjectionOrNull_u24p) {
        return AnnotationLoweringKt.getSingleTypeProjectionOrNull($this$access_u24singleTypeProjectionOrNull_u24p);
    }
}

