#
#  Copyright (c) 1994-1998 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: preferences.t,v 1.1.1.1 1998/01/04 22:47:29 abm Exp $
#

#
# Set user preferences
#

proc initPreference { filename } {

    global env

    if {$filename != "" && [file exists $filename]} {
        set database $filename
    } elseif {[info exists env(TKHYLAFAX_DEFAULTS)]} {
        set database $env(TKHYLAFAX_DEFAULTS)
    } else {
        # Search for resource database in the tkhylafax-defaults file
        if {[info exists env(HOME)]} {
	   set database $env(HOME)/.tkhylafax-defaults
        } else {
	   set database ~/.tkhylafax-defaults
        }
    }

    if {[file isfile $database] && [file readable $database]} {
        readPreferenceFile $database interactive
    } else {
        wm withdraw . 
        # Eventually, ask user to build a resource database file...
        tk_dialog .err "Ooops!" "Can't find tkhylafax resource database. Using \
	   application default values. You may generate a resource database \
	   after tkhylafax starts by selecting \"Preferences\" under \
	   the \"Options\" menubutton. Be sure to save your settings!" \
	   info 0 "OK"
        wm deiconify .
    }
}

proc readPreferenceFile { filename level } {

    if {[file exists $filename]} {
        if {[catch {option readfile $filename $level} res]} {
	   tk_dialog .err "Ooops!" "Error while reading resource database: \
	       $res. \n\n Using default values" info 0 "OK"
        }
    }
}

#
# Initialize the global variable from the option database, else
# use the default value supplied.
#

proc addPreference { var resource {default {}} } {

    set value [option get . $resource {}]
    if {$value != ""} {
        # Warp booleans to 0 or 1
        switch -exact -- $value {
	   0 -
	   1		{ # ok as is }
	   yes -
	   Yes -
	   YES -
	   true -
	   True -
	   TRUE		{set value 1}
	   no -
	   No -
	   NO -
	   false -
	   False - 
	   FALSE		{set value 0}
	   default	{}
        }
        setPreference $var $value
    } else {
        setPreference $var $default
    }
}

#
# Get the value of a resource from the resource database 
#

proc getPreference { resource } {

    set value [option get . $resource {}]
    if {$value != ""} {
        # Warp booleans to 0 or 1
        switch -exact -- $value {
	   0 -
	   1		{ # ok as is }
	   yes -
	   Yes -
	   YES -
	   true -
	   True -
	   TRUE		{set value 1}
	   no -
	   No -
	   NO -
	   false -
	   False - 
	   FALSE		{set value 0}
	   default	{}
        }
    }
    return $value
}

#
# Set the value for the global variable
#

proc setPreference { _var _value } {
    upvar #0 $_var var
    set var $_value
}

proc preferencesDialog { top } {

    global Th_Info
    global Th_Pref

    set origPreferences [array get Th_Pref]
    set t [mkToplevel $top {Preferences}]
    set dialog [mkFrame $t list]
    set oper [mkFrame $t oper {-side bottom -fill x}]
    mkLabeledRadioButtons $dialog res {Fax Resolution} Th_Pref(faxResolution) \
        20 High high Low low
    mkLabeledRadioButtons $dialog comp {Notify On Completion} \
        Th_Pref(notifyOnCompletion) 20 Yes 1 No 0 
    mkLabeledRadioButtons $dialog retry {Notify On Retry} \
        Th_Pref(notifyOnRetry) 20 Yes 1 No 0 
    mkLabeledRadioButtons $dialog poll {Initiate Poll} Th_Pref(initiatePoll) \
        20 Yes 1 No 0
    mkLabeledRadioButtons $dialog cvrpg {Cover Page} Th_Pref(coverPage) \
        20 Yes 1 No 0
    mkLabeledRadioButtons $dialog from {Automatic From} Th_Pref(autoFrom) \
        20 Yes 1 No 0
    mkLabeledEntry $dialog editor {Editor Command} Th_Pref(editorCmd) \
        $Th_Info(ewidth) 20
    mkLabeledEntry $dialog comment {Comment Lines} Th_Pref(commentLines) \
        $Th_Info(ewidth) 20
    mkLabeledEntry $dialog cvrpgpath {Cover Page Path} Th_Pref(coverPageDirs) \
        40 20
    mkButton $oper reset {-side left} -text Reset \
        -command "resetPreferenceDialog $origPreferences"
    mkButton $oper save {-side left} -text Save \
        -command savePreferences
    mkButton $oper dismiss {-side left} -text Dismiss \
        -command "destroy $t" 
}

proc resetPreferenceDialog { args } {

    global Th_Pref
    array set Th_Pref $args

}

proc savePreferences { {filename {}} } {

    global Th_Pref

    if {$filename == ""} {
        set filename {~/.tkhylafax-defaults}
    }
    if {[catch {set out [open $filename {CREAT TRUNC RDWR}]} res]} {
        tk_dialog .err "Ooops!" "Unable to open $filename. Reason: $res" \
	   error 0 OK
        return
    }

    puts $out "!!!"
    puts $out "!!! This file was generated by tkhylafax. "
    puts $out "!!!"
    foreach i [array name Th_Pref] {
        set Th_Info($i) $Th_Pref($i)
        switch -exact -- $Th_Pref($i) {
	   0 		{puts $out "*${i}:	no"}
	   1		{puts $out "*${i}:	yes"}
	   default 	{puts $out "*${i}:	$Th_Pref($i)"}
        }
    }
    close $out
    tk_dialog .err "Notification" "Your preferences for tkhylafax have been \
        saved. Tkhylafax must be restarted for the changes to take effect." \
        info 0 OK
}
