/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.model;

import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.utils.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FileType {
    private String extension;
    private String pattern;
    private static final LanguageController messages = LanguageController.getInstance();
    private static final Map<String, String> types = new HashMap<String, String>();

    public static void init() {
        types.put("tex", "^\\s*%\\s+");
        types.put("dtx", "^\\s*%\\s+");
        types.put("ltx", "^\\s*%\\s+");
        types.put("drv", "^\\s*%\\s+");
        types.put("ins", "^\\s*%\\s+");
    }

    public FileType(String extension, String pattern) {
        this.extension = extension;
        this.pattern = pattern;
    }

    public FileType(String extension) throws AraraException {
        if (!types.containsKey(extension)) {
            throw new AraraException(messages.getMessage(Messages.ERROR_FILETYPE_UNKNOWN_EXTENSION, extension, CommonUtils.getFileTypesList()));
        }
        this.extension = extension;
        this.pattern = types.get(extension);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.extension).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileType reference = (FileType)object;
        return new EqualsBuilder().append(this.extension, reference.extension).isEquals();
    }

    public String getExtension() {
        return this.extension;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return ".".concat(this.extension);
    }
}

