// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeAnalysis_Shell_HeaderFile
#define _ShapeAnalysis_Shell_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopTools_IndexedMapOfShape.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class TopoDS_Shape;
class TopoDS_Compound;


//! This class provides operators to analyze edges orientation
//! in the shell.
class ShapeAnalysis_Shell 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Clears data about loaded shells and performed checks
  Standard_EXPORT   void Clear() ;
  
  //! Adds shells contained in the <shape> to the list of loaded shells
  Standard_EXPORT   void LoadShells (const TopoDS_Shape& shape) ;
  
  //! Checks if shells fulfill orientation condition, i.e. if each
  //! edge is, either present once (free edge) or twice (connected
  //! edge) but with different orientations (FORWARD/REVERSED)
  //! Edges which do not fulfill these conditions are bad
  //!
  //! If <alsofree> is True free edges are considered.
  //! Free edges can be queried but are not bad
  Standard_EXPORT   Standard_Boolean CheckOrientedShells (const TopoDS_Shape& shape, const Standard_Boolean alsofree = Standard_False, const Standard_Boolean checkinternaledges = Standard_False) ;
  
  //! Tells if a shape is loaded (only shells are checked)
  Standard_EXPORT   Standard_Boolean IsLoaded (const TopoDS_Shape& shape)  const;
  
  //! Returns the actual number of loaded shapes (i.e. shells)
  Standard_EXPORT   Standard_Integer NbLoaded()  const;
  
  //! Returns a loaded shape specified by its rank number.
  //! Returns null shape if <num> is out of range
  Standard_EXPORT   TopoDS_Shape Loaded (const Standard_Integer num)  const;
  
  //! Tells if at least one edge is recorded as bad
  Standard_EXPORT   Standard_Boolean HasBadEdges()  const;
  
  //! Returns the list of bad edges as a Compound
  //! It is empty (not null) if no edge are recorded as bad
  Standard_EXPORT   TopoDS_Compound BadEdges()  const;
  
  //! Tells if at least one edge is recorded as free (not connected)
  Standard_EXPORT   Standard_Boolean HasFreeEdges()  const;
  
  //! Returns the list of free (not connected) edges as a Compound
  //! It is empty (not null) if no edge are recorded as free
  Standard_EXPORT   TopoDS_Compound FreeEdges()  const;
  
  //! Tells if at least one edge is connected (shared twice or more)
  Standard_EXPORT   Standard_Boolean HasConnectedEdges()  const;




protected:





private:



  TopTools_IndexedMapOfShape myShells;
  TopTools_IndexedMapOfShape myBad;
  TopTools_IndexedMapOfShape myFree;
  Standard_Boolean myConex;


};







#endif // _ShapeAnalysis_Shell_HeaderFile
