/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.ColourScheme;
import jalview.ConservationColourScheme;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.IdPanel;
import jalview.ResidueColourScheme;
import jalview.ResidueProperties;
import jalview.ScalePanel;
import jalview.ScorePanel;
import jalview.ScoreSequence;
import jalview.SeqPanel;
import jalview.Sequence;
import jalview.SequenceGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.Vector;

public class AlignmentPanel
extends Panel {
    public SeqPanel seqPanel;
    public IdPanel idPanel;
    public ScalePanel scalePanel;
    public Component parent;
    public Vector sel;
    public boolean[] selected;
    public Vector selectedColumns;
    public boolean groupEdit = false;
    public Hashtable[] cons;
    boolean conservation = false;
    Color[] color = ResidueProperties.color;
    public int scaleheight = 20;

    public AlignmentPanel(Component component, DrawableSequence[] drawableSequenceArray) {
        this.parent = component;
        this.idPanel = new IdPanel(this);
        this.seqPanel = new SeqPanel(this, drawableSequenceArray);
        this.scalePanel = new ScalePanel(this);
        this.sel = new Vector();
        this.selected = new boolean[this.seqPanel.align.size];
        this.selectedColumns = new Vector();
        this.componentInit();
        System.out.println("Loaded AlignmentPanel");
    }

    public int countSelected() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2]) {
                ++n;
            }
            ++n2;
        }
        return this.sel.size();
    }

    public void componentInit() {
        this.setLayout(null);
        this.add(this.idPanel);
        this.add(this.scalePanel);
        this.add(this.seqPanel);
        this.selectAll(false);
        System.out.println("Finished AlignmentPanel.componentInit");
    }

    public void selectAll(boolean bl) {
        int n = 0;
        if (bl) {
            while (n < this.seqPanel.align.size) {
                if (!this.sel.contains(this.seqPanel.align.sequences[n])) {
                    this.sel.addElement(this.seqPanel.align.sequences[n]);
                }
                ++n;
            }
            return;
        }
        this.sel = null;
        this.sel = new Vector();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void oldreshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        int n5 = this.idPanel.idCanvas.idWidth;
        this.scalePanel.reshape(0, 0, n3, this.scaleheight);
        this.idPanel.reshape(0, this.scaleheight, n5, n4 - this.scaleheight);
        this.seqPanel.reshape(n5, this.scaleheight, n3 - n5, n4 - this.scaleheight);
    }

    public void setSequenceColor(ColourScheme colourScheme) {
        int n = this.countSelected();
        if (n == 0) {
            if (this.cons == null) {
                System.out.println("Calculating consensus");
                this.seqPanel.align.percentIdentity();
                this.cons = this.seqPanel.align.cons;
            } else {
                this.cons = this.seqPanel.align.cons;
            }
            if (colourScheme instanceof ResidueColourScheme) {
                System.out.println("Setting consensus");
                ((ResidueColourScheme)colourScheme).cons = this.cons;
            }
            this.seqPanel.align.setColourScheme(colourScheme);
            int n2 = 0;
            while (n2 < this.seqPanel.align.groups.size()) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.seqPanel.align.groups.elementAt(n2);
                sequenceGroup.colourScheme = colourScheme;
                sequenceGroup.color = this.color;
                if (this.conservation && sequenceGroup.conserve != null) {
                    ConservationColourScheme conservationColourScheme = new ConservationColourScheme(sequenceGroup);
                    sequenceGroup.colourScheme = conservationColourScheme;
                }
                sequenceGroup.colourScheme.setColours(sequenceGroup);
                ++n2;
            }
            return;
        }
        SequenceGroup sequenceGroup = this.seqPanel.align.addGroup();
        sequenceGroup.colourScheme = colourScheme;
        sequenceGroup.color = this.color;
        this.seqPanel.align.setColourScheme(sequenceGroup);
        int n3 = 0;
        while (n3 < this.sel.size()) {
            this.seqPanel.align.removeFromGroup(this.seqPanel.align.findGroup((Sequence)this.sel.elementAt(n3)), (Sequence)this.sel.elementAt(n3));
            this.seqPanel.align.addToGroup(sequenceGroup, (Sequence)this.sel.elementAt(n3));
            ++n3;
        }
        if (this.conservation && sequenceGroup.conserve != null) {
            sequenceGroup.colourScheme = new ConservationColourScheme(sequenceGroup);
        }
        sequenceGroup.colourScheme.setColours(sequenceGroup);
    }

    public void setSequenceColor(int n, int n2) {
        int n3 = 0;
        while (n3 < this.seqPanel.align.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.seqPanel.align.groups.elementAt(n3);
            int n4 = 0;
            while (n4 < sequenceGroup.sequences.size()) {
                DrawableSequence drawableSequence = (DrawableSequence)sequenceGroup.sequences.elementAt(n4);
                int n5 = n;
                while (n5 <= n2) {
                    sequenceGroup.colourScheme.setColours(drawableSequence, n5);
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void setSequenceColor(DrawableSequence drawableSequence, int n, int n2) {
        SequenceGroup sequenceGroup = this.seqPanel.align.findGroup(drawableSequence);
        int n3 = n;
        while (n3 <= n2) {
            sequenceGroup.colourScheme.setColours(drawableSequence, n3);
            ++n3;
        }
    }

    public void setSequenceColor() {
        int n = 0;
        while (n < this.seqPanel.align.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.seqPanel.align.groups.elementAt(n);
            sequenceGroup.colourScheme.setColours(sequenceGroup);
            ++n;
        }
    }

    public void setSequenceColor(int n, ColourScheme colourScheme) {
        int n2 = this.countSelected();
        if (n2 == 0) {
            if (this.cons == null) {
                this.seqPanel.align.percentIdentity();
                this.cons = this.seqPanel.align.cons;
            }
            if (this.conservation) {
                int n3 = 0;
                while (n3 < this.seqPanel.align.groups.size()) {
                    SequenceGroup sequenceGroup = (SequenceGroup)this.seqPanel.align.groups.elementAt(n3);
                    if (sequenceGroup.conserve != null) {
                        sequenceGroup.colourScheme = new ConservationColourScheme(sequenceGroup);
                        sequenceGroup.colourScheme.setColours(sequenceGroup);
                    }
                    ++n3;
                }
                return;
            }
            int n4 = 0;
            while (n4 < this.seqPanel.align.groups.size()) {
                SequenceGroup sequenceGroup = (SequenceGroup)this.seqPanel.align.groups.elementAt(n4);
                if (sequenceGroup.colourScheme instanceof ResidueColourScheme) {
                    ((ResidueColourScheme)sequenceGroup.colourScheme).colourThreshold = n;
                    ((ResidueColourScheme)sequenceGroup.colourScheme).cons = this.cons;
                    sequenceGroup.colourScheme.setColours(sequenceGroup);
                }
                ++n4;
            }
            return;
        }
        SequenceGroup sequenceGroup = this.seqPanel.align.addGroup();
        sequenceGroup.colourScheme = colourScheme;
        int n5 = 0;
        while (n5 < this.sel.size()) {
            this.seqPanel.align.removeFromGroup(this.seqPanel.align.findGroup((Sequence)this.sel.elementAt(n5)), (Sequence)this.sel.elementAt(n5));
            this.seqPanel.align.addToGroup(sequenceGroup, (Sequence)this.sel.elementAt(n5));
            ++n5;
        }
        if (this.conservation) {
            if (sequenceGroup.colourScheme instanceof ResidueColourScheme) {
                ((ResidueColourScheme)sequenceGroup.colourScheme).colourThreshold = n;
                ((ResidueColourScheme)sequenceGroup.colourScheme).cons = this.cons;
                if (sequenceGroup.conserve != null) {
                    sequenceGroup.colourScheme = new ConservationColourScheme(sequenceGroup);
                    sequenceGroup.colourScheme.setColours(sequenceGroup);
                    return;
                }
            }
        } else if (sequenceGroup.colourScheme instanceof ResidueColourScheme) {
            ((ResidueColourScheme)sequenceGroup.colourScheme).colourThreshold = n;
            ((ResidueColourScheme)sequenceGroup.colourScheme).cons = this.cons;
            sequenceGroup.colourScheme.setColours(sequenceGroup);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("SeqPanel");
        Sequence[] sequenceArray = FormatAdapter.read(stringArray[0], "File", "POSTAL");
        DrawableSequence[] drawableSequenceArray = new ScoreSequence[sequenceArray.length];
        int n = 0;
        while (n < sequenceArray.length) {
            drawableSequenceArray[n] = new ScoreSequence(sequenceArray[n]);
            ++n;
        }
        DrawableSequence[] drawableSequenceArray2 = new DrawableSequence[sequenceArray.length];
        int n2 = 0;
        while (n2 < sequenceArray.length) {
            drawableSequenceArray2[n2] = new DrawableSequence(sequenceArray[n2]);
            ++n2;
        }
        AlignmentPanel alignmentPanel = new AlignmentPanel(null, drawableSequenceArray2);
        new ScorePanel(null, drawableSequenceArray);
        frame.setLayout(new BorderLayout());
        frame.add("Center", alignmentPanel);
        frame.resize(700, 500);
        frame.show();
    }
}

