/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlets.IncludeExcludeBasedFilter;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HeaderFilter
extends IncludeExcludeBasedFilter {
    private List<ConfiguredHeader> _configuredHeaders = new ArrayList<ConfiguredHeader>();
    private static final Logger LOG = Log.getLogger(HeaderFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String header_config = filterConfig.getInitParameter("headerConfig");
        if (header_config != null) {
            String[] configs;
            for (String config : configs = StringUtil.csvSplit(header_config)) {
                this._configuredHeaders.add(this.parseHeaderConfiguration(config));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toString(), new Object[0]);
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest http_request = (HttpServletRequest)request;
        HttpServletResponse http_response = (HttpServletResponse)response;
        if (super.shouldFilter(http_request, http_response)) {
            for (ConfiguredHeader header : this._configuredHeaders) {
                if (header.isDate()) {
                    long header_value = System.currentTimeMillis() + header.getMsOffset();
                    if (header.isAdd()) {
                        http_response.addDateHeader(header.getName(), header_value);
                        continue;
                    }
                    http_response.setDateHeader(header.getName(), header_value);
                    continue;
                }
                if (header.isAdd()) {
                    http_response.addHeader(header.getName(), header.getValue());
                    continue;
                }
                http_response.setHeader(header.getName(), header.getValue());
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("\n");
        sb.append("configured headers:\n");
        for (ConfiguredHeader c : this._configuredHeaders) {
            sb.append(c).append("\n");
        }
        return sb.toString();
    }

    private ConfiguredHeader parseHeaderConfiguration(String config) {
        String[] config_tokens = config.trim().split(" ", 2);
        String method = config_tokens[0].trim();
        String header = config_tokens[1];
        String[] header_tokens = header.trim().split(":", 2);
        String header_name = header_tokens[0].trim();
        String header_value = header_tokens[1].trim();
        ConfiguredHeader configured_header = new ConfiguredHeader(header_name, header_value, method.startsWith("add"), method.endsWith("Date"));
        return configured_header;
    }

    private static class ConfiguredHeader {
        private String _name;
        private String _value;
        private long _msOffset;
        private boolean _add;
        private boolean _date;

        public ConfiguredHeader(String name, String value, boolean add, boolean date) {
            this._name = name;
            this._value = value;
            this._add = add;
            this._date = date;
            if (this._date) {
                this._msOffset = Long.parseLong(this._value);
            }
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public boolean isAdd() {
            return this._add;
        }

        public boolean isDate() {
            return this._date;
        }

        public long getMsOffset() {
            return this._msOffset;
        }

        public String toString() {
            return (this._add ? "add" : "set") + (this._date ? "Date" : "") + " " + this._name + ": " + this._value;
        }
    }
}

