/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ConnectorServer
extends AbstractLifeCycle {
    public static final String RMI_REGISTRY_CLIENT_SOCKET_FACTORY_ATTRIBUTE = "com.sun.jndi.rmi.factory.socket";
    private static final Logger LOG = Log.getLogger(ConnectorServer.class);
    private JMXServiceURL _jmxURL;
    private final Map<String, Object> _environment;
    private final String _objectName;
    private final SslContextFactory _sslContextFactory;
    private int _registryPort;
    private int _rmiPort;
    private JMXConnectorServer _connectorServer;
    private Registry _registry;

    public ConnectorServer(JMXServiceURL serviceURL, String name) {
        this(serviceURL, null, name);
    }

    public ConnectorServer(JMXServiceURL svcUrl, Map<String, ?> environment, String name) {
        this(svcUrl, environment, name, null);
    }

    public ConnectorServer(JMXServiceURL svcUrl, Map<String, ?> environment, String name, SslContextFactory sslContextFactory) {
        this._jmxURL = svcUrl;
        this._environment = environment == null ? new HashMap<String, Object>() : new HashMap(environment);
        this._objectName = name;
        this._sslContextFactory = sslContextFactory;
    }

    public JMXServiceURL getAddress() {
        return this._jmxURL;
    }

    @Override
    public void doStart() throws Exception {
        String jndiRMI;
        String urlPath;
        boolean rmi = "rmi".equals(this._jmxURL.getProtocol());
        if (rmi) {
            if (!this._environment.containsKey("jmx.remote.rmi.server.socket.factory")) {
                this._environment.put("jmx.remote.rmi.server.socket.factory", new JMXRMIServerSocketFactory(this._jmxURL.getHost(), port -> {
                    this._rmiPort = port;
                }));
            }
            if (this._sslContextFactory != null) {
                SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                if (!this._environment.containsKey("jmx.remote.rmi.client.socket.factory")) {
                    this._environment.put("jmx.remote.rmi.client.socket.factory", csf);
                }
                if (!this._environment.containsKey(RMI_REGISTRY_CLIENT_SOCKET_FACTORY_ATTRIBUTE)) {
                    this._environment.put(RMI_REGISTRY_CLIENT_SOCKET_FACTORY_ATTRIBUTE, csf);
                }
            }
        }
        if ((urlPath = this._jmxURL.getURLPath()).startsWith(jndiRMI = "/jndi/rmi://")) {
            int startIndex = jndiRMI.length();
            int endIndex = urlPath.indexOf(47, startIndex);
            HostPort hostPort = new HostPort(urlPath.substring(startIndex, endIndex));
            String registryHost = this.startRegistry(hostPort);
            if (this._registryPort == 0) {
                this._registryPort = hostPort.getPort();
            }
            urlPath = jndiRMI + registryHost + ":" + this._registryPort + urlPath.substring(endIndex);
            this._jmxURL = new JMXServiceURL(this._jmxURL.getProtocol(), this._jmxURL.getHost(), this._jmxURL.getPort(), urlPath);
        }
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this._connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this._jmxURL, this._environment, mbeanServer);
        mbeanServer.registerMBean(this._connectorServer, new ObjectName(this._objectName));
        this._connectorServer.start();
        String rmiHost = this.normalizeHost(this._jmxURL.getHost());
        if (this._rmiPort == 0) {
            this._rmiPort = this._registryPort;
        }
        this._jmxURL = new JMXServiceURL(this._jmxURL.getProtocol(), rmiHost, this._rmiPort, urlPath);
        ShutdownThread.register(0, this);
        LOG.info("JMX URL: {}", this._jmxURL);
    }

    @Override
    public void doStop() throws Exception {
        ShutdownThread.deregister(this);
        this._connectorServer.stop();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        mbeanServer.unregisterMBean(new ObjectName(this._objectName));
        this.stopRegistry();
    }

    private String startRegistry(HostPort hostPort) throws Exception {
        String host = hostPort.getHost();
        int port = hostPort.getPort(1099);
        try {
            LocateRegistry.getRegistry(host, port).list();
            return this.normalizeHost(host);
        }
        catch (Throwable ex) {
            LOG.ignore(ex);
            SslRMIClientSocketFactory csf = this._sslContextFactory == null ? null : new SslRMIClientSocketFactory();
            JMXRMIServerSocketFactory ssf = new JMXRMIServerSocketFactory(host, p -> {
                this._registryPort = p;
            });
            this._registry = LocateRegistry.createRegistry(port, csf, ssf);
            return this.normalizeHost(host);
        }
    }

    private String normalizeHost(String host) throws UnknownHostException {
        return host == null || host.isEmpty() ? InetAddress.getLocalHost().getHostName() : host;
    }

    private void stopRegistry() {
        if (this._registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this._registry, true);
            }
            catch (Exception ex) {
                LOG.ignore(ex);
            }
            finally {
                this._registry = null;
            }
        }
    }

    private class JMXRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private final String _host;
        private final IntConsumer _portConsumer;

        private JMXRMIServerSocketFactory(String host, IntConsumer portConsumer) {
            this._host = host;
            this._portConsumer = portConsumer;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            InetAddress address = this._host == null || this._host.isEmpty() ? InetAddress.getLocalHost() : InetAddress.getByName(this._host);
            ServerSocket server = this.createServerSocket(address, port);
            this._portConsumer.accept(server.getLocalPort());
            return server;
        }

        private ServerSocket createServerSocket(InetAddress address, int port) throws IOException {
            if (ConnectorServer.this._sslContextFactory == null) {
                ServerSocket server = new ServerSocket();
                server.bind(new InetSocketAddress(address, port));
                return server;
            }
            return ConnectorServer.this._sslContextFactory.newSslServerSocket(address == null ? null : address.getHostName(), port, 0);
        }

        public int hashCode() {
            return this._host != null ? this._host.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            JMXRMIServerSocketFactory that = (JMXRMIServerSocketFactory)obj;
            return Objects.equals(this._host, that._host);
        }
    }
}

