/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import com.cloudhopper.commons.charset.GSMCharset;
import java.util.Arrays;

public class VFD2GSMCharset
extends GSMCharset {
    private static final int GSM_COL = 0;
    private static final int VFD2_COL = 1;
    private static final byte[][] VFD2_OVERRIDE_TABLE = new byte[][]{{0, 64}, {2, 36}, {30, 126}, {36, 2}, {64, -95}, {93, 95}, {94, 93}, {95, 94}, {125, 30}, {126, 125}};

    @Override
    public byte[] encode(CharSequence str0) {
        byte[] gsmBytes = super.encode(str0);
        block0: for (int i = 0; i < gsmBytes.length; ++i) {
            for (int j = 0; j < VFD2_OVERRIDE_TABLE.length; ++j) {
                if (gsmBytes[i] != VFD2_OVERRIDE_TABLE[j][0]) continue;
                gsmBytes[i] = VFD2_OVERRIDE_TABLE[j][1];
                continue block0;
            }
        }
        return gsmBytes;
    }

    @Override
    public void decode(byte[] bytes, StringBuilder buffer) {
        int length = bytes == null ? 0 : bytes.length;
        byte[] bytes2 = null;
        block0: for (int i = 0; i < length; ++i) {
            for (int j = 0; j < VFD2_OVERRIDE_TABLE.length; ++j) {
                if (bytes[i] != VFD2_OVERRIDE_TABLE[j][1]) continue;
                if (bytes2 == null) {
                    bytes2 = Arrays.copyOf(bytes, bytes.length);
                }
                bytes2[i] = VFD2_OVERRIDE_TABLE[j][0];
                continue block0;
            }
        }
        super.decode(bytes2 == null ? bytes : bytes2, buffer);
    }
}

