/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import java.text.Normalizer;

public class MobileTextUtil {
    public static final char[][] CHAR_TABLE = new char[][]{{'\u2013', '-'}, {'\u2014', '-'}, {'\u2018', '\''}, {'\u2019', '\''}, {'\u201a', '\''}, {'\u201b', '\''}, {'\u201c', '\"'}, {'\u201d', '\"'}, {'\u201e', '\"'}, {'\u201f', '\"'}, {'\u2020', '+'}, {'\u2022', '.'}, {'\u2026', '.'}, {'\u2039', '<'}, {'\u203a', '>'}};

    public static int replaceSafeUnicodeChars(StringBuilder buffer) {
        int replaced = 0;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            for (int j = 0; j < CHAR_TABLE.length; ++j) {
                if (c != CHAR_TABLE[j][0]) continue;
                ++replaced;
                buffer.setCharAt(i, CHAR_TABLE[j][1]);
            }
        }
        return replaced;
    }

    public static int replaceAccentedChars(StringBuilder buffer) {
        int sizeBefore = buffer.length();
        String s = Normalizer.normalize(buffer, Normalizer.Form.NFD);
        int sizeAfter = s.length();
        int replaced = sizeAfter - sizeBefore;
        if (replaced <= 0) {
            return 0;
        }
        s = s.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        buffer.setLength(0);
        buffer.append(s);
        return replaced;
    }
}

