/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import org.traccar.BasePipelineFactory;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;
import org.traccar.protocol.SuntechProtocolDecoder;

public class SuntechProtocolEncoder
extends StringProtocolEncoder {
    public SuntechProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private String getPrefix(Channel channel) {
        String decoderPrefix;
        SuntechProtocolDecoder protocolDecoder;
        String prefix = "SA200CMD";
        if (channel != null && (protocolDecoder = BasePipelineFactory.getHandler(channel.pipeline(), SuntechProtocolDecoder.class)) != null && (decoderPrefix = protocolDecoder.getPrefix()) != null && decoderPrefix.length() > 5) {
            prefix = decoderPrefix.substring(0, decoderPrefix.length() - 3) + "CMD";
        }
        return prefix;
    }

    @Override
    protected Object encodeCommand(Channel channel, Command command) {
        String prefix = this.getPrefix(channel);
        switch (command.getType()) {
            case "rebootDevice": {
                return this.formatCommand(command, prefix + ";%s;02;Reboot\r", "uniqueId");
            }
            case "positionSingle": {
                return this.formatCommand(command, prefix + ";%s;02;\r", "uniqueId");
            }
            case "outputControl": {
                if (command.getAttributes().containsKey("data")) {
                    if (command.getAttributes().get("data").equals("1")) {
                        return this.formatCommand(command, prefix + ";%s;02;Enable%s\r", "uniqueId", "index");
                    }
                    return this.formatCommand(command, prefix + ";%s;02;Disable%s\r", "uniqueId", "index");
                }
            }
            case "engineStop": {
                return this.formatCommand(command, prefix + ";%s;02;Enable1\r", "uniqueId");
            }
            case "engineResume": {
                return this.formatCommand(command, prefix + ";%s;02;Disable1\r", "uniqueId");
            }
            case "alarmArm": {
                return this.formatCommand(command, prefix + ";%s;02;Enable2\r", "uniqueId");
            }
            case "alarmDisarm": {
                return this.formatCommand(command, prefix + ";%s;02;Disable2\r", "uniqueId");
            }
        }
        return null;
    }
}

