/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class GpsGateProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_GPRMC = new PatternBuilder().text("$GPRMC,").number("(dd)(dd)(dd).?d*,").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),").number("(d+.d+)?,").number("(d+.d+)?,").number("(dd)(dd)(dd)").any().compile();
    private static final Pattern PATTERN_FRCMD = new PatternBuilder().text("$FRCMD,").number("(d+),").expression("[^,]*,").expression("[^,]*,").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*)?,").number("(dd)(dd)(dd),").number("(dd)(dd)(dd).?d*,").expression("([01])").any().compile();

    public GpsGateProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void send(Channel channel, SocketAddress remoteAddress, String message) {
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(message + Checksum.nmea(message) + "\r\n", remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("$FRLIN,")) {
            int beginIndex = sentence.indexOf(44, 7);
            if (beginIndex != -1) {
                int endIndex;
                if ((endIndex = sentence.indexOf(44, ++beginIndex)) != -1) {
                    String imei = sentence.substring(beginIndex, endIndex);
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
                    if (deviceSession != null) {
                        if (channel != null) {
                            this.send(channel, remoteAddress, "$FRSES," + channel.id().asShortText());
                        }
                    } else {
                        this.send(channel, remoteAddress, "$FRERR,AuthError,Unknown device");
                    }
                } else {
                    this.send(channel, remoteAddress, "$FRERR,AuthError,Parse error");
                }
            } else {
                this.send(channel, remoteAddress, "$FRERR,AuthError,Parse error");
            }
        } else if (sentence.startsWith("$FRVER,")) {
            this.send(channel, remoteAddress, "$FRVER,1,0,GpsGate Server 1.0");
        } else {
            if (sentence.startsWith("$GPRMC,")) {
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
                if (deviceSession == null) {
                    return null;
                }
                Parser parser = new Parser(PATTERN_GPRMC, sentence);
                if (!parser.matches()) {
                    return null;
                }
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
                position.setValid(parser.next().equals("A"));
                position.setLatitude(parser.nextCoordinate());
                position.setLongitude(parser.nextCoordinate());
                position.setSpeed(parser.nextDouble(0.0));
                position.setCourse(parser.nextDouble(0.0));
                dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
                position.setTime(dateBuilder.getDate());
                return position;
            }
            if (sentence.startsWith("$FRCMD,")) {
                Parser parser = new Parser(PATTERN_FRCMD, sentence);
                if (!parser.matches()) {
                    return null;
                }
                Position position = new Position(this.getProtocolName());
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
                if (deviceSession == null) {
                    return null;
                }
                position.setDeviceId(deviceSession.getDeviceId());
                position.setLatitude(parser.nextCoordinate());
                position.setLongitude(parser.nextCoordinate());
                position.setAltitude(parser.nextDouble(0.0));
                position.setSpeed(parser.nextDouble(0.0));
                position.setCourse(parser.nextDouble(0.0));
                position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
                position.setValid(parser.next().equals("1"));
                return position;
            }
        }
        return null;
    }
}

