/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeUtil {
    public static DateTime toDateTime(Timestamp value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getTime(), DateTimeZone.UTC);
    }

    public static DateTime copy(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getMillis(), DateTimeZone.UTC);
    }

    public static Timestamp toTimestamp(DateTime dt) {
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt.getMillis());
    }

    public static DateTime now() {
        return new DateTime(DateTimeZone.UTC);
    }

    public static DateTime parseEmbedded(String string0) throws IllegalArgumentException {
        return DateTimeUtil.parseEmbedded(string0, "yyyy-MM-dd", DateTimeZone.UTC);
    }

    public static DateTime parseEmbedded(String string0, String pattern, DateTimeZone zone) throws IllegalArgumentException {
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern).withZone(zone);
        StringBuilder regex = new StringBuilder(pattern.length() * 2);
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetter(c)) {
                regex.append("\\d");
                continue;
            }
            regex.append(c);
        }
        Pattern p = Pattern.compile(regex.toString());
        Matcher m = p.matcher(string0);
        if (!m.find()) {
            throw new IllegalArgumentException("String '" + string0 + "' did not contain an embedded date [regexPattern='" + regex.toString() + "', datePattern='" + pattern + "']");
        }
        String dateString = m.group();
        return fmt.parseDateTime(dateString);
    }

    public static DateTime floorToYear(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getYear(), 1, 1, 0, 0, 0, 0, value.getZone());
    }

    public static DateTime floorToMonth(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getYear(), value.getMonthOfYear(), 1, 0, 0, 0, 0, value.getZone());
    }

    public static DateTime floorToDay(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), 0, 0, 0, 0, value.getZone());
    }

    public static DateTime floorToHour(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), value.getHourOfDay(), 0, 0, 0, value.getZone());
    }

    public static DateTime floorToHalfHour(DateTime value) {
        return DateTimeUtil.floorToMinutePeriod(value, 30);
    }

    public static DateTime floorToQuarterHour(DateTime value) {
        return DateTimeUtil.floorToMinutePeriod(value, 15);
    }

    public static DateTime floorToTenMinutes(DateTime value) {
        return DateTimeUtil.floorToMinutePeriod(value, 10);
    }

    public static DateTime floorToFiveMinutes(DateTime value) {
        return DateTimeUtil.floorToMinutePeriod(value, 5);
    }

    public static DateTime floorToMinutePeriod(DateTime value, int periodInMinutes) {
        if (value == null) {
            return null;
        }
        if (periodInMinutes <= 0 || periodInMinutes > 59) {
            throw new IllegalArgumentException("period in minutes must be > 0 and <= 59");
        }
        int min = value.getMinuteOfHour();
        min = min / periodInMinutes * periodInMinutes;
        return new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), value.getHourOfDay(), min, 0, 0, value.getZone());
    }

    public static DateTime floorToMinute(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), value.getHourOfDay(), value.getMinuteOfHour(), 0, 0, value.getZone());
    }

    public static DateTime floorToSecond(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), value.getHourOfDay(), value.getMinuteOfHour(), value.getSecondOfMinute(), 0, value.getZone());
    }
}

