/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.calendar.ical4j.impl.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class Options {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.calendar.ical4j.impl.prefs");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/calendar");
    private static final String KEY_PATH = "icalendar.path";
    private static final String DEF_PATH = System.getProperty("user.home");
    private static final String KEY_TIMEZONE = "timezone.id";
    public static final String DEF_TIMEZONE = "";

    public static final String getICalendarPath() {
        return prefs.get(KEY_PATH, DEF_PATH);
    }

    public static final void setICalendarPath(String value) {
        prefs.put(KEY_PATH, value);
        Options.flush();
    }

    public static final String getTimeZoneID() {
        return prefs.get(KEY_TIMEZONE, DEF_TIMEZONE);
    }

    public static final void setTimeZoneID(String value) {
        prefs.put(KEY_TIMEZONE, value);
        Options.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Default calendar synchronization preferences exception.");
            ex.printStackTrace(System.err);
        }
    }
}

