/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;

public class SingleByteFont
extends CustomFont {
    private CodePointMapping mapping;
    private String encoding = "WinAnsiEncoding";
    private int[] width = null;

    public SingleByteFont() {
        this.updateMapping();
    }

    protected void updateMapping() {
        this.mapping = CodePointMapping.getMapping(this.getEncoding());
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.getEmbedResourceName() != null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.updateMapping();
    }

    public int getWidth(int i, int size) {
        return size * this.width[i];
    }

    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        return arr;
    }

    public char mapChar(char c) {
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    public void setWidth(int index, int width) {
        if (this.width == null) {
            this.width = new int[256];
        }
        this.width[index] = width;
    }

    public char[] getCharsUsed() {
        return null;
    }
}

