/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.demo;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import net.miginfocom.demo.HiDPIDemoPanel;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.swing.MigLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.SubstanceFontUtilities;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class HiDPISimulator {
    static final String SYSTEM_LAF_NAME = "System";
    static final String SUBSTANCE_LAF_NAME = "Substance";
    static final String OCEAN_LAF_NAME = "Ocean";
    static final String NUMBUS_LAF_NAME = "Nimbus (Soon..)";
    static JFrame APP_GUI_FRAME;
    static HiDPIDemoPanel HiDPIDEMO_PANEL;
    static JPanel SIM_PANEL;
    static JPanel MIRROR_PANEL;
    static JScrollPane MAIN_SCROLL;
    static JTextArea TEXT_AREA;
    static boolean SCALE_LAF;
    static boolean SCALE_FONTS;
    static boolean SCALE_LAYOUT;
    static boolean PAINT_GHOSTED;
    static BufferedImage GUI_BUF;
    static BufferedImage ORIG_GUI_BUF;
    static int CUR_DPI;
    static HashMap<String, Font> ORIG_DEFAULTS;

    private static JPanel createScaleMirror() {
        return new JPanel(new MigLayout()){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (GUI_BUF != null) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    double dpi = this.getToolkit().getScreenResolution();
                    AffineTransform oldTrans = g2.getTransform();
                    g2.scale(dpi / (double)CUR_DPI, dpi / (double)CUR_DPI);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2.drawImage((Image)GUI_BUF, 0, 0, null);
                    g2.setTransform(oldTrans);
                    if (ORIG_GUI_BUF != null && PAINT_GHOSTED) {
                        g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                        g2.drawImage((Image)ORIG_GUI_BUF, 0, 0, null);
                    }
                    g2.dispose();
                }
            }

            public Dimension getPreferredSize() {
                return ORIG_GUI_BUF != null ? new Dimension(ORIG_GUI_BUF.getWidth(), ORIG_GUI_BUF.getHeight()) : new Dimension(100, 100);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
    }

    private static JPanel createSimulator() {
        final JRadioButton scaleCompsFonts = new JRadioButton("UIManager Font Substitution", true);
        final JRadioButton scaleCompsLaf = new JRadioButton("Native Look&Feel Scaling", false);
        JRadioButton scaleCompsNone = new JRadioButton("No Scaling", false);
        final JRadioButton scaleLayoutMig = new JRadioButton("Native MigLayout Gap Scaling", true);
        JRadioButton scaleLayoutNone = new JRadioButton("No Gap Scaling", false);
        final JComboBox<String> lafCombo = new JComboBox<String>(new String[]{SYSTEM_LAF_NAME, SUBSTANCE_LAF_NAME, OCEAN_LAF_NAME, NUMBUS_LAF_NAME});
        ButtonGroup bg1 = new ButtonGroup();
        ButtonGroup bg2 = new ButtonGroup();
        final JCheckBox ghostCheck = new JCheckBox("Overlay \"Optimal\" HiDPI Result");
        scaleCompsLaf.setEnabled(false);
        bg1.add(scaleCompsFonts);
        bg1.add(scaleCompsLaf);
        bg1.add(scaleCompsNone);
        bg2.add(scaleLayoutMig);
        bg2.add(scaleLayoutNone);
        Vector<String> dpiStrings = new Vector<String>();
        for (float f = 0.5f; f < 2.01f; f += 0.1f) {
            dpiStrings.add(Math.round((float)PlatformDefaults.getDefaultDPI() * f) + " DPI (" + Math.round(f * 100.0f + 0.499f) + "%)");
        }
        final JComboBox dpiCombo = new JComboBox(dpiStrings);
        dpiCombo.setSelectedIndex(5);
        JPanel panel = new JPanel(new MigLayout("alignx center, insets 10px, flowy", "[]", "[]3px[]0px[]"));
        JLabel lafLabel = new JLabel("Look & Feel:");
        JLabel sliderLabel = new JLabel("Simulated DPI:");
        JLabel scaleLabel = new JLabel("Component/Text Scaling:");
        JLabel layoutLabel = new JLabel("LayoutManager Scaling:");
        JLabel visualsLabel = new JLabel("Visual Aids:");
        panel.add((Component)lafLabel, "");
        panel.add(lafCombo, "wrap");
        panel.add((Component)sliderLabel, "");
        panel.add(dpiCombo, "wrap");
        panel.add((Component)scaleLabel, "");
        panel.add((Component)scaleCompsFonts, "");
        panel.add((Component)scaleCompsLaf, "");
        panel.add((Component)scaleCompsNone, "wrap");
        panel.add((Component)layoutLabel, "");
        panel.add((Component)scaleLayoutMig, "");
        panel.add((Component)scaleLayoutNone, "wrap");
        panel.add((Component)visualsLabel, "");
        panel.add((Component)ghostCheck, "");
        HiDPISimulator.lockFont(dpiCombo, scaleCompsFonts, scaleCompsLaf, scaleLayoutMig, scaleCompsNone, lafCombo, ghostCheck, panel, lafLabel, sliderLabel, scaleLayoutNone, scaleLabel, layoutLabel, visualsLabel);
        lafCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI_BUF = null;
                try {
                    Object s = lafCombo.getSelectedItem();
                    dpiCombo.setSelectedIndex(5);
                    if (s.equals(HiDPISimulator.SYSTEM_LAF_NAME)) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    } else if (s.equals(HiDPISimulator.SUBSTANCE_LAF_NAME)) {
                        UIManager.setLookAndFeel((LookAndFeel)new SubstanceBusinessBlackSteelLookAndFeel());
                    } else if (s.equals(HiDPISimulator.OCEAN_LAF_NAME)) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    } else {
                        JOptionPane.showMessageDialog(APP_GUI_FRAME, "Nimbus will be included as soon as it is ready!");
                    }
                    if (ORIG_DEFAULTS != null) {
                        for (String key : ORIG_DEFAULTS.keySet()) {
                            UIManager.put(key, null);
                        }
                    }
                    ORIG_DEFAULTS = null;
                    if (UIManager.getLookAndFeel().getName().toLowerCase().contains("windows")) {
                        UIManager.put("TextArea.font", UIManager.getFont("TextField.font"));
                    } else {
                        UIManager.put("TextArea.font", null);
                    }
                    SwingUtilities.updateComponentTreeUI(APP_GUI_FRAME);
                    MAIN_SCROLL.setBorder(null);
                    if (s.equals(HiDPISimulator.SYSTEM_LAF_NAME)) {
                        if (scaleCompsLaf.isSelected()) {
                            scaleCompsFonts.setSelected(true);
                        }
                        scaleCompsLaf.setEnabled(false);
                    } else if (s.equals(HiDPISimulator.SUBSTANCE_LAF_NAME)) {
                        scaleCompsLaf.setEnabled(true);
                    } else if (s.equals(HiDPISimulator.OCEAN_LAF_NAME)) {
                        if (scaleCompsLaf.isSelected()) {
                            scaleCompsFonts.setSelected(true);
                        }
                        scaleCompsLaf.setEnabled(false);
                    }
                    HiDPISimulator.setDPI(CUR_DPI);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        ghostCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI_BUF = null;
                PAINT_GHOSTED = ghostCheck.isSelected();
                APP_GUI_FRAME.repaint();
            }
        });
        scaleLayoutMig.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GUI_BUF = null;
                SCALE_LAYOUT = scaleLayoutMig.isSelected();
                HiDPISimulator.setDPI(CUR_DPI);
            }
        });
        ItemListener il = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GUI_BUF = null;
                    SCALE_LAF = scaleCompsLaf.isSelected();
                    SCALE_FONTS = scaleCompsFonts.isSelected();
                    HiDPISimulator.setDPI(CUR_DPI);
                }
            }
        };
        scaleCompsLaf.addItemListener(il);
        scaleCompsFonts.addItemListener(il);
        scaleCompsNone.addItemListener(il);
        dpiCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GUI_BUF = null;
                    CUR_DPI = Integer.parseInt(dpiCombo.getSelectedItem().toString().substring(0, 3).trim());
                    HiDPISimulator.setDPI(CUR_DPI);
                }
            }
        });
        return panel;
    }

    private static void lockFont(Component ... comps) {
        for (Component c : comps) {
            Font f = c.getFont();
            c.setFont(f.deriveFont((float)f.getSize()));
        }
    }

    private static void revalidateGUI() {
        APP_GUI_FRAME.getContentPane().invalidate();
        APP_GUI_FRAME.repaint();
    }

    private static synchronized void setDPI(int dpi) {
        Set<Map.Entry<String, Font>> entries;
        float fontScale;
        float scaleFactor = (float)dpi / (float)Toolkit.getDefaultToolkit().getScreenResolution();
        TEXT_AREA.setSize(0, 0);
        PlatformDefaults.setHorizontalScaleFactor(Float.valueOf(0.1f));
        PlatformDefaults.setHorizontalScaleFactor(SCALE_LAYOUT ? Float.valueOf(scaleFactor) : null);
        PlatformDefaults.setVerticalScaleFactor(SCALE_LAYOUT ? Float.valueOf(scaleFactor) : null);
        float f = fontScale = SCALE_FONTS ? (float)dpi / (float)Toolkit.getDefaultToolkit().getScreenResolution() : 1.0f;
        if (ORIG_DEFAULTS == null) {
            ORIG_DEFAULTS = new HashMap();
            entries = new HashSet(UIManager.getLookAndFeelDefaults().keySet());
            Iterator<Map.Entry<String, Font>> it = entries.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                Object value = UIManager.get(key);
                if (!(value instanceof Font)) continue;
                ORIG_DEFAULTS.put(key, (Font)value);
            }
        }
        entries = ORIG_DEFAULTS.entrySet();
        for (Map.Entry<String, Font> e : entries) {
            Font origFont = e.getValue();
            if (!SCALE_LAF) {
                UIManager.put(e.getKey(), new FontUIResource(origFont.deriveFont((float)origFont.getSize() * fontScale)));
                continue;
            }
            UIManager.put(e.getKey(), null);
        }
        if (SCALE_LAF) {
            HiDPISimulator.scaleSubstanceLAF(scaleFactor);
        } else if (UIManager.getLookAndFeel().getName().toLowerCase().contains("substance")) {
            HiDPISimulator.scaleSubstanceLAF(1.0f);
        }
        SwingUtilities.updateComponentTreeUI(HiDPIDEMO_PANEL);
        HiDPISimulator.revalidateGUI();
    }

    private static void scaleSubstanceLAF(float factor) {
        SubstanceLookAndFeel.setFontPolicy((FontPolicy)SubstanceFontUtilities.getScaledFontPolicy((float)factor));
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SubstanceBusinessBlackSteelLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(APP_GUI_FRAME);
        MAIN_SCROLL.setBorder(null);
    }

    public static void main(String[] args) {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "HiDPI Simulator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlatformDefaults.setDefaultHorizontalUnit(1);
        PlatformDefaults.setDefaultVerticalUnit(2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (UIManager.getLookAndFeel().getName().toLowerCase().contains("windows")) {
                    UIManager.put("TextArea.font", UIManager.getFont("TextField.font"));
                }
                APP_GUI_FRAME = new JFrame("Resolution Independence Simulator");
                JPanel uberPanel = new JPanel(new MigLayout("fill, insets 0px, nocache"));
                JPanel mainPanel = new JPanel(new MigLayout("fill, insets 0px, nocache")){

                    public void paintComponent(Graphics g) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(20, 20, 30), 0.0f, this.getHeight(), new Color(90, 90, 110), false));
                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g2.setFont(g2.getFont().deriveFont(1, 13.0f));
                        g2.setPaint(Color.WHITE);
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        g2.drawString("Left panel shows the scaled version. Right side shows how this would look on a HiDPI screen. It should look the same as the original panel!", 10, 19);
                        g2.dispose();
                    }
                };
                HiDPIDEMO_PANEL = new HiDPIDemoPanel();
                SIM_PANEL = HiDPISimulator.createSimulator();
                MIRROR_PANEL = HiDPISimulator.createScaleMirror();
                MAIN_SCROLL = new JScrollPane(mainPanel);
                MAIN_SCROLL.setBorder(null);
                mainPanel.add((Component)HiDPIDEMO_PANEL, "align center center, split, span, width pref!");
                mainPanel.add((Component)MIRROR_PANEL, "id mirror, gap 20px!, width pref!");
                uberPanel.add((Component)SIM_PANEL, "dock south");
                uberPanel.add((Component)MAIN_SCROLL, "dock center");
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                APP_GUI_FRAME.setContentPane(uberPanel);
                APP_GUI_FRAME.setSize(Math.min(1240, screenSize.width), Math.min(950, screenSize.height - 30));
                APP_GUI_FRAME.setDefaultCloseOperation(3);
                APP_GUI_FRAME.setLocationRelativeTo(null);
                APP_GUI_FRAME.setVisible(true);
            }
        });
    }

    static {
        SCALE_LAF = false;
        SCALE_FONTS = true;
        SCALE_LAYOUT = true;
        PAINT_GHOSTED = false;
        GUI_BUF = null;
        ORIG_GUI_BUF = null;
        CUR_DPI = PlatformDefaults.getDefaultDPI();
    }
}

