/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.l10n.prefs;

import au.com.trgtd.tr.l10n.Locale;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class L10nPrefs {
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_LOCALE = "locale";
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.l10n");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/l10n");

    public static final Locale getLocale() {
        try {
            return Locale.valueOf(prefs.get(KEY_LOCALE, Locale.en_UK.name()));
        }
        catch (IllegalArgumentException ex) {
            return Locale.none;
        }
    }

    public static final void setLanguage(Locale locale) {
        if (locale == null) {
            prefs.put(KEY_LOCALE, Locale.none.name());
        } else {
            prefs.put(KEY_LOCALE, locale.name());
        }
        L10nPrefs.flush();
    }

    public static final boolean isEnabled() {
        return prefs.getBoolean(KEY_ENABLED, false);
    }

    public static final void setEnabled(boolean enabled) {
        prefs.putBoolean(KEY_ENABLED, enabled);
        L10nPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("L10n preferences error. " + ex.getMessage());
        }
    }
}

