/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.ExecBridge;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;

public class Toolbar
extends JToolBar {
    @Deprecated
    public static final int BASIC_HEIGHT = 34;
    static int HEIGHT_TOLERANCE;
    static int TOP;
    static int LEFT;
    static int BOTTOM;
    static int RIGHT;
    static int RESIDUAL_WIDTH;
    private boolean floatable;
    private DnDListener listener;
    private ToolbarMouseListener mouseListener;
    private String displayName;
    private DataFolder backingFolder;
    private Folder processor;
    private static final boolean isMetalLaF;
    private static final boolean isJdk15;
    private static final boolean isJdk16;
    static final long serialVersionUID = 5011742660516204764L;
    private static final int customFontHeightCorrection;
    private static Class synthIconClass;
    private static boolean testExecuted;
    int dropTargetButtonIndex = -1;
    int dragSourceButtonIndex = -1;
    boolean insertBefore = true;
    boolean isDragSourceToolbar = false;
    private static DataFlavor buttonDataFlavor;
    private static DataFlavor actionDataFlavor;
    private DnDSupport dnd;
    private static final Insets emptyInsets;
    private static Boolean isXP;
    private static Map<RenderingHints.Key, Object> hintsMap;

    public Toolbar() {
        this("");
    }

    public Toolbar(String string) {
        this(string, string, false);
    }

    public Toolbar(String string, String string2) {
        this(string, string2, false);
    }

    public Toolbar(String string, boolean bl) {
        this(string, string, bl);
    }

    Toolbar(DataFolder dataFolder, boolean bl) {
        this.backingFolder = dataFolder;
        this.initAll(dataFolder.getName(), bl);
        this.initDnD();
    }

    private static boolean useSynthIcon() {
        if (!testExecuted) {
            testExecuted = true;
            try {
                synthIconClass = Class.forName("sun.swing.plaf.synth.SynthIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(Toolbar.class.getName()).log(Level.INFO, null, classNotFoundException);
            }
        }
        return synthIconClass != null;
    }

    private void initDnD() {
        DropTarget dropTarget = new DropTarget(this, this.getDnd());
    }

    DataFolder getFolder() {
        return this.backingFolder;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (-1 != this.dropTargetButtonIndex) {
            this.paintDropGesture(graphics);
        }
    }

    private void updateDropGesture(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        Component component = this.getComponentAt(point);
        int n = this.getComponentIndex(component);
        if (n == 0) {
            this.resetDropGesture();
        } else {
            boolean bl;
            boolean bl2 = bl = point.x <= component.getLocation().x + component.getWidth() / 2;
            if (n != this.dropTargetButtonIndex || bl != this.insertBefore) {
                this.dropTargetButtonIndex = n;
                this.insertBefore = bl;
                this.repaint();
            }
        }
    }

    private void resetDropGesture() {
        this.dropTargetButtonIndex = -1;
        this.repaint();
    }

    private void paintDropGesture(Graphics graphics) {
        Component component = this.getComponentAtIndex(this.dropTargetButtonIndex);
        if (null == component) {
            return;
        }
        Point point = component.getLocation();
        int n = point.x;
        if (!this.insertBefore) {
            n += component.getWidth();
            if (this.dropTargetButtonIndex == this.getComponentCount() - 1) {
                n -= 3;
            }
        }
        this.drawDropLine(graphics, n);
    }

    private void drawDropLine(Graphics graphics, int n) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n2 = this.getHeight();
        graphics.drawLine(n, 3, n, n2 - 4);
        graphics.drawLine(n - 1, 3, n - 1, n2 - 4);
        graphics.drawLine(n + 1, 2, n + 1 + 2, 2);
        graphics.drawLine(n + 1, n2 - 3, n + 1 + 2, n2 - 3);
        graphics.drawLine(n - 2, 2, n - 2 - 2, 2);
        graphics.drawLine(n - 2, n2 - 3, n - 2 - 2, n2 - 3);
        graphics.setColor(color);
    }

    private void removeButton(Transferable transferable) {
        try {
            Object object = null;
            if (transferable.isDataFlavorSupported(buttonDataFlavor)) {
                object = transferable.getTransferData(buttonDataFlavor);
            }
            if (null != object && object instanceof DataObject) {
                ((DataObject)object).delete();
                this.repaint();
                if (this.backingFolder.getChildren().length == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                Toolbar.this.backingFolder.delete();
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, iOException);
                            }
                        }
                    });
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private boolean handleDrop(Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(actionDataFlavor)) {
                Object object = transferable.getTransferData(actionDataFlavor);
                if (object instanceof Node) {
                    DataObject dataObject = (DataObject)((Node)object).getLookup().lookup(DataObject.class);
                    return this.addButton(dataObject, this.dropTargetButtonIndex - 1, this.insertBefore);
                }
            } else {
                Object object = transferable.getTransferData(buttonDataFlavor);
                if (object instanceof DataObject) {
                    return this.moveButton((DataObject)object, this.dropTargetButtonIndex - 1, this.insertBefore);
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    private boolean isInToolbarPanel(Point point) {
        ToolbarPool toolbarPool = ToolbarPool.getDefault();
        SwingUtilities.convertPointFromScreen(point, toolbarPool);
        return toolbarPool.contains(point);
    }

    private boolean addButton(DataObject dataObject, int n, boolean bl) throws IOException {
        if (null == dataObject) {
            return false;
        }
        String string = dataObject.getName();
        DataObject[] dataObjectArray = this.backingFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (!string.equals(dataObjectArray[i].getName())) continue;
            this.isDragSourceToolbar = true;
            return this.moveButton(dataObjectArray[i], n, bl);
        }
        DataObject dataObject2 = this.getDataObjectUnderDropCursor(n, bl);
        DataShadow dataShadow = DataShadow.create(this.backingFolder, dataObject);
        DataObject dataObject3 = null;
        dataObjectArray = this.backingFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (!string.equals(dataObjectArray[i].getName())) continue;
            dataObject3 = dataObjectArray[i];
            break;
        }
        if (null != dataObject3) {
            this.reorderButtons(dataObject3, dataObject2);
        }
        return true;
    }

    private boolean moveButton(DataObject dataObject, int n, boolean bl) throws IOException {
        DataObject dataObject2 = this.getDataObjectUnderDropCursor(n, bl);
        if (!this.isDragSourceToolbar) {
            dataObject.move(this.backingFolder);
        }
        this.reorderButtons(dataObject, dataObject2);
        return true;
    }

    private void reorderButtons(DataObject dataObject, DataObject dataObject2) throws IOException {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(Arrays.asList(this.backingFolder.getChildren()));
        if (null == dataObject2) {
            arrayList.remove(dataObject);
            arrayList.add(dataObject);
        } else {
            int n = arrayList.indexOf(dataObject2);
            int n2 = arrayList.indexOf(dataObject);
            if (n2 < n) {
                --n;
            }
            arrayList.remove(dataObject);
            arrayList.add(n, dataObject);
        }
        this.backingFolder.setOrder(arrayList.toArray(new DataObject[arrayList.size()]));
    }

    private DataObject getDataObjectUnderDropCursor(int n, boolean bl) {
        DataObject[] dataObjectArray = this.backingFolder.getChildren();
        DataObject dataObject = null;
        if (dataObjectArray.length > 0) {
            if (!bl) {
                ++n;
            }
            if (n < dataObjectArray.length && n >= 0) {
                dataObject = dataObjectArray[n];
            }
        }
        return dataObject;
    }

    private boolean validateDropPosition() {
        return this.dropTargetButtonIndex >= 0 && (!this.isDragSourceToolbar || this.dragSourceButtonIndex != this.dropTargetButtonIndex && (this.dropTargetButtonIndex != this.dragSourceButtonIndex - 1 || this.insertBefore) && (this.dropTargetButtonIndex != this.dragSourceButtonIndex + 1 || !this.insertBefore)) || this.dropTargetButtonIndex < 0 && this.getComponentCount() == 1;
    }

    final Folder waitFinished() {
        if (this.backingFolder == null) {
            return null;
        }
        if (this.processor == null && this.isVisible()) {
            this.processor = new Folder();
        }
        return this.processor;
    }

    public void addNotify() {
        super.addNotify();
        this.waitFinished();
    }

    public Component[] getComponents() {
        this.waitFinished();
        return super.getComponents();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.waitFinished();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof AbstractButton) {
            component.setFocusable(false);
            ((JComponent)component).setOpaque(false);
            if (isMetalLaF && (isJdk15 || isJdk16)) {
                ((AbstractButton)component).setBorderPainted(false);
                ((AbstractButton)component).setOpaque(false);
            }
            if (isJdk16 && !isMetalLaF) {
                ((AbstractButton)component).setMargin(emptyInsets);
            }
        } else if (component instanceof JToolBar.Separator) {
            JToolBar.Separator separator = (JToolBar.Separator)component;
            if (this.getOrientation() == 1) {
                separator.setOrientation(0);
            } else {
                separator.setOrientation(1);
            }
        }
        super.addImpl(component, object, n);
        if (!"grip".equals(component.getName()) && !(component instanceof JToolBar.Separator)) {
            this.getDnd().register(component);
        }
    }

    public Toolbar(String string, String string2, boolean bl) {
        this.setDisplayName(string2);
        this.initAll(string, bl);
    }

    public static int getBasicHeight() {
        if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
            return 44;
        }
        return 34;
    }

    private void initAll(String string, boolean bl) {
        this.floatable = bl;
        this.mouseListener = null;
        this.setName(string);
        this.setFloatable(false);
        String string2 = UIManager.getLookAndFeel().getName();
        if (string2.equals("Windows")) {
            this.setBorder(Boolean.getBoolean("netbeans.small.main.window") ? BorderFactory.createEmptyBorder(1, 1, 1, 1) : BorderFactory.createEmptyBorder());
        } else if (!"Aqua".equals(UIManager.getLookAndFeel().getID()) && !"GTK".equals(UIManager.getLookAndFeel().getID())) {
            Border border = UIManager.getBorder("ToolBar.border");
            if (border == null || border instanceof MetalBorders.ToolBarBorder) {
                border = BorderFactory.createEtchedBorder(1);
            }
            this.setBorder(new CompoundBorder(border, new EmptyBorder(TOP, LEFT, BOTTOM, RIGHT)));
        }
        if (!"Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        this.addGrip();
        this.getAccessibleContext().setAccessibleName(this.displayName == null ? this.getName() : this.displayName);
        this.getAccessibleContext().setAccessibleDescription(this.getName());
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    public Dimension getPreferredSize() {
        String string = UIManager.getLookAndFeel().getID();
        int n = ToolbarPool.getDefault().getPreferredIconSize() == 24 ? ("Aqua".equals(string) ? 37 : ("Metal".equals(string) ? 44 : ("Windows".equals(string) ? (Toolbar.isXPTheme() ? 31 : 35) : ("GTK".equals(string) ? 40 : 36)))) : ("Aqua".equals(string) ? 29 : ("Metal".equals(string) ? 36 : ("Windows".equals(string) ? (Toolbar.isXPTheme() ? 23 : 27) : ("GTK".equals(string) ? 32 : 28))));
        Dimension dimension = super.getPreferredSize();
        dimension.height = Math.max(dimension.height, n);
        return dimension;
    }

    public void removeAll() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getDnd().unregister(this.getComponent(i));
        }
        super.removeAll();
        this.addGrip();
    }

    void addGrip() {
        if (this.floatable && !"QuickSearch".equals(this.getName())) {
            String string = UIManager.getLookAndFeel().getID();
            JPanel jPanel = null;
            jPanel = string.endsWith("Windows") ? (Toolbar.isXPTheme() ? new ToolbarXP() : new ToolbarGrip()) : (string.equals("Aqua") ? new ToolbarAqua() : (string.equals("GTK") ? new ToolbarGtk() : new ToolbarBump()));
            if (this.mouseListener == null) {
                this.mouseListener = new ToolbarMouseListener();
            }
            if (jPanel != null) {
                jPanel.addMouseListener(this.mouseListener);
                jPanel.addMouseMotionListener(this.mouseListener);
                jPanel.setName("grip");
                this.add(jPanel);
            }
        }
    }

    public static int rowCount(int n) {
        return 1 + n / (Toolbar.getBasicHeight() + HEIGHT_TOLERANCE + customFontHeightCorrection);
    }

    public void setDnDListener(DnDListener dnDListener) {
        this.listener = dnDListener;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            if (this.backingFolder.isValid()) {
                try {
                    return this.backingFolder.getNodeDelegate().getDisplayName();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return this.backingFolder.getName();
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    private static final void setToolTipText(JComponent jComponent, String string) {
        jComponent.setToolTipText(Actions.cutAmpersand((String)string));
    }

    protected void fireDragToolbar(int n, int n2, int n3) {
        if (this.listener != null) {
            this.listener.dragToolbar(new DnDEvent(this, this.getName(), n, n2, n3));
        }
    }

    protected void fireDropToolbar(int n, int n2, int n3) {
        if (this.listener != null) {
            this.listener.dropToolbar(new DnDEvent(this, this.getName(), n, n2, n3));
        }
    }

    final synchronized MouseInputListener mouseDelegate() {
        if (this.mouseListener == null) {
            this.mouseListener = new ToolbarMouseListener();
        }
        return this.mouseListener;
    }

    private static boolean isXPTheme() {
        if (isXP == null) {
            Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
            isXP = Boolean.TRUE.equals(bl) ? Boolean.TRUE : Boolean.FALSE;
        }
        return isXP;
    }

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap<RenderingHints.Key, Object>();
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
        if (null != this.backingFolder && null != this.processor) {
            this.processor.recreate();
        }
    }

    private DnDSupport getDnd() {
        if (this.dnd == null) {
            this.dnd = new DnDSupport();
        }
        return this.dnd;
    }

    static {
        int n;
        HEIGHT_TOLERANCE = 5;
        TOP = 2;
        LEFT = 3;
        BOTTOM = 2;
        RIGHT = 3;
        RESIDUAL_WIDTH = 16;
        isMetalLaF = MetalLookAndFeel.class.isAssignableFrom(UIManager.getLookAndFeel().getClass());
        String string = System.getProperty("java.version");
        isJdk15 = string.startsWith("1.5");
        isJdk16 = string.startsWith("1.6");
        int n2 = UIManager.getInt("customFontSize");
        if (n2 < 1) {
            n2 = 1;
        }
        if ((n = UIManager.getInt("nbDefaultFontSize")) <= 0) {
            n = 11;
        }
        customFontHeightCorrection = Math.max(n2 - n, 0);
        synthIconClass = null;
        testExecuted = false;
        buttonDataFlavor = new DataFlavor(DataObject.class, "Toolbar Item");
        actionDataFlavor = new DataFlavor(Node.class, "Action Node");
        emptyInsets = new Insets(1, 1, 1, 1);
        isXP = null;
        hintsMap = null;
    }

    private static class DefaultIconButton
    extends JButton {
        private Icon unknownIcon;

        private DefaultIconButton() {
        }

        public Icon getIcon() {
            Icon icon = super.getIcon();
            if (null == icon && (null == this.getText() || this.getText().length() == 0)) {
                if (this.unknownIcon == null) {
                    this.unknownIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/openide/loaders/unknown.gif"));
                }
                icon = this.unknownIcon;
            }
            return icon;
        }
    }

    public static class DnDEvent
    extends EventObject {
        public static final int DND_ONE = 1;
        public static final int DND_END = 2;
        public static final int DND_LINE = 3;
        private String name;
        private int dx;
        private int dy;
        private int type;
        static final long serialVersionUID = 4389530973297716699L;

        public DnDEvent(Toolbar toolbar, String string, int n, int n2, int n3) {
            super(toolbar);
            this.name = string;
            this.dx = n;
            this.dy = n2;
            this.type = n3;
        }

        public String getName() {
            return this.name;
        }

        public int getDX() {
            return this.dx;
        }

        public int getDY() {
            return this.dy;
        }

        public int getType() {
            return this.type;
        }
    }

    public static interface DnDListener
    extends EventListener {
        public void dragToolbar(DnDEvent var1);

        public void dropToolbar(DnDEvent var1);
    }

    private final class ToolbarGrip
    extends JPanel {
        static final int HGAP = 1;
        static final int VGAP = 2;
        static final int STEP = 1;
        static final int WIDTH = 2;
        int columns;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315276L;

        public ToolbarGrip() {
            this(1);
        }

        public ToolbarGrip(int n) {
            this.columns = n;
            int n2 = (n - 1) * 1 + n * 2 + 2;
            this.dim = new Dimension(n2, n2);
            this.max = new Dimension(n2, Integer.MAX_VALUE);
            this.setBorder(new EmptyBorder(2, 1, 2, 1));
            Toolbar.setToolTipText(this, Toolbar.this.getDisplayName());
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = 2;
            int n2 = dimension.height - 1 - 2;
            int n3 = n2 - n;
            graphics.setColor(this.getBackground());
            int n4 = 0;
            int n5 = 1;
            while (n4 < this.columns) {
                graphics.draw3DRect(n5, n, 2, n3, true);
                ++n4;
                n5 += 3;
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarXP
    extends JPanel {
        static final int WIDTH = 7;
        Dimension dim = new Dimension(7, 7);
        Dimension max = new Dimension(7, Integer.MAX_VALUE);
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarXP() {
            Toolbar.setToolTipText(this, Toolbar.this.getDisplayName());
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = 3;
            for (int i = 4; i < this.getHeight() - 4; i += 4) {
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.fillRect(n + 1, i + 1, 2, 2);
                Color color = UIManager.getColor("controlShadow");
                graphics.setColor(color);
                graphics.drawLine(n + 1, i + 1, n + 1, i + 1);
                int n2 = color.getRed();
                int n3 = color.getGreen();
                int n4 = color.getBlue();
                Color color2 = this.getBackground();
                int n5 = color2.getRed();
                int n6 = color2.getGreen();
                int n7 = color2.getBlue();
                int n8 = (n5 - n2) / 5;
                int n9 = (n6 - n3) / 5;
                int n10 = (n7 - n4) / 5;
                color = new Color(n2 += n8, n3 += n9, n4 += n10);
                graphics.setColor(color);
                graphics.drawLine(n + 1, i, n + 1, i);
                color = new Color(n2 += n8, n3 += n9, n4 += n10);
                graphics.setColor(color);
                graphics.drawLine(n, i + 1, n, i + 1);
                color = new Color(n2 += n8, n3 += n9, n4 += n10);
                graphics.setColor(color);
                graphics.drawLine(n, i, n, i);
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarAqua
    extends JPanel {
        static final int WIDTH = 8;
        Dimension dim = new Dimension(8, 8);
        Dimension max = new Dimension(8, Integer.MAX_VALUE);
        static final long serialVersionUID = -8819972972003315277L;

        public ToolbarAqua() {
            Toolbar.setToolTipText(this, Toolbar.this.getDisplayName());
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.addRenderingHints(Toolbar.getHints());
            int n = 5;
            int n2 = this.getHeight() / 2 - n / 2 - 2;
            int n3 = this.getWidth() / 2 - n / 2 - 2;
            GradientPaint gradientPaint = new GradientPaint(n3 + 1, n2 + 1, Color.BLACK, n3 + n - 1, n2 + n - 1, Color.WHITE);
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(gradientPaint);
            graphics2D.drawArc(n3, n2, n, n, 0, 359);
            graphics.setColor(new Color(240, 240, 240));
            graphics.drawLine(n3 + n / 2, n2 + n / 2, n3 + n / 2, n2 + n / 2);
            graphics2D.setPaint(paint);
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarGtk
    extends JPanel {
        int TOPGAP;
        int BOTGAP;
        static final int WIDTH = 6;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarGtk() {
            int n = 6;
            if (Toolbar.useSynthIcon()) {
                this.TOPGAP = 0;
                this.BOTGAP = 0;
            } else {
                this.TOPGAP = 2;
                this.BOTGAP = 2;
            }
            this.dim = new Dimension(n, n);
            this.max = new Dimension(n, Integer.MAX_VALUE);
            Toolbar.setToolTipText(this, Toolbar.this.getDisplayName());
        }

        public void paint(Graphics graphics) {
            if (Toolbar.useSynthIcon()) {
                int n = Toolbar.this.getHeight() - this.BOTGAP;
                Icon icon = UIManager.getIcon("ToolBar.handleIcon");
                Region region = Region.TOOL_BAR;
                SynthStyleFactory synthStyleFactory = SynthLookAndFeel.getStyleFactory();
                SynthStyle synthStyle = synthStyleFactory.getStyle(Toolbar.this, region);
                SynthContext synthContext = new SynthContext(Toolbar.this, region, synthStyle, 1024);
                Method method = null;
                try {
                    method = synthIconClass.getMethod("getIconWidth", Icon.class, SynthContext.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, noSuchMethodException);
                }
                int n2 = 0;
                try {
                    n2 = (Integer)method.invoke(null, icon, synthContext);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, invocationTargetException);
                }
                try {
                    method = synthIconClass.getMethod("paintIcon", Icon.class, SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, noSuchMethodException);
                }
                try {
                    method.invoke(null, icon, synthContext, graphics, new Integer(0), new Integer(-1), new Integer(n2), new Integer(n));
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, invocationTargetException);
                }
            } else {
                Dimension dimension = this.getSize();
                int n = dimension.height - this.BOTGAP;
                graphics.setColor(this.getBackground());
                int n3 = 0;
                while (n3 + 1 < dimension.width) {
                    int n4 = this.TOPGAP;
                    while (n4 + 1 < n) {
                        graphics.setColor(this.getBackground().brighter());
                        graphics.drawLine(n3, n4, n3, n4);
                        if (n3 + 5 < dimension.width && n4 + 5 < n) {
                            graphics.drawLine(n3 + 2, n4 + 2, n3 + 2, n4 + 2);
                        }
                        graphics.setColor(this.getBackground().darker().darker());
                        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
                        if (n3 + 5 < dimension.width && n4 + 5 < n) {
                            graphics.drawLine(n3 + 3, n4 + 3, n3 + 3, n4 + 3);
                        }
                        n4 += 4;
                    }
                    n3 += 4;
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return new Dimension(6, Toolbar.this.getHeight() - this.BOTGAP - this.TOPGAP);
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    private final class ToolbarBump
    extends JPanel {
        static final int TOPGAP = 2;
        static final int BOTGAP = 2;
        static final int WIDTH = 6;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarBump() {
            int n = 6;
            this.dim = new Dimension(n, n);
            this.max = new Dimension(n, Integer.MAX_VALUE);
            Toolbar.setToolTipText(this, Toolbar.this.getDisplayName());
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.height - 2;
            graphics.setColor(this.getBackground());
            int n2 = 0;
            while (n2 + 1 < dimension.width) {
                int n3 = 2;
                while (n3 + 1 < n) {
                    graphics.setColor(this.getBackground().brighter());
                    graphics.drawLine(n2, n3, n2, n3);
                    if (n2 + 5 < dimension.width && n3 + 5 < n) {
                        graphics.drawLine(n2 + 2, n3 + 2, n2 + 2, n3 + 2);
                    }
                    graphics.setColor(this.getBackground().darker().darker());
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
                    if (n2 + 5 < dimension.width && n3 + 5 < n) {
                        graphics.drawLine(n2 + 3, n3 + 3, n2 + 3, n3 + 3);
                    }
                    n3 += 4;
                }
                n2 += 4;
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    final class Folder
    extends FolderInstance {
        private Map<Object, Object> cookiesToObjects;

        public Folder() {
            super(Toolbar.this.backingFolder);
            this.cookiesToObjects = new HashMap<Object, Object>();
            this.recreate();
        }

        public String instanceName() {
            return Toolbar.this.getClass().getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return Toolbar.this.getClass();
        }

        protected InstanceCookie acceptDataObject(DataObject dataObject) {
            InstanceCookie instanceCookie = super.acceptDataObject(dataObject);
            if (instanceCookie == null) {
                JButton jButton = ExecBridge.createButton(dataObject);
                if (jButton != null) {
                    jButton.putClientProperty("file", dataObject);
                }
                return jButton != null ? new InstanceSupport.Instance(jButton) : null;
            }
            return instanceCookie;
        }

        protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Object object = super.instanceForCookie(dataObject, instanceCookie);
            this.cookiesToObjects.put(object, dataObject);
            return object;
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz;
            InstanceCookie.Of of;
            boolean bl = instanceCookie instanceof InstanceCookie.Of ? (of = (InstanceCookie.Of)instanceCookie).instanceOf(Component.class) || of.instanceOf(Presenter.Toolbar.class) || of.instanceOf(Action.class) : Component.class.isAssignableFrom(clazz = instanceCookie.instanceClass()) || Presenter.Toolbar.class.isAssignableFrom(clazz) || Action.class.isAssignableFrom(clazz);
            return bl ? instanceCookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            Toolbar.this.removeAll();
            int n = 0;
            while (true) {
                block14: {
                    Object var8_9;
                    block15: {
                        if (n >= instanceCookieArray.length) {
                            Toolbar.this.invalidate();
                            return Toolbar.this;
                        }
                        try {
                            try {
                                Object object = instanceCookieArray[n].instanceCreate();
                                Object object2 = this.cookiesToObjects.get(object);
                                if (object instanceof Presenter.Toolbar) {
                                    object = ((Presenter.Toolbar)object).getToolbarPresenter();
                                }
                                if (object instanceof Component) {
                                    if (object instanceof JComponent && "Fixed".equals(((JComponent)object).getClientProperty("Toolbar"))) {
                                        Toolbar.this.floatable = false;
                                        Toolbar.this.removeAll();
                                        Toolbar.this.setBorder(null);
                                    }
                                    if (object instanceof JComponent) {
                                        if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                                            ((JComponent)object).putClientProperty("PreferredIconSize", new Integer(24));
                                        }
                                        ((JComponent)object).putClientProperty("file", object2);
                                    }
                                    Toolbar.this.add((Component)object);
                                    var8_9 = null;
                                    this.cookiesToObjects.clear();
                                    break block14;
                                }
                                if (!(object instanceof Action)) break block15;
                                Action action = (Action)object;
                                DefaultIconButton defaultIconButton = new DefaultIconButton();
                                if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                                    defaultIconButton.putClientProperty("PreferredIconSize", new Integer(24));
                                }
                                if (null == action.getValue("SmallIcon") && (null == action.getValue("Name") || action.getValue("Name").toString().length() == 0)) {
                                    action.putValue("SmallIcon", new ImageIcon(ImageUtilities.loadImage((String)"org/openide/loaders/unknown.gif")));
                                }
                                Actions.connect((AbstractButton)defaultIconButton, (Action)action);
                                defaultIconButton.putClientProperty("file", object2);
                                Toolbar.this.add(defaultIconButton);
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, iOException);
                                var8_9 = null;
                                this.cookiesToObjects.clear();
                                break block14;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                Logger.getLogger(Toolbar.class.getName()).log(Level.WARNING, null, classNotFoundException);
                                var8_9 = null;
                                this.cookiesToObjects.clear();
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            var8_9 = null;
                            this.cookiesToObjects.clear();
                            throw throwable;
                        }
                        var8_9 = null;
                        this.cookiesToObjects.clear();
                        break block14;
                    }
                    var8_9 = null;
                    this.cookiesToObjects.clear();
                }
                ++n;
            }
        }

        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable);
        }
    }

    class ToolbarMouseListener
    extends MouseInputAdapter {
        private boolean dragging = false;
        private Point startPoint = null;

        ToolbarMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.startPoint = mouseEvent.getPoint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragging) {
                int n = Toolbar.this.getX() + mouseEvent.getX() - this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : mouseEvent.getX() - this.startPoint.x;
                Toolbar.this.fireDropToolbar(n, mouseEvent.getY() - this.startPoint.y, 1);
                this.dragging = false;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            int n2 = 1;
            if (mouseEvent.isControlDown()) {
                n2 = 3;
            } else if ((n & 8) != 0 || (n & 4) != 0) {
                n2 = 2;
            }
            if (this.startPoint == null) {
                this.startPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            }
            int n3 = Toolbar.this.getX() + mouseEvent.getX() + this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? (Toolbar.this.getX() >= Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH - Toolbar.this.getX()) : mouseEvent.getX() - this.startPoint.x;
            Toolbar.this.fireDragToolbar(n3, mouseEvent.getY() - this.startPoint.y, n2);
            this.dragging = true;
        }
    }

    private class DnDSupport
    implements DragSourceListener,
    DragGestureListener,
    DropTargetListener,
    DragSourceMotionListener {
        private DragSource dragSource = new DragSource();
        private Cursor dragMoveCursor = DragSource.DefaultMoveDrop;
        private Cursor dragNoDropCursor = DragSource.DefaultMoveNoDrop;
        private Cursor dragRemoveCursor = Utilities.createCustomCursor((Component)Toolbar.this, (Image)ImageUtilities.loadImage((String)"org/openide/loaders/delete.gif"), (String)"NO_ACTION_MOVE");
        private Map<Component, DragGestureRecognizer> recognizers = new HashMap<Component, DragGestureRecognizer>();

        public DnDSupport() {
            this.dragSource.addDragSourceMotionListener(this);
        }

        public void register(Component component) {
            DragGestureRecognizer dragGestureRecognizer = this.recognizers.get(component);
            if (null == dragGestureRecognizer) {
                dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(component, 2, this);
                this.recognizers.put(component, dragGestureRecognizer);
            }
        }

        public void unregister(Component component) {
            DragGestureRecognizer dragGestureRecognizer = this.recognizers.get(component);
            if (null != dragGestureRecognizer) {
                dragGestureRecognizer.removeDragGestureListener(this);
                this.recognizers.remove(component);
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            Toolbar.this.resetDropGesture();
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            Toolbar.this.isDragSourceToolbar = false;
            Component component = dragSourceDropEvent.getDragSourceContext().getComponent();
            if (component instanceof JButton) {
                ((JButton)component).getModel().setRollover(false);
            }
            component.repaint();
            Toolbar.this.resetDropGesture();
            if (!dragSourceDropEvent.getDropSuccess() && !Toolbar.this.isInToolbarPanel(dragSourceDropEvent.getLocation())) {
                Toolbar.this.removeButton(dragSourceDropEvent.getDragSourceContext().getTransferable());
            }
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (!ToolbarPool.getDefault().isInEditMode() || "QuickSearch".equals(Toolbar.this.getName())) {
                return;
            }
            try {
                DataObject dataObject;
                Component component = dragGestureEvent.getComponent();
                if (component instanceof JToolBar.Separator || "grip".equals(component.getName())) {
                    return;
                }
                ExTransferable.Single single = null;
                if (component instanceof JComponent && (dataObject = (DataObject)((JComponent)component).getClientProperty("file")) != null) {
                    single = new ExTransferable.Single(buttonDataFlavor){

                        public Object getData() {
                            return dataObject;
                        }
                    };
                }
                if (component instanceof JButton) {
                    ((JButton)component).getModel().setArmed(false);
                    ((JButton)component).getModel().setPressed(false);
                    ((JButton)component).getModel().setRollover(true);
                }
                if (single != null) {
                    Toolbar.this.dragSourceButtonIndex = Toolbar.this.getComponentIndex(component);
                    Toolbar.this.isDragSourceToolbar = true;
                    this.dragSource.startDrag(dragGestureEvent, this.dragMoveCursor, (Transferable)single, this);
                }
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                Exceptions.printStackTrace((Throwable)invalidDnDOperationException);
            }
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            boolean bl = false;
            try {
                if (Toolbar.this.validateDropPosition()) {
                    bl = Toolbar.this.handleDrop(dropTargetDropEvent.getTransferable());
                }
                Object var4_3 = null;
                dropTargetDropEvent.dropComplete(bl);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                dropTargetDropEvent.dropComplete(bl);
                throw throwable;
            }
            Toolbar.this.resetDropGesture();
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            Toolbar.this.resetDropGesture();
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(buttonDataFlavor) || dropTargetDragEvent.isDataFlavorSupported(actionDataFlavor)) {
                dropTargetDragEvent.acceptDrag(3);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(buttonDataFlavor) || dropTargetDragEvent.isDataFlavorSupported(actionDataFlavor)) {
                Toolbar.this.updateDropGesture(dropTargetDragEvent);
                if (!Toolbar.this.validateDropPosition()) {
                    dropTargetDragEvent.rejectDrag();
                } else {
                    dropTargetDragEvent.acceptDrag(3);
                }
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            int n = dragSourceDragEvent.getDropAction();
            if ((n & 2) != 0) {
                dragSourceContext.setCursor(this.dragMoveCursor);
            } else if (Toolbar.this.isInToolbarPanel(dragSourceDragEvent.getLocation())) {
                dragSourceContext.setCursor(this.dragNoDropCursor);
            } else {
                dragSourceContext.setCursor(this.dragRemoveCursor);
            }
        }
    }
}

