/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.filters.FilterChoice;
import tr.view.filters.FilterComboAbstract;
import tr.view.filters.MultiChoiceDialog;
import tr.view.filters.TopicAll;
import tr.view.filters.TopicMultiple;
import tr.view.filters.TopicMultipleEdit;

public class FilterTopic
extends FilterChoice
implements PropertyChangeListener {
    public static final byte INDEX = 6;

    public FilterTopic() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new TopicsComboBox();
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Topic topic = (Topic)this.combo.getSelectedItem();
        if (topic == null) {
            this.fireMatchAll();
        } else if (topic instanceof TopicAll) {
            this.fireMatchAll();
        } else if (topic instanceof TopicMultiple) {
            TopicMultiple multiple = (TopicMultiple)topic;
            this.fireChanged(new TopicMatcher(multiple.getChosen()));
        } else {
            this.fireChanged(new TopicMatcher(topic));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-topic");
    }

    public byte getIndex() {
        return 6;
    }

    public String[] getSerialValues() {
        if (this.combo == null) {
            return null;
        }
        Topic topic = (Topic)this.combo.getSelectedItem();
        if (topic == null) {
            return null;
        }
        if (topic instanceof TopicAll) {
            return new String[]{"all"};
        }
        if (topic instanceof TopicMultiple) {
            Vector chosen = ((TopicMultiple)topic).getChosen();
            if (chosen == null || chosen.size() == 0) {
                return null;
            }
            Vector<String> values = new Vector<String>();
            for (Topic t : chosen) {
                if (t == null) continue;
                values.add(t.getName());
            }
            return values.toArray(new String[0]);
        }
        return new String[]{topic.getName()};
    }

    public void setSerialValues(String[] values) {
        if (this.combo == null) {
            return;
        }
        this.combo.stopChangeEvents();
        if (values == null || values.length == 0) {
            this.combo.setSelectedItem(null);
        } else if (values.length == 1) {
            if (values[0].equals("all")) {
                this.combo.setSelectedIndex(0);
            } else {
                this.combo.setSelectedItem((Object)this.getTopic(values[0]));
            }
        } else if (values.length > 1) {
            Object object = this.combo.getItemAt(1);
            if (object instanceof TopicMultiple) {
                TopicMultiple multiple = (TopicMultiple)object;
                Vector<Topic> chosen = new Vector<Topic>();
                for (String name : values) {
                    Topic topic = this.getTopic(name);
                    if (topic == null) continue;
                    chosen.add(topic);
                }
                multiple.setChosen(chosen);
            }
            this.combo.setSelectedIndex(1);
        }
        this.combo.startChangeEvents();
    }

    private Topic getTopic(String name) {
        if (name == null) {
            return null;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        Manager manager = data.getTopicManager();
        for (Topic topic : manager.list()) {
            if (!topic.getName().equals(name)) continue;
            return topic;
        }
        return null;
    }

    protected boolean canExcludeNulls() {
        return false;
    }

    public class TopicsComboBox
    extends FilterComboAbstract {
        private final ActionListener listener;
        private Object lastSelectedItem;

        public TopicsComboBox() {
            super((ComboBoxModel)new TopicsComboBoxModel());
            this.listener = !Utilities.isMac() ? new WindowsActionListener() : new RealActionListener();
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
            this.lastSelectedItem = this.getSelectedItem();
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        private final class WindowsActionListener
        implements ActionListener {
            private WindowsActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = TopicsComboBox.this.getSelectedItem();
                if (object instanceof TopicMultipleEdit) {
                    TopicsComboBoxModel model = (TopicsComboBoxModel)TopicsComboBox.this.getModel();
                    TopicMultiple tm = model.multiple;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getTopicManager().list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)TopicsComboBox.this), all, tm.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-topic"));
                    d.setLocationRelativeTo((Component)((Object)TopicsComboBox.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        tm.setChosen(d.getChosen());
                        TopicsComboBox.this.setSelectedItem(tm);
                        TopicsComboBox.this.lastSelectedItem = tm;
                    } else {
                        TopicsComboBox.this.setSelectedItem(TopicsComboBox.this.lastSelectedItem);
                    }
                } else {
                    TopicsComboBox.this.lastSelectedItem = object;
                }
                TopicsComboBox.this.fireValueChange();
            }
        }

        private final class RealActionListener
        implements ActionListener {
            private RealActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object object = TopicsComboBox.this.getSelectedItem();
                if (object instanceof TopicMultiple) {
                    TopicMultiple tm = (TopicMultiple)object;
                    Data data = (Data)DataLookup.instance().lookup(Data.class);
                    Vector all = data == null ? new Vector() : data.getTopicManager().list();
                    MultiChoiceDialog d = new MultiChoiceDialog((Component)((Object)TopicsComboBox.this), all, tm.getChosen(), true);
                    d.setTitle(NbBundle.getMessage(this.getClass(), (String)"filter-topic"));
                    d.setLocationRelativeTo((Component)((Object)TopicsComboBox.this));
                    d.setVisible(true);
                    if (d.isOkay()) {
                        tm.setChosen(d.getChosen());
                    }
                }
                TopicsComboBox.this.fireValueChange();
            }
        }
    }

    private class TopicsComboBoxModel
    extends DefaultComboBoxModel
    implements Observer {
        private final TopicAll all = new TopicAll();
        private final TopicMultiple multiple = new TopicMultiple();
        private final TopicMultipleEdit multipleEdit = new TopicMultipleEdit();
        private Manager<Topic> topicManager;
        private List<Topic> topics;
        private Lookup.Result result;

        public TopicsComboBoxModel() {
            this.initialise();
        }

        private void initialise() {
            Data data;
            if (this.topicManager != null) {
                this.topicManager.removeObserver((Observer)this);
            }
            if ((data = (Data)DataLookup.instance().lookup(Data.class)) == null) {
                this.topicManager = null;
                this.topics = new Vector<Topic>();
            } else {
                this.topicManager = data.getTopicManager();
                this.topicManager.addObserver((Observer)this);
                this.topics = this.topicManager.list();
                Collections.sort(this.topics);
            }
            this.topics.add(0, (Topic)this.all);
            this.topics.add(1, (Topic)this.multiple);
            if (!Utilities.isMac()) {
                this.topics.add(2, (Topic)this.multipleEdit);
            }
            if (this.result == null) {
                this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        TopicsComboBoxModel.this.update(null, null);
                    }
                });
            }
        }

        public Object getElementAt(int index) {
            return this.topics.get(index);
        }

        public int getSize() {
            return this.topics.size();
        }

        public void update(Observable o, Object arg) {
            this.initialise();
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopicMatcher
    implements Matcher<Action> {
        private final boolean all;
        private final List<Topic> topics;

        public TopicMatcher() {
            this.all = true;
            this.topics = null;
        }

        public TopicMatcher(Topic topic) {
            this.all = false;
            this.topics = new Vector<Topic>();
            this.topics.add(topic);
        }

        public TopicMatcher(List<Topic> topics) {
            this.all = false;
            this.topics = topics;
        }

        public boolean matches(Action action) {
            if (this.all) {
                return true;
            }
            for (Topic topic : this.topics) {
                if (!action.getTopic().equals((Object)topic)) continue;
                return true;
            }
            return false;
        }
    }
}

